/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.geometry.DouglasPeuckerSimplification;
import org.jetbrains.letsPlot.core.commons.geometry.VisvalingamWhyattSimplification;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier;", "", "myPoints", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "strategy", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;", "(Ljava/util/List;Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;)V", "indices", "", "getIndices", "()Ljava/util/List;", "isWeightLimitSet", "", "()Z", "myCountLimit", "myWeightLimit", "", "myWeights", "points", "getPoints", "getIndex", "p", "Lkotlin/Pair;", "getWeight", "setCountLimit", "countLimit", "setWeightLimit", "weightLimit", "Companion", "RankingStrategy", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPolylineSimplifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolylineSimplifier.kt\norg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1549#2:93\n1620#2,3:94\n1549#2:97\n1620#2,3:98\n766#2:101\n857#2,2:102\n766#2:104\n857#2,2:105\n1549#2:107\n1620#2,3:108\n*S KotlinDebug\n*F\n+ 1 PolylineSimplifier.kt\norg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier\n*L\n17#1:93\n17#1:94,3\n22#1:97\n22#1:98,3\n23#1:101\n23#1:102,2\n28#1:104\n28#1:105,2\n34#1:107\n34#1:108,3\n*E\n"})
public final class PolylineSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DoubleVector> myPoints;
    @NotNull
    private final List<Double> myWeights;
    private double myWeightLimit;
    private int myCountLimit;
    public static final double DOUGLAS_PEUCKER_PIXEL_THRESHOLD = 0.25;

    private PolylineSimplifier(List<DoubleVector> myPoints, RankingStrategy strategy) {
        this.myPoints = myPoints;
        this.myWeightLimit = Double.NaN;
        this.myCountLimit = -1;
        this.myWeights = strategy.getWeights(this.myPoints);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DoubleVector> getPoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getIndices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.myPoints.get((int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getIndices() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.myPoints.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)((int)i), (Object)this.myWeights.get((int)i)));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Pair p = (Pair)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !Double.isNaN(this.getWeight((Pair<Integer, Double>)p));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator comparator2 = ((Comparator)new Comparator(this){
            final /* synthetic */ PolylineSimplifier this$0;
            {
                this.this$0 = polylineSimplifier;
            }

            public final int compare(T a2, T b2) {
                Pair it = (Pair)a2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(PolylineSimplifier.access$getWeight(this.this$0, it));
                it = (Pair)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(PolylineSimplifier.access$getWeight(this.this$0, it)));
            }
        }).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"reversed(...)");
        List sorted = CollectionsKt.sortedWith((Iterable)iterable2, comparator2);
        Collection filtered = null;
        if (this.isWeightLimitSet()) {
            Iterable $this$filter$iv2 = sorted;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair p = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(this.getWeight((Pair<Integer, Double>)p) > this.myWeightLimit)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            filtered = (List)destination$iv$iv2;
        } else {
            filtered = CollectionsKt.take((Iterable)sorted, (int)this.myCountLimit);
        }
        Iterable $this$map$iv2 = filtered;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair p = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(this.getIndex((Pair<Integer, Double>)it));
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv3));
    }

    private final boolean isWeightLimitSet() {
        return !Double.isNaN(this.myWeightLimit);
    }

    @NotNull
    public final PolylineSimplifier setWeightLimit(double weightLimit) {
        this.myWeightLimit = weightLimit;
        this.myCountLimit = -1;
        return this;
    }

    @NotNull
    public final PolylineSimplifier setCountLimit(int countLimit) {
        this.myWeightLimit = Double.NaN;
        this.myCountLimit = countLimit;
        return this;
    }

    private final double getWeight(Pair<Integer, Double> p) {
        return ((Number)p.getSecond()).doubleValue();
    }

    private final int getIndex(Pair<Integer, Double> p) {
        return ((Number)p.getFirst()).intValue();
    }

    public /* synthetic */ PolylineSimplifier(List myPoints, RankingStrategy strategy, DefaultConstructorMarker $constructor_marker) {
        this(myPoints, strategy);
    }

    public static final /* synthetic */ double access$getWeight(PolylineSimplifier $this, Pair p) {
        return $this.getWeight((Pair<Integer, Double>)p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004J\u0014\u0010\u000b\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$Companion;", "", "()V", "DOUGLAS_PEUCKER_PIXEL_THRESHOLD", "", "douglasPeucker", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier;", "points", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "threshold", "visvalingamWhyatt", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolylineSimplifier visvalingamWhyatt(@NotNull List<DoubleVector> points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            return new PolylineSimplifier(points, new VisvalingamWhyattSimplification(), null);
        }

        @NotNull
        public final PolylineSimplifier douglasPeucker(@NotNull List<DoubleVector> points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            return new PolylineSimplifier(points, new DouglasPeuckerSimplification(), null);
        }

        @NotNull
        public final List<DoubleVector> douglasPeucker(@NotNull List<DoubleVector> points, double threshold) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            return this.douglasPeucker(points).setWeightLimit(threshold).getPoints();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H&\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;", "", "getWeights", "", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static interface RankingStrategy {
        @NotNull
        public List<Double> getWeights(@NotNull List<DoubleVector> var1);
    }
}

