/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetsTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultFacetsTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "options", "", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "rectKey", "", "getRectKey$plot_builder", "()Ljava/util/List;", "textKey", "getTextKey$plot_builder", "showStrip", "", "showStripBackground", "stripColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "stripFill", "stripLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "stripMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "stripStrokeWidth", "", "stripTextJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "stripTextStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "plot-builder"})
public final class DefaultFacetsTheme
extends ThemeValuesAccess
implements FacetsTheme {
    @NotNull
    private final List<String> rectKey;
    @NotNull
    private final List<String> textKey;

    public DefaultFacetsTheme(@NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        Object[] objectArray = new String[]{"strip_background", "rect"};
        this.rectKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"strip_text", "text"};
        this.textKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getRectKey$plot_builder() {
        return this.rectKey;
    }

    @NotNull
    public final List<String> getTextKey$plot_builder() {
        return this.textKey;
    }

    @Override
    public boolean showStrip() {
        return !this.isElemBlank(this.textKey);
    }

    @Override
    public boolean showStripBackground() {
        return this.showStrip() && !this.isElemBlank(this.rectKey);
    }

    @Override
    @NotNull
    public Color stripFill() {
        return this.getColor(this.getElemValue(this.rectKey), "fill");
    }

    @Override
    @NotNull
    public Color stripColor() {
        return this.getColor(this.getElemValue(this.rectKey), "color");
    }

    @Override
    public double stripStrokeWidth() {
        return this.getNumber(this.getElemValue(this.rectKey), "size");
    }

    @Override
    @NotNull
    public LineType stripLineType() {
        return this.getLineType(this.getElemValue(this.rectKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle stripTextStyle() {
        return this.getTextStyle(this.getElemValue(this.textKey));
    }

    @Override
    @NotNull
    public Thickness stripMargins() {
        return this.getMargins(this.getElemValue(this.textKey));
    }

    @Override
    @NotNull
    public TextJustification stripTextJustification() {
        return this.getTextJustification(this.getElemValue(this.textKey));
    }
}

