/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitFileAnnotation;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"getAnnotationFromCache", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
public final class GitAnnotationProviderKt {
    @Nullable
    public static final FileAnnotation getAnnotationFromCache(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        String string = repository.getCurrentRevision();
        if (string == null) {
            return null;
        }
        String currentRevision = string;
        VcsHistoryCache cache = VcsCacheManager.getInstance((Project)project).getVcsHistoryCache();
        FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file));
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(...)");
        FilePath filePath2 = filePath;
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        VcsRevisionNumber vcsRevisionNumber = cache.getLastRevision(filePath2, vcsKey, (VcsRevisionNumber)new GitRevisionNumber(currentRevision));
        if (vcsRevisionNumber == null) {
            return null;
        }
        VcsRevisionNumber lastRevision = vcsRevisionNumber;
        VcsKey vcsKey2 = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey2, (String)"getKey(...)");
        Object object = cache.getAnnotation(filePath2, vcsKey2, lastRevision);
        GitAnnotationProvider.CachedData cachedData = object instanceof GitAnnotationProvider.CachedData ? (GitAnnotationProvider.CachedData)object : null;
        if (cachedData == null) {
            return null;
        }
        GitAnnotationProvider.CachedData annotationData = cachedData;
        return new GitFileAnnotation(project, file, filePath2, lastRevision, annotationData.lines);
    }
}

