/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.LoadCommitDetailsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getOrLoadDetails", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "loadDetails", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitLogCommitDetailsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogCommitDetailsLoader.kt\ngit4idea/rebase/log/GitLogCommitDetailsLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n2632#2,3:55\n*S KotlinDebug\n*F\n+ 1 GitLogCommitDetailsLoader.kt\ngit4idea/rebase/log/GitLogCommitDetailsLoaderKt\n*L\n24#1:55,3\n*E\n"})
public final class GitLogCommitDetailsLoaderKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final List<VcsCommitMetadata> getOrLoadDetails(@NotNull Project project, @NotNull VcsLogData data2, @NotNull VcsLogCommitSelection selection) {
        boolean bl;
        ArrayList cachedCommits;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            cachedCommits = new ArrayList(selection.getCachedMetadata());
            Iterable $this$none$iv = cachedCommits;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    VcsCommitMetadata it = (VcsCommitMetadata)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof LoadingDetails)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return cachedCommits;
        }
        return GitLogCommitDetailsLoaderKt.loadDetails(project, data2, selection);
    }

    private static final List<VcsCommitMetadata> loadDetails(Project project, VcsLogData data2, VcsLogCommitSelection selection) {
        try {
            Object[] objectArray = new Object[]{VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)selection)};
            List loadedDetails = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitLogCommitDetailsLoaderKt.loadDetails$lambda$1(data2, selection), GitBundle.message("rebase.log.action.progress.indicator.loading.commit.message.title", objectArray), true, project);
            if (loadedDetails.size() != VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)selection)) {
                throw new LoadCommitDetailsException();
            }
            Intrinsics.checkNotNull((Object)loadedDetails);
            return loadedDetails;
        }
        catch (VcsException e) {
            Object[] objectArray = new Object[]{VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)selection)};
            String string = GitBundle.message("rebase.log.action.loading.commit.message.failed.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String error = string;
            LOG.warn(error, (Throwable)e);
            Notification notification = VcsNotifier.standardNotification().createNotification(error, NotificationType.ERROR).setDisplayId("git.log.could.not.load.changes.of.commit");
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
            Notification notification2 = notification;
            VcsNotifier.getInstance((Project)project).notify(notification2);
            throw new LoadCommitDetailsException();
        }
    }

    private static final List loadDetails$lambda$1(VcsLogData $data, VcsLogCommitSelection $selection) {
        MiniDetailsGetter miniDetailsGetter = $data.getMiniDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)miniDetailsGetter, (String)"getMiniDetailsGetter(...)");
        return AbstractDataGetter.Companion.getCommitDetails((AbstractDataGetter)miniDetailsGetter, $selection.getIds());
    }

    static {
        Logger logger = Logger.getInstance((String)"Git.Rebase.Log.Action.CommitDetailsLoader");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

