/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteDeleteProviderKt;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/JupyterRemoteDeleteProvider;", "Lcom/intellij/ide/DeleteProvider;", "project", "Lcom/intellij/openapi/project/Project;", "selected", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelected", "()Ljava/util/Collection;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "deleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getOptimizedDeleteRequest", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "contains", "", "remotePath", "canDeleteElement", "doDeleteAuthority", "doDeleteRemoteFile", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteDeleteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteDeleteProvider.kt\ncom/intellij/jupyter/py/ui/remote/providers/JupyterRemoteDeleteProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n1863#2,2:116\n1557#2:118\n1628#2,3:119\n1611#2,9:122\n1863#2:131\n1864#2:133\n1620#2:134\n1863#2:135\n2632#2,3:136\n1864#2:139\n1755#2,3:140\n1734#2,3:143\n1#3:132\n61#4,5:146\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteDeleteProvider.kt\ncom/intellij/jupyter/py/ui/remote/providers/JupyterRemoteDeleteProvider\n*L\n41#1:116,2\n65#1:118\n65#1:119,3\n67#1:122,9\n67#1:131\n67#1:133\n67#1:134\n70#1:135\n71#1:136,3\n70#1:139\n83#1:140,3\n84#1:143,3\n67#1:132\n97#1:146,5\n*E\n"})
public final class JupyterRemoteDeleteProvider
implements DeleteProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<AbstractTreeNode<?>> selected;

    public JupyterRemoteDeleteProvider(@NotNull Project project, @NotNull Collection<? extends AbstractTreeNode<?>> selected) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        this.project = project;
        this.selected = selected;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<AbstractTreeNode<?>> getSelected() {
        return this.selected;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(PlatformDataKeys.PROJECT);
        if (this.selected.size() > 1) {
            Object[] objectArray = new Object[]{this.selected.size()};
            int answer2 = Messages.showYesNoDialog((Project)project, (String)JupyterRemoteBundle.message("Jupyter.remote.remove.multiple.files", objectArray), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (answer2 == 0) {
                Iterable $this$forEach$iv = this.getOptimizedDeleteRequest();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JupyterRemotePath remotePath = (JupyterRemotePath)element$iv;
                    boolean bl = false;
                    this.doDeleteRemoteFile(remotePath);
                }
            }
        } else {
            String string;
            boolean isDeletingAuthority;
            Object object = CollectionsKt.first((Iterable)this.selected);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.jupyter.py.ui.remote.JupyterRemoteNode");
            JupyterRemotePath remotePath = ((JupyterRemoteNode)((Object)object)).getRemotePath();
            String fileName = remotePath.getName();
            boolean bl = isDeletingAuthority = fileName == null;
            if (isDeletingAuthority) {
                Object[] element$iv = new Object[]{remotePath.getAuthority()};
                string = JupyterRemoteBundle.message("Jupyter.remote.remove.connection.confirmation", element$iv);
            } else {
                Object[] objectArray = new Object[]{fileName};
                String string2 = ExecutionBundle.message((String)"service.view.delete.confirmation", (Object[])objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            String message2 = string;
            int answer3 = Messages.showYesNoDialog((Project)project, (String)message2, (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (answer3 == 0) {
                if (isDeletingAuthority) {
                    this.doDeleteAuthority(remotePath);
                } else {
                    this.doDeleteRemoteFile(remotePath);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<JupyterRemotePath> getOptimizedDeleteRequest() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.selected;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.jupyter.py.ui.remote.JupyterRemoteNode");
            collection.add(((JupyterRemoteNode)it).getRemotePath());
        }
        List pathsToRemove = (List)destination$iv$iv;
        JupyterRemoteDeleteProviderKt.access$getLOG$p().debug("Requested deletion of " + pathsToRemove + " remote files");
        Iterable $this$mapNotNull$iv = this.selected;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            JupyterRemotePath it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
            boolean bl3 = false;
            JupyterRemoteCompositeNode jupyterRemoteCompositeNode = it instanceof JupyterRemoteCompositeNode ? (JupyterRemoteCompositeNode)it : null;
            if ((jupyterRemoteCompositeNode != null ? jupyterRemoteCompositeNode.getRemotePath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List folders = (List)destination$iv$iv2;
        List optimizedRequest = new ArrayList();
        Iterable $this$forEach$iv = pathsToRemove;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl5;
            JupyterRemotePath path;
            block6: {
                path = (JupyterRemotePath)element$iv;
                boolean bl6 = false;
                Iterable $this$none$iv = folders;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        JupyterRemotePath folder = (JupyterRemotePath)element$iv2;
                        boolean bl7 = false;
                        if (!(!Intrinsics.areEqual((Object)folder, (Object)path) && this.contains(folder, path))) continue;
                        bl5 = false;
                        break block6;
                    }
                    bl5 = true;
                }
            }
            if (!bl5) continue;
            optimizedRequest.add(path);
        }
        JupyterRemoteDeleteProviderKt.access$getLOG$p().debug("Delete request optimized to deletion of " + optimizedRequest);
        return optimizedRequest;
    }

    private final boolean contains(JupyterRemotePath $this$contains, JupyterRemotePath remotePath) {
        return StringsKt.startsWith$default((String)remotePath.getFullPath(), (String)$this$contains.getFullPath(), (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        AbstractTreeNode it;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.selected.size() > 1) {
            boolean bl;
            Iterable $this$any$iv = this.selected;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    it = (AbstractTreeNode)element$iv;
                    boolean bl3 = false;
                    JupyterRemoteCompositeNode jupyterRemoteCompositeNode = it instanceof JupyterRemoteCompositeNode ? (JupyterRemoteCompositeNode)it : null;
                    if (jupyterRemoteCompositeNode != null) {
                        if (jupyterRemoteCompositeNode.isAuthorityNode()) {
                            return false;
                        }
                        bl2 = false;
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    return false;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        Iterable $this$all$iv = this.selected;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (AbstractTreeNode)element$iv;
            boolean bl = false;
        } while (it instanceof JupyterRemoteNode);
        return false;
    }

    private final void doDeleteAuthority(JupyterRemotePath remotePath) {
        block2: {
            if (!remotePath.isAuthority()) {
                boolean bl = false;
                JupyterRemoteDeleteProviderKt.access$getLOG$p().error(remotePath + " doesn't look like an authority.");
                Unit unit = Unit.INSTANCE;
                throw new IllegalStateException(unit.toString());
            }
            String authority = remotePath.getAuthority();
            ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParametersSettings.Companion.getInstance(this.project).getConnectionSettingsForAuthority(authority);
            if (configuredServerJupyterModuleConnectionSettings == null) break block2;
            ConfiguredServerJupyterModuleConnectionSettings it = configuredServerJupyterModuleConnectionSettings;
            boolean bl = false;
            Logger $this$debug_u24default$iv = JupyterRemoteDeleteProviderKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Deleting remote Jupyter settings for authority \"" + authority + "\"", e$iv);
            }
            JupyterConnectionParametersSettings.Companion.getInstance(this.project).removeRemoteServer(it);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.getForApp()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(remotePath, null){
                int label;
                final /* synthetic */ JupyterRemotePath $remotePath;
                {
                    this.$remotePath = $remotePath;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                            this.label = 1;
                            v1 = StoreUtilKt.saveSettings((ComponentManager)((ComponentManager)v0), (boolean)true, (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            this.label = 2;
                            v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$remotePath, null){
                                int label;
                                final /* synthetic */ JupyterRemotePath $remotePath;
                                {
                                    this.$remotePath = $remotePath;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Path localAuthorityRoot = JupyterRemoteFileSystem.Companion.getInstance().remotePathToLocalFilePath(this.$remotePath);
                                            FileUtil.delete((Path)localAuthorityRoot);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl23
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl23:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void doDeleteRemoteFile(JupyterRemotePath remotePath) {
        JupyterRemoteFileSystem fs = JupyterRemoteFileSystem.Companion.getInstance();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.getForApp()), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fs, remotePath, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JupyterRemoteFileSystem $fs;
            final /* synthetic */ JupyterRemotePath $remotePath;
            {
                this.$fs = $fs;
                this.$remotePath = $remotePath;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.$fs.deleteFileOnClientAndServer((Object)$this$launch, this.$remotePath, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }
}

