/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.core.jupyter.JupyterErrorHandlingUtilKt;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameterSettingsUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteCopyPasteLog;
import com.intellij.jupyter.py.ui.remote.providers.LocalToRemoteCopyStrategy;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommand;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/MultipleLocalFilesToRemoteDirCommand;", "Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePsiItems", "", "Lcom/intellij/psi/PsiFileSystemItem;", "targetDirectory", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;)V", "taskTitle", "", "getTaskTitle", "()Ljava/lang/String;", "strategy", "Lcom/intellij/jupyter/py/ui/remote/providers/LocalToRemoteCopyStrategy;", "doExecute", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\npasteCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/MultipleLocalFilesToRemoteDirCommand\n+ 2 JupyterErrorHandlingUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterErrorHandlingUtilKt\n*L\n1#1,394:1\n36#2,6:395\n73#2,6:401\n43#2:407\n79#2:408\n77#2,7:409\n47#2:416\n*S KotlinDebug\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/MultipleLocalFilesToRemoteDirCommand\n*L\n244#1:395,6\n244#1:401,6\n244#1:407\n244#1:408\n244#1:409,7\n244#1:416\n*E\n"})
final class MultipleLocalFilesToRemoteDirCommand
extends PasteCommand {
    @NotNull
    private final Collection<PsiFileSystemItem> sourcePsiItems;
    @NotNull
    private final JupyterRemotePath targetDirectory;
    @NotNull
    private final String taskTitle;
    @NotNull
    private final LocalToRemoteCopyStrategy strategy;

    public MultipleLocalFilesToRemoteDirCommand(@NotNull Project project, @NotNull Collection<? extends PsiFileSystemItem> sourcePsiItems, @NotNull JupyterRemotePath targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sourcePsiItems, (String)"sourcePsiItems");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        super(project, null);
        this.sourcePsiItems = sourcePsiItems;
        this.targetDirectory = targetDirectory;
        Object[] objectArray = new Object[]{this.targetDirectory.getNameOrAuthority()};
        this.taskTitle = JupyterRemoteBundle.message("Jupyter.remote.copying.multiple", objectArray);
        this.strategy = new LocalToRemoteCopyStrategy(this);
    }

    @Override
    @NotNull
    protected String getTaskTitle() {
        return this.taskTitle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doExecute() {
        try {
            void $this$runHandlingConnectionErrors_u24default$iv;
            Logger logger = JupyterRemoteCopyPasteLog.INSTANCE.getLOG();
            JupyterRemotePath remotePath$iv = this.targetDirectory;
            boolean suggestRemovingConnection$iv = true;
            boolean $i$f$runHandlingConnectionErrors = false;
            void $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors_u24default$iv;
            boolean $i$f$runHandlingConnectionErrors2 = false;
            try {
                boolean bl = false;
                for (PsiFileSystemItem sourcePsiItem : this.sourcePsiItems) {
                    if (sourcePsiItem instanceof PsiDirectory) {
                        Path path = ((PsiDirectory)sourcePsiItem).getVirtualFile().toNioPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                        String string = ((PsiDirectory)sourcePsiItem).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this.strategy.copyDirectory(path, string, this.targetDirectory);
                        continue;
                    }
                    Path path = sourcePsiItem.getVirtualFile().toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    String string = sourcePsiItem.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.strategy.copyFile(path, string, this.targetDirectory);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (IOException e$iv$iv) {
                boolean bl = false;
                ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority());
                if (configuredServerJupyterModuleConnectionSettings == null) {
                    throw e$iv$iv;
                }
                JupyterErrorHandlingUtilKt.suggestRemovingConnection((ConfiguredServerJupyterModuleConnectionSettings)configuredServerJupyterModuleConnectionSettings, (boolean)suggestRemovingConnection$iv);
                void var13_15 = $this$runHandlingConnectionErrors$iv$iv;
                bl = false;
                var13_15.warn("Unexpected exception for " + JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority()), (Throwable)e$iv$iv);
                Object var10_12 = null;
            }
        }
        catch (FileExistsHandler.CopyingCancelException copyingCancelException) {
            // empty catch block
        }
    }
}

