/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteFileNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommand;
import com.intellij.jupyter.py.ui.remote.providers.RemoteToRemoteCopyStrategyBase;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/MultipleRemoteFilesToRemoteDirCommandBase;", "Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "itemsToPaste", "", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "remoteTargetDirectory", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;)V", "getItemsToPaste", "()Ljava/util/Collection;", "getRemoteTargetDirectory", "()Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "strategy", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToRemoteCopyStrategyBase;", "getStrategy", "()Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToRemoteCopyStrategyBase;", "doExecute", "", "Lcom/intellij/jupyter/py/ui/remote/providers/MultipleRemoteFilesToOtherRemoteDirCommand;", "Lcom/intellij/jupyter/py/ui/remote/providers/MultipleRemoteFilesToSameRemoteDirCommand;", "intellij.jupyter.py"})
abstract class MultipleRemoteFilesToRemoteDirCommandBase
extends PasteCommand {
    @NotNull
    private final Collection<JupyterRemoteNode> itemsToPaste;
    @NotNull
    private final JupyterRemotePath remoteTargetDirectory;

    private MultipleRemoteFilesToRemoteDirCommandBase(Project project, Collection<? extends JupyterRemoteNode> itemsToPaste, JupyterRemotePath remoteTargetDirectory) {
        super(project, null);
        this.itemsToPaste = itemsToPaste;
        this.remoteTargetDirectory = remoteTargetDirectory;
    }

    @NotNull
    protected final Collection<JupyterRemoteNode> getItemsToPaste() {
        return this.itemsToPaste;
    }

    @NotNull
    protected final JupyterRemotePath getRemoteTargetDirectory() {
        return this.remoteTargetDirectory;
    }

    @NotNull
    protected abstract RemoteToRemoteCopyStrategyBase getStrategy();

    @Override
    protected void doExecute() {
        try {
            for (JupyterRemoteNode remoteNode : this.itemsToPaste) {
                JupyterRemoteNode jupyterRemoteNode = remoteNode;
                if (jupyterRemoteNode instanceof JupyterRemoteFileNode) {
                    RemoteToRemoteCopyStrategyBase remoteToRemoteCopyStrategyBase = this.getStrategy();
                    JupyterRemotePath jupyterRemotePath = remoteNode.getRemotePath();
                    String string = remoteNode.getRemotePath().getName();
                    Intrinsics.checkNotNull((Object)string);
                    remoteToRemoteCopyStrategyBase.copyFile(jupyterRemotePath, string, this.remoteTargetDirectory);
                    continue;
                }
                if (jupyterRemoteNode instanceof JupyterRemoteCompositeNode) {
                    this.getStrategy().copyDirectory(remoteNode.getRemotePath(), remoteNode.getRemotePath().getNameOrAuthority(), this.remoteTargetDirectory);
                    continue;
                }
                if (jupyterRemoteNode instanceof JupyterRemoteLoadingNode) {
                    return;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        catch (FileExistsHandler.CopyingCancelException copyingCancelException) {
            // empty catch block
        }
    }

    public /* synthetic */ MultipleRemoteFilesToRemoteDirCommandBase(Project project, Collection itemsToPaste, JupyterRemotePath remoteTargetDirectory, DefaultConstructorMarker $constructor_marker) {
        this(project, itemsToPaste, remoteTargetDirectory);
    }
}

