/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileWriterOutputStream;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.NotebookModel;
import com.intellij.jupyter.py.remote.vfs.JupyterRemoteVfsUtilKt;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.RemoteToRemoteCopyStrategyBase;
import com.intellij.jupyter.py.ui.remote.providers.UtilKt;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToOtherRemoteCopyStrategy;", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToRemoteCopyStrategyBase;", "fileExistsHandler", "Lcom/intellij/jupyter/py/ui/remote/providers/FileExistsHandler;", "<init>", "(Lcom/intellij/jupyter/py/ui/remote/providers/FileExistsHandler;)V", "copyFile", "", "remoteFilePath", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "newRemoteFileName", "", "remoteTargetDir", "intellij.jupyter.py"})
public final class RemoteToOtherRemoteCopyStrategy
extends RemoteToRemoteCopyStrategyBase {
    public RemoteToOtherRemoteCopyStrategy(@NotNull FileExistsHandler fileExistsHandler) {
        Intrinsics.checkNotNullParameter((Object)fileExistsHandler, (String)"fileExistsHandler");
        super(fileExistsHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(@NotNull JupyterRemotePath remoteFilePath, @NotNull String newRemoteFileName, @NotNull JupyterRemotePath remoteTargetDir) {
        Intrinsics.checkNotNullParameter((Object)remoteFilePath, (String)"remoteFilePath");
        Intrinsics.checkNotNullParameter((Object)newRemoteFileName, (String)"newRemoteFileName");
        Intrinsics.checkNotNullParameter((Object)remoteTargetDir, (String)"remoteTargetDir");
        if (!this.getFileExistsHandler().canProceedWithRemoteFile(remoteTargetDir, newRemoteFileName)) {
            return;
        }
        ContentsApiModel m = UtilKt.getFileNodeLookingOnExtension(remoteFilePath);
        if (!(m instanceof LeafContentsApiModel)) {
            return;
        }
        String[] model = (String[])m;
        String[] stringArray = new String[]{newRemoteFileName};
        JupyterRemotePath targetPath = remoteTargetDir.resolve(stringArray);
        stringArray = model;
        if (stringArray instanceof FileModel) {
            CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi(targetPath);
            if (cachingFileContentsApi != null && (cachingFileContentsApi = cachingFileContentsApi.fileWriter(targetPath.getJupyterPath())) != null) {
                Closeable closeable = (Closeable)cachingFileContentsApi;
                Throwable throwable = null;
                try {
                    FileWriterOutputStream writer = (FileWriterOutputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = ((FileModel)model).getContent();
                    Intrinsics.checkNotNull((Object)byArray);
                    writer.write(byArray);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        } else if (stringArray instanceof NotebookModel) {
            CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi(targetPath);
            if (cachingFileContentsApi != null) {
                String string = targetPath.getJupyterPath();
                ObjectNode objectNode = ((NotebookModel)model).getContent();
                Intrinsics.checkNotNull((Object)objectNode);
                cachingFileContentsApi.writeNotebook(string, objectNode);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

