/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.events.AbstractFileChangeEvent;
import org.apache.commons.vfs2.events.ChangedEvent;
import org.apache.commons.vfs2.events.CreateEvent;
import org.apache.commons.vfs2.events.DeleteEvent;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.util.Messages;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final FileListener[] EMPTY_FILE_LISTENER_ARRAY = new FileListener[0];
    private static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    protected final Lock myLock = new ReentrantLock();
    @NotNull
    private final FileName rootName;
    private final String rootURI;
    private final Collection<Capability> capabilities = new HashSet<Capability>();
    private final Map<FileName, ArrayList<FileListener>> listenerMap = new HashMap<FileName, ArrayList<FileListener>>();
    private final FileSystemOptions fileSystemOptions;
    private final AtomicLong useCount = new AtomicLong();
    private FileSystemKey cacheKey;
    private final AtomicInteger openStreams = new AtomicInteger(0);

    protected AbstractFileSystem(@NotNull FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder builder = DefaultFileSystemConfigBuilder.getInstance();
        String uri = builder.getRootURI(fileSystemOptions);
        if (uri == null) {
            uri = rootName.getURI();
        }
        this.rootURI = uri;
    }

    protected AbstractFileSystem(@NotNull FileName rootName, FileSystemOptions fileSystemOptions) {
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder builder = DefaultFileSystemConfigBuilder.getInstance();
        String uri = builder.getRootURI(fileSystemOptions);
        if (uri == null) {
            uri = rootName.getURI();
        }
        this.rootURI = uri;
    }

    @Override
    public void init() {
        this.addCapabilities(this.capabilities);
    }

    @Override
    public void close() {
        this.closeCommunicationLink();
    }

    public void closeCommunicationLink() {
        this.myLock.lock();
        try {
            this.doCloseCommunicationLink();
        }
        finally {
            this.myLock.unlock();
        }
    }

    protected boolean tryClose() {
        return this.tryCloseCommunicationLink();
    }

    private boolean tryCloseCommunicationLink() {
        if (this.myLock.tryLock()) {
            try {
                this.doCloseCommunicationLink();
                boolean bl = true;
                return bl;
            }
            finally {
                this.myLock.unlock();
            }
        }
        return false;
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(@NotNull AbstractFileName var1) throws Exception;

    protected abstract void addCapabilities(Collection<Capability> var1);

    @Override
    @NotNull
    public FileName getRootName() {
        return this.rootName;
    }

    @Override
    public String getRootURI() {
        return this.rootURI;
    }

    protected void putFileToCache(FileObject file) {
        this.getFilesCache().putFile(file);
    }

    private FilesCache getFilesCache() {
        FilesCache filesCache = this.getContext().getFileSystemManager().getFilesCache();
        if (filesCache == null) {
            throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
        }
        return filesCache;
    }

    protected FileObject getFileFromCache(FileName name) {
        return this.getFilesCache().getFile(this, name);
    }

    protected void removeFileFromCache(FileName name) {
        this.getFilesCache().removeFile(this, name);
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return this.capabilities.contains((Object)capability);
    }

    @Override
    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    @Override
    public FileObject resolveFile(@NotNull String nameStr) throws FileSystemException {
        return this.resolveFile(this.getFileSystemManager().resolveName(this.rootName, nameStr));
    }

    @Override
    public FileObject resolveFile(@NotNull FileName name) throws FileSystemException {
        return this.resolveFile(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject resolveFile(@NotNull FileName name, boolean useCache) throws FileSystemException {
        this.myLock.lock();
        try {
            if (!this.rootName.getRootURI().equals(name.getRootURI())) {
                throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", name, this.rootName, name.getRootURI());
            }
            FileObject file = useCache ? this.getFileFromCache(name) : null;
            if (file == null) {
                try {
                    file = this.createFile((AbstractFileName)name);
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/resolve-file.error", (Object)name, (Throwable)e);
                }
                file = this.decorateFileObject(file);
                if (useCache) {
                    this.putFileToCache(file);
                }
            }
            if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
                file.refresh();
            }
            FileObject fileObject = file;
            return fileObject;
        }
        finally {
            this.myLock.unlock();
        }
    }

    protected FileObject decorateFileObject(FileObject file) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_CALL)) {
            file = new OnCallRefreshFileObject(file);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                file = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(file);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
        }
        return file;
    }

    @Override
    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    @Override
    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject file, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file, selector);
    }

    @Override
    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", (Object)this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FileObject file, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList listeners = this.listenerMap.computeIfAbsent(file.getName(), k -> new ArrayList());
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FileObject file, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file.getName());
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenerMap.remove(file.getName());
                }
            }
        }
    }

    public void fireFileCreated(FileObject file) {
        this.fireEvent(new CreateEvent(file));
    }

    public void fireFileDeleted(FileObject file) {
        this.fireEvent(new DeleteEvent(file));
    }

    public void fireFileChanged(FileObject file) {
        this.fireEvent(new ChangedEvent(file));
    }

    public boolean isReleaseable() {
        return this.useCount.get() < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent event) {
        FileListener[] fileListeners = null;
        FileObject fileObject = event.getFileObject();
        FileListener[] fileListenerArray = this.listenerMap;
        synchronized (this.listenerMap) {
            ArrayList<FileListener> listeners = this.listenerMap.get(fileObject.getName());
            if (listeners != null) {
                fileListeners = listeners.toArray(EMPTY_FILE_LISTENER_ARRAY);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (fileListeners != null) {
                for (FileListener fileListener : fileListeners) {
                    try {
                        event.notify(fileListener);
                    }
                    catch (Exception e) {
                        String message = Messages.getString("vfs.provider/notify-listener.warn", (Object)fileObject);
                        VfsLog.warn(this.getLogger(), LOG, message, e);
                    }
                }
            }
            return;
        }
    }

    void fileObjectHanded(FileObject fileObject) {
        this.useCount.incrementAndGet();
    }

    void fileObjectDestroyed(FileObject fileObject) {
        this.useCount.decrementAndGet();
    }

    void setCacheKey(FileSystemKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    void streamOpened() {
        this.openStreams.incrementAndGet();
    }

    void streamClosed() {
        if (this.openStreams.decrementAndGet() == 0) {
            this.notifyAllStreamsClosed();
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    public boolean isOpen() {
        return this.openStreams.get() > 0;
    }
}

