/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.util.URIUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericURLFileName
extends GenericFileName {
    private static final int BUFFER_SIZE = 250;
    private final String queryString;

    public GenericURLFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String queryString) {
        super(scheme, hostName, port, defaultPort, userName, password, path, type);
        if (StringUtils.isEmpty((CharSequence)this.absPath)) {
            this.absPath = "/";
        } else if (this.absPath.length() > 1 && this.absPath.endsWith("/") && !this.supportTrailingSeparator()) {
            this.absPath = this.absPath.substring(0, this.absPath.length() - 1);
        }
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathQueryEncoded(String charset) throws FileSystemException {
        if (this.getQueryString() == null) {
            if (charset != null) {
                return URIUtils.encodePath(this.getPathDecoded(), charset);
            }
            return URIUtils.encodePath(this.getPathDecoded());
        }
        StringBuilder sb = new StringBuilder(250);
        if (charset != null) {
            sb.append(URIUtils.encodePath(this.getPathDecoded(), charset));
        } else {
            sb.append(URIUtils.encodePath(this.getPathDecoded()));
        }
        sb.append("?");
        sb.append(this.getQueryString());
        return sb.toString();
    }

    @Override
    public FileName createName(String absPath, FileType type) {
        return new GenericURLFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), absPath, type, this.getQueryString());
    }

    @Override
    @NotNull
    public String getBaseName() {
        if (this.baseName == null) {
            int idx = this.getPath().endsWith("/") ? this.getPath().substring(0, this.getPath().length() - 2).lastIndexOf("/") : this.getPath().lastIndexOf("/");
            this.baseName = idx == -1 ? this.getPath() : this.getPath().substring(idx + 1);
        }
        if (this.baseName.endsWith("/")) {
            this.baseName = this.baseName.substring(0, this.baseName.length() - 1);
        }
        return this.baseName;
    }

    @Override
    protected String createURI() {
        if (this.getQueryString() != null) {
            return super.createURI() + "?" + this.getQueryString();
        }
        return super.createURI();
    }

    public String getURIEncoded(String charset) throws FileSystemException {
        StringBuilder sb = new StringBuilder(250);
        this.appendRootUri(sb, true);
        sb.append(this.getPathQueryEncoded(charset));
        return sb.toString();
    }

    @Override
    @Nullable
    public FileName getParent() {
        int idx;
        String path = this.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((idx = path.lastIndexOf(47)) == -1 || idx == path.length() - 1) {
            return null;
        }
        String parentPath = idx == 0 ? "/" : path.substring(0, idx) + "/";
        return this.createName(parentPath, FileType.FOLDER);
    }

    @Override
    public boolean supportTrailingSeparator() {
        return true;
    }
}

