/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.util.zipFs.Zip64Util;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a2\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0001\u00a8\u0006\u0011"}, d2={"recreateDir", "Ljava/nio/file/Path;", "file", "totalSize", "", "uncompressedZip", "", "dir", "targetFile", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compressSharedIndex", "output", "compressorStream", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "getFileOrDirectorySize", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/indexing/shared/util/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final Path recreateDir(@NotNull Path file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathsKt.deleteRecursively((Path)file);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        return file;
    }

    public static final long totalSize(@NotNull Path $this$totalSize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$totalSize, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile($this$totalSize, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            l = Files.size($this$totalSize);
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory($this$totalSize, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Ref.LongRef total = new Ref.LongRef();
                Files.walkFileTree($this$totalSize, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(total){
                    final /* synthetic */ Ref.LongRef $total;
                    {
                        this.$total = $total;
                    }

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                        this.$total.element += attrs.size();
                        return FileVisitResult.CONTINUE;
                    }
                });
                l = total.element;
            } else {
                l = 0L;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void uncompressedZip(@NotNull Path dir, @NotNull Path targetFile, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.pushState();
        indicator.setText(SharedIndexesBundle.message("progress.text.zipping.index.pack", new Object[0]));
        try {
            Closeable closeable = (Closeable)Zip64Util.openZip64File(targetFile, false);
            Throwable throwable = null;
            try {
                List<Object> list;
                JBZipFile file = (JBZipFile)closeable;
                boolean bl = false;
                indicator.setText2(SharedIndexesBundle.message("progress.text2.scanning.files", new Object[0]));
                AutoCloseable autoCloseable = Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.comparing(arg_0 -> UtilKt.uncompressedZip$lambda$5$lambda$1(arg_0 -> UtilKt.uncompressedZip$lambda$5$lambda$0(dir, arg_0), arg_0)));
                Throwable throwable2 = null;
                try {
                    Stream stream = (Stream)autoCloseable;
                    boolean bl2 = false;
                    list = stream.filter(arg_0 -> UtilKt.uncompressedZip$lambda$5$lambda$4$lambda$3(UtilKt::uncompressedZip$lambda$5$lambda$4$lambda$2, arg_0)).toList();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                List<Object> allFiles = list;
                indicator.setIndeterminate(false);
                double count = 0.0;
                for (Path path : allFiles) {
                    String relativePath;
                    indicator.checkCanceled();
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((Object)dir.relativize(path)).toString()), (String)"toSystemIndependentName(...)");
                    try {
                        double d = count;
                        count = d + 1.0;
                        indicator.setFraction(d / (double)allFiles.size());
                        JBZipEntry entry = file.getOrCreateEntry(relativePath);
                        entry.setMethod(0);
                        entry.setTime(0L);
                        entry.setDataFromPath(path);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to add " + relativePath + " entry to the target archive. " + e.getMessage(), e);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetFile);
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw new RuntimeException("Failed to generate indexes archive at " + targetFile + ". " + e.getMessage(), e);
        }
        finally {
            indicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void compressSharedIndex(@NotNull Path file, @NotNull Path output, @NotNull ProgressIndicator indicator, @NotNull Function1<? super OutputStream, ? extends OutputStream> compressorStream) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(compressorStream, (String)"compressorStream");
        indicator.pushState();
        int bufferSize = 0x800000;
        indicator.setText(SharedIndexesBundle.message("packing.to.xz", new Object[0]));
        indicator.setIndeterminate(false);
        long total = Files.size(file);
        long completed = 0L;
        try {
            Closeable closeable = PathKt.outputStream$default((Path)output, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, bufferSize);
            Throwable throwable = null;
            try {
                BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)compressorStream.invoke((Object)outputStream);
                Throwable throwable2 = null;
                try {
                    OutputStream output2 = (OutputStream)closeable2;
                    boolean bl2 = false;
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    Closeable closeable3 = inputStream;
                    Throwable throwable3 = null;
                    try {
                        int sz;
                        InputStream inputStream2 = (InputStream)closeable3;
                        boolean bl3 = false;
                        byte[] buffer = new byte[bufferSize];
                        while ((sz = inputStream2.read(buffer)) > 0) {
                            output2.write(buffer, 0, sz);
                            indicator.setFraction((double)(completed += (long)sz) / (double)total);
                            indicator.checkCanceled();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            FileUtil.delete((Path)output);
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw new RuntimeException("Failed to generate compressed shared index from " + file + " to " + output + ". " + e.getMessage(), e);
        }
        finally {
            indicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getFileOrDirectorySize(@NotNull Path $this$getFileOrDirectorySize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getFileOrDirectorySize, (String)"<this>");
        if (!Files.exists($this$getFileOrDirectorySize, new LinkOption[0])) {
            return 0L;
        }
        if (!Files.isDirectory($this$getFileOrDirectorySize, new LinkOption[0])) {
            l = Files.size($this$getFileOrDirectorySize);
        } else {
            AutoCloseable autoCloseable = Files.walk($this$getFileOrDirectorySize, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                long l2 = it.filter(arg_0 -> UtilKt.getFileOrDirectorySize$lambda$13$lambda$10(UtilKt::getFileOrDirectorySize$lambda$13$lambda$9, arg_0)).mapToLong(arg_0 -> UtilKt.getFileOrDirectorySize$lambda$13$lambda$12(UtilKt::getFileOrDirectorySize$lambda$13$lambda$11, arg_0)).sum();
                l = l2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return l;
    }

    private static final String uncompressedZip$lambda$5$lambda$0(Path $dir, Path it) {
        Path path = $dir.relativize(it);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        return ((Object)path).toString();
    }

    private static final String uncompressedZip$lambda$5$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean uncompressedZip$lambda$5$lambda$4$lambda$2(Path it) {
        return !Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean uncompressedZip$lambda$5$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getFileOrDirectorySize$lambda$13$lambda$9(Path p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.toFile().isFile();
    }

    private static final boolean getFileOrDirectorySize$lambda$13$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final long getFileOrDirectorySize$lambda$13$lambda$11(Path p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.toFile().length();
    }

    private static final long getFileOrDirectorySize$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }
}

