/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.SharedIndexBase;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentEnumerators;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"loadSharedIndexAsBase", "Lcom/intellij/indexing/shared/generator/SharedIndexBase;", "sharedIndex", "Ljava/nio/file/Path;", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "tempRoot", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporterBasesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporterBasesLoader.kt\ncom/intellij/indexing/shared/generator/IndexesExporterBasesLoaderKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n3170#2,11:101\n1557#3:112\n1628#3,3:113\n*S KotlinDebug\n*F\n+ 1 IndexesExporterBasesLoader.kt\ncom/intellij/indexing/shared/generator/IndexesExporterBasesLoaderKt\n*L\n36#1:101,11\n81#1:112\n81#1:113,3\n*E\n"})
public final class IndexesExporterBasesLoaderKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final SharedIndexBase loadSharedIndexAsBase(@NotNull Path sharedIndex, @NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Path tempRoot) {
        Pair t2;
        Object object;
        byte[] bytes;
        Object object2;
        SharedIndexCompression sharedIndexCompression;
        Object element$iv;
        Object $this$singleOrNull$iv;
        block36: {
            Intrinsics.checkNotNullParameter((Object)sharedIndex, (String)"sharedIndex");
            Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)tempRoot, (String)"tempRoot");
            $this$singleOrNull$iv = SharedIndexCompression.values();
            boolean $i$f$singleOrNull = false;
            SharedIndexCompression single$iv22 = null;
            boolean found$iv = false;
            int n = ((SharedIndexCompression[])$this$singleOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                SharedIndexCompression it = element$iv = $this$singleOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)((Object)sharedIndex.getFileName()).toString(), (String)(".ijx" + it.getExtensionSuffix()), (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    sharedIndexCompression = null;
                    break block36;
                }
                single$iv22 = element$iv;
                found$iv = true;
            }
            sharedIndexCompression = !found$iv ? null : single$iv22;
        }
        if (sharedIndexCompression == null) {
            throw new IllegalStateException("Failed to resolve extension to shared index compression".toString());
        }
        SharedIndexCompression ext = sharedIndexCompression;
        $this$singleOrNull$iv = tempRoot.toFile();
        Path unpackRoot = FilesKt.createTempDir$default((String)((Object)sharedIndex.getFileName()).toString(), null, (File)$this$singleOrNull$iv, (int)2, null).toPath();
        Intrinsics.checkNotNull((Object)unpackRoot);
        PathKt.delete$default((Path)unpackRoot, (boolean)false, (int)1, null);
        byte[] metadataBytes = null;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(sharedIndex, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable $i$f$singleOrNull = inputStream;
        int single$iv22 = 0x100000;
        $i$f$singleOrNull = $i$f$singleOrNull instanceof BufferedInputStream ? (BufferedInputStream)$i$f$singleOrNull : new BufferedInputStream((InputStream)$i$f$singleOrNull, single$iv22);
        Throwable single$iv22 = null;
        try {
            BufferedInputStream compressedStream = (BufferedInputStream)$i$f$singleOrNull;
            boolean bl = false;
            Closeable closeable = ext.createUnpackingStream((InputStream)compressedStream);
            element$iv = null;
            try {
                InputStream uncompressedZipStream = (InputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new ZipInputStream(uncompressedZipStream);
                object2 = null;
                try {
                    ZipInputStream zip = (ZipInputStream)closeable2;
                    boolean bl3 = false;
                    while (zip.getNextEntry() != null) {
                        ZipEntry next;
                        if (next.isDirectory()) continue;
                        String name = next.getName();
                        Intrinsics.checkNotNull((Object)name);
                        if (SharedIndexContentEnumerators.INSTANCE.isRelatedToEnumerator(name)) {
                            bytes = ByteStreamsKt.readBytes((InputStream)zip);
                            Path path = unpackRoot.resolve(name);
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                            PathKt.write((Path)path, (byte[])bytes);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)name, (Object)SharedIndexMetadata.Companion.getMetadataPath())) continue;
                        metadataBytes = ByteStreamsKt.readBytes((InputStream)zip);
                    }
                    zip = Unit.INSTANCE;
                }
                catch (Throwable zip) {
                    object2 = zip;
                    throw zip;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
                }
                uncompressedZipStream = Unit.INSTANCE;
            }
            catch (Throwable uncompressedZipStream) {
                element$iv = uncompressedZipStream;
                throw uncompressedZipStream;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)element$iv);
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            single$iv22 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$f$singleOrNull, (Throwable)single$iv22);
        }
        if (metadataBytes == null) {
            throw new IllegalStateException("Failed to find metadata.json entry".toString());
        }
        SharedIndexMetadata metadata = SharedIndexMetadata.Companion.tryReadSharedIndexMetadata(metadataBytes);
        if (metadata == null) {
            throw new IllegalStateException("Failed to read metadata.json".toString());
        }
        if (!ideVersion.isSuitableMetadata(metadata)) {
            throw new IllegalStateException(("The shared index (" + metadata + ") is not compatible with the current version (" + ideVersion + ")").toString());
        }
        try {
            object = (Closeable)SharedIndexContentEnumerators.INSTANCE.openEnumeratorForAttachedSharedIndex(unpackRoot);
            Throwable bl = null;
            try {
                void $this$mapTo$iv$iv;
                Object enumerator = (ContentHashEnumerator)object;
                boolean bl4 = false;
                ArrayList hashes = new ArrayList();
                enumerator.forEach((arg_0, arg_1) -> IndexesExporterBasesLoaderKt.loadSharedIndexAsBase$lambda$7$lambda$5((arg_0, arg_1) -> IndexesExporterBasesLoaderKt.loadSharedIndexAsBase$lambda$7$lambda$4(hashes, arg_0, arg_1), arg_0, arg_1));
                Iterable $this$map$iv = hashes;
                boolean $i$f$map = false;
                object2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    bytes = (byte[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(new IndexedFileHash((byte[])it, null, 2, null));
                }
                enumerator = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            }
            catch (Throwable enumerator) {
                bl = enumerator;
                throw enumerator;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)bl);
            }
            object = enumerator;
        }
        catch (Throwable t2) {
            throw new RuntimeException("Failed to load ContentHashEnumerator. " + t2.getMessage(), t2);
        }
        finally {
            PathKt.delete$default((Path)unpackRoot, (boolean)false, (int)1, null);
        }
        Object knownHashes = object;
        try {
            t2 = TuplesKt.to((Object)Files.size(sharedIndex), (Object)DigestUtilKt.sha256Hex((Path)sharedIndex));
        }
        catch (Throwable t3) {
            throw new RuntimeException("Cannot compute size and sha256 for the shared index. " + t3.getMessage(), t3);
        }
        object = t2;
        long size = ((Number)object.component1()).longValue();
        String sha256 = (String)object.component2();
        return new SharedIndexBase(sharedIndex, sha256, size, metadata, (Set)knownHashes);
    }

    private static final boolean loadSharedIndexAsBase$lambda$7$lambda$4(ArrayList $hashes, int n, byte[] hash) {
        return $hashes.add(hash);
    }

    private static final boolean loadSharedIndexAsBase$lambda$7$lambda$5(Function2 $tmp0, int p0, Object p1) {
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }
}

