/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyByteLiteralInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyByteLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyByteLiteralInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyByteLiteralInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            char first_char;
            boolean isByte;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            String value = node.getStringValue();
            PsiFile file = node.getContainingFile();
            if (file == null) {
                return;
            }
            boolean default_bytes = false;
            if (file instanceof PyFile) {
                PyFile pyfile = (PyFile)file;
                default_bytes = !FutureFeature.UNICODE_LITERALS.requiredAt(pyfile.getLanguageLevel()) && !pyfile.hasImportFromFuture(FutureFeature.UNICODE_LITERALS);
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration((PsiFile)file);
            try {
                if (charsetString != null && !Charset.forName(charsetString).equals(StandardCharsets.US_ASCII)) {
                    default_bytes = false;
                }
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
            boolean hasNonAscii = false;
            int length = value.length();
            char c = '\u0000';
            for (int i = 0; i < length; ++i) {
                c = value.charAt(i);
                if (c <= '\u00ff') continue;
                hasNonAscii = true;
                break;
            }
            boolean bl = isByte = (first_char = Character.toLowerCase(node.getText().charAt(0))) == 'b' || default_bytes && first_char != 'u';
            if (hasNonAscii && isByte) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.byte.literal.contains.illegal.characters", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyByteLiteralInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

