/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.invertBoolean;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.rename.RenameProcessor;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInvertBooleanDelegate
extends InvertBooleanDelegate {
    public boolean isVisibleOnElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        VirtualFile virtualFile;
        if (element == null) {
            PyInvertBooleanDelegate.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile2 = virtualFile = (containingFile = element.getContainingFile()) != null ? containingFile.getVirtualFile() : null;
        if (virtualFile != null && ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
            return false;
        }
        if (element instanceof PyTargetExpression || element instanceof PyNamedParameter) {
            return true;
        }
        return PyInvertBooleanDelegate.isBooleanLiteral(element.getParent());
    }

    public boolean isAvailableOnElement(@NotNull PsiElement element) {
        PyExpression defaultValue;
        PyAssignmentStatement assignmentStatement;
        VirtualFile virtualFile;
        if (element == null) {
            PyInvertBooleanDelegate.$$$reportNull$$$0(1);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
            return false;
        }
        if (element instanceof PyTargetExpression && (assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class)) != null) {
            PyExpression assignedValue = assignmentStatement.getAssignedValue();
            if (assignedValue == null) {
                return false;
            }
            return PyInvertBooleanDelegate.isBooleanLiteral((PsiElement)assignedValue);
        }
        if (element instanceof PyNamedParameter && (defaultValue = ((PyNamedParameter)element).getDefaultValue()) != null && PyInvertBooleanDelegate.isBooleanLiteral((PsiElement)defaultValue)) {
            return true;
        }
        return PyInvertBooleanDelegate.isBooleanLiteral(element.getParent());
    }

    @Nullable
    public PsiElement adjustElement(PsiElement element, Project project, Editor editor2) {
        PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
        if (assignmentStatement != null) {
            return assignmentStatement.getTargets()[0];
        }
        if (element instanceof PyNamedParameter) {
            return element;
        }
        return null;
    }

    public void collectRefElements(PsiElement psiElement, @Nullable RenameProcessor renameProcessor, @NotNull String newName, Collection<? super PsiElement> elementsToInvert) {
        if (newName == null) {
            PyInvertBooleanDelegate.$$$reportNull$$$0(2);
        }
        Collection refs = ReferencesSearch.search((PsiElement)psiElement).findAll();
        for (PsiReference ref : refs) {
            PsiElement refElement = ref.getElement();
            if (this.collectElementsToInvert(psiElement, refElement, elementsToInvert)) continue;
            PyInvertBooleanDelegate.collectForeignElementsToInvert((PsiElement)psiElement, (PsiElement)refElement, (Language)PythonLanguage.getInstance(), elementsToInvert);
        }
    }

    public PsiElement getElementToInvert(PsiElement namedElement, PsiElement element) {
        if (element instanceof PyTargetExpression) {
            PyExpression value;
            PyTargetExpression target = (PyTargetExpression)element;
            PyAssignmentStatement parent = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyAssignmentStatement.class);
            if (parent != null && parent.getTargets().length == 1 && (value = parent.getAssignedValue()) != null) {
                return value;
            }
        } else {
            if (element.getParent() instanceof PyPrefixExpression) {
                return element.getParent();
            }
            if (element instanceof PyReferenceExpression) {
                return element;
            }
        }
        return null;
    }

    public void invertElementInitializer(PsiElement psiElement) {
        PyExpression defaultValue;
        if (psiElement instanceof PyNamedParameter && (defaultValue = ((PyNamedParameter)psiElement).getDefaultValue()) != null) {
            this.replaceWithNegatedExpression((PsiElement)defaultValue);
        }
    }

    public void replaceWithNegatedExpression(PsiElement expression) {
        if (expression != null && PsiTreeUtil.getParentOfType((PsiElement)expression, PyImportStatementBase.class, (boolean)false) == null) {
            PyExpression replacement = PyInvertBooleanDelegate.invertExpression(expression);
            expression.replace((PsiElement)replacement);
        }
    }

    @NotNull
    private static PyExpression invertExpression(@NotNull PsiElement expression) {
        PyExpression operand;
        if (expression == null) {
            PyInvertBooleanDelegate.$$$reportNull$$$0(3);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        if (expression instanceof PyBoolLiteralExpression) {
            String value = ((PyBoolLiteralExpression)expression).getValue() ? "False" : "True";
            PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), value);
            if (pyExpression == null) {
                PyInvertBooleanDelegate.$$$reportNull$$$0(4);
            }
            return pyExpression;
        }
        if (expression instanceof PyReferenceExpression && ("False".equals(expression.getText()) || "True".equals(expression.getText()))) {
            String value = "True".equals(expression.getText()) ? "False" : "True";
            PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), value);
            if (pyExpression == null) {
                PyInvertBooleanDelegate.$$$reportNull$$$0(5);
            }
            return pyExpression;
        }
        if (expression instanceof PyPrefixExpression && ((PyPrefixExpression)expression).getOperator() == PyTokenTypes.NOT_KEYWORD && (operand = ((PyPrefixExpression)expression).getOperand()) != null) {
            PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), operand.getText());
            if (pyExpression == null) {
                PyInvertBooleanDelegate.$$$reportNull$$$0(6);
            }
            return pyExpression;
        }
        PyExpression pyExpression = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), "not " + expression.getText());
        if (pyExpression == null) {
            PyInvertBooleanDelegate.$$$reportNull$$$0(7);
        }
        return pyExpression;
    }

    private static boolean isBooleanLiteral(@Nullable PsiElement element) {
        if (element instanceof PyBoolLiteralExpression) {
            return true;
        }
        return element instanceof PyReferenceExpression && ("True".equals(element.getText()) || "False".equals(element.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/invertBoolean/PyInvertBooleanDelegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "invertExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleOnElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectRefElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invertExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

