/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.codeStyle;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleInstaller;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class JSPrettierCodeStyleInstaller
implements PrettierCodeStyleInstaller {
    @Override
    public void install(@NotNull Project project, @NotNull PrettierConfig config, @NotNull CodeStyleSettings settings) {
        if (project == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(0);
        }
        if (config == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(2);
        }
        JSPrettierCodeStyleInstaller.installJSDialectSettings(config, settings, (Language)JavascriptLanguage.INSTANCE, JSCodeStyleSettings.class);
        JSPrettierCodeStyleInstaller.installJSDialectSettings(config, settings, (Language)JavaScriptSupportLoader.TYPESCRIPT, TypeScriptCodeStyleSettings.class);
    }

    @Override
    public boolean isInstalled(@NotNull Project project, @NotNull PrettierConfig config, @NotNull CodeStyleSettings settings) {
        if (project == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(3);
        }
        if (config == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(5);
        }
        return JSPrettierCodeStyleInstaller.isInstalledForDialect(config, settings, (Language)JavascriptLanguage.INSTANCE, JSCodeStyleSettings.class) && JSPrettierCodeStyleInstaller.isInstalledForDialect(config, settings, (Language)JavaScriptSupportLoader.TYPESCRIPT, TypeScriptCodeStyleSettings.class);
    }

    private static boolean isInstalledForDialect(@NotNull PrettierConfig config, CodeStyleSettings settings, Language language, Class<? extends JSCodeStyleSettings> settingsClass) {
        if (config == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(6);
        }
        JSCodeStyleSettings customSettings = (JSCodeStyleSettings)settings.getCustomSettings(settingsClass);
        return customSettings.USE_DOUBLE_QUOTES == !config.singleQuote && customSettings.FORCE_QUOTE_STYlE && customSettings.USE_SEMICOLON_AFTER_STATEMENT == config.semi && customSettings.FORCE_SEMICOLON_STYLE && customSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES == config.bracketSpacing && customSettings.SPACES_WITHIN_OBJECT_TYPE_BRACES == config.bracketSpacing && customSettings.SPACES_WITHIN_IMPORTS == config.bracketSpacing && customSettings.ENFORCE_TRAILING_COMMA == JSPrettierCodeStyleInstaller.convertTrailingCommaOption(config.trailingComma) && PrettierCodeStyleInstaller.commonPrettierSettingsApplied(config, settings, language);
    }

    private static void installJSDialectSettings(@NotNull PrettierConfig config, @NotNull CodeStyleSettings settings, @NotNull Language language, @NotNull Class<? extends JSCodeStyleSettings> settingsClass) {
        if (config == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(8);
        }
        if (language == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(9);
        }
        if (settingsClass == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(10);
        }
        PrettierCodeStyleInstaller.applyCommonPrettierSettings(config, settings, language);
        JSCodeStyleSettings customSettings = (JSCodeStyleSettings)settings.getCustomSettings(settingsClass);
        customSettings.USE_DOUBLE_QUOTES = !config.singleQuote;
        customSettings.USE_SEMICOLON_AFTER_STATEMENT = config.semi;
        customSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES = config.bracketSpacing;
        customSettings.SPACES_WITHIN_OBJECT_TYPE_BRACES = config.bracketSpacing;
        customSettings.SPACES_WITHIN_IMPORTS = config.bracketSpacing;
        customSettings.ENFORCE_TRAILING_COMMA = JSPrettierCodeStyleInstaller.convertTrailingCommaOption(config.trailingComma);
        customSettings.FORCE_QUOTE_STYlE = true;
        customSettings.FORCE_SEMICOLON_STYLE = true;
        customSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = false;
    }

    @NotNull
    private static JSCodeStyleSettings.TrailingCommaOption convertTrailingCommaOption(@NotNull PrettierConfig.TrailingCommaOption option) {
        if (option == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(11);
        }
        JSCodeStyleSettings.TrailingCommaOption trailingCommaOption = switch (option) {
            default -> throw new IncompatibleClassChangeError();
            case PrettierConfig.TrailingCommaOption.none -> JSCodeStyleSettings.TrailingCommaOption.Remove;
            case PrettierConfig.TrailingCommaOption.all, PrettierConfig.TrailingCommaOption.es5 -> JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
        };
        if (trailingCommaOption == null) {
            JSPrettierCodeStyleInstaller.$$$reportNull$$$0(12);
        }
        return trailingCommaOption;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/codeStyle/JSPrettierCodeStyleInstaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/codeStyle/JSPrettierCodeStyleInstaller";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTrailingCommaOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInstalled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInstalledForDialect";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installJSDialectSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertTrailingCommaOption";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

