/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic.ui.logs;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEvent;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEventListener;
import com.intellij.ml.inline.completion.impl.diagnostic.TextLogKt;
import com.intellij.ml.inline.completion.impl.diagnostic.TextMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.text.DateFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/logs/MLCompletionFullLogsWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "consoleLog", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "dispose", "", "intellij.ml.inline.completion"})
public final class MLCompletionFullLogsWindow
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final ConsoleViewImpl consoleLog;

    public MLCompletionFullLogsWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, true);
        this.consoleLog = new ConsoleViewImpl(project, true);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.consoleLog));
        this.setContent(this.consoleLog.getComponent());
        DiagnosticLoggersKt.addMLCompletionEventsListener(new MLCompletionEventListener(){

            @Override
            public void onEvent(MLCompletionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!consoleLog.isDisplayable()) {
                    return;
                }
                TextMessage textMessage = TextLogKt.toTextMessage(event);
                if (textMessage == null) {
                    return;
                }
                TextMessage textMessage2 = textMessage;
                String string = DateFormatUtil.formatTimeWithSeconds((long)textMessage2.getTime());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatTimeWithSeconds(...)");
                String time = string;
                ConsoleViewImpl consoleViewImpl = consoleLog;
                String string2 = "[ " + time + " ] ";
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"LOG_DEBUG_OUTPUT");
                consoleViewImpl.print(string2, consoleViewContentType);
                ConsoleViewImpl consoleViewImpl2 = consoleLog;
                String string3 = textMessage2.getText() + "\n";
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
                consoleViewImpl2.print(string3, consoleViewContentType2);
            }
        }, this);
    }

    public void dispose() {
    }
}

