/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.convert;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtilKt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.lang.JupyterLangData;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "jupyterCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "popupPresentationTextKey", "", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabledAndVisible", "", "actionPerformed", "Companion", "Lcom/intellij/jupyter/core/core/impl/actions/convert/JupyterConvertToSqlCellAction;", "Lcom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertToCodeCellAction;", "Lcom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertToMarkdownCellAction;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookConvertCellAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookConvertCellAction.kt\ncom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NotebookCellLinesActionUtil.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1755#2,3:72\n39#3,8:75\n47#3,2:84\n1#4:83\n*S KotlinDebug\n*F\n+ 1 NotebookConvertCellAction.kt\ncom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction\n*L\n47#1:72,3\n53#1:75,8\n53#1:84,2\n53#1:83\n*E\n"})
public abstract class NotebookConvertCellAction
extends DumbAwareAction
implements JupyterEditorAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterCellType jupyterCellType;
    @NotNull
    private final String popupPresentationTextKey;

    private NotebookConvertCellAction(JupyterCellType jupyterCellType, String popupPresentationTextKey) {
        this.jupyterCellType = jupyterCellType;
        this.popupPresentationTextKey = popupPresentationTextKey;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(event));
        if (Intrinsics.areEqual((Object)event.getPlace(), (Object)"popup")) {
            event.getPresentation().setText(JupyterBundle.message(this.popupPresentationTextKey, new Object[0]));
        }
    }

    private final boolean isEnabledAndVisible(AnActionEvent event) {
        boolean bl;
        block7: {
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
            if (editorImpl == null) {
                return false;
            }
            EditorImpl editor = editorImpl;
            if (!NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)editor))) {
                return false;
            }
            NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.get((Editor)editor);
            if (!(notebookCellLinesEditHelper != null ? notebookCellLinesEditHelper.isChangingCellTypeAllowed() : false)) {
                return false;
            }
            JupyterLangData jupyterLangData = JupyterLangData.Companion.getDataByJupyterCellType(JupyterEditorExtensionsKt.getNotebookFile((Editor)editor), this.jupyterCellType);
            if (jupyterLangData == null) {
                return false;
            }
            JupyterLangData cellTypeData = jupyterLangData;
            NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
            Intrinsics.checkNotNull((Object)notebookCellSelectionModel);
            Iterable $this$any$iv = notebookCellSelectionModel.getSelectedCells();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                    boolean bl2 = false;
                    if (!(JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(it) != cellTypeData.getJupyterCellType())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$withCellLinesAndSelection = false;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext$iv$iv = dataContext;
        boolean $i$f$withCellLinesAndSelection2 = false;
        Object object = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext$iv$iv);
        if (object != null) {
            EditorImpl editorImpl;
            EditorImpl it$iv$iv = editorImpl = object;
            boolean bl = false;
            object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it$iv$iv)) ? editorImpl : null;
            if (object == null) {
            } else {
                EditorImpl editor$iv$iv;
                NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor$iv$iv));
                if (notebookCellSelectionModel != null) {
                    void cellSelection;
                    void cellLines;
                    NotebookCellSelectionModel notebookCellSelectionModel2 = notebookCellSelectionModel;
                    NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get((Editor)editor$iv$iv);
                    EditorImpl editor = editor$iv$iv = object;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{Companion.makeName(this.jupyterCellType)};
                    String actionName = JupyterBundle.message("convert.cell.command.name", objectArray);
                    Project project = event.getProject();
                    if (project == null) {
                        return;
                    }
                    WriteCommandAction.writeCommandAction((Project)project).withName(actionName).run(() -> NotebookConvertCellAction.actionPerformed$lambda$2$lambda$1(editor, this, (NotebookCellLines)cellLines, (NotebookCellSelectionModel)cellSelection));
                }
            }
        }
    }

    private static final void actionPerformed$lambda$2$lambda$1(EditorImpl $editor, NotebookConvertCellAction this$0, NotebookCellLines $cellLines, NotebookCellSelectionModel $cellSelection) {
        JupyterLangData jupyterLangData = JupyterLangData.Companion.getDataByJupyterCellType(JupyterEditorExtensionsKt.getNotebookFile((Editor)$editor), this$0.jupyterCellType);
        if (jupyterLangData == null) {
            return;
        }
        JupyterLangData cellType = jupyterLangData;
        NotebookCellLinesActionUtilKt.convertCells((Editor)$editor, $cellLines, $cellSelection, cellType);
        if (cellType.getCellType() == NotebookCellLines.CellType.MARKDOWN) {
            NotebookEditorModeKt.setMode((Editor)((Editor)$editor), (NotebookEditorMode)NotebookEditorMode.COMMAND);
        }
    }

    public /* synthetic */ NotebookConvertCellAction(JupyterCellType jupyterCellType, String popupPresentationTextKey, DefaultConstructorMarker $constructor_marker) {
        this(jupyterCellType, popupPresentationTextKey);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction$Companion;", "", "<init>", "()V", "makeName", "", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String makeName(@NotNull JupyterCellType cellType) {
            Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
            String string = cellType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = Strings.capitalize((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

