/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.tags;

import com.intellij.jupyter.core.core.impl.actions.select.NotebookCellLinesWithSelectionActionBase;
import com.intellij.jupyter.core.editor.ui.NotebookCellAddTagDialog;
import com.intellij.jupyter.core.fus.JupyterFusAddTagSource;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/tags/NotebookCellAddTagAction;", "Lcom/intellij/jupyter/core/core/impl/actions/select/NotebookCellLinesWithSelectionActionBase;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cellSelection", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "update", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellAddTagAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellAddTagAction.kt\ncom/intellij/jupyter/core/core/impl/actions/tags/NotebookCellAddTagAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class NotebookCellAddTagAction
extends NotebookCellLinesWithSelectionActionBase
implements ActionRemoteBehaviorSpecification.Frontend {
    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.firstOrNull((List)cellSelection.getSelectedCells());
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval selectedCell = interval;
        NotebookCellAddTagDialog dialog = new NotebookCellAddTagDialog(project2, (Editor)editor, selectedCell.getOrdinal(), JupyterFusAddTagSource.CONTEXT_MENU);
        dialog.show();
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl != null) {
            EditorImpl editorImpl2;
            EditorImpl it = editorImpl2 = editorImpl;
            boolean bl = false;
            object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it)) ? editorImpl2 : null;
        } else {
            object = null;
        }
        boolean hasCellLinesAnsSelectionSupport = object != null;
        boolean registryEnabled = Registry.Companion.is("jupyter.cell.metadata.tags", false);
        event.getPresentation().setEnabledAndVisible(hasCellLinesAnsSelectionSupport && registryEnabled);
    }
}

