/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.doubleFile;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.doubleFile.JupyterOriginEventHandler;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookOriginToSourceChangePropagator;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFileSystem;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListeners;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"propagateChange", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "sourceDocument", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "project", "Lcom/intellij/openapi/project/Project;", "updatedNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookFileChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookFileChangeListener.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookFileChangeListenerKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,203:1\n19#2:204\n14#3:205\n14#3:206\n14#3:207\n1557#4:208\n1628#4,2:209\n1630#4:214\n1557#4:215\n1628#4,2:216\n1630#4:221\n1104#5,3:211\n1104#5,3:218\n*S KotlinDebug\n*F\n+ 1 NotebookFileChangeListener.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookFileChangeListenerKt\n*L\n95#1:204\n99#1:205\n116#1:206\n145#1:207\n148#1:208\n148#1:209,2\n148#1:214\n149#1:215\n149#1:216,2\n149#1:221\n148#1:211,3\n149#1:218,3\n*E\n"})
public final class NotebookFileChangeListenerKt {
    private static final void propagateChange(VirtualFile file) {
        block9: {
            Throwable throwable;
            Object object;
            if (!(file instanceof VirtualFileWithId)) {
                return;
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile = NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem().getCached((VirtualFileWithId)file);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile sourceFile = backedNotebookVirtualFile;
            Document $this$asSafely$iv = FileDocumentManager.getInstance().getDocument(sourceFile.getFile());
            boolean $i$f$asSafely22 = false;
            Document document = $this$asSafely$iv;
            if (!(document instanceof DocumentEx)) {
                document = null;
            }
            DocumentEx documentEx = (DocumentEx)document;
            if (documentEx == null) {
                return;
            }
            DocumentEx sourceDocument = documentEx;
            Project project = ProjectLocator.Companion.getInstance().guessProjectForFile(file);
            if (project == null) {
                return;
            }
            Project project2 = project;
            if (!project2.isInitialized()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JupyterOriginEventHandler.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(StringsKt.trimIndent((String)("\n          Unexpected change of the file " + file + "\n          Source document is " + sourceDocument + "\n          Source file is " + sourceFile + "\n          Project is " + project2 + "\n          Project.isOpen = " + project2.isOpen() + "\n          Project.isDisposed = " + project2.isDisposed() + "\n          ")));
                return;
            }
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)JupyterFileUtils.INSTANCE.readNotebook(file));
            }
            catch (Throwable $i$f$asSafely22) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$asSafely22));
            }
            if (Result.isSuccess-impl((Object)object)) {
                JupyterNotebookBase updatedNotebook = (JupyterNotebookBase)object;
                boolean bl = false;
                NotebookFileChangeListenerKt.propagateChange(file, sourceFile, sourceDocument, project2, updatedNotebook);
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block9;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JupyterOriginEventHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("cannot parse updated notebook " + file, it);
        }
    }

    public static final void propagateChange(@NotNull VirtualFile file, @NotNull BackedNotebookVirtualFile sourceFile, @NotNull DocumentEx sourceDocument, @NotNull Project project, @NotNull JupyterNotebookBase updatedNotebook) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)sourceDocument, (String)"sourceDocument");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)updatedNotebook, (String)"updatedNotebook");
        ThreadingAssertions.assertWriteAccess();
        JupyterNotebook originalNotebook = sourceFile.getNotebook();
        updatedNotebook.setListeners(originalNotebook.getListeners());
        originalNotebook.setListeners(new JupyterListeners());
        WriteCommandAction.writeCommandAction((Project)project).withName(JupyterBundle.message("action.JupyterLoadNotebookFromDisk.text", new Object[0])).run(() -> NotebookFileChangeListenerKt.propagateChange$lambda$3(sourceDocument, updatedNotebook, file));
        List intervals = NotebookCellLines.Companion.get((Document)sourceDocument).getIntervals();
        if (intervals.size() != updatedNotebook.cellsCount() || intervals.size() != sourceFile.getNotebook().cellsCount()) {
            Collection<Integer> collection;
            char it;
            char element$iv;
            int n;
            int count$iv;
            boolean $i$f$count;
            CharSequence $this$count$iv;
            JupyterCell it2;
            Collection<Integer> collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List<JupyterCell> cells = sourceFile.getNotebook().computeCells();
            boolean $i$f$logger22 = false;
            Logger logger = Logger.getInstance(NotebookOriginToSourceChangePropagator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Iterable $i$f$logger22 = updatedNotebook.computeCells();
            List list = intervals;
            int n2 = updatedNotebook.computeCells().size();
            int n3 = cells.size();
            int n4 = intervals.size();
            Logger logger2 = logger;
            boolean $i$f$map = false;
            void var10_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JupyterCell jupyterCell = (JupyterCell)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                $this$count$iv = it2.getSource();
                $i$f$count = false;
                count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    it = element$iv = $this$count$iv.charAt(n);
                    boolean bl2 = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                collection2.add(count$iv + 1);
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = cells;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (JupyterCell)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                $this$count$iv = it2.getSource();
                $i$f$count = false;
                count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    it = element$iv = $this$count$iv.charAt(n);
                    boolean bl3 = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                collection.add(count$iv + 1);
            }
            collection = (List)destination$iv$iv;
            logger2.error(StringsKt.trimMargin$default((String)("Jupyter notebook has " + n4 + " intervals, but original notebook has " + n3 + " and updated notebook has " + n2 + " cells.\n        |intervals = " + list + "\n        |updated notebook cells sizes = " + collection2 + "\n        |original notebook cells sizes = " + (List)collection + "\n      "), null, (int)1, null));
        }
        sourceFile.setNotebookOrNull(updatedNotebook);
        PsiDocumentManager.getInstance((Project)project).commitDocument((Document)sourceDocument);
        JupyterListenersKt.notifyNotebookChanged(updatedNotebook);
        JupyterListenersKt.allOutputsUpdated(updatedNotebook);
        NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem().markUnmodified$intellij_jupyter_core(sourceFile);
    }

    private static final void propagateChange$lambda$3(DocumentEx $sourceDocument, JupyterNotebookBase $updatedNotebook, VirtualFile $file) {
        $sourceDocument.setText($updatedNotebook.asSource());
        $sourceDocument.setModificationStamp($file.getModificationStamp());
    }

    public static final /* synthetic */ void access$propagateChange(VirtualFile file) {
        NotebookFileChangeListenerKt.propagateChange(file);
    }
}

