/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionInterruptService;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorProvider;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookFileListenerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isInitialized", "", "installListenerIfNeeded", "", "createAsyncFileListener", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "deleteSession", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "dispose", "Companion", "intellij.jupyter.core"})
public final class NotebookFileListenerService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean isInitialized;

    public NotebookFileListenerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void installListenerIfNeeded() {
        if (this.isInitialized) {
            return;
        }
        VirtualFileManager.getInstance().addAsyncFileListener(this.createAsyncFileListener(), (Disposable)this);
        this.isInitialized = true;
    }

    private final AsyncFileListener createAsyncFileListener() {
        return arg_0 -> NotebookFileListenerService.createAsyncFileListener$lambda$0(this, arg_0);
    }

    private final void deleteSession(Project project, BackedNotebookVirtualFile notebook) {
        JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(project).getNotebookSession(notebook);
        if (jupyterNotebookSession == null) {
            return;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        JupyterTaskExecutorProvider.INSTANCE.interruptExecution(project, notebook);
        ApplicationManager.getApplication().executeOnPooledThread(() -> NotebookFileListenerService.deleteSession$lambda$1(session));
    }

    public void dispose() {
    }

    private static final AsyncFileListener.ChangeApplier createAsyncFileListener$lambda$0(NotebookFileListenerService this$0, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        return new AsyncFileListener.ChangeApplier(events, this$0){
            final /* synthetic */ List<? extends VFileEvent> $events;
            final /* synthetic */ NotebookFileListenerService this$0;
            {
                this.$events = $events;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void beforeVfsChange() {
                void $this$forEach$iv;
                Iterable<Object> iterable = this.$events;
                Intrinsics.checkNotNull(iterable);
                iterable = iterable;
                NotebookFileListenerService notebookFileListenerService = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BackedNotebookVirtualFile notebookVirtualFile;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (!(event instanceof VFileDeleteEvent) || !Intrinsics.areEqual((Object)((VFileDeleteEvent)event).getFile().getFileType(), (Object)JupyterFileType.INSTANCE)) continue;
                    VirtualFile virtualFile = ((VFileDeleteEvent)event).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    if (BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile) == null) continue;
                    NotebookFileListenerService.access$deleteSession(notebookFileListenerService, NotebookFileListenerService.access$getProject$p(notebookFileListenerService), notebookVirtualFile);
                }
            }
        };
    }

    private static final void deleteSession$lambda$1(JupyterNotebookSession $session) {
        try {
            $session.getKernelClient().deleteSession();
        }
        catch (Exception e) {
            JupyterExecutionInterruptService.Companion.getLOG().debug("Failed to delete session " + $session, (Throwable)e);
        }
    }

    public static final /* synthetic */ void access$deleteSession(NotebookFileListenerService $this, Project project, BackedNotebookVirtualFile notebook) {
        $this.deleteSession(project, notebook);
    }

    public static final /* synthetic */ Project access$getProject$p(NotebookFileListenerService $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookFileListenerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/editor/NotebookFileListenerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nNotebookFileListenerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookFileListenerService.kt\ncom/intellij/jupyter/core/editor/NotebookFileListenerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,57:1\n31#2,2:58\n*S KotlinDebug\n*F\n+ 1 NotebookFileListenerService.kt\ncom/intellij/jupyter/core/editor/NotebookFileListenerService$Companion\n*L\n55#1:58,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookFileListenerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NotebookFileListenerService> serviceClass$iv = NotebookFileListenerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NotebookFileListenerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

