/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorLastActionTracker;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.TextRange;
import java.awt.Component;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterSelectSourceAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.jupyter.core"})
public final class JupyterSelectSourceAction
extends JupyterEditorActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SELECT_ALL_ACTION_ID = "$SelectAll";

    private JupyterSelectSourceAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Companion.actionPerformed(e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterSelectSourceAction$Companion;", "", "<init>", "()V", "SELECT_ALL_ACTION_ID", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String lastAction = EditorLastActionTracker.getInstance().getLastActionId();
            if (Intrinsics.areEqual((Object)lastAction, (Object)Reflection.getOrCreateKotlinClass(JupyterSelectSourceAction.class).getSimpleName())) {
                AnAction selectAll = ActionManager.getInstance().getAction(JupyterSelectSourceAction.SELECT_ALL_ACTION_ID);
                ActionManager actionManager = ActionManager.getInstance();
                InputEvent inputEvent = e.getInputEvent();
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
                ActionCallback actionCallback = actionManager.tryToExecute(selectAll, inputEvent, (Component)(editorImpl != null ? editorImpl.getComponent() : null), e.getPlace(), true);
                Intrinsics.checkNotNull((Object)actionCallback);
            } else {
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
                if (editorImpl == null) {
                    return;
                }
                EditorImpl editor = editorImpl;
                DataContext dataContext2 = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
                NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext2);
                if (interval == null) {
                    return;
                }
                NotebookCellLines.Interval cellInterval = interval;
                TextRange jupyterCell = cellInterval.getContentRange((Editor)editor);
                CommandProcessor.getInstance().executeCommand(e.getProject(), () -> Companion.actionPerformed$lambda$0(editor, jupyterCell), e.getPresentation().getText(), null);
            }
        }

        private static final void actionPerformed$lambda$0(EditorImpl $editor, TextRange $jupyterCell) {
            $editor.getSelectionModel().setSelection($jupyterCell.getStartOffset(), $jupyterCell.getEndOffset());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

