/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.auth.hub;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.auth.hub.JupyterHubAuthHandler;
import com.intellij.jupyter.core.jupyter.connections.auth.hub.JupyterHubAuthUserInteraction;
import com.intellij.notebooks.jupyter.core.jupyter.preview.JupyterHttpUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubLoginDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "uri", "Ljava/net/URI;", "authHandler", "Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthHandler;", "wasWrongUsernameOrToken", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/net/URI;Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthHandler;Z)V", "userField", "Lcom/intellij/ui/components/JBTextField;", "tokenField", "value", "rememberToken", "getRememberToken", "()Z", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "dialogResult", "Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthUserInteraction$DialogResult;", "getDialogResult", "()Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthUserInteraction$DialogResult;", "intellij.jupyter.core"})
public final class JupyterHubLoginDialog
extends DialogWrapper {
    @NotNull
    private final URI uri;
    @Nullable
    private final JupyterHubAuthHandler authHandler;
    private final boolean wasWrongUsernameOrToken;
    private JBTextField userField;
    private JBTextField tokenField;
    private boolean rememberToken;

    public JupyterHubLoginDialog(@Nullable Project project, @NotNull URI uri, @Nullable JupyterHubAuthHandler authHandler, boolean wasWrongUsernameOrToken) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        super(project);
        this.uri = uri;
        this.authHandler = authHandler;
        this.wasWrongUsernameOrToken = wasWrongUsernameOrToken;
        this.rememberToken = PasswordSafe.Companion.getInstance().isRememberPasswordByDefault();
        this.setTitle(JupyterBundle.message("Jupyter.hub.login.dialog.title", new Object[0]));
        this.init();
    }

    public final boolean getRememberToken() {
        return this.rememberToken;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11(this, arg_0));
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.getOKAction().isEnabled()) {
            PasswordSafe.Companion.getInstance().setRememberPasswordByDefault(this.rememberToken);
        }
    }

    @Nullable
    public final JupyterHubAuthUserInteraction.DialogResult getDialogResult() {
        JBTextField jBTextField = this.userField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        if (string == null) {
            return null;
        }
        JBTextField jBTextField2 = this.tokenField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokenField");
            jBTextField2 = null;
        }
        String string2 = jBTextField2.getText();
        if (string2 == null) {
            return null;
        }
        return new JupyterHubAuthUserInteraction.DialogResult(string, new OneTimeString(string2), this.rememberToken);
    }

    private static final Unit createCenterPanel$lambda$11$lambda$0(JupyterHubLoginDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{this$0.uri.toASCIIString()};
        $this$row.label(JupyterBundle.message("Jupyter.hub.login.dialog.description", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$2$lambda$1(JupyterHubLoginDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Desktop.getDesktop().browse(JupyterHttpUtilsKt.addPathSegment((URI)this$0.uri, (String)"hub/token"));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$2(JupyterHubLoginDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(JupyterBundle.message("Jupyter.hub.login.dialog.description.token.page.link", new Object[0]), arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$4$lambda$3(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Desktop.getDesktop().browse(new URI(JupyterBundle.message("Jupyter.hub.login.dialog.description.instruction.link.href", new Object[0])));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(JupyterBundle.message("Jupyter.hub.login.dialog.description.instruction.link", new Object[0]), JupyterHubLoginDialog::createCenterPanel$lambda$11$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$6$lambda$5(JupyterHubLoginDialog this$0, JBTextField $this$applyToComponent) {
        String savedUsername;
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        JupyterHubAuthHandler jupyterHubAuthHandler = this$0.authHandler;
        String string = savedUsername = jupyterHubAuthHandler != null ? jupyterHubAuthHandler.getUsername() : null;
        if (savedUsername != null) {
            $this$applyToComponent.setText(savedUsername);
        } else {
            $this$applyToComponent.setText(System.getProperty("user.name"));
            $this$applyToComponent.selectAll();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$6(JupyterHubLoginDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.userField = (JBTextField)$this$row.textField().align((Align)AlignX.FILL.INSTANCE).focused().applyToComponent(arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$6$lambda$5(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$7(JupyterHubLoginDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.tokenField = (JBTextField)$this$row.textField().align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$8(String $error, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($error);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$10$lambda$9(JupyterHubLoginDialog this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.rememberToken = it.isSelected();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$10(JupyterHubLoginDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.selected((Cell)$this$row.checkBox(JupyterBundle.message("Jupyter.hub.login.dialog.remember", new Object[0])), (boolean)this$0.rememberToken).onChanged(arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$10$lambda$9(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11(JupyterHubLoginDialog this$0, Panel $this$panel) {
        String error;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, JupyterHubLoginDialog::createCenterPanel$lambda$11$lambda$4, (int)1, null);
        $this$panel.row(JupyterBundle.message("Jupyter.hub.login.dialog.username", new Object[0]), arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$6(this$0, arg_0));
        $this$panel.row(JupyterBundle.message("Jupyter.hub.login.dialog.token", new Object[0]), arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$7(this$0, arg_0));
        String string = error = this$0.wasWrongUsernameOrToken ? JupyterBundle.message("Jupyter.hub.login.dialog.wrong.username.or.token", new Object[0]) : null;
        if (error != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$8(error, arg_0), (int)1, null);
        }
        if (!PasswordSafe.Companion.getInstance().isMemoryOnly()) {
            $this$panel.row("", arg_0 -> JupyterHubLoginDialog.createCenterPanel$lambda$11$lambda$10(this$0, arg_0));
        }
        return Unit.INSTANCE;
    }
}

