/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.idea.AppMode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.fus.JupyterFeatureCollectorManager;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterBrowserOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterErrorOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterImageOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterJsonDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterMarkdownOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterOutputDataKeyExtractorKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterOutputImageFormats;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterTextOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.NotebookDisplayOutputDataKeyExtractor;
import com.intellij.jupyter.core.jupyter.editor.outputs.NotebookStreamOutputDataKeyExtractor;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterDataKeyCollector;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.CommStorage;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterErrorOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterExecuteResultOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterStreamOutput;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.remote.RemoteOutputsUpdater;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKeyExtractor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J)\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J9\u0010$\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010%J*\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J+\u0010(\u001a\u00020)*\b\u0012\u0004\u0012\u00020*0\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010+\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\u00020.*\u00020/H\u0002\u00a8\u00060\u00b2\u0006\f\u00101\u001a\u0004\u0018\u000102X\u008a\u0084\u0002"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterOutputDataKeyExtractor;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKeyExtractor;", "<init>", "()V", "extract", "", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "toResult", "", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;", "result", "", "output", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutput;", "extractImpl", "extractOutputDataKeysForSwingTypes", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "isLastForCell", "", "detectSwingOutputRepresentation", "executionCount", "", "data", "Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;", "metadata", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;", "(Ljava/lang/Integer;Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "getImageSizeFromMetadata", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey$Size;", "mimeType", "Lcom/intellij/jupyter/core/jupyter/nbformat/MimeType;", "extractDisplayKeyByExternalProvider", "(Ljava/lang/Integer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;ZLcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "extractStreamKeyByExternalProvider", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/NotebookStreamOutputDataKeyExtractor$ExtractionResult;", "asTextOutputDataKey", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterTextOutputDataKey;", "", "isErrorStream", "(Ljava/util/List;Ljava/lang/Integer;Z)Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterTextOutputDataKey;", "asErrorOutputDataKey", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterErrorOutputDataKey;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterErrorOutput;", "intellij.jupyter.core", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;"})
@SourceDebugExtension(value={"SMAP\nJupyterOutputDataKeyExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterOutputDataKeyExtractor.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterOutputDataKeyExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1863#2,2:219\n1567#2:222\n1598#2,4:223\n1#3:221\n*S KotlinDebug\n*F\n+ 1 JupyterOutputDataKeyExtractor.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterOutputDataKeyExtractor\n*L\n60#1:219,2\n202#1:222\n202#1:223,4\n*E\n"})
public final class JupyterOutputDataKeyExtractor
implements NotebookOutputDataKeyExtractor {
    @Nullable
    public List<NotebookOutputDataKey> extract(@NotNull Editor editor, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return !JupyterFileEditorKt.isJupyter(editor) ? null : (interval.getType() != NotebookCellLines.CellType.CODE ? null : this.extractImpl(editor, interval));
    }

    private final void toResult(JupyterWebOutputInfo $this$toResult, List<NotebookOutputDataKey> result2, JupyterOutput output) {
        JupyterExecuteResultOutput jupyterExecuteResultOutput = output instanceof JupyterExecuteResultOutput ? (JupyterExecuteResultOutput)output : null;
        result2.add(new JupyterBrowserOutputDataKey($this$toResult, jupyterExecuteResultOutput != null ? Integer.valueOf(jupyterExecuteResultOutput.getExecutionCount()) : null));
    }

    private final List<NotebookOutputDataKey> extractImpl(Editor editor, NotebookCellLines.Interval interval) {
        JupyterWebOutputInfo info;
        JupyterOutputs jupyterOutputs = JupyterOutputDataKeyExtractorKt.getOutputsForIndex(editor, interval.getOrdinal());
        if (jupyterOutputs == null) {
            return CollectionsKt.emptyList();
        }
        JupyterOutputs outputs = jupyterOutputs;
        List<JupyterOutput> outputSequence = outputs.getOutputs();
        ArrayList<NotebookOutputDataKey> result2 = new ArrayList<NotebookOutputDataKey>();
        JupyterDataKeyCollector webKeyCollector = new JupyterDataKeyCollector();
        NotebookIntervalPointer cellPointer = NotebookIntervalPointerFactory.Companion.get(editor).create(interval);
        Iterator iterator = ((Iterable)outputSequence).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JupyterWebOutputInfo webOutputInfo;
            int outputIndex = n++;
            JupyterOutput output = (JupyterOutput)iterator.next();
            NotebookOutputDataKey swingKey = this.extractOutputDataKeysForSwingTypes(editor, cellPointer, output, outputIndex == outputSequence.size() - 1);
            if (swingKey != null) {
                result2.add(swingKey);
                continue;
            }
            JupyterWebOutputInfo jupyterWebOutputInfo = webOutputInfo = webKeyCollector.createOutputInfo((Pair<? extends JupyterOutput, Integer>)new Pair((Object)output, (Object)outputIndex), interval, editor);
            if (jupyterWebOutputInfo == null) continue;
            this.toResult(jupyterWebOutputInfo, (List<NotebookOutputDataKey>)result2, output);
        }
        JupyterWebOutputInfo jupyterWebOutputInfo = info = webKeyCollector.createOutputInfo(null, interval, editor);
        if (jupyterWebOutputInfo != null) {
            this.toResult(jupyterWebOutputInfo, (List<NotebookOutputDataKey>)result2, null);
        }
        if (AppMode.isRemoteDevHost()) {
            Iterable $this$forEach$iv = RemoteOutputsUpdater.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RemoteOutputsUpdater t = (RemoteOutputsUpdater)element$iv;
                boolean bl = false;
                t.updateOutputs(editor, interval.getOrdinal(), (Collection<? extends NotebookOutputDataKey>)result2);
            }
        }
        JupyterFeatureCollectorManager.Companion.getInstance().collectOutputTypes(editor, result2);
        return result2;
    }

    private final NotebookOutputDataKey extractOutputDataKeysForSwingTypes(Editor editor, NotebookIntervalPointer cellPointer, JupyterOutput output, boolean isLastForCell) {
        NotebookOutputDataKey notebookOutputDataKey;
        JupyterOutput jupyterOutput = output;
        if (jupyterOutput instanceof JupyterDisplayDataOutput) {
            JupyterOutput widgetModel;
            DisplayDataContainer dataObject = ((JupyterDisplayDataOutput)output).getData();
            if (dataObject.has(MimeType.WIDGET_VIEW.getMimeType())) {
                String modelId;
                CommStorage commStorage;
                BackedNotebookVirtualFile notebook;
                BackedNotebookVirtualFile backedNotebookVirtualFile = notebook = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
                if (backedNotebookVirtualFile != null) {
                    BackedNotebookVirtualFile it = backedNotebookVirtualFile;
                    boolean bl = false;
                    commStorage = CommStorage.Companion.getOrInit(it);
                } else {
                    commStorage = null;
                }
                CommStorage commStorage2 = commStorage;
                JupyterOutput jupyterOutput2 = widgetModel = dataObject.getAsJsonNode(MimeType.WIDGET_VIEW.getMimeType());
                JsonNode jsonNode = jupyterOutput2 != null ? jupyterOutput2.get("model_id") : null;
                TextNode textNode = jsonNode instanceof TextNode ? (TextNode)jsonNode : null;
                String string = modelId = textNode != null ? textNode.textValue() : null;
                if (modelId != null) {
                    CommStorage commStorage3 = commStorage2;
                    boolean bl = commStorage3 != null ? commStorage3.contains(modelId) : false;
                    if (bl) {
                        return null;
                    }
                }
            }
            JupyterExecuteResultOutput jupyterExecuteResultOutput = (widgetModel = output) instanceof JupyterExecuteResultOutput ? (JupyterExecuteResultOutput)widgetModel : null;
            Integer executionCount = jupyterExecuteResultOutput != null ? Integer.valueOf(jupyterExecuteResultOutput.getExecutionCount()) : null;
            NotebookOutputDataKey externalOutput = this.extractDisplayKeyByExternalProvider(executionCount, editor, cellPointer, isLastForCell, dataObject);
            if (externalOutput != null) {
                return externalOutput;
            }
            NotebookOutputDataKey swingComponent = this.detectSwingOutputRepresentation(executionCount, dataObject, ((JupyterDisplayDataOutput)output).getMetadata());
            return swingComponent;
        }
        if (jupyterOutput instanceof JupyterStreamOutput) {
            NotebookStreamOutputDataKeyExtractor.ExtractionResult extractionResult;
            NotebookStreamOutputDataKeyExtractor.ExtractionResult extractionResult2 = extractionResult = this.extractStreamKeyByExternalProvider(editor, cellPointer, output, isLastForCell);
            notebookOutputDataKey = (extractionResult2 != null ? extractionResult2.getMatchFound() : false) ? extractionResult.getResult() : (NotebookOutputDataKey)this.asTextOutputDataKey(((JupyterStreamOutput)output).getText(), null, Intrinsics.areEqual((Object)((JupyterStreamOutput)output).getName(), (Object)"stderr"));
        } else {
            notebookOutputDataKey = jupyterOutput instanceof JupyterErrorOutput ? (NotebookOutputDataKey)this.asErrorOutputDataKey((JupyterErrorOutput)output) : null;
        }
        return notebookOutputDataKey;
    }

    private final NotebookOutputDataKey detectSwingOutputRepresentation(Integer executionCount, DisplayDataContainer data, JupyterMetadata metadata) {
        NotebookOutputDataKey notebookOutputDataKey;
        List mimeTypes = CollectionsKt.toList(data.getItems());
        MimeType mimeType = MimeType.Companion.getFirstAcceptableMimeTypeNotWidget(mimeTypes);
        if (mimeType == null) {
            return null;
        }
        MimeType firstSupportedType = mimeType;
        String mimeType2 = firstSupportedType.getMimeType();
        switch (WhenMappings.$EnumSwitchMapping$0[firstSupportedType.ordinal()]) {
            case 1: {
                notebookOutputDataKey = null;
                break;
            }
            case 2: {
                List<String> list = data.getAsMultiline(mimeType2);
                notebookOutputDataKey = list != null ? JupyterOutputDataKeyExtractor.asTextOutputDataKey$default(this, list, executionCount, false, 2, null) : null;
                break;
            }
            case 3: {
                String string = data.getAsString(mimeType2);
                if (string == null) {
                    return null;
                }
                String mdText = string;
                if (JupyterDSSettings.Companion.getInstance().getMarkdownRenderMode() == JupyterDSSettings.MarkdownRenderMode.NOTEBOOK_CEF) {
                    return null;
                }
                notebookOutputDataKey = new JupyterMarkdownOutputDataKey(mdText);
                break;
            }
            case 4: {
                notebookOutputDataKey = null;
                break;
            }
            case 5: {
                notebookOutputDataKey = JupyterJsonDataKey.Companion.extract(data.getJson(), executionCount);
                break;
            }
            case 6: {
                JupyterImageOutputDataKey jupyterImageOutputDataKey;
                String string = data.getAsString(mimeType2);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    jupyterImageOutputDataKey = new JupyterImageOutputDataKey(it, JupyterOutputImageFormats.PNG, this.getImageSizeFromMetadata(metadata, MimeType.IMAGE_PNG), executionCount);
                } else {
                    jupyterImageOutputDataKey = null;
                }
                notebookOutputDataKey = jupyterImageOutputDataKey;
                break;
            }
            case 7: {
                JupyterImageOutputDataKey jupyterImageOutputDataKey;
                String string = data.getAsString(mimeType2);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    jupyterImageOutputDataKey = new JupyterImageOutputDataKey(it, JupyterOutputImageFormats.JPEG, this.getImageSizeFromMetadata(metadata, MimeType.IMAGE_JPG), executionCount);
                } else {
                    jupyterImageOutputDataKey = null;
                }
                notebookOutputDataKey = jupyterImageOutputDataKey;
                break;
            }
            case 8: {
                notebookOutputDataKey = null;
                break;
            }
            case 9: {
                notebookOutputDataKey = null;
                break;
            }
            case 10: {
                notebookOutputDataKey = null;
                break;
            }
            case 11: {
                notebookOutputDataKey = null;
                break;
            }
            case 12: {
                notebookOutputDataKey = null;
                break;
            }
            case 13: {
                notebookOutputDataKey = null;
                break;
            }
            case 14: {
                notebookOutputDataKey = null;
                break;
            }
            case 15: {
                notebookOutputDataKey = null;
                break;
            }
            case 16: {
                return null;
            }
            case 17: {
                notebookOutputDataKey = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return notebookOutputDataKey;
    }

    private final JupyterImageOutputDataKey.Size getImageSizeFromMetadata(JupyterMetadata metadata, MimeType mimeType) {
        String mimeType2 = mimeType.getMimeType();
        JupyterMetadata jupyterMetadata = metadata.getObject(mimeType2);
        if (jupyterMetadata == null) {
            return null;
        }
        JupyterMetadata sizeObject = jupyterMetadata;
        Double d = sizeObject.getDouble("width");
        if (d == null) {
            return null;
        }
        int preferredWidth = (int)d.doubleValue();
        Double d2 = sizeObject.getDouble("height");
        if (d2 == null) {
            return null;
        }
        int preferredHeight = (int)d2.doubleValue();
        return new JupyterImageOutputDataKey.Size(preferredWidth, preferredHeight);
    }

    private final NotebookOutputDataKey extractDisplayKeyByExternalProvider(Integer executionCount, Editor editor, NotebookIntervalPointer cellPointer, boolean isLastForCell, DisplayDataContainer data) {
        Lazy notebookFile$delegate = LazyKt.lazy(() -> JupyterOutputDataKeyExtractor.extractDisplayKeyByExternalProvider$lambda$5(editor));
        return (NotebookOutputDataKey)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)NotebookDisplayOutputDataKeyExtractor.Companion.getEP_NAME().getExtensionList()), arg_0 -> JupyterOutputDataKeyExtractor.extractDisplayKeyByExternalProvider$lambda$7(editor, data, executionCount, cellPointer, isLastForCell, notebookFile$delegate, arg_0)));
    }

    private final NotebookStreamOutputDataKeyExtractor.ExtractionResult extractStreamKeyByExternalProvider(Editor editor, NotebookIntervalPointer cellPointer, JupyterOutput output, boolean isLastForCell) {
        return (NotebookStreamOutputDataKeyExtractor.ExtractionResult)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)NotebookStreamOutputDataKeyExtractor.Companion.getEP_NAME().getExtensionList()), arg_0 -> JupyterOutputDataKeyExtractor.extractStreamKeyByExternalProvider$lambda$8(editor, cellPointer, output, isLastForCell, arg_0)), JupyterOutputDataKeyExtractor::extractStreamKeyByExternalProvider$lambda$9));
    }

    private final JupyterTextOutputDataKey asTextOutputDataKey(List<String> $this$asTextOutputDataKey, Integer executionCount, boolean isErrorStream) {
        return new JupyterTextOutputDataKey($this$asTextOutputDataKey, executionCount, isErrorStream ? JupyterTextOutputDataKey.OutputType.STDERR : JupyterTextOutputDataKey.OutputType.STDOUT);
    }

    static /* synthetic */ JupyterTextOutputDataKey asTextOutputDataKey$default(JupyterOutputDataKeyExtractor jupyterOutputDataKeyExtractor, List list, Integer n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return jupyterOutputDataKeyExtractor.asTextOutputDataKey(list, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final JupyterErrorOutputDataKey asErrorOutputDataKey(JupyterErrorOutput $this$asErrorOutputDataKey) {
        void $this$mapIndexedTo$iv$iv;
        String exceptionType = $this$asErrorOutputDataKey.getEname();
        String exceptionValue = $this$asErrorOutputDataKey.getEvalue();
        List<String> it = $this$asErrorOutputDataKey.getTraceback();
        Iterable $this$mapIndexed$iv = it;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void node;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(index != it.size() - 1 ? (String)node + "\n" : node);
        }
        List traceback = (List)destination$iv$iv;
        return new JupyterErrorOutputDataKey(exceptionType, exceptionValue, traceback);
    }

    private static final BackedNotebookVirtualFile extractDisplayKeyByExternalProvider$lambda$5(Editor $editor) {
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        VirtualFile virtualFile = $editor.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile file = virtualFile;
            boolean bl = false;
            backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(file);
        } else {
            backedNotebookVirtualFile = null;
        }
        return backedNotebookVirtualFile;
    }

    private static final BackedNotebookVirtualFile extractDisplayKeyByExternalProvider$lambda$6(Lazy<? extends BackedNotebookVirtualFile> $notebookFile$delegate) {
        Lazy<? extends BackedNotebookVirtualFile> lazy = $notebookFile$delegate;
        return (BackedNotebookVirtualFile)lazy.getValue();
    }

    private static final NotebookOutputDataKey extractDisplayKeyByExternalProvider$lambda$7(Editor $editor, DisplayDataContainer $data, Integer $executionCount, NotebookIntervalPointer $cellPointer, boolean $isLastForCell, Lazy $notebookFile$delegate, NotebookDisplayOutputDataKeyExtractor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.extractKey($editor, JupyterOutputDataKeyExtractor.extractDisplayKeyByExternalProvider$lambda$6((Lazy<? extends BackedNotebookVirtualFile>)$notebookFile$delegate), $data, $executionCount, $cellPointer, $isLastForCell);
    }

    private static final NotebookStreamOutputDataKeyExtractor.ExtractionResult extractStreamKeyByExternalProvider$lambda$8(Editor $editor, NotebookIntervalPointer $cellPointer, JupyterOutput $output, boolean $isLastForCell, NotebookStreamOutputDataKeyExtractor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.extractKey($editor, $cellPointer, $output, $isLastForCell);
    }

    private static final boolean extractStreamKeyByExternalProvider$lambda$9(NotebookStreamOutputDataKeyExtractor.ExtractionResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMatchFound();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MimeType.values().length];
            try {
                nArray[MimeType.TEXT_HTML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.TEXT_PLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.TEXT_MARKDOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.APPLICATION_JAVASCRIPT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.APPLICATION_JSON.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.IMAGE_PNG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.IMAGE_JPG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.IMAGE_SVG.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.WIDGET_VIEW.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.GIF.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.LATEX.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.DEBUG.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.GEO_JSON.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.VDOM_PATTERN.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.VND_PATTERN.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.EMPTY.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MimeType.UNKNOWN.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

