/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers.JupyterCefHttpHandler;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers.JupyterCefPathHandler;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers.JupyterCefWebSocketHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.UriUtilKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002JB\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "<init>", "()V", "sourceHandler", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefHttpHandler;", "appName", "", "sender", "com/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefPathHandler$sender$1", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefPathHandler$sender$1;", "getLocalFileBytes", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "filePath", "process", "", "path", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCefPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCefPathHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefPathHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,74:1\n24#2:75\n*S KotlinDebug\n*F\n+ 1 JupyterCefPathHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefPathHandler\n*L\n47#1:75\n*E\n"})
public final class JupyterCefPathHandler
extends WebServerPathHandler {
    @NotNull
    private final JupyterCefHttpHandler sourceHandler = new JupyterCefHttpHandler();
    @NotNull
    private final String appName;
    @NotNull
    private final sender.1 sender = new HttpRequestHandler(){

        public boolean process(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context) {
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return false;
        }

        public final boolean send(byte[] bytes, String name, FullHttpRequest request, Channel channel) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)emptyHttpHeaders, (String)"INSTANCE");
            return this.sendData(bytes, name, request, channel, (HttpHeaders)emptyHttpHeaders);
        }
    };

    public JupyterCefPathHandler() {
        this.appName = "jupyter";
    }

    private final byte[] getLocalFileBytes(FullHttpRequest request, String filePath) {
        Object path;
        block11: {
            block10: {
                UUID uUID;
                String string = request.headers().get((CharSequence)HttpHeaderNames.REFERER);
                if (string == null) {
                    return null;
                }
                String refererUri = string;
                String string2 = (String)UriUtilKt.getQueryParameters((URI)new URI(refererUri)).get("url");
                if (string2 == null) {
                    return null;
                }
                String wsUrlStr = string2;
                URI wsUrl = new URI(wsUrlStr);
                if (!Intrinsics.areEqual((Object)wsUrl.getScheme(), (Object)"ws")) {
                    return null;
                }
                String string3 = (String)UriUtilKt.getQueryParameters((URI)wsUrl).get("uuid");
                if (string3 == null) {
                    return null;
                }
                String uuidStr = string3;
                try {
                    uUID = UUID.fromString(uuidStr);
                }
                catch (IllegalArgumentException e) {
                    JupyterCefPathHandler $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(JupyterCefPathHandler.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Unable to decode UUID: " + uuidStr, (Throwable)e);
                    return null;
                }
                UUID uuid = uUID;
                Intrinsics.checkNotNull((Object)uuid);
                Object object = JupyterCefWebSocketHandler.Companion.getListener(uuid);
                if (object == null || (object = object.resolveFilePath(filePath)) == null) {
                    return null;
                }
                path = object;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists((Path)path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block10;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isRegularFile((Path)path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block11;
            }
            return null;
        }
        byte[] byArray = Files.readAllBytes((Path)path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return byArray;
    }

    public boolean process(@NotNull String path, @Nullable Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)decodedRawPath, (String)"decodedRawPath");
        if (Intrinsics.areEqual((Object)projectName, (Object)this.appName)) {
            byte[] foundInternally;
            byte[] byArray = foundInternally = this.sourceHandler.processInternalLibs(path);
            if (foundInternally == null && (byArray = this.getLocalFileBytes(request, path)) == null) {
                return false;
            }
            byte[] bytes = byArray;
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            return this.sender.send(bytes, path, request, channel);
        }
        return false;
    }
}

