/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookPopupManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.SharedMemoryCache;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenRaster;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenViewComponent;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffscreenViewPort;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.cef.SharedMemory;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefDragData;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.handler.CefScreenInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016JD\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u001a\u0010'\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u0013H\u0016J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000fH\u0016JE\u0010+\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-2\u0006\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u00100J\u001a\u00101\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u00102\u001a\u00020\u001fH\u0016J4\u00103\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001fH\u0016J\u001a\u00109\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010:\u001a\u00020\u001fH\u0016J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefRenderHandler;", "Lorg/cef/handler/CefNativeRenderHandler;", "popupManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookPopupManager;", "raster", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;", "graphicsConfigurationManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookPopupManager;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;)V", "getPopupManager", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookPopupManager;", "sharedMemCache", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/SharedMemoryCache;", "getViewRect", "Ljava/awt/Rectangle;", "browser", "Lorg/cef/browser/CefBrowser;", "getScreenInfo", "", "screenInfo", "Lorg/cef/handler/CefScreenInfo;", "getScreenPoint", "Ljava/awt/Point;", "viewPoint", "getDeviceScaleFactor", "", "onPaintWithSharedMem", "", "popup", "dirtyRectsCount", "", "sharedMemName", "", "boostHandle", "", "width", "height", "disposeNativeResources", "onPopupShow", "show", "onPopupSize", "size", "onPaint", "dirtyRects", "", "buffer", "Ljava/nio/ByteBuffer;", "(Lorg/cef/browser/CefBrowser;Z[Ljava/awt/Rectangle;Ljava/nio/ByteBuffer;II)V", "onCursorChange", "cursor", "startDragging", "dragData", "Lorg/cef/callback/CefDragData;", "mask", "x", "y", "updateDragCursor", "operation", "scheduleOnEdt", "runnable", "Ljava/lang/Runnable;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCefRenderHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCefRenderHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefRenderHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1863#2,2:194\n*S KotlinDebug\n*F\n+ 1 NotebookCefRenderHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefRenderHandler\n*L\n167#1:194,2\n*E\n"})
public final class NotebookCefRenderHandler
implements CefNativeRenderHandler {
    @NotNull
    private final NotebookPopupManager popupManager;
    @NotNull
    private final JcefOffScreenRaster raster;
    @NotNull
    private final NotebookGraphicsConfigurationManager graphicsConfigurationManager;
    @NotNull
    private final SharedMemoryCache sharedMemCache;

    public NotebookCefRenderHandler(@NotNull NotebookPopupManager popupManager, @NotNull JcefOffScreenRaster raster, @NotNull NotebookGraphicsConfigurationManager graphicsConfigurationManager) {
        Intrinsics.checkNotNullParameter((Object)popupManager, (String)"popupManager");
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        Intrinsics.checkNotNullParameter((Object)graphicsConfigurationManager, (String)"graphicsConfigurationManager");
        this.popupManager = popupManager;
        this.raster = raster;
        this.graphicsConfigurationManager = graphicsConfigurationManager;
        this.sharedMemCache = new SharedMemoryCache();
    }

    @NotNull
    public final NotebookPopupManager getPopupManager() {
        return this.popupManager;
    }

    @NotNull
    public Rectangle getViewRect(@Nullable CefBrowser browser) {
        Rectangle rectangle;
        Rectangle visibleRect;
        EditorImpl editorImpl = this.popupManager.getEditor();
        Rectangle rectangle2 = editorImpl != null && (editorImpl = editorImpl.getContentComponent()) != null ? editorImpl.getVisibleRect() : (visibleRect = null);
        if (visibleRect != null) {
            Object object = this.popupManager.getEditor();
            int viewWidth = this.graphicsConfigurationManager.scaleDownHiDPIAware(visibleRect.width - (object != null && (object = object.getScrollPane()) != null && (object = ((JScrollPane)object).getVerticalScrollBar()) != null ? ((JComponent)object).getWidth() : 0));
            rectangle = new Rectangle(0, 0, viewWidth, this.graphicsConfigurationManager.scaleDownHiDPIAware(visibleRect.height));
        } else {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        return rectangle;
    }

    public boolean getScreenInfo(@Nullable CefBrowser browser, @NotNull CefScreenInfo screenInfo) {
        Intrinsics.checkNotNullParameter((Object)screenInfo, (String)"screenInfo");
        Rectangle viewRect = this.getViewRect(browser);
        screenInfo.Set(this.getDeviceScaleFactor(browser), 24, 3, false, viewRect, viewRect);
        return true;
    }

    @NotNull
    public Point getScreenPoint(@Nullable CefBrowser browser, @NotNull Point viewPoint) {
        Intrinsics.checkNotNullParameter((Object)viewPoint, (String)"viewPoint");
        return viewPoint;
    }

    public double getDeviceScaleFactor(@Nullable CefBrowser browser) {
        return this.graphicsConfigurationManager.getScreenScale();
    }

    public void onPaintWithSharedMem(@Nullable CefBrowser browser, boolean popup, int dirtyRectsCount, @Nullable String sharedMemName, long boostHandle, int width, int height) {
        SharedMemory.WithRaster withRaster;
        if (sharedMemName == null) {
            return;
        }
        SharedMemory.WithRaster $this$onPaintWithSharedMem_u24lambda_u240 = withRaster = this.sharedMemCache.get(sharedMemName, boostHandle);
        boolean $i$a$-apply-NotebookCefRenderHandler$onPaintWithSharedMem$mem$22 = false;
        $this$onPaintWithSharedMem_u24lambda_u240.setWidth(width);
        $this$onPaintWithSharedMem_u24lambda_u240.setHeight(height);
        $this$onPaintWithSharedMem_u24lambda_u240.setDirtyRectsCount(dirtyRectsCount);
        $this$onPaintWithSharedMem_u24lambda_u240.lasUsedMs = System.currentTimeMillis();
        SharedMemory.WithRaster mem = withRaster;
        ByteBuffer buffer = mem.wrapRaster();
        Rectangle[] $i$a$-apply-NotebookCefRenderHandler$onPaintWithSharedMem$mem$22 = new Rectangle[]{new Rectangle(0, 0, width, height)};
        Rectangle[] dirtyRects = $i$a$-apply-NotebookCefRenderHandler$onPaintWithSharedMem$mem$22;
        if (dirtyRectsCount > 0) {
            ByteBuffer rectsMem = mem.wrapRects();
            IntBuffer rects = rectsMem.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            int c = 0;
            int n = dirtyRectsCount - 1;
            if (c <= n) {
                while (true) {
                    int pos = c * 4;
                    Rectangle r = new Rectangle();
                    r.x = rects.get(pos++);
                    r.y = rects.get(pos++);
                    r.width = rects.get(pos++);
                    r.height = rects.get(pos);
                    dirtyRects[c] = r;
                    if (c == n) break;
                    ++c;
                }
            }
        }
        Intrinsics.checkNotNull((Object)buffer);
        this.onPaint(browser, popup, dirtyRects, buffer, width, height);
    }

    public void disposeNativeResources() {
        this.sharedMemCache.dispose();
    }

    public void onPopupShow(@Nullable CefBrowser browser, boolean show) {
        this.scheduleOnEdt(() -> NotebookCefRenderHandler.onPopupShow$lambda$1(show, this));
    }

    public void onPopupSize(@NotNull CefBrowser browser, @NotNull Rectangle size) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.scheduleOnEdt(() -> NotebookCefRenderHandler.onPopupSize$lambda$2(this, size));
    }

    public void onPaint(@Nullable CefBrowser browser, boolean popup, @NotNull Rectangle[] dirtyRects, @NotNull ByteBuffer buffer, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)dirtyRects, (String)"dirtyRects");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (popup) {
            this.popupManager.updatePopupImage((Rectangle)ArraysKt.first((Object[])dirtyRects), buffer);
            this.scheduleOnEdt(() -> NotebookCefRenderHandler.onPaint$lambda$3(this));
        } else {
            Set<JcefOffscreenViewPort> affectedPorts = this.raster.updateImageFromCef(buffer, dirtyRects, width, height);
            if (!((Collection)affectedPorts).isEmpty()) {
                this.scheduleOnEdt(() -> NotebookCefRenderHandler.onPaint$lambda$5(affectedPorts));
            }
        }
    }

    public boolean onCursorChange(@Nullable CefBrowser browser, int cursor) {
        this.scheduleOnEdt(() -> NotebookCefRenderHandler.onCursorChange$lambda$6(this, cursor));
        return true;
    }

    public boolean startDragging(@Nullable CefBrowser browser, @Nullable CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    public void updateDragCursor(@Nullable CefBrowser browser, int operation) {
    }

    private final void scheduleOnEdt(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private static final void onPopupShow$lambda$1(boolean $show, NotebookCefRenderHandler this$0) {
        if (!$show) {
            this$0.popupManager.tryHide();
        } else {
            this$0.popupManager.tryShow();
        }
    }

    private static final void onPopupSize$lambda$2(NotebookCefRenderHandler this$0, Rectangle $size) {
        this$0.popupManager.setPopupRect($size);
    }

    private static final void onPaint$lambda$3(NotebookCefRenderHandler this$0) {
        this$0.popupManager.tryShow();
    }

    private static final void onPaint$lambda$5(Set $affectedPorts) {
        Iterable $this$forEach$iv = $affectedPorts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl = false;
            it.getViewPortComponentController().contentChanged();
        }
    }

    private static final void onCursorChange$lambda$6(NotebookCefRenderHandler this$0, int $cursor) {
        block0: {
            JcefOffScreenViewComponent jcefOffScreenViewComponent = this$0.popupManager.getCurrentComponent();
            if (jcefOffScreenViewComponent == null) break block0;
            jcefOffScreenViewComponent.setCursor(new Cursor($cursor));
        }
    }
}

