/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.jupyter.core.JupyterCoreIcons;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.helper.OtherKt;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureItemPresentation;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewModel;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewSelectionManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0017H\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!J\b\u0010\"\u001a\u00020#H\u0002J\r\u0010$\u001a\u00070#\u00a2\u0006\u0002\b%H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0017H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150+H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0017H\u0016J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "title", "", "level", "", "parent", "model", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;Ljava/lang/String;ILcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;)V", "getLevel", "()I", "getParent", "()Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "getModel", "()Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "children", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "isExecuting", "", "associatedIntervals", "addChild", "child", "associateInterval", "interval", "markAsExecuting", "", "hasExecutingChildren", "collectAllRelatedIntervals", "", "getIcon", "Ljavax/swing/Icon;", "getCellTypeIcon", "Lorg/jetbrains/annotations/NotNull;", "navigate", "requestFocus", "getRespectivePsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/impl/JupyterPsiCellImpl;", "getChildren", "", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "canNavigate", "canNavigateToSource", "getValue", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewCellElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewCellElement.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,75:1\n1755#2,3:76\n1863#2:79\n1864#2:81\n1#3:80\n37#4,2:82\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewCellElement.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement\n*L\n36#1:76,3\n42#1:79\n42#1:81\n69#1:82,2\n*E\n"})
public final class JupyterStructureViewCellElement
implements StructureViewTreeElement {
    @NotNull
    private final NotebookCellLines.Interval cell;
    @NotNull
    private final String title;
    private final int level;
    @Nullable
    private final JupyterStructureViewCellElement parent;
    @NotNull
    private final JupyterStructureViewModel model;
    @NotNull
    private final List<TreeElement> children;
    private boolean isExecuting;
    @NotNull
    private final List<NotebookCellLines.Interval> associatedIntervals;

    public JupyterStructureViewCellElement(@NotNull NotebookCellLines.Interval cell, @NotNull String title, int level, @Nullable JupyterStructureViewCellElement parent, @NotNull JupyterStructureViewModel model) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.cell = cell;
        this.title = title;
        this.level = level;
        this.parent = parent;
        this.model = model;
        this.children = new ArrayList();
        this.associatedIntervals = new ArrayList();
    }

    public /* synthetic */ JupyterStructureViewCellElement(NotebookCellLines.Interval interval, String string, int n, JupyterStructureViewCellElement jupyterStructureViewCellElement, JupyterStructureViewModel jupyterStructureViewModel, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            jupyterStructureViewCellElement = null;
        }
        this(interval, string, n, jupyterStructureViewCellElement, jupyterStructureViewModel);
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final JupyterStructureViewCellElement getParent() {
        return this.parent;
    }

    @NotNull
    public final JupyterStructureViewModel getModel() {
        return this.model;
    }

    public final boolean addChild(@NotNull TreeElement child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.children.add(child);
    }

    public final boolean associateInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.associatedIntervals.add(interval);
    }

    public final void markAsExecuting() {
        block0: {
            this.isExecuting = true;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.markAsExecuting();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasExecutingChildren() {
        boolean bl;
        if (this.isExecuting) return true;
        Iterable $this$any$iv = this.children;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            TreeElement it = (TreeElement)element$iv;
            boolean bl2 = false;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = it instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)it : null;
            if (jupyterStructureViewCellElement != null) {
                if (jupyterStructureViewCellElement.hasExecutingChildren()) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final List<NotebookCellLines.Interval> collectAllRelatedIntervals() {
        List intervals = new ArrayList();
        intervals.addAll((Collection)this.associatedIntervals);
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeElement child = (TreeElement)element$iv;
            boolean bl = false;
            Object object = child instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)child : null;
            if (object == null || (object = ((JupyterStructureViewCellElement)object).collectAllRelatedIntervals()) == null) continue;
            Object it = object;
            boolean bl2 = false;
            intervals.addAll((Collection)it);
        }
        return intervals;
    }

    private final Icon getIcon() {
        Icon icon;
        if (this.hasExecutingChildren()) {
            Icon icon2 = AllIcons.RunConfigurations.TestState.Run_run;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Run_run");
        } else {
            icon = this.getCellTypeIcon();
        }
        return icon;
    }

    private final Icon getCellTypeIcon() {
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[OtherKt.toJupyterCellType(this.cell.getType()).ordinal()]) {
            case 1 -> JupyterCoreIcons.MarkdownCell;
            case 2 -> JupyterCoreIcons.CodeCell;
            default -> (Icon)EmptyIcon.create((int)16, (int)16);
        };
        Intrinsics.checkNotNull((Object)icon);
        return icon;
    }

    public void navigate(boolean requestFocus) {
        JupyterStructureViewSelectionManager jupyterStructureViewSelectionManager = this.model.getSelectionManager();
        if (jupyterStructureViewSelectionManager == null) {
            return;
        }
        JupyterStructureViewSelectionManager selectionModel = jupyterStructureViewSelectionManager;
        selectionModel.withNavigationFlag((Function0<Unit>)((Function0)() -> JupyterStructureViewCellElement.navigate$lambda$4(this, requestFocus)));
    }

    private final JupyterPsiCellImpl getRespectivePsiCell() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getPsiCell(editor2, this.cell.getOrdinal());
        return jupyterPsiCell instanceof JupyterPsiCellImpl ? (JupyterPsiCellImpl)jupyterPsiCell : null;
    }

    @NotNull
    public TreeElement[] getChildren() {
        Collection $this$toTypedArray$iv = this.children;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TreeElement[0]);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)new JupyterStructureItemPresentation(this.title, null, this.getIcon(), this.level);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public NotebookCellLines.Interval getValue() {
        return this.cell;
    }

    private static final Unit navigate$lambda$4(JupyterStructureViewCellElement this$0, boolean $requestFocus) {
        block0: {
            JupyterPsiCellImpl jupyterPsiCellImpl;
            JupyterPsiCellImpl it = jupyterPsiCellImpl = this$0.getRespectivePsiCell();
            boolean bl = false;
            JupyterPsiCellImpl jupyterPsiCellImpl2 = it;
            Object object = (jupyterPsiCellImpl2 != null ? jupyterPsiCellImpl2.isValid() : false) ? jupyterPsiCellImpl : null;
            if (object == null) break block0;
            object.navigate($requestFocus);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

