/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConverterSupport;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.data.types.DbPointSets;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.FakeRangeFormatter;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataConverters {

    public static class DateRangeToText
    extends DataConverter<String, String> {
        private final Formatter myFormatter;

        public DateRangeToText(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (formatsCache == null) {
                DateRangeToText.$$$reportNull$$$0(0);
            }
            if (formatterCreator == null) {
                DateRangeToText.$$$reportNull$$$0(1);
            }
            super(PointSet.DATE_RANGE, PointSet.TEXT);
            this.myFormatter = new FakeRangeFormatter(ConverterSupport.getDateFormatter((FormatsCache)formatsCache, (FormatterCreator)formatterCreator));
        }

        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                DateRangeToText.$$$reportNull$$$0(2);
            }
            try {
                return (String)this.myFormatter.parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                DateRangeToText.$$$reportNull$$$0(3);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DbDataConverters$DateRangeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimestampRangeToText
    extends DataConverter<String, String> {
        private final Formatter myFormatter;

        public TimestampRangeToText(@NotNull FormatterCreator formatterCreator) {
            if (formatterCreator == null) {
                TimestampRangeToText.$$$reportNull$$$0(0);
            }
            super(PointSet.TIMESTAMP_RANGE, PointSet.TEXT);
            this.myFormatter = new FakeRangeFormatter(ConverterSupport.createTimestampFormatter((FormatterCreator)formatterCreator));
        }

        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                TimestampRangeToText.$$$reportNull$$$0(1);
            }
            try {
                return (String)this.myFormatter.parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                TimestampRangeToText.$$$reportNull$$$0(2);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DbDataConverters$TimestampRangeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberRangeToText
    extends DataConverter<String, String> {
        private final FormatterCreator myFormatterCreator;

        public NumberRangeToText(@NotNull FormatterCreator formatterCreator) {
            if (formatterCreator == null) {
                NumberRangeToText.$$$reportNull$$$0(0);
            }
            super(PointSet.NUMBER_RANGE, PointSet.TEXT);
            this.myFormatterCreator = formatterCreator;
        }

        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                NumberRangeToText.$$$reportNull$$$0(1);
            }
            try {
                return (String)new FakeRangeFormatter((Formatter)this.myFormatterCreator.create(FormatterCreator.getDecimalKey(null, null))).parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                NumberRangeToText.$$$reportNull$$$0(2);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DbDataConverters$NumberRangeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeZonedTimestampToTemporal
    extends DataConverter<TimeZonedTimestamp, TemporalAccessor> {
        public TimeZonedTimestampToTemporal() {
            super(DbPointSets.TIMESTAMP_WITH_TIMEZONE, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Nullable
        protected TimeZonedTimestamp reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeZonedTimestampToTemporal.$$$reportNull$$$0(0);
            }
            return new TimeZonedTimestamp(value instanceof OffsetDateTime ? (OffsetDateTime)value : ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtilCore.getDefaultOffset()));
        }

        @Nullable
        protected TemporalAccessor notNull(@NotNull TimeZonedTimestamp value) {
            if (value == null) {
                TimeZonedTimestampToTemporal.$$$reportNull$$$0(1);
            }
            return value.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DbDataConverters$TimeZonedTimestampToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeZonedTimeToTemporal
    extends DataConverter<TimeZonedTime, TemporalAccessor> {
        public TimeZonedTimeToTemporal() {
            super(DbPointSets.TIME_WITH_TIMEZONE, PointSet.TEMPORAL_TIME);
        }

        @Nullable
        protected TimeZonedTime reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeZonedTimeToTemporal.$$$reportNull$$$0(0);
            }
            return new TimeZonedTime(value instanceof OffsetTime ? (OffsetTime)value : ((LocalTime)value).atOffset(DataGridFormattersUtilCore.getLocalTimeOffset()).withOffsetSameInstant(DataGridFormattersUtilCore.getDefaultOffset()));
        }

        @Nullable
        protected TemporalAccessor notNull(@NotNull TimeZonedTime value) {
            if (value == null) {
                TimeZonedTimeToTemporal.$$$reportNull$$$0(1);
            }
            return value.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DbDataConverters$TimeZonedTimeToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

