/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectivityConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.SmartList;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDriver
extends Iconable,
DatabaseConnectivityConfiguration,
UserDataHolder {
    public static final Option<Boolean> OPTION_AUTO_COMMIT = new Option<Boolean>("auto-commit", true);
    public static final Option<Boolean> OPTION_AUTO_SYNC = new Option<Boolean>("auto-sync", true);
    public static final Option<Boolean> OPTION_FORMAT_SOURCES_ON_SYNC = new Option<Boolean>("format-sources-on-sync", true);
    public static final Option<Boolean> OPTION_SEND_APP_INFO = new Option<Boolean>("send-app-info", true);
    public static final Option<SchemaControl> OPTION_SCHEMA_CONTROL = new Option<SchemaControl>("schema-control", SchemaControl.AUTOMATIC);
    public static final Option<DBIntrospectionOptions.SourceLoading> OPTION_SOURCE_LOADING = new Option<DBIntrospectionOptions.SourceLoading>("source-loading", DBIntrospectionOptions.SourceLoading.USER_SOURCES);
    public static final Key<Boolean> CAN_LOAD_TABLES = new Key("CAN_LOAD_TABLES");

    public String getId();

    @NlsSafe
    @NotNull
    public String getName();

    @NlsSafe
    @Nullable
    public String getComment();

    @Nullable
    public String getDriverClass();

    public String getSqlDialect();

    @Nullable
    public Dbms getForcedDbms();

    public boolean isPredefined();

    @Nullable
    public Bounds getConnectionBounds();

    public <T> T getOption(@NotNull Option<T> var1);

    public <T> void setOption(@NotNull Option<T> var1, T var2);

    @Nullable
    public String getVmOptions();

    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations();

    public boolean matchesUrl(@NotNull String var1);

    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers();

    @NotNull
    public String getSampleUrl();

    public Map<String, String> getDriverProperties();

    public Map<String, String> getVmEnv();

    @NotNull
    public List<ArtifactRef> getArtifacts();

    public List<SimpleClasspathElement> getNativeLibraryPaths();

    public List<SimpleClasspathElement> getClasspathElements();

    public List<SimpleClasspathElement> getAdditionalClasspathElements();

    public boolean hasDriverFiles();

    public LocalDataSource createDataSource(@Nullable String var1);

    public void setAdditionalClasspathElements(List<SimpleClasspathElement> var1);

    @NotNull
    public DatabaseDriver copy(@Nullable String var1, boolean var2);

    @NotNull
    public Set<Constraint> getConstraints();

    @Override
    @Nullable
    default public DatabaseConnectivityConfiguration getParentConfiguration() {
        return null;
    }

    public static class Option<T> {
        private static final Map<String, Option<?>> ourInstances = new LinkedHashMap();
        private final String myName;
        private final T myDef;

        @Nullable
        public static Option byName(String name2) {
            return ourInstances.get(name2);
        }

        @NotNull
        public static Collection<? extends Option<?>> enumerate() {
            Collection<Option<?>> collection = ourInstances.values();
            if (collection == null) {
                Option.$$$reportNull$$$0(0);
            }
            return collection;
        }

        public Option(String name2, T def) {
            this.myName = name2;
            this.myDef = def;
            ourInstances.put(name2, this);
        }

        public String getName() {
            return this.myName;
        }

        public T getDefault() {
            return this.myDef;
        }

        public T get(@Nullable DatabaseDriver driver) {
            return driver != null ? driver.getOption(this) : this.myDef;
        }

        public T fromString(String value) {
            if (value == null) {
                return this.myDef;
            }
            if (this.myDef instanceof String) {
                return (T)value;
            }
            if (this.myDef instanceof Boolean) {
                return (T)Boolean.valueOf(value);
            }
            if (this.myDef instanceof Enum) {
                return (T)Enum.valueOf(((Enum)this.myDef).getClass(), value);
            }
            throw new AssertionError((Object)(this + "!=" + value));
        }

        public String toString() {
            return this.myName + "(" + this.myDef + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriver$Option", "enumerate"));
        }
    }

    public static class Bounds {
        public boolean inReadOnlyMode = false;
        @NotNull
        public ObjectKind boundTo = ObjectKind.DATABASE;
        @NotNull
        public List<Pair<String, Boolean>> rewriteParameters = new SmartList();
        @Nullable
        public String defaultValue = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bounds bounds = (Bounds)o;
            return this.inReadOnlyMode == bounds.inReadOnlyMode && this.boundTo.equals(bounds.boundTo) && this.rewriteParameters.equals(bounds.rewriteParameters) && Objects.equals(this.defaultValue, bounds.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.inReadOnlyMode, this.boundTo, this.rewriteParameters, this.defaultValue);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.inReadOnlyMode) {
                b.append("[RO] ");
            }
            b.append("kind=").append(this.boundTo);
            if (this.defaultValue != null) {
                b.append(" default=").append(this.defaultValue);
            }
            if (!this.rewriteParameters.isEmpty()) {
                b.append(" +").append(this.rewriteParameters.size()).append(" rewrite parameters");
            }
            return b.toString();
        }
    }

    public static class Constraint {
        @Nullable
        public final Dbms dbms;
        @Nullable
        public final Version from;
        @Nullable
        public final Version to;

        public Constraint(@Nullable Dbms dbms, @Nullable Version from, @Nullable Version to) {
            this.dbms = dbms;
            this.from = from;
            this.to = to;
        }

        public boolean matches(@NotNull Dbms dbms, @Nullable Version version) {
            if (dbms == null) {
                Constraint.$$$reportNull$$$0(0);
            }
            if (this.dbms != null && dbms != this.dbms) {
                return false;
            }
            if (version == null) {
                return true;
            }
            if (this.from != null && version.less(this.from)) {
                return false;
            }
            return this.to == null || !version.isOrGreater(this.to);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constraint that = (Constraint)o;
            return Objects.equals(this.dbms, that.dbms) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        public int hashCode() {
            return Objects.hash(this.dbms, this.from, this.to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dataSource/DatabaseDriver$Constraint", "matches"));
        }
    }

    public static interface ArtifactRef {
        @NotNull
        public String getId();

        @Nullable
        public Version getArtifactVersion();

        public String getChannel();
    }
}

