/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.artifacts;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.util.Version;
import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.proxy.CommonProxy;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;

public final class DatabaseArtifactLoaderImpl
extends DatabaseArtifactLoader {
    public static final String DRIVER_DIR = "jdbc-drivers";
    public static final String PROPERTY_DRIVER_PATH = "datagrip.driver.path";
    private static final String ARTIFACTS_XML = "jdbc-drivers.xml";
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactLoaderImpl.class);
    @Nullable
    private static String ourDownloadPath;
    private List<RemoteRepository> myDefaultRepositories;
    private final ConcurrentMap<DatabaseArtifactList.Repository, RemoteRepository> myRepositories = ConcurrentFactoryMap.createMap(r -> ArtifactRepositoryManager.createRemoteRepository((String)r.id, (String)r.url));
    private static final File NATIVE_LIBS_ROOT;

    @Override
    @NotNull
    public DatabaseArtifactList getDefaultArtifactList() {
        DatabaseArtifactList databaseArtifactList = DatabaseArtifactManager.getArtifacts();
        if (databaseArtifactList == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(0);
        }
        return databaseArtifactList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadArtifact(@NotNull DatabaseArtifactList.ArtifactVersion download) throws IOException {
        if (download == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(1);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(download);
        try {
            DownloadableFileSetDescription description = DatabaseArtifactLoaderImpl.asDownloadable(download);
            if (!description.getFiles().isEmpty()) {
                FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(description);
                downloader.download(dir);
            }
            try {
                this.downloadMavenItems(download, dir);
            }
            catch (Exception e) {
                throw new IOException("Download from maven failed", e);
            }
            this.unpackZippedItems(download);
        }
        finally {
            for (DatabaseArtifactList.Item item : download.items) {
                this.refillCache(download, dir, item);
            }
        }
    }

    @Override
    public boolean isValid(@NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(2);
        }
        return this.isValidFileList(version);
    }

    @Override
    public boolean isValid(@NotNull DatabaseArtifactList list, @NotNull String name2, @Nullable Version version) {
        DatabaseArtifactList.Artifact artifact;
        DatabaseArtifactList.ArtifactVersion desc;
        if (list == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(3);
        }
        if (name2 == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(4);
        }
        DatabaseArtifactList.ArtifactVersion artifactVersion = desc = (artifact = list.getArtifact(name2)) == null || version == null ? null : artifact.get(version);
        if (desc != null) {
            return this.isValid(desc);
        }
        return version != null && this.getArtifactDir(list, name2, version).exists();
    }

    public boolean isValidFileList(@NotNull DatabaseArtifactList.ArtifactVersion desc) {
        if (desc == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(5);
        }
        return this.isAllDownloaded(desc);
    }

    @Override
    public boolean hasMissingLocalFiles(@NotNull DatabaseArtifactList.ArtifactVersion artifact) {
        if (artifact == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(6);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(artifact);
        for (DatabaseArtifactList.Item item : artifact.items) {
            if (!item.os.applicable || item.type == DatabaseArtifactList.Item.Type.LICENSE || !item.isLocal() || DatabaseArtifactLoaderImpl.getItemFile(dir, item).exists()) continue;
            return true;
        }
        return false;
    }

    private boolean isAllDownloaded(@NotNull DatabaseArtifactList.ArtifactVersion artifact) {
        if (artifact == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(7);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(artifact);
        for (DatabaseArtifactList.Item item : artifact.items) {
            if (!item.os.applicable || item.type == DatabaseArtifactList.Item.Type.LICENSE || this.exists(dir, artifact, item)) continue;
            return false;
        }
        return true;
    }

    private boolean exists(File dir, DatabaseArtifactList.ArtifactVersion ver, DatabaseArtifactList.Item item) {
        if (item.type != DatabaseArtifactList.Item.Type.MAVEN) {
            return DatabaseArtifactLoaderImpl.getItemFile(dir, item).exists();
        }
        Pair<List<File>, Boolean> state = this.getClassPathState(item, ver, dir);
        if (!((Boolean)state.second).booleanValue()) {
            return false;
        }
        for (File file : (List)state.first) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private static File getItemFile(File dir, DatabaseArtifactList.Item item) {
        if (item.isLocal()) {
            String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)item.url, (String)"file://"));
            return new File(path);
        }
        return new File(dir, item.name);
    }

    private void downloadMavenItems(@NotNull DatabaseArtifactList.ArtifactVersion download, File dir) throws Exception {
        if (download == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(8);
        }
        for (DatabaseArtifactList.Item item : download.items) {
            if (item.type != DatabaseArtifactList.Item.Type.MAVEN || !item.os.applicable) continue;
            this.resolveMavenItem(dir, item, true);
        }
    }

    private void refillCache(@NotNull DatabaseArtifactList.ArtifactVersion download, File dir, DatabaseArtifactList.Item item) {
        if (download == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(9);
        }
        item.classpath = null;
        this.getClassPathState(item, download, dir);
    }

    @Override
    public void unpackZippedItems(@NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(10);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(version);
        for (DatabaseArtifactList.Item item : version.items) {
            if (!item.os.applicable || item.type != DatabaseArtifactList.Item.Type.NATIVE && item.type != DatabaseArtifactList.Item.Type.PACK) continue;
            DatabaseArtifactLoaderImpl.unpackZipIfNeeded(dir, version, item);
        }
    }

    @Nullable
    private static File unpackZipIfNeeded(File dir, @NotNull DatabaseArtifactList.ArtifactVersion version, DatabaseArtifactList.Item item) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(11);
        }
        File archive = DatabaseArtifactLoaderImpl.getItemFile(dir, item);
        return DatabaseArtifactLoaderImpl.unpackZipIfNeeded(archive, version);
    }

    @Override
    @NotNull
    public List<File> getNativeLibraries(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactList.Item.Arch arch) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(12);
        }
        if (arch == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(13);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(version);
        ArrayList<File> paths = new ArrayList<File>();
        for (DatabaseArtifactList.Item item : version.items) {
            File archive;
            File archPath;
            if (!item.os.applicable || !item.arch.matches(arch)) continue;
            if (item.type == DatabaseArtifactList.Item.Type.NATIVE && (archPath = this.getNativeLibrary(archive = new File(dir, item.name), version, arch)) != null) {
                paths.add(archPath);
            }
            if (item.type != DatabaseArtifactList.Item.Type.MAVEN || !item.url.contains(":dll:")) continue;
            JBIterable.from(this.getClassPath(item, version, dir)).filterMap(File::getParentFile).unique().addAllTo(paths);
        }
        ArrayList<File> arrayList = paths;
        if (arrayList == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public File getNativeLibrary(@NotNull File archive, @Nullable DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactList.Item.Arch arch) {
        File path;
        if (archive == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(15);
        }
        if (arch == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(16);
        }
        if ((path = DatabaseArtifactLoaderImpl.unpackZipIfNeeded(archive, version)) == null) {
            return null;
        }
        return DatabaseArtifactLoaderImpl.chooseArchPath(path, arch);
    }

    private static File chooseArchPath(File path, @NotNull DatabaseArtifactList.Item.Arch arch) {
        String archDir;
        if (arch == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(17);
        }
        switch (arch) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ANY: {
                String string = null;
                break;
            }
            case X86: {
                String string = "x86";
                break;
            }
            case X86_64: {
                String string = "x64";
                break;
            }
            case ARM64: {
                String string = archDir = "arm64";
            }
        }
        if (archDir == null) {
            return path;
        }
        File archFolder = new File(path, archDir);
        if (!archFolder.exists()) {
            return path;
        }
        File sso = new File(archFolder, "SSO");
        if (sso.exists()) {
            return sso;
        }
        return archFolder;
    }

    private static void extractLibrary(Path archive, Path out, String name2) {
        if (DatabaseArtifactLoaderImpl.isExtracted(out)) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2(DatabaseBundle.message("progress.details.extracting", name2));
        }
        try {
            ZipUtil.extract((Path)archive, (Path)out, null, (boolean)true);
        }
        catch (IOException e) {
            LOG.warn("Failed to extract " + name2, (Throwable)e);
            try {
                NioFiles.deleteRecursively((Path)out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @Nullable
    public File unpackZipIfNeeded(@NotNull File archive) {
        if (archive == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(18);
        }
        return DatabaseArtifactLoaderImpl.unpackZipIfNeeded(archive, null);
    }

    @Override
    @NotNull
    public File getUnpackedPath(@NotNull File archive, @Nullable DatabaseArtifactList.ArtifactVersion version) {
        if (archive == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(19);
        }
        return DatabaseArtifactLoaderImpl.getUnpackPath(archive, version);
    }

    private static File unpackZipIfNeeded(@NotNull File archive, @Nullable DatabaseArtifactList.ArtifactVersion version) {
        if (archive == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(20);
        }
        if (!archive.exists()) {
            return null;
        }
        File out = DatabaseArtifactLoaderImpl.getUnpackPath(archive, version);
        DatabaseArtifactLoaderImpl.extractLibrary(archive.toPath(), out.toPath(), archive.getName());
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isExtracted(Path out) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(out);){
            if (!stream.iterator().hasNext()) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    private static File getUnpackPath(File archive, @Nullable DatabaseArtifactList.ArtifactVersion version) {
        String name2 = FileUtil.getNameWithoutExtension((File)archive);
        if (version != null) {
            return new File(new File(new File(NATIVE_LIBS_ROOT, version.artifact.id), version.version.toString()), name2);
        }
        MessageDigest digest = DigestUtil.sha256();
        try {
            DigestUtil.updateContentHash((MessageDigest)digest, (Path)archive.toPath());
        }
        catch (Throwable th) {
            LOG.warn(th);
        }
        String fileHash = StringUtil.toHexString((byte[])digest.digest());
        return new File(new File(NATIVE_LIBS_ROOT, "user-provided"), name2 + "-" + fileHash);
    }

    @NotNull
    private static File getArtifactDir(@NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(21);
        }
        return DatabaseArtifactLoaderImpl.getArtifactDir(version.artifact, version.version);
    }

    @NotNull
    static File getArtifactDir(@NotNull DatabaseArtifactList.Artifact artifact, @NotNull Version version) {
        File expected;
        if (artifact == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(22);
        }
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(23);
        }
        if ((expected = DatabaseArtifactLoaderImpl.getArtifactDirImpl(artifact.id, version)).exists()) {
            File file = expected;
            if (file == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(24);
            }
            return file;
        }
        File old2 = DatabaseArtifactLoaderImpl.getArtifactDirImpl(artifact.name, version);
        if (old2.exists()) {
            File file = old2;
            if (file == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(25);
            }
            return file;
        }
        if (artifact.id.equals("MySQL ConnectorJ") && (old2 = DatabaseArtifactLoaderImpl.getArtifactDirImpl("MySQL Connector/J 8", version)).exists()) {
            File file = old2;
            if (file == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(26);
            }
            return file;
        }
        File file = expected;
        if (file == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(27);
        }
        return file;
    }

    @Override
    @NotNull
    public File getArtifactDir(@NotNull DatabaseArtifactList list, @NotNull String name2, @NotNull Version version) {
        File asIs;
        if (list == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(28);
        }
        if (name2 == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(29);
        }
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(30);
        }
        if ((asIs = DatabaseArtifactLoaderImpl.getArtifactDirImpl(name2, version)).exists()) {
            File file = asIs;
            if (file == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(31);
            }
            return file;
        }
        DatabaseArtifactList.Artifact artifact = list.getArtifact(name2);
        return artifact == null ? asIs : DatabaseArtifactLoaderImpl.getArtifactDir(artifact, version);
    }

    @NotNull
    private static File getArtifactDirImpl(@NotNull String artifact, @NotNull Version version) {
        if (artifact == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(32);
        }
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(33);
        }
        return new File(new File(DatabaseArtifactLoaderImpl.getDownloadPath(), artifact), version.toString());
    }

    @NotNull
    private Pair<List<File>, Boolean> resolveClassPath(DatabaseArtifactList.Item item, DatabaseArtifactList.ArtifactVersion ver, File dir) {
        if (item.os.applicable) {
            if (item.type == DatabaseArtifactList.Item.Type.JAR) {
                Pair pair = Pair.create(Collections.singletonList(DatabaseArtifactLoaderImpl.getItemFile(dir, item)), (Object)true);
                if (pair == null) {
                    DatabaseArtifactLoaderImpl.$$$reportNull$$$0(34);
                }
                return pair;
            }
            if (item.type == DatabaseArtifactList.Item.Type.PACK) {
                File root = DatabaseArtifactLoaderImpl.unpackZipIfNeeded(dir, ver, item);
                List files2 = JBIterable.of((Object[])(root == null ? null : root.listFiles())).filter(f -> StringUtil.endsWithIgnoreCase((String)f.getName(), (String)".jar")).toList();
                Pair pair = Pair.create((Object)files2, (Object)true);
                if (pair == null) {
                    DatabaseArtifactLoaderImpl.$$$reportNull$$$0(35);
                }
                return pair;
            }
            if (item.type == DatabaseArtifactList.Item.Type.MAVEN) {
                Pair pair;
                try {
                    pair = Pair.create(new ArrayList<File>(this.resolveMavenItem(dir, item, false)), (Object)true);
                }
                catch (ArtifactResolutionException ignore) {
                    Pair pair2 = Pair.create(Collections.emptyList(), (Object)false);
                    if (pair2 == null) {
                        DatabaseArtifactLoaderImpl.$$$reportNull$$$0(37);
                    }
                    return pair2;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    Pair pair3 = Pair.create(Collections.emptyList(), (Object)false);
                    if (pair3 == null) {
                        DatabaseArtifactLoaderImpl.$$$reportNull$$$0(38);
                    }
                    return pair3;
                }
                if (pair == null) {
                    DatabaseArtifactLoaderImpl.$$$reportNull$$$0(36);
                }
                return pair;
            }
        }
        Pair pair = Pair.create(Collections.emptyList(), (Object)true);
        if (pair == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(39);
        }
        return pair;
    }

    @NotNull
    private static DownloadableFileDescription asDownloadable(@NotNull DatabaseArtifactList.Item item) {
        if (item == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(40);
        }
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(item.url, item.name);
        if (downloadableFileDescription == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(41);
        }
        return downloadableFileDescription;
    }

    @NotNull
    public static DownloadableFileSetDescription asDownloadable(@NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(42);
        }
        return new DownloadableFileSetDescriptionImpl(version.artifact.name, version.version.toString(), ContainerUtil.mapNotNull(version.items, item -> item.os.applicable && item.type != DatabaseArtifactList.Item.Type.MAVEN ? DatabaseArtifactLoaderImpl.asDownloadable(item) : null));
    }

    @NotNull
    private Collection<File> resolveMavenItem(File dir, DatabaseArtifactList.Item item, boolean download) throws Exception {
        boolean shortForm;
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText(DatabaseBundle.message("progress.text.choice.downloading.resolving", download ? 0 : 1, item.url));
        }
        ArtifactRepositoryManager manager = new ArtifactRepositoryManager(dir, this.getRepositories(item.list), indicator != null ? new ProgressConsumer(){

            public void consume(String message) {
                indicator.setText2(message);
            }

            public boolean isCanceled() {
                return indicator.isCanceled();
            }
        } : ProgressConsumer.DEAF, !download);
        List coords = StringUtil.split((String)item.url, (String)":");
        boolean bl = shortForm = coords.size() == 3;
        if (!shortForm && coords.size() != 4) {
            throw new IOException("Illegal maven coordinates " + item.url + " should be group:artifact:version");
        }
        String groupId = (String)coords.get(0);
        String id = (String)coords.get(1);
        String version = shortForm ? (String)coords.get(2) : (String)coords.get(3);
        ArtifactKind kind = DatabaseArtifactLoaderImpl.getArtifactKind(item, shortForm ? "" : (String)coords.get(2));
        List list = ContainerUtil.map((Collection)manager.resolveDependencyAsArtifactStrict(groupId, id, version, kind, true, Collections.emptyList()), a -> a.getFile());
        if (list == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    private static ArtifactKind getArtifactKind(DatabaseArtifactList.Item item, String classifier) throws IOException {
        if (StringUtil.isEmpty((String)classifier)) {
            ArtifactKind artifactKind = ArtifactKind.ARTIFACT;
            if (artifactKind == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(44);
            }
            return artifactKind;
        }
        ArtifactKind kind = ArtifactKind.find((String)classifier, (String)"jar");
        if (kind != null) {
            ArtifactKind artifactKind = kind;
            if (artifactKind == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(45);
            }
            return artifactKind;
        }
        kind = ArtifactKind.find((String)"", (String)classifier);
        if (kind != null) {
            ArtifactKind artifactKind = kind;
            if (artifactKind == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(46);
            }
            return artifactKind;
        }
        throw new IOException("Unknown kind " + classifier + " in " + item.url);
    }

    @NotNull
    private List<RemoteRepository> getRepositories(@NotNull DatabaseArtifactList list) {
        if (list == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(47);
        }
        if (this.myDefaultRepositories == null) {
            this.myDefaultRepositories = ArtifactRepositoryManager.createDefaultRemoteRepositories();
        }
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(this.myDefaultRepositories);
        for (DatabaseArtifactList.Repository repository : list.getRepositories()) {
            repositories.add((RemoteRepository)this.myRepositories.get(repository));
        }
        ArrayList<RemoteRepository> arrayList = repositories;
        if (arrayList == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<File> getClasspathElements(@NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(49);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(version);
        ArrayList<File> elements = new ArrayList<File>();
        for (DatabaseArtifactList.Item item : version.items) {
            List<File> cp = this.getClassPath(item, version, dir);
            if (cp == null) continue;
            elements.addAll(cp);
        }
        ArrayList<File> arrayList = elements;
        if (arrayList == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @Override
    public boolean hasClasspathElementsFast(@NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(51);
        }
        File dir = DatabaseArtifactLoaderImpl.getArtifactDir(version);
        for (DatabaseArtifactList.Item item : version.items) {
            if (!DatabaseArtifactLoaderImpl.hasClassPathFast(item, dir)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public List<File> getClassPath(@NotNull DatabaseArtifactList.Item item, DatabaseArtifactList.ArtifactVersion ver, File dir) {
        if (item == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(52);
        }
        return (List)this.getClassPathState((DatabaseArtifactList.Item)item, (DatabaseArtifactList.ArtifactVersion)ver, (File)dir).first;
    }

    @NotNull
    private Pair<List<File>, Boolean> getClassPathState(@NotNull DatabaseArtifactList.Item item, DatabaseArtifactList.ArtifactVersion ver, File dir) {
        Pair<List<File>, Boolean> cp;
        if (item == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(53);
        }
        if ((cp = item.classpath) != null) {
            Pair<List<File>, Boolean> pair = cp;
            if (pair == null) {
                DatabaseArtifactLoaderImpl.$$$reportNull$$$0(54);
            }
            return pair;
        }
        Pair<List<File>, Boolean> newClasspath = this.resolveClassPath(item, ver, dir);
        item.classpath = newClasspath;
        Pair<List<File>, Boolean> pair = newClasspath;
        if (pair == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(55);
        }
        return pair;
    }

    private static boolean hasClassPathFast(@NotNull DatabaseArtifactList.Item item, File dir) {
        Pair<List<File>, Boolean> cp;
        if (item == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(56);
        }
        if ((cp = item.classpath) != null) {
            return cp.first != null && !((List)cp.first).isEmpty();
        }
        if (!item.os.applicable) {
            return false;
        }
        if (item.type == DatabaseArtifactList.Item.Type.JAR || item.type == DatabaseArtifactList.Item.Type.PACK) {
            return DatabaseArtifactLoaderImpl.getItemFile(dir, item).exists();
        }
        if (item.type == DatabaseArtifactList.Item.Type.MAVEN) {
            return !FileUtil.visitFiles((File)dir, f -> !f.isFile());
        }
        return false;
    }

    @Override
    @Nullable
    public String getRemoteArtifactListUrl() {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        return StringUtil.isNotEmpty((String)serviceUrl) ? serviceUrl + "/jdbc-drivers/jdbc-drivers.xml" : null;
    }

    @Override
    @NotNull
    public File getLocalArtifactListPath() {
        return new File(DatabaseArtifactLoaderImpl.getDownloadPath(), ARTIFACTS_XML);
    }

    @Override
    public byte @Nullable [] loadArtifactList() throws IOException {
        String remoteUrl = this.getRemoteArtifactListUrl();
        if (remoteUrl == null) {
            return null;
        }
        return HttpRequests.request((String)remoteUrl).readBytes(ProgressIndicatorProvider.getGlobalProgressIndicator());
    }

    @Override
    @NotNull
    public List<URL> getTestArtifactLists() {
        ArrayList<URL> testUrls = new ArrayList<URL>();
        File testArtifacts = DatabaseDriverManagerImpl.existentTestPath("test-database-artifacts.xml");
        if (testArtifacts != null) {
            try {
                testUrls.add(testArtifacts.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e);
            }
        }
        ArrayList<URL> arrayList = testUrls;
        if (arrayList == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @NotNull
    public static @SystemDependent String getDownloadPath() {
        if (ourDownloadPath == null) {
            String propertyValue = System.getProperty(PROPERTY_DRIVER_PATH);
            ourDownloadPath = propertyValue != null ? PathManager.getAbsolutePath((String)StringUtil.unquoteString((String)propertyValue, (char)'\"')) : PathManager.getConfigPath() + File.separator + DRIVER_DIR;
        }
        String string = ourDownloadPath;
        if (string == null) {
            DatabaseArtifactLoaderImpl.$$$reportNull$$$0(58);
        }
        return string;
    }

    static {
        CommonProxy.isInstalledAssertion();
        NATIVE_LIBS_ROOT = new File(PathManager.getSystemPath(), "jdbc-native-deps");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28, 29, 30, 32, 33, 40, 42, 47, 49, 51, 52, 53, 56 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactLoaderImpl";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "download";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 30: 
            case 33: 
            case 42: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 28: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 6: 
            case 7: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arch";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 40: 
            case 52: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultArtifactList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 40: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactLoaderImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibraries";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactDir";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassPath";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "asDownloadable";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMavenItem";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactKind";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPathState";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestArtifactLists";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingLocalFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAllDownloaded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadMavenItems";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refillCache";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unpackZippedItems";
                break;
            }
            case 11: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unpackZipIfNeeded";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibraries";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibrary";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "chooseArchPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getUnpackedPath";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDir";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDirImpl";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "asDownloadable";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathElements";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasClasspathElementsFast";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getClassPath";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getClassPathState";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "hasClassPathFast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28, 29, 30, 32, 33, 40, 42, 47, 49, 51, 52, 53, 56 -> new IllegalArgumentException(string);
        };
    }
}

