/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dbimport/DataImporter;", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceType", "Lcom/intellij/database/dbimport/ReaderTask$SourceFactory;", "info", "Lcom/intellij/database/dbimport/ImportInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dbimport/ReaderTask$SourceFactory;Lcom/intellij/database/dbimport/ImportInfo;)V", "myProject", "myNamespace", "Lcom/intellij/database/psi/DbNamespace;", "myExistingTable", "Lcom/intellij/database/psi/DbTable;", "mySourceType", "myInfo", "getImportInfo", "importData", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lockTable", "", "unlockTable", "Companion", "intellij.database.impl"})
public final class DataImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DbNamespace myNamespace;
    @Nullable
    private final DbTable myExistingTable;
    @NotNull
    private final ReaderTask.SourceFactory mySourceType;
    @Nullable
    private final ImportInfo myInfo;
    @NotNull
    private static final Set<DasTable> ourBusyTables;

    public DataImporter(@NotNull Project project, @NotNull ReaderTask.SourceFactory sourceType, @NotNull ImportInfo info2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.myProject = project;
        DatabaseEditorContext databaseEditorContext = info2.getContext();
        Intrinsics.checkNotNull((Object)databaseEditorContext, (String)"null cannot be cast to non-null type com.intellij.database.actions.ImportEditorContext");
        ImportEditorContext context = (ImportEditorContext)databaseEditorContext;
        DbNamespace dbNamespace = context.getNamespace();
        Intrinsics.checkNotNull((Object)dbNamespace);
        this.myNamespace = dbNamespace;
        this.myExistingTable = (DbTable)DbSqlUtilCore.findElement(this.myNamespace.getDataSource(), info2.getTablePath());
        this.mySourceType = sourceType;
        this.myInfo = info2;
    }

    @NotNull
    public final ImportInfo getImportInfo() {
        ImportInfo importInfo = this.myInfo;
        Intrinsics.checkNotNull((Object)importInfo);
        return importInfo;
    }

    @Nullable
    public final Object importData(@NotNull Continuation<? super Boolean> $completion) throws IOException {
        if (this.myInfo == null) {
            return null;
        }
        String string = DatabaseBundle.message("progress.title.importing.data", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)AsyncTask.Companion.frame(string).getElement()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ DataImporter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = DataImporter.access$getMyNamespace$p(this.this$0).getDataSource();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDataSource(...)");
                        dataSource = v0;
                        v1 = dataSource.getDbms();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDbms(...)");
                        dbms = v1;
                        DataImporter.access$lockTable(this.this$0);
                        namespace = DbImplUtilCore.getSearchPathObjectForSwitch(DataImporter.access$getMyNamespace$p(this.this$0));
                        v2 = DataImporter.access$getMySourceType$p(this.this$0).createSource(DataImporter.access$getMyInfo$p(this.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"createSource(...)");
                        source = v2;
                        v3 = DataImporter.access$getMyProject$p(this.this$0);
                        var7_9 = DbImplUtilCore.getLocalDataSource(dataSource);
                        Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"getLocalDataSource(...)");
                        modifier = new ImportDatabaseModifier(v3, var7_9, DataImporter.access$getMyInfo$p(this.this$0), (Dbms)var3_4, source, ObjectPaths.searchPathOf(namespace));
                        v4 = DataImporter.access$getMyInfo$p(this.this$0).getTablePath();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getTablePath(...)");
                        targetTablePath = v4;
                        if (DataImporter.access$getMyExistingTable$p(this.this$0) == null) {
                            modifier.include(targetTablePath);
                        }
                        modifier.setElementToFocus(targetTablePath);
                        this.label = 1;
                        v5 = modifier.runStatements(false, (Continuation<? super Boolean>)((Continuation)this));
                        ** if (v5 != var8_2) goto lbl32
lbl31:
                        // 1 sources

                        return var8_2;
lbl32:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl38:
                            // 2 sources

                            var4_6 = (Boolean)v5;
                        }
                        catch (Throwable var5_8) {
                            throw var5_8;
                        }
                        finally {
                            DataImporter.access$unlockTable(this.this$0);
                        }
                        return Boxing.boxBoolean((boolean)(var4_6 != false));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void lockTable() {
        ImportInfo importInfo = this.myInfo;
        Intrinsics.checkNotNull((Object)importInfo);
        if (!importInfo.shouldLockTable()) {
            return;
        }
        if (this.myExistingTable != null) {
            ourBusyTables.add(this.myExistingTable);
        }
    }

    private final void unlockTable() {
        ImportInfo importInfo = this.myInfo;
        Intrinsics.checkNotNull((Object)importInfo);
        if (!importInfo.shouldLockTable()) {
            return;
        }
        if (this.myExistingTable != null) {
            ourBusyTables.remove(this.myExistingTable);
        }
    }

    @JvmStatic
    public static final boolean isBusy(@Nullable Object element) {
        return Companion.isBusy(element);
    }

    public static final /* synthetic */ DbNamespace access$getMyNamespace$p(DataImporter $this) {
        return $this.myNamespace;
    }

    public static final /* synthetic */ void access$lockTable(DataImporter $this) {
        $this.lockTable();
    }

    public static final /* synthetic */ ReaderTask.SourceFactory access$getMySourceType$p(DataImporter $this) {
        return $this.mySourceType;
    }

    public static final /* synthetic */ ImportInfo access$getMyInfo$p(DataImporter $this) {
        return $this.myInfo;
    }

    public static final /* synthetic */ Project access$getMyProject$p(DataImporter $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ DbTable access$getMyExistingTable$p(DataImporter $this) {
        return $this.myExistingTable;
    }

    public static final /* synthetic */ void access$unlockTable(DataImporter $this) {
        $this.unlockTable();
    }

    static {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        ourBusyTables = set;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dbimport/DataImporter$Companion;", "", "<init>", "()V", "ourBusyTables", "", "Lcom/intellij/database/model/DasTable;", "isBusy", "", "element", "getElement", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isBusy(@Nullable Object element) {
            DasTable table = this.getElement(element);
            return table != null && ourBusyTables.contains(table);
        }

        private final DasTable getElement(Object element) {
            return element instanceof DasTableChild ? ((DasTableChild)element).getTable() : (element instanceof DasTable ? (DasTable)element : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

