/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.CsvLexer;
import com.intellij.database.datagrid.CsvParserResult;
import com.intellij.database.datagrid.CsvReader;
import com.intellij.database.datagrid.StreamCsvFormatParser;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.OffsetBatchRecords;
import com.intellij.database.remote.dbimport.OffsetRecord;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvSource
implements ReaderTask.Source {
    private final ThrowableComputable<InputStream, IOException> myStream;
    private final Charset myCharset;
    private final long mySizeInBytes;
    private final double myBytesPerChar;
    private final ParserChooser myChooser;
    private CsvReader myReader;
    private CsvInputParser myParser;

    public static int getPreviewCharacterCount() {
        return Registry.intValue((String)"database.csv.preview.char.count", (int)10000);
    }

    public CsvSource(@NotNull ThrowableComputable<InputStream, IOException> stream, @NotNull Charset charset, @NotNull ImportInfo info2, int maxCharsReadPerBatch, long bytes) {
        if (stream == null) {
            CsvSource.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            CsvSource.$$$reportNull$$$0(1);
        }
        if (info2 == null) {
            CsvSource.$$$reportNull$$$0(2);
        }
        this.myStream = stream;
        this.myBytesPerChar = charset.newEncoder().averageBytesPerChar();
        this.myCharset = charset;
        this.myChooser = new ParserChooser(Objects.requireNonNull(info2.getFormat()), maxCharsReadPerBatch);
        this.mySizeInBytes = bytes;
    }

    @Override
    @Nullable
    public ReaderTask.Result read() throws InterruptedException, IOException {
        if (this.myReader == null) {
            this.myReader = new CsvReader((Reader)new BufferedReader(new InputStreamReader((InputStream)this.myStream.compute(), this.myCharset)));
        }
        if (this.myParser == null) {
            this.myParser = this.myChooser.create(this.myReader);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        long start2 = System.currentTimeMillis();
        StreamCsvFormatParser.CsvParserResult result2 = this.myParser.parse();
        if (result2 == null) {
            return null;
        }
        List tokens = result2.getRecords();
        return new ReaderTask.ResultImpl(CsvSource.createBatch(tokens, (double)result2.getCharacters() * this.myBytesPerChar), result2.getErrors(), System.currentTimeMillis() - start2);
    }

    @Override
    @NotNull
    public ImportIndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder adder, @NotNull ImportInfo info2) {
        if (indicator == null) {
            CsvSource.$$$reportNull$$$0(3);
        }
        if (adder == null) {
            CsvSource.$$$reportNull$$$0(4);
        }
        if (info2 == null) {
            CsvSource.$$$reportNull$$$0(5);
        }
        return new ImportIndicatorUpdater(indicator, adder, info2){

            @Override
            @Nullable
            public String calculateSpeed(long timeSpent) {
                long size = Math.round(this.myCurrentSize / (double)timeSpent);
                return size == 0L ? null : String.format("%s/s", StringUtil.formatFileSize((long)size));
            }
        };
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myChooser.myFormat;
        if (csvFormat == null) {
            CsvSource.$$$reportNull$$$0(6);
        }
        return csvFormat;
    }

    public long getSizeInBytes() {
        return this.mySizeInBytes;
    }

    @Override
    public void calculateSize(@NotNull Consumer<Double> callback) {
        if (callback == null) {
            CsvSource.$$$reportNull$$$0(7);
        }
        callback.consume((Object)this.mySizeInBytes);
    }

    @Override
    public void close() {
        if (this.myReader == null) {
            return;
        }
        try {
            this.myReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static BatchRecords createBatch(@NotNull List<StreamCsvFormatParser.Token[]> tokens, double size) {
        if (tokens == null) {
            CsvSource.$$$reportNull$$$0(8);
        }
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        Int2LongOpenHashMap lines = new Int2LongOpenHashMap();
        Int2LongOpenHashMap offsets = new Int2LongOpenHashMap();
        for (Object[] objectArray : tokens) {
            StreamCsvFormatParser.Token first2 = (StreamCsvFormatParser.Token)ArrayUtil.getFirstElement((Object[])objectArray);
            long lineNumber = Objects.requireNonNull(first2).getLine();
            long charNumber = Objects.requireNonNull(first2).getOffset();
            lines.put(objects.size(), lineNumber);
            offsets.put(objects.size(), charNumber);
            objects.add(ContainerUtil.map((Object[])objectArray, StreamCsvFormatParser.Token::getValue, (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY));
        }
        return new MyRecords(objects, (Int2LongMap)lines, (Int2LongMap)offsets, tokens, size);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/csv/CsvSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/csv/CsvSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIndicatorUpdater";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateSize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static final class ParserChooser {
        private final CsvFormat myFormat;
        private final int myMaxCharsReadPerBatch;

        private ParserChooser(@NotNull CsvFormat format, int maxCharsReadPerBatch) {
            if (format == null) {
                ParserChooser.$$$reportNull$$$0(0);
            }
            this.myFormat = format;
            this.myMaxCharsReadPerBatch = maxCharsReadPerBatch;
        }

        @NotNull
        CsvInputParser create(@NotNull CsvReader reader) throws IOException {
            if (reader == null) {
                ParserChooser.$$$reportNull$$$0(1);
            }
            String line = reader.readAhead(CsvSource.getPreviewCharacterCount());
            CsvFormatParser parser2 = new CsvFormatParser(this.myFormat);
            CsvParserResult markup = line == null ? null : parser2.parse((CharSequence)line);
            return markup == null ? new MyOneLineParser(reader) : new MyFormatParser(this.myFormat, this.myMaxCharsReadPerBatch, reader);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/csv/CsvSource$ParserChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface CsvInputParser {
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse() throws IOException;
    }

    private static class MyRecords
    extends OffsetBatchRecords {
        private final List<StreamCsvFormatParser.Token[]> myTokens;

        MyRecords(@NotNull List<Object[]> records, @NotNull Int2LongMap lines, @NotNull Int2LongMap startOffsets, @NotNull List<StreamCsvFormatParser.Token[]> tokens, double size) {
            if (records == null) {
                MyRecords.$$$reportNull$$$0(0);
            }
            if (lines == null) {
                MyRecords.$$$reportNull$$$0(1);
            }
            if (startOffsets == null) {
                MyRecords.$$$reportNull$$$0(2);
            }
            if (tokens == null) {
                MyRecords.$$$reportNull$$$0(3);
            }
            super(records, lines, startOffsets, size);
            this.myTokens = tokens;
        }

        @NotNull
        public ErrorRecord getErrorRecord(@NotNull Exception e, int idx) {
            StreamCsvFormatParser.Token[] tokens;
            if (e == null) {
                MyRecords.$$$reportNull$$$0(4);
            }
            if (!(e instanceof ImportInfo.ConversionException)) {
                ErrorRecord errorRecord = super.getErrorRecord(e, idx);
                if (errorRecord == null) {
                    MyRecords.$$$reportNull$$$0(5);
                }
                return errorRecord;
            }
            int tokenIndex = ((ImportInfo.ConversionException)e).getIndex();
            StreamCsvFormatParser.Token token = tokenIndex < (tokens = this.myTokens.get(idx)).length ? tokens[tokenIndex] : null;
            return new OffsetRecord(e, this.getLineNumber(idx), token != null ? token.getOffset() : (long)tokenIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startOffsets";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokens";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/csv/CsvSource$MyRecords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/csv/CsvSource$MyRecords";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorRecord";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorRecord";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyFormatParser
    implements CsvInputParser {
        private final StreamCsvFormatParser myParser;

        private MyFormatParser(@NotNull CsvFormat format, int maxCharsReadPerBatch, @NotNull CsvReader reader) {
            if (format == null) {
                MyFormatParser.$$$reportNull$$$0(0);
            }
            if (reader == null) {
                MyFormatParser.$$$reportNull$$$0(1);
            }
            this.myParser = new StreamCsvFormatParser(format, maxCharsReadPerBatch, reader);
        }

        @Override
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse() throws IOException {
            return this.myParser.parse();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "format";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reader";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/csv/CsvSource$MyFormatParser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyOneLineParser
    implements CsvInputParser {
        private final CsvReader myReader;
        private boolean myEnd;

        private MyOneLineParser(@NotNull CsvReader reader) {
            if (reader == null) {
                MyOneLineParser.$$$reportNull$$$0(0);
            }
            this.myReader = reader;
        }

        @Override
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse() throws IOException {
            if (this.myEnd) {
                return null;
            }
            this.myEnd = true;
            String string = this.myReader.readString(0x500000);
            if (string == null) {
                return null;
            }
            int length = string.length();
            StreamCsvFormatParser.Token token = new StreamCsvFormatParser.Token(string, false, CsvLexer.TokenType.VALUE, 0L, (long)length);
            StreamCsvFormatParser.Token[] tokens = new StreamCsvFormatParser.Token[]{token};
            List<StreamCsvFormatParser.Token[]> list = Collections.singletonList(tokens);
            return new StreamCsvFormatParser.CsvParserResult(tokens, list, MyOneLineParser.getError(this.myReader, string.substring(0, Math.min(string.length(), CsvSource.getPreviewCharacterCount()))), (long)length);
        }

        @NotNull
        private static List<ErrorRecord> getError(@NotNull CsvReader r, @NotNull String text) throws IOException {
            if (r == null) {
                MyOneLineParser.$$$reportNull$$$0(1);
            }
            if (text == null) {
                MyOneLineParser.$$$reportNull$$$0(2);
            }
            if (!r.isReady()) {
                return new ArrayList<ErrorRecord>();
            }
            StreamCsvFormatParser.MaxCharactersReachedException exception = new StreamCsvFormatParser.MaxCharactersReachedException(text);
            OffsetRecord record = new OffsetRecord((Exception)exception, 0L, 0L);
            List<OffsetRecord> list = List.of(record);
            if (list == null) {
                MyOneLineParser.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/csv/CsvSource$MyOneLineParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/csv/CsvSource$MyOneLineParser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getError";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

