/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DBConnectionAccessibilityMatcher;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.introspection.BriefIntrospectionTask;
import com.intellij.database.introspection.CombinedIntrospectionTask;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DatabaseFragmentIntrospectionTask;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.ListSchemasTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.StringFun;
import com.intellij.ide.PlatformIdeService;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0003ijkB)\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&H\u0014J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0018\u0010/\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020)H\u0014J(\u00100\u001a\u00020\"\"\b\b\u0003\u00102*\u00020\u001c2\u0006\u00101\u001a\u00020)2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H204H\u0004J\u0010\u00105\u001a\u00020\"2\u0006\u00101\u001a\u00020)H\u0004J\u001a\u00106\u001a\u0004\u0018\u00010\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u00107\u001a\u00020\u0013H\u0014J\u0012\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u00107\u001a\u00020\u0013H\u0014J\u0018\u00109\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020:H\u0014J\u0018\u0010;\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020<H\u0014J\u0018\u0010=\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020>H\u0014J\b\u0010?\u001a\u00020@H\u0016J&\u0010A\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030BR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000H$J!\u0010C\u001a\u00020\"2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0D\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010EJ\u0018\u0010F\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010G\u001a\u00020\"2\u0006\u00101\u001a\u00020)2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010&H\u0014J\u000e\u0010J\u001a\u0004\u0018\u00010K*\u00020KH\u0002J\u000e\u0010L\u001a\u0004\u0018\u00010\u001c*\u00020\u001cH\u0002J\u0010\u0010M\u001a\u00020\"2\u0006\u00101\u001a\u00020)H\u0014J&\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010O2\u0006\u00101\u001a\u00020)2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010&H\u0014J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020K0$2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u001e\u0010Q\u001a\u00020\"2\u0006\u00101\u001a\u00020)2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001c0&H\u0002J\u001e\u0010;\u001a\u00020\"2\u0006\u00101\u001a\u00020)2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020K0&H\u0002J\u001e\u0010T\u001a\u00020\"2\u0006\u00101\u001a\u00020)2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V0&H\u0002J9\u0010W\u001a\u001e\u0012\u0004\u0012\u00028\u00010XR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010YJ;\u0010Z\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010[R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\\J;\u0010]\u001a \u0012\u0006\b\u0001\u0012\u00028\u00020^R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010_\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010`J\u001d\u0010a\u001a\u00020\"2\u0006\u00101\u001a\u00020)2\u0006\u0010\u001b\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010bJ8\u0010c\u001a\u00020\"2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020e0O2\u0006\u0010f\u001a\u00020\u00192\u0018\u0010g\u001a\u0014\u0012\u0004\u0012\u00020e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130D0hH\u0016R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "MR", "Lcom/intellij/database/model/basic/BasicModMultiDatabaseRoot;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "connectionCurrentDatabaseName", "", "getConnectionCurrentDatabaseName", "()Ljava/lang/String;", "setConnectionCurrentDatabaseName", "(Ljava/lang/String;)V", "databasesAreListed", "", "checkDatabaseIsAccessibleInCurrentConnection", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "checkConnectionApplicable", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$ConnectionApplicability;", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "logModelInfo", "", "reorderTasks", "", "originalTasks", "", "introspectGeneral", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "introspectGeneralWithDistributionByDatabases", "notifyCannotSwitchDatabase", "root", "Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "db", "introspectNamespaces", "introspectNamespacesInTran", "tran", "T", "databases", "Lcom/intellij/util/containers/JBIterable;", "listAndApplyDatabasesIfNotYet", "reifyDatabase", "databaseName", "findDatabase", "introspectDatabase", "Lcom/intellij/database/introspection/DatabaseIntrospectionTask;", "introspectSchemas", "Lcom/intellij/database/introspection/SchemasIntrospectionTask;", "introspectDatabaseFragments", "Lcom/intellij/database/introspection/DatabaseFragmentIntrospectionTask;", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "introspectDatabaseSchemas", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "retrieveSchemasOfDatabase", "introspectAutomatically", "namespaces", "Lcom/intellij/database/model/basic/BasicNamespace;", "adjustSchemaInstance", "Lcom/intellij/database/model/basic/BasicSchema;", "adjustDatabaseInstance", "introspectPreDatabaseObjects", "getDatabasesToIntrospect", "", "getSchemasToIntrospect", "introspectDatabases", "databasesToIntrospect", "schemasToIntrospect", "introspectFragments", "fragmentToIntrospect", "Lcom/intellij/database/model/basic/BasicMajorObject;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "postProcessDatabase", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "introspectNativeDefinitions", "elements", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "result", "", "DatabaseLister", "BaseDatabaseRetriever", "BaseNativeRetriever", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseMultiDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,619:1\n1010#2,2:620\n1010#2,2:622\n1010#2,2:624\n774#2:626\n865#2,2:627\n774#2:629\n865#2,2:630\n295#2,2:632\n1485#2:675\n1510#2,3:676\n1513#2,3:686\n368#3,2:634\n368#3,2:637\n1#4:636\n1068#5:639\n1152#5:640\n1069#5,5:641\n1156#5,2:646\n1074#5,2:648\n1068#5:664\n1152#5:665\n1069#5,5:666\n1156#5,2:671\n1074#5,2:673\n992#6:650\n1021#6,3:651\n1024#6,3:661\n381#7,7:654\n381#7,7:679\n*S KotlinDebug\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector\n*L\n134#1:620,2\n135#1:622,2\n136#1:624,2\n159#1:626\n159#1:627,2\n232#1:629\n232#1:630,2\n251#1:632,2\n598#1:675\n598#1:676,3\n598#1:686,3\n370#1:634,2\n400#1:637,2\n488#1:639\n488#1:640\n488#1:641,5\n488#1:646,2\n488#1:648,2\n533#1:664\n533#1:665\n533#1:666,5\n533#1:671,2\n533#1:673,2\n529#1:650\n529#1:651,3\n529#1:661,3\n529#1:654,7\n598#1:679,7\n*E\n"})
public abstract class BaseMultiDatabaseIntrospector<MR extends BasicModMultiDatabaseRoot, D extends BasicModMateDatabase, S extends BasicModSchema>
extends BaseNativeIntrospector<MR, D, S> {
    @Nullable
    private String connectionCurrentDatabaseName;
    private boolean databasesAreListed;

    @Nullable
    protected final String getConnectionCurrentDatabaseName() {
        return this.connectionCurrentDatabaseName;
    }

    protected final void setConnectionCurrentDatabaseName(@Nullable String string) {
        this.connectionCurrentDatabaseName = string;
    }

    public BaseMultiDatabaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
    }

    protected boolean checkDatabaseIsAccessibleInCurrentConnection(@NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Object object = this.getDbConnection();
        if (object == null || (object = object.getConnectionPoint()) == null) {
            return false;
        }
        Object connectionPoint = object;
        DBConnectionAccessibilityMatcher dBConnectionAccessibilityMatcher = this.getAccessibilityMatcher();
        if (dBConnectionAccessibilityMatcher == null) {
            return true;
        }
        DBConnectionAccessibilityMatcher accessibilityMatcher = dBConnectionAccessibilityMatcher;
        return accessibilityMatcher.isDatabaseAccessible((DatabaseConnectionPoint)connectionPoint, database);
    }

    @Override
    @NotNull
    protected BaseIntrospector.ConnectionApplicability checkConnectionApplicable(@NotNull IntrospectionTask task) {
        boolean ok2;
        BasicDatabase db;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BaseIntrospector.ConnectionApplicability connectionApplicability = this.getDbConnection() == null ? BaseIntrospector.ConnectionApplicability.connNone : (this.isMetadataAccessDependsOnConnection() ? ((db = this.getDatabase(task)) != null ? ((ok2 = this.checkDatabaseIsAccessibleInCurrentConnection(db)) ? BaseIntrospector.ConnectionApplicability.connApplicableFull : BaseIntrospector.ConnectionApplicability.connInapplicable) : BaseIntrospector.ConnectionApplicability.connApplicablePartial) : BaseIntrospector.ConnectionApplicability.connApplicableFull);
        return connectionApplicability;
    }

    @Override
    protected void logModelInfo() {
        super.logModelInfo();
        BasicModModel basicModModel = this.getMyModel();
        if (basicModModel == null) {
            IntrospectionQueryContext.logWarn$default(this, "The model is not initialized yet", null, 2, null);
            return;
        }
        BasicModModel model = basicModModel;
        if (!this.getTracing()) {
            return;
        }
        StringBuilder b = new StringBuilder();
        BasicRoot basicRoot = model.getRoot();
        Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicMultiDatabaseRoot");
        BasicMultiDatabaseRoot root = (BasicMultiDatabaseRoot)basicRoot;
        Iterable<? extends BasicMateDatabase> iterable = root.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        int n1 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(iterable), BaseMultiDatabaseIntrospector::logModelInfo$lambda$0));
        StringBuilder stringBuilder = b;
        Iterable<? extends BasicMateDatabase> iterable2 = root.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getNamespaces(...)");
        StringBuilder stringBuilder2 = stringBuilder.append("The model contains " + CollectionsKt.count(iterable2) + " databases, " + n1 + " of them are with schemas");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        BasicMateDatabase currDatabase = root.getCurrentDatabase();
        if (currDatabase != null) {
            BasicSchema currSchema;
            StringBuilder stringBuilder3 = b.append("Current database: " + currDatabase.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            Iterable<? extends BasicMateNamespace> iterable3 = currDatabase.getNamespaces();
            Intrinsics.checkNotNullExpressionValue(iterable3, (String)"getNamespaces(...)");
            int n2 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(iterable3), BaseMultiDatabaseIntrospector::logModelInfo$lambda$1));
            StringBuilder stringBuilder4 = b;
            Iterable<? extends BasicMateNamespace> iterable4 = currDatabase.getNamespaces();
            Intrinsics.checkNotNullExpressionValue(iterable4, (String)"getNamespaces(...)");
            StringBuilder stringBuilder5 = stringBuilder4.append("The current database has " + CollectionsKt.count(iterable4) + " schemas, " + n2 + " of them have inner objects");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            BasicSchema basicSchema = currSchema = ModelFun.getCurrentSchema(currDatabase);
            if (basicSchema != null) {
                StringBuilder stringBuilder6 = b.append("Current schema: " + basicSchema.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                StringBuilder stringBuilder7 = stringBuilder6.append('\n');
                v12 = stringBuilder7;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            } else {
                StringBuilder stringBuilder8 = b.append("No current schema in this database");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                StringBuilder stringBuilder9 = stringBuilder8.append('\n');
                v12 = stringBuilder9;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            }
        } else {
            StringBuilder stringBuilder10 = b.append("No current database.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            StringBuilder stringBuilder11 = stringBuilder10.append('\n');
            v12 = stringBuilder11;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.trace(string);
    }

    @Override
    @NotNull
    protected List<IntrospectionTask> reorderTasks(@NotNull Collection<? extends IntrospectionTask> originalTasks) {
        Intrinsics.checkNotNullParameter(originalTasks, (String)"originalTasks");
        ArrayList tasks0 = new ArrayList(0);
        ArrayList tasks1 = new ArrayList(0);
        ArrayList tasks2 = new ArrayList(0);
        BasicModMateDatabase basicModMateDatabase = (BasicModMateDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
        String currentDatabaseName = basicModMateDatabase != null ? basicModMateDatabase.getName() : null;
        for (IntrospectionTask introspectionTask : originalTasks) {
            IntrospectionTask introspectionTask2 = introspectionTask;
            if (introspectionTask2 instanceof IndefiniteIntrospectionTask || introspectionTask2 instanceof CombinedIntrospectionTask) {
                ((Collection)tasks0).add(introspectionTask);
                continue;
            }
            if (introspectionTask2 instanceof DefiniteIntrospectionTask) {
                String name2 = ((DefiniteIntrospectionTask)introspectionTask).getDatabaseName();
                if (Intrinsics.areEqual((Object)name2, (Object)currentDatabaseName) || Intrinsics.areEqual((Object)name2, (Object)"@") || ((CharSequence)name2).length() == 0) {
                    ((Collection)tasks1).add(introspectionTask);
                    continue;
                }
                ((Collection)tasks2).add(introspectionTask);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        List $this$sortBy$iv = tasks0;
        boolean bl = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntrospectionTask it = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it.getTaskTypeOrder());
                    it = (IntrospectionTask)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it.getTaskTypeOrder()));
                }
            });
        }
        $this$sortBy$iv = tasks1;
        boolean bl2 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntrospectionTask it = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it.getTaskTypeOrder());
                    it = (IntrospectionTask)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it.getTaskTypeOrder()));
                }
            });
        }
        $this$sortBy$iv = tasks2;
        boolean bl3 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntrospectionTask it = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it.getTaskTypeOrder());
                    it = (IntrospectionTask)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it.getTaskTypeOrder()));
                }
            });
        }
        ArrayList tasks = new ArrayList(originalTasks.size());
        tasks.addAll(tasks0);
        tasks.addAll(tasks1);
        tasks.addAll(tasks2);
        return tasks;
    }

    @Override
    protected void introspectGeneral(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.introspectServerAndSessionInfo();
        this.listAndApplyDatabasesIfNotYet(transaction);
        if (this.isMetadataAccessDependsOnConnection()) {
            this.introspectGeneralWithDistributionByDatabases(transaction);
        } else {
            super.introspectGeneral(transaction);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectGeneralWithDistributionByDatabases(DBTransaction transaction) {
        void $this$filterTo$iv$iv;
        Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        Iterable<? extends BasicMateDatabase> $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable<? extends BasicMateDatabase> iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicNamespace p0 = (BasicNamespace)element$iv$iv;
            boolean $i$f$introspectGeneralWithDistributionByDatabases$stub_for_inlining = false;
            boolean bl = false;
            if (!this.inIntrospectionScope(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List databasesToIntrospect = (List)destination$iv$iv;
        ArrayList applicableTasks = new ArrayList();
        DBConnectionAccessibilityMatcher accessibilityMatcher = this.getAccessibilityMatcher();
        boolean canSwitchDatabase = accessibilityMatcher != null && accessibilityMatcher.canSwitchDatabase();
        for (BasicModMateDatabase db : databasesToIntrospect) {
            DefiniteIntrospectionTask additionalTask = IntrospectionTasks.prepareDatabaseTask(this.getDataSourceId(), db);
            if (this.checkDatabaseIsAccessibleInCurrentConnection(db)) {
                ((Collection)applicableTasks).add(additionalTask);
                continue;
            }
            if (canSwitchDatabase) {
                this.deferTask(additionalTask);
                continue;
            }
            this.notifyCannotSwitchDatabase((BasicMultiDatabaseRoot)this.getRoot(), db);
        }
        if (!((Collection)applicableTasks).isEmpty()) {
            this.introspectPreDatabaseObjects(transaction);
            Iterator iterator = applicableTasks.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                IntrospectionTask applicableTask = (IntrospectionTask)e;
                this.introspectInTran(transaction, applicableTask);
            }
        }
        this.introspectServerObjectsInTran(transaction);
    }

    private final void notifyCannotSwitchDatabase(BasicMultiDatabaseRoot root, BasicDatabase db) {
        BasicDatabase accessibleDatabase = root.getCurrentDatabase();
        Object object = accessibleDatabase;
        if (object == null || (object = object.getDisplayName()) == null) {
            object = "not detected";
        }
        Object accessibleDatabaseString = object;
        IntrospectionQueryContext.logWarn$default(this, "Cannot perform introspection task with non-accessible database (" + db.getDisplayName() + ") because switching database is not possible in this configuration; the only accessible database is " + (String)accessibleDatabaseString, null, 2, null);
        Object object2 = accessibleDatabase;
        if (object2 == null || (object2 = object2.getDisplayName()) == null) {
            String string = DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.currentDatabaseIsNotDetected", new Object[0]);
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        Object accessibleDatabaseI18nString = object2;
        Object[] objectArray = new Object[]{accessibleDatabaseI18nString, db.getDisplayName()};
        PlatformIdeService.getInstance().notification("Switching database in introspection", PlatformIdeService.NotificationType.WARNING, DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.title", new Object[0]), DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.subtitle", new Object[0]), DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.description", objectArray), this.getProject(), "base.introspector.switching.database.singleDatabaseMode");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        boolean needsToListDatabases;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        boolean bl = needsToListDatabases = IntrospectionTaskHelperFun.isEmpty(iterable) || task instanceof IndefiniteIntrospectionTask || task instanceof DefiniteIntrospectionTask && this.getDatabaseIsKnown((DefiniteIntrospectionTask)task);
        if (needsToListDatabases) {
            this.listAndApplyDatabasesIfNotYet(transaction);
        }
        boolean allApplicable = !this.isMetadataAccessDependsOnConnection();
        IntrospectionTask introspectionTask = task;
        if (introspectionTask instanceof DefiniteIntrospectionTask || introspectionTask instanceof CombinedIntrospectionTask) {
            boolean applicableRightNow;
            BasicDatabase basicDatabase = this.getDatabase(task);
            if (basicDatabase == null) {
                return;
            }
            BasicDatabase theDatabase = basicDatabase;
            boolean bl2 = applicableRightNow = allApplicable || this.checkDatabaseIsAccessibleInCurrentConnection(theDatabase);
            if (applicableRightNow) {
                this.retrieveSchemasOfDatabase(transaction, theDatabase);
            } else {
                ListSchemasTask listSchemasTask;
                if (task instanceof ListSchemasTask) {
                    listSchemasTask = (ListSchemasTask)task;
                } else {
                    String string = task.getDataSourceId();
                    String string2 = theDatabase.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    listSchemasTask = new ListSchemasTask(string, string2);
                }
                ListSchemasTask taskToDefer = listSchemasTask;
                this.deferTask(taskToDefer);
            }
        } else if (introspectionTask instanceof IndefiniteIntrospectionTask) {
            List list;
            if (task instanceof BriefIntrospectionTask && ((BriefIntrospectionTask)task).getVisitEveryDatabase()) {
                Iterable<? extends BasicMateDatabase> iterable2 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getNamespaces(...)");
                list = CollectionsKt.toList(iterable2);
            } else {
                void $this$filterTo$iv$iv;
                Iterable<? extends BasicMateDatabase> iterable3 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable3, (String)"getNamespaces(...)");
                Iterable<? extends BasicMateDatabase> $this$filter$iv = iterable3;
                boolean $i$f$filter = false;
                Iterable<? extends BasicMateDatabase> iterable4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BasicNamespace p0 = (BasicNamespace)element$iv$iv;
                    boolean $i$f$introspectNamespaces$stub_for_inlining$5 = false;
                    boolean bl3 = false;
                    if (!this.inIntrospectionScope(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List databases = list;
            for (BasicModMateDatabase db : databases) {
                boolean applicableRightNow;
                boolean bl4 = applicableRightNow = allApplicable || this.checkDatabaseIsAccessibleInCurrentConnection(db);
                if (applicableRightNow) {
                    this.retrieveSchemasOfDatabase(transaction, db);
                    continue;
                }
                String string = task.getDataSourceId();
                String string3 = db.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                ListSchemasTask additionalTask = new ListSchemasTask(string, string3);
                this.deferTask(additionalTask);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.listAndApplyDatabasesIfNotYet(tran);
        BasicDatabase firstDatabase = ((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
        if (firstDatabase == null && this.dbms.isSnowflake()) {
            BasicMateDatabase basicMateDatabase;
            block3: {
                Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
                Iterable<? extends BasicMateDatabase> $this$firstOrNull$iv = iterable;
                boolean $i$f$firstOrNull = false;
                for (BasicMateDatabase basicMateDatabase2 : $this$firstOrNull$iv) {
                    BasicModMateDatabase it = (BasicModMateDatabase)basicMateDatabase2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.inIntrospectionScope(it)) continue;
                    basicMateDatabase = basicMateDatabase2;
                    break block3;
                }
                basicMateDatabase = null;
            }
            firstDatabase = basicMateDatabase;
        }
        if (firstDatabase != null) {
            JBIterable jBIterable = JBIterable.of((Object)firstDatabase);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            this.introspectNamespacesInTran(tran, jBIterable);
        }
    }

    protected final <T extends BasicDatabase> void introspectNamespacesInTran(@NotNull DBTransaction tran, @NotNull JBIterable<T> databases) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(databases, (String)"databases");
        for (BasicDatabase database : databases) {
            Intrinsics.checkNotNull((Object)database);
            this.retrieveSchemasOfDatabase(tran, database);
        }
    }

    protected final void listAndApplyDatabasesIfNotYet(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        if (IntrospectionTaskHelperFun.isEmpty(iterable) || !this.databasesAreListed) {
            this.trace("Listing databases\u2026");
            DatabaseLister<?, ?> databaseLister = this.createDatabaseLister();
            databaseLister.listAndApplyDatabases$intellij_database_dialects_base(tran);
            Iterable<? extends BasicMateDatabase> iterable2 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
            Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getNamespaces(...)");
            this.databasesAreListed = IntrospectionTaskHelperFun.isNotEmpty(iterable2);
        }
    }

    @Override
    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        BasicDatabase database = this.findDatabase(databaseName);
        if (database == null && !this.databasesAreListed) {
            this.listAndApplyDatabasesIfNotYet(transaction);
            database = this.findDatabase(databaseName);
        }
        return database;
    }

    @Override
    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return Intrinsics.areEqual((Object)databaseName, (Object)"@") ? (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase() : (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    @Override
    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default(this, "Cannot find database with name '" + task.getDatabaseName() + "'.", null, 2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        this.introspectAutoInTran(transaction, SetsKt.setOf((Object)database));
    }

    @Override
    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default(this, "Cannot find database with name '" + task.getDatabaseName() + "'.", null, 2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        NamingFamily<? extends BasicSchema> namingFamily = database.getSchemas();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getSchemas(...)");
        List schemas = ModelFun.elementsByNames(namingFamily, task.getSchemaNames());
        this.introspectAutoInTran(transaction, schemas);
    }

    @Override
    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull DatabaseFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default(this, "Cannot find database with name '" + task.getDatabaseName() + "'.", null, 2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(transaction, (BasicModMateDatabase)database);
        databaseRetriever.retrieveServerAndDatabaseObjects();
    }

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        return BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE();
    }

    @NotNull
    protected abstract DatabaseLister<?, ?> createDatabaseLister();

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        if (!(databases.length == 0)) {
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                String dbs2 = ArraysKt.joinToString$default((Object[])databases, (CharSequence)"", null, null, (int)0, null, (Function1)introspectDatabaseSchemas.1.dbs.1.INSTANCE, (int)30, null);
                IntrospectionQueryContext.access$trace(introspectionQueryContext, "Introspecting database schemas brief info for the following databases: " + dbs2);
            }
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseMultiDatabaseIntrospector.introspectDatabaseSchemas$lambda$8(databases, this, arg_0)));
        } else {
            BasicModMateDatabase basicModMateDatabase = (BasicModMateDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
            if (basicModMateDatabase == null) {
                return;
            }
            BasicModMateDatabase currentDatabase = basicModMateDatabase;
            this.trace("Introspecting database schemas for the current database " + currentDatabase.getDisplayName());
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseMultiDatabaseIntrospector.introspectDatabaseSchemas$lambda$9(this, currentDatabase, arg_0)));
        }
    }

    @Override
    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        boolean bl = this.getModel().contains(database);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Alien database.";
            throw new AssertionError((Object)string);
        }
        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(transaction, (BasicModMateDatabase)database);
        databaseRetriever.retrieveSchemas();
    }

    @Override
    protected void introspectAutomatically(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        JBIterable jBIterable;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                this.introspectPreDatabaseObjects(tran);
                if (namespaces2 == null) break block7;
                Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
                if (!IntrospectionTaskHelperFun.isEmpty(iterable)) break block8;
            }
            this.listAndApplyDatabasesIfNotYet(tran);
        }
        List databasesToIntrospect = CollectionsKt.toList(this.getDatabasesToIntrospect(tran, namespaces2));
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$trace = false;
        if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv;
            boolean bl = false;
            IntrospectionQueryContext.access$trace(introspectionQueryContext, "IntrospectAutoInTran: getting the following " + databasesToIntrospect.size() + " databases:" + CollectionsKt.joinToString$default((Iterable)databasesToIntrospect, null, null, null, (int)0, null, (Function1)introspectAutomatically.1.1.INSTANCE, (int)31, null));
        }
        this.introspectDatabases(tran, databasesToIntrospect);
        if (namespaces2 != null && !namespaces2.isEmpty()) {
            $i$f$trace = JBIterable.from((Iterable)namespaces2).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$14(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$13(this, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)$i$f$trace);
            jBIterable = $i$f$trace;
        } else {
            $i$f$trace = JBIterable.from((Iterable)databasesToIntrospect).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$16(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$15(this, arg_0), arg_0)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$17((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

                public final Boolean invoke(BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)this.receiver).inIntrospectionScope(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)$i$f$trace);
            jBIterable = $i$f$trace;
        }
        JBIterable schemasToIntrospect2 = jBIterable;
        List list = schemasToIntrospect2.filterMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$19(BaseMultiDatabaseIntrospector::introspectAutomatically$lambda$18, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List schemasWillBeIntrospected = list;
        this.introspectSchemas(tran, schemasWillBeIntrospected);
        for (BasicModMateDatabase d : databasesToIntrospect) {
            this.postProcessDatabase(tran, d);
        }
    }

    private final BasicSchema adjustSchemaInstance(BasicSchema $this$adjustSchemaInstance) {
        if ($this$adjustSchemaInstance instanceof BasicModSchema && ((BasicModSchema)$this$adjustSchemaInstance).isDropped()) {
            Object e;
            BasicDatabase basicDatabase = ((BasicModSchema)$this$adjustSchemaInstance).getDatabase();
            if (basicDatabase == null || (basicDatabase = this.adjustDatabaseInstance(basicDatabase)) == null) {
                return null;
            }
            BasicDatabase database = basicDatabase;
            BasicSchema replacement = null;
            Family<? extends BasicElement> schemas = database.familyOf(((BasicModSchema)$this$adjustSchemaInstance).getKind());
            if ($this$adjustSchemaInstance instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)((Object)$this$adjustSchemaInstance)).getObjectId() != Long.MIN_VALUE && schemas instanceof IdentifyingFamily) {
                e = ((IdentifyingFamily)schemas).getByObjectId(((BasicIdentifiedElement)((Object)$this$adjustSchemaInstance)).getObjectId());
                BasicSchema basicSchema = replacement = e instanceof BasicSchema ? (BasicSchema)e : null;
            }
            if (replacement == null && schemas instanceof NamingFamily) {
                e = ((NamingFamily)schemas).get(((BasicModSchema)$this$adjustSchemaInstance).getName());
                replacement = e instanceof BasicSchema ? (BasicSchema)e : null;
            }
            return replacement;
        }
        return $this$adjustSchemaInstance;
    }

    private final BasicDatabase adjustDatabaseInstance(BasicDatabase $this$adjustDatabaseInstance) {
        if ($this$adjustDatabaseInstance instanceof BasicModDatabase && ((BasicModDatabase)$this$adjustDatabaseInstance).isDropped()) {
            Object e;
            BasicDatabase replacement = null;
            ModFamily databases = (ModFamily)((BasicModMultiDatabaseRoot)this.getRoot()).familyOf(((BasicModDatabase)$this$adjustDatabaseInstance).getKind());
            if ($this$adjustDatabaseInstance instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)((Object)$this$adjustDatabaseInstance)).getObjectId() != Long.MIN_VALUE && databases instanceof IdentifyingFamily) {
                e = ((IdentifyingFamily)((Object)databases)).getByObjectId(((BasicIdentifiedElement)((Object)$this$adjustDatabaseInstance)).getObjectId());
                BasicDatabase basicDatabase = replacement = e instanceof BasicDatabase ? (BasicDatabase)e : null;
            }
            if (replacement == null && databases instanceof NamingFamily) {
                e = ((NamingFamily)((Object)databases)).get(((BasicModDatabase)$this$adjustDatabaseInstance).getName());
                replacement = e instanceof BasicDatabase ? (BasicDatabase)e : null;
            }
            return replacement;
        }
        return $this$adjustDatabaseInstance;
    }

    protected void introspectPreDatabaseObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
    }

    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (namespaces2 != null && !namespaces2.isEmpty()) {
            JBIterable jBIterable = JBIterable.from((Iterable)namespaces2).filterMap(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$21(BaseMultiDatabaseIntrospector::getDatabasesToIntrospect$lambda$20, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return (Iterable)jBIterable;
        }
        this.introspectNamespacesInTran(tran);
        JBIterable jBIterable = UtilKt.asJBIterable(((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces()).filter(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$22((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

            public final Boolean invoke(BasicNamespace p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((BaseMultiDatabaseIntrospector)this.receiver).inIntrospectionScope(p0);
            }
        }, arg_0)).map(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$24(BaseMultiDatabaseIntrospector::getDatabasesToIntrospect$lambda$23, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return (Iterable)jBIterable;
    }

    private final List<BasicSchema> getSchemasToIntrospect(BasicModMateDatabase database) {
        Iterable<? extends BasicMateNamespace> iterable = database.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        return CollectionsKt.toList(iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void introspectDatabases(DBTransaction tran, Collection<? extends BasicDatabase> databasesToIntrospect) {
        void this_$iv;
        CharSequence sectionMessage = CollectionFun.dumpToLongCharSequence(databasesToIntrospect, "database", BaseMultiDatabaseIntrospector::introspectDatabases$lambda$25);
        BaseIntrospector baseIntrospector = this;
        String name$iv = "Introspect:Databases";
        boolean $i$f$doSection = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv, sectionMessage) : null;
        try {
            boolean bl = false;
            for (BasicDatabase basicDatabase : databasesToIntrospect) {
                this.doSectionAndHandleErrors("Introspect:Database", "Introspect database " + basicDatabase.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(basicDatabase, this, tran){
                    final /* synthetic */ BasicDatabase $database;
                    final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                    final /* synthetic */ DBTransaction $tran;
                    {
                        this.$database = $database;
                        this.this$0 = $receiver;
                        this.$tran = $tran;
                    }

                    public final void invoke() {
                        BasicDatabase basicDatabase = this.$database;
                        Intrinsics.checkNotNull((Object)basicDatabase, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
                        BasicModMateDatabase db = (BasicModMateDatabase)basicDatabase;
                        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.this$0.createDatabaseRetriever(this.$tran, db);
                        databaseRetriever.process();
                    }
                }));
            }
        }
        finally {
            this_$iv$iv = this_$iv;
            boolean $i$f$logSectionEnd = false;
            if (ref$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv, null, 2, null);
                }
            }
        }
    }

    private final void introspectSchemas(DBTransaction tran, Collection<? extends BasicSchema> schemasToIntrospect2) {
        ArrayList retrievers = new ArrayList(schemasToIntrospect2.size());
        for (BasicSchema basicSchema : schemasToIntrospect2) {
            BasicDatabase basicDatabase = basicSchema.getDatabase();
            this.doSectionAndHandleErrors("InitializeSchemaRetriever", "Initialize retriever for database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + basicSchema.getName(), (Function0<Unit>)((Function0)() -> BaseMultiDatabaseIntrospector.introspectSchemas$lambda$27(basicSchema, this, tran, retrievers)));
        }
        Iterator iterator = retrievers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<BasicSchema> iterator2 = iterator;
        while (iterator2.hasNext()) {
            BasicSchema basicSchema = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)basicSchema, (String)"next(...)");
            BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever = (BaseNativeIntrospector.AbstractSchemaRetriever)((Object)basicSchema);
            BasicDatabase basicDatabase = abstractSchemaRetriever.getSchema().getDatabase();
            this.doSectionAndHandleErrors("Introspect:Schema", "Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + abstractSchemaRetriever.getSchema().getName() + " (names)", (Function0<Unit>)((Function0)() -> BaseMultiDatabaseIntrospector.introspectSchemas$lambda$28(abstractSchemaRetriever)));
        }
        Iterator iterator3 = retrievers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            BasicSchema basicSchema = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)basicSchema, (String)"next(...)");
            BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever = (BaseNativeIntrospector.AbstractSchemaRetriever)((Object)basicSchema);
            BasicDatabase basicDatabase = abstractSchemaRetriever.getSchema().getDatabase();
            this.doSectionAndHandleErrors("Introspect:Schema", "Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + abstractSchemaRetriever.getSchema().getName() + " (details)", (Function0<Unit>)((Function0)() -> BaseMultiDatabaseIntrospector.introspectSchemas$lambda$29(abstractSchemaRetriever)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void introspectFragments(DBTransaction tran, Collection<? extends BasicMajorObject> fragmentToIntrospect) {
        void this_$iv;
        void $this$groupByTo$iv$iv222;
        void $this$groupBy$iv;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)fragmentToIntrospect), BaseMultiDatabaseIntrospector::introspectFragments$lambda$30);
        boolean $i$f$groupBy22 = false;
        void var6_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv222) {
            Object object;
            BasicSchema key$iv$iv;
            BasicMajorObject it = (BasicMajorObject)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getSchema());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map schemaFragments = destination$iv$iv;
        Iterable $i$f$groupBy22 = schemaFragments.values();
        int $this$groupByTo$iv$iv222 = 0;
        for (Object $i$f$groupByTo2 : $i$f$groupBy22) {
            void it;
            List list = (List)$i$f$groupByTo2;
            int n = $this$groupByTo$iv$iv222;
            boolean bl = false;
            int n2 = it.size();
            $this$groupByTo$iv$iv222 = n + n2;
        }
        int fragmentCount = $this$groupByTo$iv$iv222;
        String sectionMessage = "Introspect " + fragmentCount + " fragments in " + CollectionFun.dumpToLongCharSequence$default(schemaFragments.keySet(), "schema", null, 2, null);
        BaseIntrospector $this$groupByTo$iv$iv222 = this;
        String name$iv = "IntrospectFragment";
        boolean $i$f$doSection = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv, sectionMessage) : null;
        try {
            boolean bl = false;
            for (Map.Entry entry : schemaFragments.entrySet()) {
                BasicSchema schema = (BasicSchema)entry.getKey();
                List fragments2 = (List)entry.getValue();
                BasicDatabase basicDatabase = schema.getDatabase();
                this.doSectionAndHandleErrors("Introspect:Fragment", "Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + schema.getName() + " (" + fragments2.size() + " fragments)", (Function0<Unit>)((Function0)new Function0<Unit>(schema, this, tran, (List<? extends BasicMajorObject>)fragments2){
                    final /* synthetic */ BasicSchema $schema;
                    final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                    final /* synthetic */ DBTransaction $tran;
                    final /* synthetic */ List<BasicMajorObject> $fragments;
                    {
                        this.$schema = $schema;
                        this.this$0 = $receiver;
                        this.$tran = $tran;
                        this.$fragments = $fragments;
                    }

                    public final void invoke() {
                        BasicSchema basicSchema = this.$schema;
                        Intrinsics.checkNotNull((Object)basicSchema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
                        BasicModSchema s = (BasicModSchema)basicSchema;
                        BaseNativeIntrospector.AbstractSchemaRetriever<BasicModSchema> retriever = this.this$0.createSchemaRetriever(this.$tran, s);
                        retriever.setMode(IntrospectionMode.FRAGMENT);
                        retriever.retrieveSpecificFragments((Collection<BasicMajorObject>)this.$fragments);
                    }
                }));
            }
        }
        finally {
            this_$iv$iv = this_$iv;
            boolean $i$f$logSectionEnd = false;
            if (ref$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv, null, 2, null);
                }
            }
        }
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractNativeRetriever<D> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        return new BaseNativeIntrospector.AbstractNativeRetriever<D>(this, transaction, database){};
    }

    @Override
    @NotNull
    protected abstract BaseDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @Override
    @NotNull
    protected abstract BaseNativeIntrospector.AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(database, (String)"database");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        JBIterable jBIterable = JBIterable.from(elements);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        Iterable $this$groupBy$iv = (Iterable)jBIterable;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BasicElement it = (BasicElement)element$iv$iv;
            boolean bl = false;
            BasicDatabase key$iv$iv = it.getDatabase();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groups = destination$iv$iv;
        for (Map.Entry entry : groups.entrySet()) {
            BasicDatabase db = (BasicDatabase)entry.getKey();
            List dbElements = (List)entry.getValue();
            if (db == null) continue;
            if (!this.getModel().contains(db)) {
                throw new IllegalArgumentException("The database " + db + " is from another model");
            }
            BasicModMateDatabase database = (BasicModMateDatabase)db;
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseMultiDatabaseIntrospector.introspectNativeDefinitions$lambda$35(this, database, dbElements, withNestedElements, result2, arg_0)));
        }
    }

    private static final boolean logModelInfo$lambda$0(BasicMateDatabase it) {
        Iterable<? extends BasicMateNamespace> iterable = it.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        return IntrospectionTaskHelperFun.isNotEmpty(iterable);
    }

    private static final boolean logModelInfo$lambda$1(BasicMateNamespace it) {
        return it.getChildren().isNotEmpty();
    }

    private static final Unit introspectDatabaseSchemas$lambda$8(BasicDatabase[] $databases, BaseMultiDatabaseIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (BasicDatabase database : $databases) {
            this$0.retrieveSchemasOfDatabase(it, database);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectDatabaseSchemas$lambda$9(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase $currentDatabase, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.retrieveSchemasOfDatabase(it, $currentDatabase);
        return Unit.INSTANCE;
    }

    private static final boolean introspectAutomatically$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable introspectAutomatically$lambda$13(BaseMultiDatabaseIntrospector this$0, BasicNamespace ns) {
        JBIterable jBIterable;
        BasicNamespace basicNamespace = ns;
        if (basicNamespace instanceof BasicModMateDatabase) {
            JBIterable jBIterable2 = UtilKt.asJBIterable((Iterable)this$0.getSchemasToIntrospect((BasicModMateDatabase)ns)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomatically$lambda$13$lambda$12((Function1)new Function1<BasicNamespace, Boolean>((Object)this$0){

                public final Boolean invoke(BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)this.receiver).inIntrospectionScope(p0);
                }
            }, arg_0));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        } else if (basicNamespace instanceof BasicModSchema) {
            jBIterable = BaseIntrospectionFunctions.asSingleOrEmptyJBIterable(this$0.adjustSchemaInstance((BasicSchema)ns));
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return (Iterable)jBIterable;
    }

    private static final Iterable introspectAutomatically$lambda$14(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable introspectAutomatically$lambda$15(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.getSchemasToIntrospect(it);
    }

    private static final Iterable introspectAutomatically$lambda$16(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean introspectAutomatically$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModSchema introspectAutomatically$lambda$18(BasicSchema it) {
        return it instanceof BasicModSchema ? (BasicModSchema)it : null;
    }

    private static final BasicModSchema introspectAutomatically$lambda$19(Function1 $tmp0, Object p0) {
        return (BasicModSchema)$tmp0.invoke(p0);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$20(BasicNamespace it) {
        return (BasicModMateDatabase)DasUtil.getParentOfClass(it, BasicDatabase.class, false);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$21(Function1 $tmp0, Object p0) {
        return (BasicModMateDatabase)$tmp0.invoke(p0);
    }

    private static final boolean getDatabasesToIntrospect$lambda$22(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$23(BasicModMateDatabase it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
        return it;
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$24(Function1 $tmp0, Object p0) {
        return (BasicModMateDatabase)$tmp0.invoke(p0);
    }

    private static final CharSequence introspectDatabases$lambda$25(BasicDatabase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit introspectSchemas$lambda$27(BasicSchema $schema, BaseMultiDatabaseIntrospector this$0, DBTransaction $tran, ArrayList $retrievers) {
        Intrinsics.checkNotNull((Object)$schema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
        BasicModSchema s = (BasicModSchema)$schema;
        BaseNativeIntrospector.AbstractSchemaRetriever<BasicModSchema> retriever = this$0.createSchemaRetriever($tran, s);
        $retrievers.add(retriever);
        return Unit.INSTANCE;
    }

    private static final Unit introspectSchemas$lambda$28(BaseNativeIntrospector.AbstractSchemaRetriever $retriever) {
        $retriever.prepareParameters();
        $retriever.processPreliminaryPhase();
        return Unit.INSTANCE;
    }

    private static final Unit introspectSchemas$lambda$29(BaseNativeIntrospector.AbstractSchemaRetriever $retriever) {
        $retriever.processMainPhase();
        return Unit.INSTANCE;
    }

    private static final boolean introspectFragments$lambda$30(BasicMajorObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSchema() != null;
    }

    private static final Unit introspectNativeDefinitions$lambda$35(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase $database, List $dbElements, boolean $withNestedElements, Map $result, DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector.AbstractNativeRetriever<BasicModMateDatabase> retriever = this$0.createNativeRetriever(transaction, (Object)$database);
        retriever.retrieveNativeDefinitions($dbElements, $withNestedElements, $result);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "process", "", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "beforeServerAndDatabaseObjectsRetrieval", "beforeSchemasRetrieval", "intellij.database.dialects.base"})
    protected static abstract class BaseDatabaseRetriever<D extends BasicModMateDatabase>
    extends BaseNativeIntrospector.AbstractDatabaseRetriever<D> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database);
        }

        @Override
        public void process() {
            String isCurrentStr = ((BasicNamespace)this.getDatabase()).isCurrent() ? "(current) " : "";
            String string = ((BasicModMateDatabase)this.getDatabase()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String databaseName = string;
            String introspectionLogMessage = StringFun.centerAndPadAsTitle("INTROSPECTING DATABASE " + databaseName + " " + isCurrentStr, 140, '=');
            Object[] objectArray = new Object[]{databaseName};
            this.this$0.reportIntrospecting(introspectionLogMessage, "introspection.report.database.plain", objectArray);
            this.retrieveSchemas();
            this.retrieveServerAndDatabaseObjects();
        }

        @Override
        public void retrieveSchemas() {
            this.beforeSchemasRetrieval();
        }

        @Override
        public void retrieveServerAndDatabaseObjects() {
            this.beforeServerAndDatabaseObjectsRetrieval();
        }

        protected void beforeServerAndDatabaseObjectsRetrieval() {
        }

        protected void beforeSchemasRetrieval() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseNativeRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "intellij.database.dialects.base"})
    protected static abstract class BaseNativeRetriever<D extends BasicModMateDatabase>
    extends BaseNativeIntrospector.AbstractNativeRetriever<D> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseNativeRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\u0004\b\u0003\u0010\u0001*\b\b\u0004\u0010\u0002*\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00030\u000e2\u0006\u0010\t\u001a\u00020\nH$J\u0016\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0014J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0002J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00028\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0019\u001a\u00028\u0003H$\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u001e\u001a\u00028\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004\u00a2\u0006\u0002\u0010#J#\u0010\u001e\u001a\u00028\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00028\u0004*\u00020&H\u0082\b\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "T", "MD", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;)V", "listAndApplyDatabases", "", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "listAndApplyDatabases$intellij_database_dialects_base", "prepareParameters", "listDatabases", "", "traceDatabases", "dbs", "applyDatabases", "shouldUpdateCurrent", "", "databases", "", "isCurrent", "idx", "", "db", "(ILjava/lang/Object;)Z", "applyDatabase", "Lcom/intellij/database/model/families/ModNamingFamily;", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "renew", "id", "", "name", "", "(Lcom/intellij/database/model/families/ModNamingFamily;JLjava/lang/String;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "asMD", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "(Lcom/intellij/database/model/basic/BasicModNamedElement;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "retrieveExternalDatabases", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseMultiDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,619:1\n361#1:620\n361#1:621\n178#2,5:622\n183#2,3:630\n1872#3,3:627\n*S KotlinDebug\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister\n*L\n356#1:620\n358#1:621\n337#1:622,5\n337#1:630,3\n338#1:627,3\n*E\n"})
    protected abstract class DatabaseLister<T, MD extends BasicModMateDatabase> {
        public final void listAndApplyDatabases$intellij_database_dialects_base(@NotNull DBTransaction tran) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            this.prepareParameters();
            List<T> dbs2 = this.listDatabases(tran);
            this.traceDatabases(dbs2);
            this.applyDatabases(dbs2);
            this.retrieveExternalDatabases(tran);
        }

        protected void prepareParameters() {
        }

        @NotNull
        protected abstract List<T> listDatabases(@NotNull DBTransaction var1);

        protected void traceDatabases(@NotNull List<? extends T> dbs2) {
            Intrinsics.checkNotNullParameter(dbs2, (String)"dbs");
            BaseMultiDatabaseIntrospector.this.trace("Listed " + dbs2.size() + " databases");
        }

        private final void applyDatabases(List<? extends T> dbs2) {
            BaseMultiDatabaseIntrospector.this.inModel(arg_0 -> DatabaseLister.applyDatabases$lambda$2(this, dbs2, arg_0));
        }

        protected boolean shouldUpdateCurrent(@NotNull Iterable<?> databases) {
            Intrinsics.checkNotNullParameter(databases, (String)"databases");
            return true;
        }

        protected boolean isCurrent(int idx, T db) {
            return idx == 0;
        }

        @NotNull
        protected abstract MD applyDatabase(@NotNull ModNamingFamily<?> var1, T var2);

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final MD renew(@NotNull ModNamingFamily<?> databases, long id, @Nullable String name2) {
            void $this$asMD$iv;
            Intrinsics.checkNotNullParameter(databases, (String)"databases");
            DatabaseLister databaseLister = this;
            Object e = ((ModNamingIdentifyingFamily)databases).renew(id, name2);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            Object e2 = e;
            boolean $i$f$asMD = false;
            return (MD)((BasicModMateDatabase)$this$asMD$iv);
        }

        @NotNull
        protected final MD renew(@NotNull ModNamingFamily<?> databases, @Nullable String name2) {
            Intrinsics.checkNotNullParameter(databases, (String)"databases");
            DatabaseLister databaseLister = this;
            String string = name2;
            if (string == null) {
                string = "";
            }
            Object obj2 = databases.createOrGet(string);
            Intrinsics.checkNotNullExpressionValue(obj2, (String)"createOrGet(...)");
            Object $this$asMD$iv = obj2;
            boolean $i$f$asMD = false;
            return (MD)((BasicModMateDatabase)$this$asMD$iv);
        }

        private final MD asMD(BasicModNamedElement $this$asMD) {
            boolean $i$f$asMD = false;
            Intrinsics.checkNotNull((Object)$this$asMD, (String)"null cannot be cast to non-null type MD of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector.DatabaseLister");
            return (MD)((BasicModMateDatabase)$this$asMD);
        }

        protected void retrieveExternalDatabases(@NotNull DBTransaction tran) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit applyDatabases$lambda$2(DatabaseLister this$0, List $dbs, BasicModMultiDatabaseRoot root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            NamingFamily namingFamily = root.getDatabases();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getDatabases(...)");
            NamingFamily databases = namingFamily;
            boolean updateCurrent = this$0.shouldUpdateCurrent(databases);
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)databases);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = $dbs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void db;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int idx = n;
                boolean bl2 = false;
                Object database = this$0.applyDatabase(it, db);
                boolean current = this$0.isCurrent(idx, db);
                if (!updateCurrent) continue;
                ((BasicModNamespace)database).setCurrent(current);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }
}

