/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.OracleDbmsOutputHandler;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001>B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\bH\u0002J\"\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u001e\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J4\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001b0+H\u0002J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\bH\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020\bH\u0002J \u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u00103\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\b05H\u0002J\u0016\u00106\u001a\u00020\b2\f\u00107\u001a\b\u0012\u0004\u0012\u00020#05H\u0002J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u001bH\u0014J\b\u0010=\u001a\u00020\u001bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "paths", "", "", "tags", "coveragePath", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getTags", "()Ljava/util/List;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "p", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getP", "()Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "start", "", "genUuid", "hookReporterTermination", "tests", "Lcom/intellij/database/util/AsyncTask;", "reporter", "attachReporter", "testsReporter", "Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "coverageReporter", "fetchReporter", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "fetchSize", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "reportOutput", "input", "expected", "Lkotlin/text/Regex;", "preprocessOutput", "startTests", "testReporter", "allSchemas", "", "runScript", "reporters", "getProcessInput", "Ljava/io/OutputStream;", "detachIsDefault", "", "detachProcessImpl", "destroyProcessImpl", "Reporter", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nUtPlSqlHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtPlSqlHandler.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class UtPlSqlHandler
extends ProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final List<String> tags;
    @Nullable
    private final String coveragePath;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final EmptyProgressIndicator p;
    @NotNull
    private final Regex expected;

    public UtPlSqlHandler(@NotNull Project project, @NotNull LocalDataSource ds, @NotNull List<String> paths, @NotNull List<String> tags, @Nullable String coveragePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.project = project;
        this.ds = ds;
        this.paths = paths;
        this.tags = tags;
        this.coveragePath = coveragePath;
        Logger logger2 = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
        this.p = new EmptyProgressIndicator();
        this.expected = new Regex("Actual: (.*?)(?: \\(.*\\))? was expected to equal: (.*?)(?: \\(.*\\))?");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final EmptyProgressIndicator getP() {
        return this.p;
    }

    public final void start() {
        Reporter reporter;
        Reporter testReporter = new Reporter("tests_reporter", "ut_teamcity_reporter", this.genUuid());
        String string = this.coveragePath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            reporter = new Reporter("coverage_reporter", "ut_coveralls_reporter", this.genUuid());
        } else {
            reporter = null;
        }
        Reporter coverageReporter = reporter;
        AsyncTask<Unit> tests = this.startTests(testReporter, coverageReporter);
        AsyncTask<?> reporter2 = this.attachReporter(testReporter, coverageReporter);
        this.startNotify();
        this.notifyTextAvailable(ServiceMessageBuilder.testsStarted().toString(), ProcessOutputTypes.STDOUT);
        this.hookReporterTermination(tests, reporter2);
    }

    private final String genUuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private final void hookReporterTermination(AsyncTask<Unit> tests, AsyncTask<?> reporter) {
        tests.whenComplete(null, (arg_0, arg_1) -> UtPlSqlHandler.hookReporterTermination$lambda$2((arg_0, arg_1) -> UtPlSqlHandler.hookReporterTermination$lambda$1(reporter, arg_0, arg_1), arg_0, arg_1));
        reporter.whenComplete(null, (arg_0, arg_1) -> UtPlSqlHandler.hookReporterTermination$lambda$3(new Function2(this){
            final /* synthetic */ UtPlSqlHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(Object object, Throwable e) {
                if (!this.this$0.isProcessTerminated()) {
                    if (e != null) {
                        if (!AsyncUtil.isCancellation(e)) {
                            String string = e.getMessage();
                            if (string == null) {
                                string = "";
                            }
                            this.this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                        }
                        UtPlSqlHandler.access$notifyProcessTerminated(this.this$0, 1);
                    } else {
                        UtPlSqlHandler.access$notifyProcessTerminated(this.this$0, 0);
                    }
                }
            }
        }, arg_0, arg_1));
    }

    private final AsyncTask<?> attachReporter(Reporter testsReporter, Reporter coverageReporter) {
        return AsyncTask.Companion.currentFrame().computeAsync(UtPlSqlHandler::attachReporter$lambda$4, () -> UtPlSqlHandler.attachReporter$lambda$9(this, testsReporter, coverageReporter));
    }

    private final void fetchReporter(DatabaseConnection connection2, Reporter reporter, int fetchSize, Function1<? super RemoteResultSet, Unit> consumer) {
        SmartStatements.Companion.poweredBy(connection2).call(new Configuration(false, null, null, fetchSize, null, null, 55, null)).noisy().execute(new StatementParameters().parameter(new CallableStatementData.SimpleOutParameter(1, -10, 0, null, null, 28, null)).asCallData(StringsKt.trimIndent((String)("\n        declare\n          l_reporter " + reporter.getType() + " := " + reporter.getType() + "();\n        begin\n          l_reporter.set_reporter_id('" + reporter.getUuid() + "');\n          ? := l_reporter.get_lines_cursor();\n        end;"))), (ExecutionMode)StandardExecutionMode.GENERIC, StandardResultsProcessors.firstResult((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)arg_0 -> UtPlSqlHandler.fetchReporter$lambda$10(this, consumer, arg_0))));
    }

    private final void reportOutput(String input) {
        block0: {
            String string = this.preprocessOutput(input);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.notifyTextAvailable(it + "\n", ProcessOutputTypes.STDOUT);
        }
    }

    private final String preprocessOutput(String input) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        new ServiceMessagesParser().parse(input, new ServiceMessageParserCallback(this, (Ref.ObjectRef<String>)result2){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void parseException(ParseException parseException, String text) {
                Intrinsics.checkNotNullParameter((Object)parseException, (String)"parseException");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                UtPlSqlHandler.access$getLOG$p(this.this$0).warn((Throwable)parseException);
                this.$result.element = text;
            }

            /*
             * WARNING - void declaration
             */
            public void serviceMessage(ServiceMessage message) {
                Object object;
                String it;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Map map2 = message.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAttributes(...)");
                Map attrs = MapsKt.toMutableMap((Map)map2);
                String string = (String)attrs.get("name");
                if (string != null && (string = this.fixName(string)) != null) {
                    it = string;
                    boolean bl = false;
                    attrs.put("name", it);
                }
                Ref.ObjectRef<String> objectRef = this.$result;
                ServiceMessage serviceMessage = message;
                if (serviceMessage instanceof TestStarted) {
                    String testName = ((TestStarted)message).getTestName();
                    if (((TestStarted)message).getLocationHint() == null) {
                        String string2;
                        Map map3 = attrs;
                        it = "locationHint";
                        String string3 = testName;
                        if (string3 != null) {
                            void it2;
                            String string4 = string3;
                            Ref.ObjectRef<String> objectRef2 = objectRef;
                            boolean bl = false;
                            string2 = "db://" + (String)it2;
                            objectRef = objectRef2;
                        } else {
                            string2 = null;
                        }
                        String bl = string2;
                        map3.put(it, bl);
                    }
                    object = ServiceMessage.asString((String)((TestStarted)message).getMessageName(), (Map)attrs);
                } else if (serviceMessage instanceof TestStdErr) {
                    void it3;
                    String string5 = ((TestStdErr)message).getStdErr();
                    Ref.ObjectRef<String> objectRef3 = objectRef;
                    boolean bl = false;
                    boolean bl2 = it3 == null || StringsKt.startsWith$default((String)it3, (String)"Test exception:", (boolean)false, (int)2, null);
                    objectRef = objectRef3;
                    object = bl2 ? null : ServiceMessage.asString((String)((TestStdErr)message).getMessageName(), (Map)attrs);
                } else if (serviceMessage instanceof TestFailed) {
                    if (((TestFailed)message).getFailureMessage() == null) {
                        String string6 = (String)attrs.remove("details");
                        if (string6 != null) {
                            MatchResult matchResult;
                            void details;
                            String string7 = string6;
                            UtPlSqlHandler utPlSqlHandler = this.this$0;
                            String bl = string7;
                            Ref.ObjectRef<String> objectRef4 = objectRef;
                            boolean bl3 = false;
                            attrs.put("message", details);
                            MatchResult matchResult2 = UtPlSqlHandler.access$getExpected$p(utPlSqlHandler).matchEntire((CharSequence)details);
                            if (matchResult2 != null) {
                                MatchResult matchResult3;
                                MatchResult $this$serviceMessage_u24lambda_u244_u24lambda_u243 = matchResult3 = matchResult2;
                                boolean bl4 = false;
                                Map map4 = attrs;
                                String string8 = "actual";
                                MatchGroup matchGroup = $this$serviceMessage_u24lambda_u244_u24lambda_u243.getGroups().get(1);
                                String string9 = matchGroup != null ? matchGroup.getValue() : null;
                                map4.put(string8, string9);
                                map4 = attrs;
                                string8 = "expected";
                                MatchGroup matchGroup2 = $this$serviceMessage_u24lambda_u244_u24lambda_u243.getGroups().get(2);
                                string9 = matchGroup2 != null ? matchGroup2.getValue() : null;
                                map4.put(string8, string9);
                                attrs.put("type", "comparisonFailure");
                                matchResult = matchResult3;
                            } else {
                                matchResult = null;
                            }
                            v11 = matchResult;
                            objectRef = objectRef4;
                        } else {
                            v11 = null;
                        }
                    }
                    object = ServiceMessage.asString((String)((TestFailed)message).getMessageName(), (Map)attrs);
                } else {
                    object = serviceMessage instanceof TestIgnored ? ServiceMessage.asString((String)((TestIgnored)message).getMessageName(), (Map)attrs) + "\n" + ServiceMessage.asString((String)"testFinished", (Map)attrs) : ServiceMessage.asString((String)message.getMessageName(), (Map)attrs);
                }
                objectRef.element = object;
            }

            private final String fixName(String $this$fixName) {
                String string = $this$fixName;
                return string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null;
            }

            public void regularText(String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$result.element = text;
            }
        });
        return (String)result2.element;
    }

    private final AsyncTask<Unit> startTests(Reporter testReporter, Reporter coverageReporter) {
        return DatabaseSessionManager.getFacade(this.project, this.ds, null, null, false, null, DGDepartment.TEST_RUNNER).runAsync(arg_0 -> UtPlSqlHandler.startTests$lambda$13(this, testReporter, coverageReporter, arg_0));
    }

    private final Iterable<String> allSchemas() {
        TreePattern sc = this.ds.getIntrospectionScope();
        boolean bl = false;
        JBTreeTraverser jBTreeTraverser = ((JBTreeTraverser)((JBTreeTraverser)this.ds.getModel().traverser().expand(arg_0 -> UtPlSqlHandler.allSchemas$lambda$20$lambda$15(UtPlSqlHandler::allSchemas$lambda$20$lambda$14, arg_0))).filter(arg_0 -> UtPlSqlHandler.allSchemas$lambda$20$lambda$17(arg_0 -> UtPlSqlHandler.allSchemas$lambda$20$lambda$16(sc, arg_0), arg_0))).map(arg_0 -> UtPlSqlHandler.allSchemas$lambda$20$lambda$19(UtPlSqlHandler::allSchemas$lambda$20$lambda$18, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"let(...)");
        return (Iterable)jBTreeTraverser;
    }

    private final String runScript(Iterable<Reporter> reporters) {
        return "\n    declare" + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$22, (int)30, null) + "\n    begin " + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$24, (int)30, null) + "\n      ut_runner.run(\n        ut_varchar2_list (" + CollectionsKt.joinToString$default((Iterable)this.paths, null, null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$25, (int)31, null) + "),\n        ut_reporters(" + CollectionsKt.joinToString$default(reporters, null, null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$26, (int)31, null) + "),\n        false,\n        ut_varchar2_list(" + CollectionsKt.joinToString$default(this.allSchemas(), null, null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$27, (int)31, null) + "),\n        a_tags => " + (this.tags.isEmpty() ? "null" : ScriptGeneratorHelperKt.getSqlString(CollectionsKt.joinToString$default((Iterable)this.tags, (CharSequence)",", null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$28, (int)30, null))) + "\n      );\n    end;";
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public boolean detachIsDefault() {
        return false;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
    }

    protected void destroyProcessImpl() {
        this.p.cancel();
    }

    private static final Unit hookReporterTermination$lambda$1(AsyncTask $reporter, Unit unit, Throwable e) {
        if (e != null) {
            $reporter.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final void hookReporterTermination$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void hookReporterTermination$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attachReporter$lambda$4(Runnable it) {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(it, 500L, TimeUnit.MILLISECONDS);
    }

    private static final Unit attachReporter$lambda$9$lambda$8$lambda$5(UtPlSqlHandler this$0, RemoteResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        String string = rs.getString(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this$0.reportOutput(string);
        return Unit.INSTANCE;
    }

    private static final Unit attachReporter$lambda$9$lambda$8$lambda$7$lambda$6(OutputStreamWriter $writer, RemoteResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        $writer.write(rs.getString(1));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit attachReporter$lambda$9$lambda$8(UtPlSqlHandler this$0, Reporter $testsReporter, Reporter $coverageReporter, InterruptibleDatabaseConnection connection2) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            try {
                this$0.fetchReporter(connection2, $testsReporter, 1, (Function1<? super RemoteResultSet, Unit>)((Function1)arg_0 -> UtPlSqlHandler.attachReporter$lambda$9$lambda$8$lambda$5(this$0, arg_0)));
                if ($coverageReporter == null) break block8;
                String string = this$0.coveragePath;
                Intrinsics.checkNotNull((Object)string);
                Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(string), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    OutputStreamWriter writer = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    this$0.fetchReporter(connection2, $coverageReporter, 10000, (Function1<? super RemoteResultSet, Unit>)((Function1)arg_0 -> UtPlSqlHandler.attachReporter$lambda$9$lambda$8$lambda$7$lambda$6(writer, arg_0)));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable th) {
                this$0.LOG.warn(th);
                String string = th.getMessage();
                if (string == null) {
                    string = th.toString();
                }
                this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
            }
        }
        return Unit.INSTANCE;
    }

    private static final AsyncTask attachReporter$lambda$9(UtPlSqlHandler this$0, Reporter $testsReporter, Reporter $coverageReporter) {
        return DatabaseSessionManager.getFacade(this$0.project, this$0.ds, null, null, false, null, DGDepartment.TEST_RUNNER).runAsync(arg_0 -> UtPlSqlHandler.attachReporter$lambda$9$lambda$8(this$0, $testsReporter, $coverageReporter, arg_0));
    }

    private static final void fetchReporter$lambda$10(UtPlSqlHandler this$0, Function1 $consumer, RemoteResultSet it) {
        this$0.p.checkCanceled();
        Intrinsics.checkNotNull((Object)it);
        $consumer.invoke((Object)it);
    }

    private static final Unit startTests$lambda$13$lambda$12(ResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit startTests$lambda$13(UtPlSqlHandler this$0, Reporter $testReporter, Reporter $coverageReporter, InterruptibleDatabaseConnection connection2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        new OracleDbmsOutputHandler().enable(connection2, 10000000);
        Object[] objectArray = new Reporter[]{$testReporter, $coverageReporter};
        SmartStatements.Companion.poweredBy(connection2).simple().noisy().execute(this$0.runScript(CollectionsKt.listOfNotNull((Object[])objectArray)), UtPlSqlHandler::startTests$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final boolean allSchemas$lambda$20$lambda$14(DasObject it) {
        return Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.ROOT);
    }

    private static final boolean allSchemas$lambda$20$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean allSchemas$lambda$20$lambda$16(TreePattern $sc, DasObject it) {
        return Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.SCHEMA) && DataSourceSchemaMapping.isIntrospected($sc, it);
    }

    private static final boolean allSchemas$lambda$20$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String allSchemas$lambda$20$lambda$18(DasObject it) {
        return it.getName();
    }

    private static final String allSchemas$lambda$20$lambda$19(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CharSequence runScript$lambda$22(Reporter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Reporter $this$runScript_u24lambda_u2422_u24lambda_u2421 = it;
        boolean bl = false;
        return "\n      " + $this$runScript_u24lambda_u2422_u24lambda_u2421.getName() + " " + $this$runScript_u24lambda_u2422_u24lambda_u2421.getType() + " := " + $this$runScript_u24lambda_u2422_u24lambda_u2421.getType() + "();";
    }

    private static final CharSequence runScript$lambda$24(Reporter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Reporter $this$runScript_u24lambda_u2424_u24lambda_u2423 = it;
        boolean bl = false;
        return "\n      " + $this$runScript_u24lambda_u2424_u24lambda_u2423.getName() + ".set_reporter_id('" + $this$runScript_u24lambda_u2424_u24lambda_u2423.getUuid() + "');\n      " + $this$runScript_u24lambda_u2424_u24lambda_u2423.getName() + ".output_buffer.init();";
    }

    private static final CharSequence runScript$lambda$25(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ScriptGeneratorHelperKt.getSqlString(it);
    }

    private static final CharSequence runScript$lambda$26(Reporter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence runScript$lambda$27(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ScriptGeneratorHelperKt.getSqlString(it);
    }

    private static final CharSequence runScript$lambda$28(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    public static final /* synthetic */ void access$notifyProcessTerminated(UtPlSqlHandler $this, int p0) {
        $this.notifyProcessTerminated(p0);
    }

    public static final /* synthetic */ Logger access$getLOG$p(UtPlSqlHandler $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ Regex access$getExpected$p(UtPlSqlHandler $this) {
        return $this.expected;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "", "name", "", "type", "uuid", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "getUuid", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.oracle.ex"})
    private static final class Reporter {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final String uuid;

        public Reporter(@NotNull String name2, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.name = name2;
            this.type = type;
            this.uuid = uuid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.uuid;
        }

        @NotNull
        public final Reporter copy(@NotNull String name2, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Reporter(name2, type, uuid);
        }

        public static /* synthetic */ Reporter copy$default(Reporter reporter, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporter.name;
            }
            if ((n & 2) != 0) {
                string2 = reporter.type;
            }
            if ((n & 4) != 0) {
                string3 = reporter.uuid;
            }
            return reporter.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Reporter(name=" + this.name + ", type=" + this.type + ", uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + this.uuid.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reporter)) {
                return false;
            }
            Reporter reporter = (Reporter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)reporter.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)reporter.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uuid, (Object)reporter.uuid);
        }
    }
}

