/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extensions.Clipboard;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.Files;
import com.intellij.database.extensions.SchemaGeneratorBindings;
import com.intellij.database.extensions.ScriptLogger;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SchemaScripts {
    private static final Logger LOG = Logger.getInstance(SchemaScripts.class);

    private SchemaScripts() {
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<Path> getScriptFiles(@NotNull PluginId pluginId, @NotNull String dirName) {
        List<Path> list;
        Stream<Path> stream;
        block14: {
            Path dir;
            if (pluginId == null) {
                SchemaScripts.$$$reportNull$$$0(0);
            }
            if (dirName == null) {
                SchemaScripts.$$$reportNull$$$0(1);
            }
            if ((dir = SchemaScripts.getScriptsDirectory(pluginId, dirName)) == null) {
                List<Path> list2 = Collections.emptyList();
                if (list2 == null) {
                    SchemaScripts.$$$reportNull$$$0(2);
                }
                return list2;
            }
            stream = java.nio.file.Files.list(dir);
            list = stream.filter(ExtensionsRootType.regularFileFilter()).collect(Collectors.toList());
            if (stream == null) break block14;
            stream.close();
        }
        List<Path> list3 = list;
        if (list3 == null) {
            SchemaScripts.$$$reportNull$$$0(3);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    List<Path> list4 = Collections.emptyList();
                    if (list4 == null) {
                        SchemaScripts.$$$reportNull$$$0(4);
                    }
                    return list4;
                }
            }
        }
    }

    @Nullable
    public static Path getScriptsDirectory(@NotNull PluginId pluginId, @NotNull String dirName) {
        if (pluginId == null) {
            SchemaScripts.$$$reportNull$$$0(5);
        }
        if (dirName == null) {
            SchemaScripts.$$$reportNull$$$0(6);
        }
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(pluginId, dirName, true);
        }
        catch (IOException ex) {
            LOG.warn("Unable to find extension scripts directory", (Throwable)ex);
            return null;
        }
    }

    public static boolean areAvailableIn(@NotNull DataContext context) {
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(7);
        }
        return !SchemaScripts.getSelection(context).isEmpty();
    }

    public static void runScript(@NotNull DataContext context, final @NotNull Path scriptFile, @NotNull PluginId hostPluginId) {
        JBIterable selection;
        Project project;
        IdeScriptEngine engine;
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(8);
        }
        if (scriptFile == null) {
            SchemaScripts.$$$reportNull$$$0(9);
        }
        if (hostPluginId == null) {
            SchemaScripts.$$$reportNull$$$0(10);
        }
        if ((engine = SchemaScripts.prepareEngine(project = (Project)CommonDataKeys.PROJECT.getData(context), scriptFile, hostPluginId, (JBIterable<DasObject>)(selection = SchemaScripts.getSelection(context).filter(DasObject.class)))) == null) {
            return;
        }
        ExtensionScriptsUtil.prepareScript((Path)scriptFile);
        Task.Backgroundable task = new Task.Backgroundable(project, DatabaseBundle.message("progress.title.running", scriptFile.getFileName().toString()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project != null && project.isDisposed() || selection.find(o -> !((DbElement)o).isValid()) != null) {
                    return;
                }
                try {
                    ExtensionScriptsUtil.evalScript((Project)project, (IdeScriptEngine)engine, (Path)scriptFile);
                }
                catch (Exception ex) {
                    LOG.warn((Throwable)ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/extensions/SchemaScripts$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    private static IdeScriptEngine prepareEngine(@Nullable Project project, @NotNull Path scriptFile, @NotNull PluginId hostPluginId, @NotNull JBIterable<DasObject> selection) {
        IdeScriptEngine engine;
        if (scriptFile == null) {
            SchemaScripts.$$$reportNull$$$0(11);
        }
        if (hostPluginId == null) {
            SchemaScripts.$$$reportNull$$$0(12);
        }
        if (selection == null) {
            SchemaScripts.$$$reportNull$$$0(13);
        }
        if ((engine = ExtensionScriptsUtil.getEngineFor((Project)project, (PluginId)hostPluginId, (Path)scriptFile, GridUtil::suggestPlugin)) != null) {
            ExtensionScriptsUtil.setBindings((IdeScriptEngine)engine).bind(SchemaGeneratorBindings.PROJECT, (Object)project).bind(SchemaGeneratorBindings.SELECTION, selection).bind(SchemaGeneratorBindings.CLIPBOARD, (Object)new ClipboardImpl()).bind(SchemaGeneratorBindings.LOG, (Object)new ScriptLoggerImpl(engine)).bind(SchemaGeneratorBindings.FILES, (Object)new FilesImpl(project, scriptFile));
        }
        return engine;
    }

    @NotNull
    private static JBIterable<? extends DasObject> getSelection(@NotNull DataContext context) {
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(14);
        }
        JBIterable jBIterable = DatabaseContextFun.getSelectedDbElementsExpandingGroups(context).filter(DasObject.class);
        if (jBIterable == null) {
            SchemaScripts.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/SchemaScripts";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPluginId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/SchemaScripts";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getScriptsDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areAvailableIn";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runScript";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 15 -> new IllegalStateException(string);
        };
    }

    private static class ClipboardImpl
    implements Clipboard {
        private ClipboardImpl() {
        }

        @Override
        @NotNull
        public String get() {
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                return contents != null ? (String)contents.getTransferData(DataFlavor.stringFlavor) : "";
            }
            catch (UnsupportedFlavorException | IOException exception) {
                return "";
            }
        }

        @Override
        public void set(@Nullable String text) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(StringUtil.notNullize((String)text)));
        }
    }

    private static class ScriptLoggerImpl
    implements ScriptLogger {
        private final IdeScriptEngine myEngine;

        ScriptLoggerImpl(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                ScriptLoggerImpl.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        @Override
        public void print(@NotNull String message) {
            if (message == null) {
                ScriptLoggerImpl.$$$reportNull$$$0(1);
            }
            try {
                this.myEngine.getStdOut().append(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void error(@NotNull String message) {
            if (message == null) {
                ScriptLoggerImpl.$$$reportNull$$$0(2);
            }
            this.error(message, null);
        }

        @Override
        public void error(@NotNull String message, @Nullable Throwable th) {
            if (message == null) {
                ScriptLoggerImpl.$$$reportNull$$$0(3);
            }
            try {
                Writer err = this.myEngine.getStdErr();
                err.append(message).append("\n");
                if (th != null) {
                    err.append(ExceptionUtil.getThrowableText((Throwable)th));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extensions/SchemaScripts$ScriptLoggerImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FilesImpl
    implements Files {
        private final Project myProject;
        private final Path myScriptFile;

        FilesImpl(@Nullable Project project, @NotNull Path scriptFile) {
            if (scriptFile == null) {
                FilesImpl.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myScriptFile = scriptFile;
        }

        @Override
        public void chooseFileAndSave(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Label @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                FilesImpl.$$$reportNull$$$0(1);
            }
            if (description == null) {
                FilesImpl.$$$reportNull$$$0(2);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(3);
            }
            FileSaverDescriptor descriptor2 = new FileSaverDescriptor(title, description, new String[0]);
            this.chooseFileAndSaveImpl((FileChooserDescriptor)descriptor2, saveAction);
        }

        @Override
        public void chooseDirectoryAndSave(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Label @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                FilesImpl.$$$reportNull$$$0(4);
            }
            if (description == null) {
                FilesImpl.$$$reportNull$$$0(5);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(6);
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title).withDescription(description);
            this.chooseFileAndSaveImpl(descriptor2, saveAction);
        }

        @Override
        public void refresh(@NotNull File file) {
            VirtualFile virtualFile;
            if (file == null) {
                FilesImpl.$$$reportNull$$$0(7);
            }
            if ((virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true)) == null) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.content.href.generator.generated.to.href.dir", this.myScriptFile.getFileName().toString(), virtualFile.getPath()), NotificationType.INFORMATION).setDisplayId("SchemaScripts.generation.finished").setListener((notification, event) -> {
                if ("generator".equals(event.getDescription())) {
                    ExtensionScriptsUtil.navigateToFile((Project)this.myProject, (Path)this.myScriptFile);
                } else if (!ExtensionScriptsUtil.navigateToFile((Project)this.myProject, (Path)file.toPath())) {
                    notification.expire();
                }
            }).notify(this.myProject);
        }

        private void chooseFileAndSaveImpl(@NotNull FileChooserDescriptor descriptor2, @NotNull Consumer<File> saveAction) {
            if (descriptor2 == null) {
                FilesImpl.$$$reportNull$$$0(8);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(9);
            }
            Ref fileRef = Ref.create();
            Runnable runnable = () -> FileChooserFactory.getInstance().createPathChooser(descriptor2, this.myProject, null).choose(null, files2 -> fileRef.set((Object)((VirtualFile)ContainerUtil.getFirstItem((List)files2))));
            try {
                ApplicationManager.getApplication().invokeAndWait(runnable);
                if (!fileRef.isNull()) {
                    VirtualFile virtualFile = (VirtualFile)fileRef.get();
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    saveAction.consume((Object)file);
                    this.refresh(file);
                }
            }
            catch (Throwable t) {
                ExceptionUtil.rethrow((Throwable)t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "saveAction";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extensions/SchemaScripts$FilesImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseFileAndSave";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseDirectoryAndSave";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refresh";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseFileAndSaveImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

