/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObjectWithSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import org.jetbrains.annotations.Nullable;

public interface BasicMixinSourceAware
extends DasObjectWithSource {
    @Nullable
    default public CompositeText getSourceTextOrPlaceholder() {
        BasicSourceAware self = (BasicSourceAware)this;
        int length = self.getSourceTextLength();
        if (length == 0) {
            return null;
        }
        CompositeText compositeText = self.getSourceText();
        if (compositeText == null) {
            BasicModel model = self.getModel();
            Dbms dbms = model == null ? Dbms.UNKNOWN : model.getDbms();
            String text = String.format("-- The source text is lost (family: %s, kind: %s, name:%s, source text length: %d)", dbms.getName(), self.getKind().code(), self.getRealName(), length);
            compositeText = new SimpleCompositeText((CharSequence)text, CompositeText.Kind.COMMENT);
        }
        return compositeText;
    }

    @Nullable
    default public String getOriginalSourceText() {
        BasicSourceAware self = (BasicSourceAware)this;
        CompositeText ct = self.getSourceText();
        if (ct != null) {
            CompositeText content = ct.getContent();
            if (content == null) {
                return null;
            }
            return content.getText().toString();
        }
        return null;
    }
}

