/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelConvertersKt;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_22;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertPostgres", "intellij.database.core.impl"})
public final class Converter_4_22
extends Converter {
    @NotNull
    public static final Converter_4_22 INSTANCE = new Converter_4_22();

    private Converter_4_22() {
        int[] nArray = new int[]{4, 22};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (modelMem.getDbms().isPostgres()) {
            this.convertPostgres(modelMem);
        }
    }

    private final void convertPostgres(ModelMem modelMem) {
        Int2ObjectOpenHashMap routines = new Int2ObjectOpenHashMap();
        for (ModelElementMem node : modelMem.getNodes()) {
            Integer n = node.getId();
            if (n == null) {
                continue;
            }
            int id = n;
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"routine")) continue;
            String rk = ModelConvertersKt.getProperty(node, "RoutineKind");
            if (rk != null && StringsKt.equals((String)rk, (String)"procedure", (boolean)true)) {
                ModelConvertersKt.setProperty(node, "PgRoutineKind", "P");
            } else {
                routines.put(id, (Object)node);
            }
            ModelConvertersKt.removeProperty(node, "RoutineKind");
        }
        if (routines.isEmpty()) {
            return;
        }
        for (ModelElementMem node : modelMem.getNodes()) {
            ModelElementMem routine2;
            String string;
            String dtp;
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"argument") || ModelConvertersKt.getProperty(node, "DataType") == null) continue;
            String string2 = dtp;
            if (Intrinsics.areEqual((Object)string2, (Object)"trigger")) {
                string = "T";
            } else {
                if (!Intrinsics.areEqual((Object)string2, (Object)"event_trigger")) continue;
                string = "V";
            }
            String x = string;
            Integer n = node.getParentId();
            if (n == null) {
                continue;
            }
            int routineId = n;
            if ((ModelElementMem)routines.get(routineId) == null) continue;
            ModelConvertersKt.setProperty(routine2, "PgRoutineKind", x);
        }
    }
}

