/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescriptionPopup {
    private final List<Item> myItems;
    private final @NlsContexts.PopupTitle String myTitle;

    public DescriptionPopup(@NotNull List<Item> items, @NlsContexts.PopupTitle @NotNull String title) {
        if (items == null) {
            DescriptionPopup.$$$reportNull$$$0(0);
        }
        if (title == null) {
            DescriptionPopup.$$$reportNull$$$0(1);
        }
        this.myItems = items;
        this.myTitle = title;
    }

    @NotNull
    public JBPopup build(@NotNull DataContext context) {
        if (context == null) {
            DescriptionPopup.$$$reportNull$$$0(2);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.myTitle, (ActionGroup)this.createGroup(this.myItems), context, null, true, null);
        Item selected = (Item)JBIterable.from(this.myItems).find(o -> o instanceof CheckItem);
        String text = selected == null ? "\n\n" : selected.description();
        popup2.setAdText(text, 2);
        popup2.addListSelectionListener(e -> {
            Item item = DescriptionPopup.getSelectedItem(e);
            if (item == null) {
                return;
            }
            String description = item.description();
            popup2.setAdText(description, 2);
        });
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            DescriptionPopup.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @Nullable
    private static Item getSelectedItem(ListSelectionEvent e) {
        JList source = (JList)e.getSource();
        Object e2 = source.getSelectedValue();
        if (!(e2 instanceof PopupFactoryImpl.ActionItem)) {
            return null;
        }
        PopupFactoryImpl.ActionItem actionItem = (PopupFactoryImpl.ActionItem)e2;
        AnAction anAction = actionItem.getAction();
        if (!(anAction instanceof MyCheckBoxAdapter)) {
            return null;
        }
        MyCheckBoxAdapter adapter = (MyCheckBoxAdapter)anAction;
        return adapter.myItem;
    }

    @NotNull
    DefaultActionGroup createGroup(@NotNull List<Item> items) {
        if (items == null) {
            DescriptionPopup.$$$reportNull$$$0(4);
        }
        return new DefaultActionGroup(ContainerUtil.map(items, i2 -> i2.createAction()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    static interface Item {
        @NlsActions.ActionText
        @NotNull
        public String name();

        @NlsActions.ActionDescription
        @NotNull
        public String description();

        public void chosen(AnActionEvent var1);

        @NotNull
        public AnAction createAction();
    }

    private static final class MyCheckBoxAdapter
    extends CheckboxAction {
        private final CheckItem myItem;

        private MyCheckBoxAdapter(@NotNull CheckItem item) {
            if (item == null) {
                MyCheckBoxAdapter.$$$reportNull$$$0(0);
            }
            super(item.name(), StringUtil.removeHtmlTags((String)item.description()), null);
            this.myItem = item;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyCheckBoxAdapter.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCheckBoxAdapter.$$$reportNull$$$0(2);
            }
            return this.myItem.isSelected();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyCheckBoxAdapter.$$$reportNull$$$0(3);
            }
            if (state) {
                this.myItem.chosen(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$MyCheckBoxAdapter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$MyCheckBoxAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static interface CheckItem
    extends Item {
        public boolean isSelected();

        @Override
        @NotNull
        default public AnAction createAction() {
            return new MyCheckBoxAdapter(this);
        }
    }

    public static class ResolveModePopup
    extends DescriptionPopup {
        public ResolveModePopup(@NotNull ItemSelector<SqlFileResolveMode> selector) {
            if (selector == null) {
                ResolveModePopup.$$$reportNull$$$0(0);
            }
            super(ResolveModePopup.createItems(selector), "");
        }

        @NotNull
        private static List<Item> createItems(@NotNull ItemSelector<SqlFileResolveMode> selector) {
            if (selector == null) {
                ResolveModePopup.$$$reportNull$$$0(1);
            }
            List<Item> list = Arrays.asList(new SeparatorItem(SqlBundle.message((String)"resolve.mode", (Object[])new Object[0])), new ResolveModeItem(SqlFileResolveMode.SCRIPT, selector), new ResolveModeItem(SqlFileResolveMode.PLAYGROUND, selector));
            if (list == null) {
                ResolveModePopup.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$ResolveModePopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$ResolveModePopup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createItems";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ResolveModeItem
    implements CheckItem {
        private final SqlFileResolveMode myResolveMode;
        private final ItemSelector<SqlFileResolveMode> mySelector;

        ResolveModeItem(@NotNull SqlFileResolveMode mode, @NotNull ItemSelector<SqlFileResolveMode> selector) {
            if (mode == null) {
                ResolveModeItem.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                ResolveModeItem.$$$reportNull$$$0(1);
            }
            this.myResolveMode = mode;
            this.mySelector = selector;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.myResolveMode.getDisplayName();
            if (string == null) {
                ResolveModeItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String description() {
            String string = this.myResolveMode.getDescription();
            if (string == null) {
                ResolveModeItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isSelected() {
            return this.mySelector.isSelected(this.myResolveMode);
        }

        @Override
        public void chosen(AnActionEvent e) {
            this.mySelector.select(this.myResolveMode, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$ResolveModeItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$ResolveModeItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class IsolationItem
    implements CheckItem {
        private final TxIsolation myIsolation;
        private final TxPopup.TxIsolationSelector mySelector;

        IsolationItem(@NotNull TxIsolation isolation, @NotNull TxPopup.TxIsolationSelector selector) {
            if (isolation == null) {
                IsolationItem.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                IsolationItem.$$$reportNull$$$0(1);
            }
            this.myIsolation = isolation;
            this.mySelector = selector;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.myIsolation.getName();
            if (string == null) {
                IsolationItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String description() {
            String string = this.myIsolation.getDescription();
            if (string == null) {
                IsolationItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void chosen(AnActionEvent e) {
            this.mySelector.select(this.myIsolation, e);
        }

        @Override
        public boolean isSelected() {
            return this.mySelector.isSelected(this.myIsolation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$IsolationItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$IsolationItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class TxSettingsPopup
    extends TxPopup {
        public static final Map<TxIsolation, @Nls String> DESCRIPTIONS = ContainerUtil.map2Map(Arrays.asList(Pair.create((Object)((Object)TxIsolation.DEFAULT), (Object)DatabaseBundle.message("transaction.mode.database.default.description", new Object[0])), Pair.create((Object)((Object)TxIsolation.READ_UNCOMMITTED), (Object)DatabaseBundle.message("transaction.mode.read.uncommitted.description", new Object[0])), Pair.create((Object)((Object)TxIsolation.READ_COMMITTED), (Object)DatabaseBundle.message("transaction.mode.read.committed.description", new Object[0])), Pair.create((Object)((Object)TxIsolation.REPEATABLE_READ), (Object)DatabaseBundle.message("transaction.mode.repeatable.read.description", new Object[0])), Pair.create((Object)((Object)TxIsolation.SERIALIZABLE), (Object)DatabaseBundle.message("transaction.mode.serializable.description", new Object[0]))));

        public TxSettingsPopup(@NotNull List<TxIsolation> levels, @NotNull TxPopup.TxIsolationSelector selector) {
            if (levels == null) {
                TxSettingsPopup.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                TxSettingsPopup.$$$reportNull$$$0(1);
            }
            super(TxSettingsPopup.createItems(levels, selector), selector);
        }

        @NotNull
        public static List<Item> createItems(@NotNull List<TxIsolation> levels, @NotNull TxPopup.TxIsolationSelector selector) {
            if (levels == null) {
                TxSettingsPopup.$$$reportNull$$$0(2);
            }
            if (selector == null) {
                TxSettingsPopup.$$$reportNull$$$0(3);
            }
            List list = levels.isEmpty() ? ContainerUtil.emptyList() : JBIterable.of((Object)new SeparatorItem(DatabaseBundle.message("action.transaction.isolation.text", new Object[0]))).filter(Item.class).append((Iterable)JBIterable.from(levels).map(l -> new IsolationItem((TxIsolation)((Object)l), selector))).toList();
            if (list == null) {
                TxSettingsPopup.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "levels";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createItems";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class TxPopup
    extends DescriptionPopup {
        public TxPopup(@NotNull TxSelector selector) {
            if (selector == null) {
                TxPopup.$$$reportNull$$$0(0);
            }
            this((List<Item>)ContainerUtil.emptyList(), selector);
        }

        TxPopup(@NotNull List<Item> items, @NotNull TxSelector selector) {
            if (items == null) {
                TxPopup.$$$reportNull$$$0(1);
            }
            if (selector == null) {
                TxPopup.$$$reportNull$$$0(2);
            }
            super(TxPopup.createItems(items, selector), "");
        }

        @NotNull
        private static List<Item> createItems(@NotNull List<Item> items, @NotNull TxSelector selector) {
            if (items == null) {
                TxPopup.$$$reportNull$$$0(3);
            }
            if (selector == null) {
                TxPopup.$$$reportNull$$$0(4);
            }
            List list = JBIterable.of((Object[])new Item[]{new SeparatorItem(DatabaseBundle.message("transaction.mode", new Object[0])), new TxAuto(selector), new TxManual(selector)}).append(items).toList();
            if (list == null) {
                TxPopup.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$TxPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$TxPopup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createItems";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }

        public static interface TxSelector {
            public void toggle(@Nullable AnActionEvent var1, boolean var2);

            public boolean isAuto();
        }

        private static final class TxAuto
        implements CheckItem {
            private final TxSelector mySelector;

            private TxAuto(@NotNull TxSelector selector) {
                if (selector == null) {
                    TxAuto.$$$reportNull$$$0(0);
                }
                this.mySelector = selector;
            }

            @Override
            @NotNull
            public String name() {
                String string = DatabaseBundle.message("transaction.mode.auto", new Object[0]);
                if (string == null) {
                    TxAuto.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public String description() {
                String string = DatabaseBundle.message("transaction.mode.auto.description", new Object[0]);
                if (string == null) {
                    TxAuto.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            public void chosen(AnActionEvent e) {
                this.mySelector.toggle(e, true);
            }

            @Override
            public boolean isSelected() {
                return this.mySelector.isAuto();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selector";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxAuto";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxAuto";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "name";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "description";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }

        private static final class TxManual
        implements CheckItem {
            private final TxSelector mySelector;

            private TxManual(@NotNull TxSelector selector) {
                if (selector == null) {
                    TxManual.$$$reportNull$$$0(0);
                }
                this.mySelector = selector;
            }

            @Override
            @NotNull
            public String name() {
                String string = DatabaseBundle.message("transaction.mode.manual", new Object[0]);
                if (string == null) {
                    TxManual.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public String description() {
                String string = DatabaseBundle.message("transaction.mode.manual.description", new Object[0]);
                if (string == null) {
                    TxManual.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            public void chosen(AnActionEvent e) {
                this.mySelector.toggle(e, false);
            }

            @Override
            public boolean isSelected() {
                return !this.mySelector.isAuto();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selector";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxManual";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxManual";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "name";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "description";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }

        public static class TxSelectorImpl
        implements TxSelector {
            private boolean myMode;

            @Override
            public void toggle(@Nullable AnActionEvent e, boolean auto) {
                this.myMode = auto;
            }

            @Override
            public boolean isAuto() {
                return this.myMode;
            }
        }

        public static interface TxIsolationSelector
        extends TxSelector,
        ItemSelector<TxIsolation> {
        }
    }

    public static interface ItemSelector<T> {
        public boolean isSelected(@NotNull T var1);

        public void select(@NotNull T var1, AnActionEvent var2);
    }

    public static class SeparatorItem
    implements Item {
        private final @NlsActions.ActionText String myText;

        public SeparatorItem(@NlsActions.ActionText @NotNull String text) {
            if (text == null) {
                SeparatorItem.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.myText;
            if (string == null) {
                SeparatorItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String description() {
            return "";
        }

        @Override
        public void chosen(AnActionEvent e) {
        }

        @Override
        @NotNull
        public AnAction createAction() {
            return new Separator(this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DescriptionPopup$SeparatorItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DescriptionPopup$SeparatorItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

