/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaEditor {
    private final SchemaExporters mySchemaExporters;
    private final DatabaseEditorCapabilities.DbEditorCaps myDbEditorCaps;
    private static final SchemaExporters ourExporters = DasSchemaExporters.createDefaultExporters();
    private static final Map<Dbms, SchemaEditor> ourFactory = ConcurrentFactoryMap.create(dbms -> new SchemaEditor(ourExporters, DatabaseEditorCapabilities.createFor(dbms)), ContainerUtil::createConcurrentSoftValueMap);

    @NotNull
    public DeModel createModel(@NotNull DatabaseEditorContext context, @Nullable DasModel model) {
        if (context == null) {
            SchemaEditor.$$$reportNull$$$0(0);
        }
        return new DeModel(this.mySchemaExporters, context, model);
    }

    public boolean canExport(@NotNull BasicElement object) {
        if (object == null) {
            SchemaEditor.$$$reportNull$$$0(1);
        }
        return this.mySchemaExporters.get(object) != null;
    }

    public SchemaEditor(@NotNull SchemaExporters exporters, @NotNull DatabaseEditorCapabilities.DbEditorCaps caps) {
        if (exporters == null) {
            SchemaEditor.$$$reportNull$$$0(2);
        }
        if (caps == null) {
            SchemaEditor.$$$reportNull$$$0(3);
        }
        this.mySchemaExporters = exporters;
        this.myDbEditorCaps = caps;
    }

    @NotNull
    public DatabaseEditorCapabilities.DbEditorCaps getDbEditorCaps() {
        DatabaseEditorCapabilities.DbEditorCaps dbEditorCaps = this.myDbEditorCaps;
        if (dbEditorCaps == null) {
            SchemaEditor.$$$reportNull$$$0(4);
        }
        return dbEditorCaps;
    }

    public static SchemaEditor forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            SchemaEditor.$$$reportNull$$$0(5);
        }
        return ourFactory.get(dbms);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbEditorCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canExport";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

