/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.UnparsedTypeHolder;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.model.DeGrant;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeColumn
extends DeTableChild
implements UnparsedTypeHolder {
    @NotNull
    public String dataType;
    @Nullable
    public String defaultValue;
    @NotNull
    public final Set<Flag> flags;
    public final List<DeGrant> grants;

    protected DeColumn(@NotNull DeModel model) {
        if (model == null) {
            DeColumn.$$$reportNull$$$0(0);
        }
        super(model);
        this.dataType = "int";
        this.defaultValue = null;
        this.flags = EnumSet.noneOf(Flag.class);
        this.grants = new ArrayList<DeGrant>();
        this.init(model);
    }

    public DeColumn(@NotNull String name2, @NotNull DeTable parent, @NotNull DeModel model) {
        if (name2 == null) {
            DeColumn.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            DeColumn.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DeColumn.$$$reportNull$$$0(3);
        }
        super(name2, parent, model);
        this.dataType = "int";
        this.defaultValue = null;
        this.flags = EnumSet.noneOf(Flag.class);
        this.grants = new ArrayList<DeGrant>();
        this.init(model);
    }

    private void init(@NotNull DeModel model) {
        Dbms dbms;
        if (model == null) {
            DeColumn.$$$reportNull$$$0(4);
        }
        this.dataType = (dbms = model.getDbms()).is(Dbms.BIGQUERY) ? "int64" : (dbms.is(Dbms.SQLITE) ? "integer" : "int");
    }

    @Override
    @NotNull
    public String getUnparsedType() {
        String string = this.dataType;
        if (string == null) {
            DeColumn.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public DeColumn getEditedDeObject() {
        return (DeColumn)super.getEditedDeObject();
    }

    @Override
    @Nullable
    public BasicTypedElement getEditedBasic() {
        return (BasicTypedElement)super.getEditedBasic();
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DeObject> otherChildren) {
        if (other == null) {
            DeColumn.$$$reportNull$$$0(6);
        }
        if (children2 == null) {
            DeColumn.$$$reportNull$$$0(7);
        }
        if (otherChildren == null) {
            DeColumn.$$$reportNull$$$0(8);
        }
        DeColumn otherColumn = (DeColumn)other;
        return !this.dataType.equals(otherColumn.dataType) || !this.grants.equals(otherColumn.grants) || !Objects.equals(this.defaultValue, otherColumn.defaultValue) || !Comparing.haveEqualElements(this.flags, otherColumn.flags) || super.isAlteredIgnoringChild(other, children2, otherChildren);
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            DeColumn.$$$reportNull$$$0(9);
        }
        return new DeColumn(model);
    }

    public boolean isInTable() {
        return this.table.columns.contains(this);
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj2, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj2 == null) {
            DeColumn.$$$reportNull$$$0(10);
        }
        if (copier == null) {
            DeColumn.$$$reportNull$$$0(11);
        }
        super.copyFrom(obj2, withChildren, copier);
        DeColumn col = (DeColumn)obj2;
        this.dataType = col.dataType;
        this.defaultValue = col.defaultValue;
        this.flags.clear();
        this.flags.addAll(col.flags);
        this.grants.clear();
        this.grants.addAll(col.grants);
        DeColumn deColumn = this;
        if (deColumn == null) {
            DeColumn.$$$reportNull$$$0(12);
        }
        return deColumn;
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType;
        try {
            dataType = DataTypeFactory.of(this.dataType);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        if (dataType == null) {
            DeColumn.$$$reportNull$$$0(13);
        }
        return dataType;
    }

    public boolean isNotNull() {
        return this.flags.contains((Object)Flag.NOT_NULL);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            DeColumn.$$$reportNull$$$0(14);
        }
        return objectKind;
    }

    @Override
    public short getPosition() {
        int idx = this.table.columns.indexOf(this);
        return idx == -1 ? (short)0 : (short)(idx + 1);
    }

    public boolean isComputed() {
        DasColumn editedColumn = (DasColumn)ObjectUtils.tryCast((Object)this.getEditedObject(), DasColumn.class);
        return DasUtil.isComputed(editedColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeColumn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeColumn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnparsedType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static enum Flag {
        NOT_NULL,
        AUTO_INC;

    }
}

