/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExportHelperImpl;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeModel
implements CasingProvider {
    public static final DeModel STUB = new DeModel(null, null);
    private final CasingProvider myModel;
    private final SchemaExportHelper myHelper;
    private final Set<DeObject> myRoots;

    public DeModel(@NotNull SchemaExporters exporters, @NotNull DatabaseEditorContext context, @Nullable DasModel model) {
        if (exporters == null) {
            DeModel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DeModel.$$$reportNull$$$0(1);
        }
        this.myRoots = new LinkedHashSet<DeObject>();
        this.myModel = model;
        this.myHelper = exporters.createHelper(context, this);
    }

    public DeModel(@NotNull DeModel model) {
        if (model == null) {
            DeModel.$$$reportNull$$$0(2);
        }
        this.myRoots = new LinkedHashSet<DeObject>();
        this.myModel = model;
        this.myHelper = SchemaExportHelperImpl.createChained(this);
    }

    private DeModel(@Nullable CasingProvider model, @Nullable SchemaExportHelper helper) {
        this.myRoots = new LinkedHashSet<DeObject>();
        this.myModel = model;
        this.myHelper = helper;
    }

    public Dbms getDbms() {
        return this.myHelper == null ? Dbms.UNKNOWN : this.myHelper.getContext().getDbms();
    }

    @NotNull
    public JBIterable<? extends DeObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.myRoots);
        if (jBIterable == null) {
            DeModel.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public JBTreeTraverser<DeObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(o -> o.getDasChildren(null)).withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            DeModel.$$$reportNull$$$0(4);
        }
        return jBTreeTraverser;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            DeModel.$$$reportNull$$$0(5);
        }
        Casing casing = this.myModel == null ? DasUtil.CASING_EXACT : this.myModel.getCasing(kind, context);
        if (casing == null) {
            DeModel.$$$reportNull$$$0(6);
        }
        return casing;
    }

    public void addRoot(@NotNull DeObject obj2) {
        if (obj2 == null) {
            DeModel.$$$reportNull$$$0(7);
        }
        this.myRoots.add(obj2);
    }

    public void removeRoot(@NotNull DeObject obj2) {
        if (obj2 == null) {
            DeModel.$$$reportNull$$$0(8);
        }
        this.myRoots.remove(obj2);
    }

    public DasModel getDasModel() {
        return (DasModel)ObjectUtils.tryCast((Object)this.myModel, DasModel.class);
    }

    @Nullable
    public DasModel unwrap() {
        CasingProvider tmp = this.myModel;
        while (tmp instanceof DeModel) {
            tmp = ((DeModel)tmp).myModel;
        }
        return (DasModel)tmp;
    }

    public DeModel getDeModel() {
        return (DeModel)ObjectUtils.tryCast((Object)this.myModel, DeModel.class);
    }

    public CasingProvider getSubModel() {
        return this.myModel;
    }

    public SchemaExportHelper getExportHelper() {
        return this.myHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

