/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelLiteRef;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbSinglePropModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFamilyGridDataHookup<C extends BasicElement>
extends GridDataHookUpBase<GridRow, GridColumn> {
    private final DataGridListModel myModel;
    private final GridMutationModel myMutationModel;
    private final GridStorageAndModelUpdater myModelUpdater;
    private final DbEditorController myController;
    static final ObjectFormatter FORMATTER = new ObjectFormatter(){

        @Nullable
        public String objectToString(@Nullable Object o, GridColumn column2, @NotNull ObjectFormatterConfig config) {
            DbFamilyGridColumn c2;
            DbModelApplier dbModelApplier;
            if (config == null) {
                2.$$$reportNull$$$0(0);
            }
            if (o instanceof DbTextModelState) {
                DbTextModelState ts2 = (DbTextModelState)o;
                return ts2.getText();
            }
            if (column2 instanceof DbFamilyGridColumn && (dbModelApplier = (c2 = (DbFamilyGridColumn)column2).getApplier()) instanceof DbSinglePropModelApplier) {
                DbSinglePropModelApplier a = (DbSinglePropModelApplier)dbModelApplier;
                if (o instanceof DbSingleValueModelState) {
                    DbSingleValueModelState s = (DbSingleValueModelState)o;
                    return BasicMetaUtils.getPropertyStringValue(a.getProperty(), s.getValue());
                }
            }
            if (o instanceof DbReferenceModelState) {
                DbReferenceModelState s = (DbReferenceModelState)o;
                return BasicMetaUtils.renderRefInfo(s.getActualRef());
            }
            return o == null ? null : o.toString();
        }

        public boolean isStringLiteral(@Nullable GridColumn column2, @Nullable Object value, @NotNull ObjectFormatterMode mode) {
            if (mode == null) {
                2.$$$reportNull$$$0(1);
            }
            return false;
        }

        @NotNull
        public String getStringLiteral(@NotNull String value, GridColumn column2, @NotNull ObjectFormatterMode mode) {
            if (value == null) {
                2.$$$reportNull$$$0(2);
            }
            if (mode == null) {
                2.$$$reportNull$$$0(3);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbFamilyGridDataHookup$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "objectToString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStringLiteral";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStringLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public DbFamilyGridDataHookup(@NotNull DbEditorController controller) {
        if (controller == null) {
            DbFamilyGridDataHookup.$$$reportNull$$$0(0);
        }
        super(controller.getProject());
        this.myController = controller;
        this.myModel = new DataGridListModel(Object::equals);
        this.myMutationModel = new GridMutationModel((GridDataHookUp)this);
        this.myModelUpdater = new GridStorageAndModelUpdater((GridListModelBase)this.myModel, this.myMutationModel, null);
    }

    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        return new GridPagingModelImpl.SinglePage(this.getDataModel());
    }

    public void reset(@NotNull List<DbModelRef<C, DbStructureObjectModelState<C>>> objects) {
        if (objects == null) {
            DbFamilyGridDataHookup.$$$reportNull$$$0(1);
        }
        ArrayList<DbFamilyGridColumn<Object>> columns = new ArrayList<DbFamilyGridColumn<Object>>();
        if (!objects.isEmpty()) {
            Iterable<DbModelRef<?, ?>> columnModels = this.getColumnModels(objects.get(0));
            for (DbModelRef<Object, DbStructureObjectModelState<Object>> dbModelRef : columnModels) {
                if (!DbFamilyGridDataHookup.isDisplayable(dbModelRef)) continue;
                columns.add(new DbFamilyGridColumn<Object>(columns.size(), dbModelRef.getApplier(), this.getTitle(dbModelRef)));
            }
        }
        ArrayList rows = new ArrayList();
        for (DbModelRef<Object, DbStructureObjectModelState<Object>> dbModelRef : objects) {
            Map states = JBIterable.from(this.getColumnModels(dbModelRef)).toMap(DbModelLiteRef::getModelInternalKey, DbModelRef::getState);
            List values = ContainerUtil.map(columns, c2 -> (DbModelState)states.get(c2.getApplier().getModelInternalKey()));
            rows.add(new DbFamilyGridRow(rows.size() + 1, dbModelRef.getIdentity(), values.toArray(new DbModelState[0])));
        }
        this.myModelUpdater.removeRows(0, this.myModel.getRowCount());
        this.myModelUpdater.setColumns(columns);
        this.myModelUpdater.addRows(rows);
    }

    @Nls
    @NotNull
    private String getTitle(DbModelRef<?, ?> sub) {
        DbEditorModelController modelController = this.myController.getModelController();
        String title = sub.resolve(modelController).getTitle();
        if (title == null) {
            ElementIdentity identity = sub.getIdentity();
            title = modelController.getBuilder().getTitle(modelController.getDbms(identity), identity, sub.getModelInternalKey());
        }
        String string = title;
        if (string == null) {
            DbFamilyGridDataHookup.$$$reportNull$$$0(2);
        }
        return string;
    }

    private Iterable<DbModelRef<?, ?>> getColumnModels(DbModelRef<C, DbStructureObjectModelState<C>> ref2) {
        DbObjectModelState<C> objState = ref2.getState().getObjectRef().getState();
        return objState.getSubStates();
    }

    @NotNull
    public GridLoader getLoader() {
        return new GridLoader(){

            public void reloadCurrentPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.load(source, 0);
            }

            public void loadNextPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.load(source, 0);
            }

            public void loadPreviousPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.load(source, 0);
            }

            public void loadLastPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.load(source, 0);
            }

            public void loadFirstPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.load(source, 0);
            }

            public void load(@NotNull GridRequestSource source, int offset) {
                if (source == null) {
                    1.$$$reportNull$$$0(5);
                }
            }

            public void updateTotalRowCount(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(6);
                }
                DbFamilyGridDataHookup.this.notifyRequestFinished(source, false);
            }

            public void applyFilterAndSorting(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(7);
                }
                DbFamilyGridDataHookup.this.notifyRequestFinished(source, false);
            }

            public void updateIsTotalRowCountUpdateable() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "source";
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbFamilyGridDataHookup$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reloadCurrentPage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadNextPage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadPreviousPage";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadLastPage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadFirstPage";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "load";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateTotalRowCount";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyFilterAndSorting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getMutationModel() {
        GridMutationModel gridMutationModel = this.myMutationModel;
        if (gridMutationModel == null) {
            DbFamilyGridDataHookup.$$$reportNull$$$0(3);
        }
        return gridMutationModel;
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DbFamilyGridDataHookup.$$$reportNull$$$0(4);
        }
        return dataGridListModel;
    }

    private static boolean isDisplayable(DbModelRef<?, ?> sub) {
        return sub.getState() instanceof DbTextModelState || sub.getState() instanceof DbReferenceModelState || sub.getApplier() instanceof DbSinglePropModelApplier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbFamilyGridDataHookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbFamilyGridDataHookup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class DbFamilyGridColumn<C extends BasicElement>
    implements GridColumn {
        private final int myColNum;
        private final DbModelApplier<C, ?> myApplier;
        private final String myTitle;

        private DbFamilyGridColumn(int colNum, @NotNull DbModelApplier<C, ?> applier, @NotNull @Nls String title) {
            if (applier == null) {
                DbFamilyGridColumn.$$$reportNull$$$0(0);
            }
            if (title == null) {
                DbFamilyGridColumn.$$$reportNull$$$0(1);
            }
            this.myColNum = colNum;
            this.myApplier = applier;
            this.myTitle = title;
        }

        public int getColumnNumber() {
            return this.myColNum;
        }

        public int getType() {
            return 0;
        }

        public String getName() {
            return this.myTitle;
        }

        @Nullable
        public String getTypeName() {
            return null;
        }

        private DbModelApplier<C, ?> getApplier() {
            return this.myApplier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "applier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/ui/DbFamilyGridDataHookup$DbFamilyGridColumn";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DbFamilyGridRow<C extends BasicElement>
    implements GridRow {
        private final int myRowNum;
        private final ElementIdentity<C> myIdentity;
        private final DbModelState[] myStates;

        private DbFamilyGridRow(int rowNum, ElementIdentity<C> identity, DbModelState[] states) {
            this.myRowNum = rowNum;
            this.myIdentity = identity;
            this.myStates = states;
        }

        @Nullable
        public Object getValue(int columnNum) {
            return this.myStates[columnNum];
        }

        public int getSize() {
            return this.myStates.length;
        }

        public void setValue(int i2, @Nullable Object object) {
            this.myStates[i2] = (DbModelState)object;
        }

        public int getRowNum() {
            return this.myRowNum;
        }

        public ElementIdentity<C> getIdentity() {
            return this.myIdentity;
        }
    }
}

