/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DasUtil {
    public static final Function<DasObject, String> TO_NAME = o -> o == null ? null : o.getName();
    public static final Function<DasObject, ObjectKind> TO_KIND = o -> o == null ? null : o.getKind();
    public static final Function<DasObject, DasObject> TO_PARENT = t -> {
        DasObject o = t.getDasParent();
        ObjectKind kind = DasUtil.getKind(o);
        return kind == ObjectKind.NONE || kind == ObjectKind.ROOT ? null : o;
    };
    public static final String NO_NAME = new String("");
    public static final Set<DasColumn.Attribute> NO_ATTRS = Collections.emptySet();
    public static final Casing CASING_MIXED = Casing.create(Case.MIXED, Case.EXACT);
    public static final Casing CASING_EXACT = Casing.create(Case.EXACT, Case.EXACT);
    public static final CasingProvider NO_CASING_PROVIDER = (kind, context) -> CASING_MIXED;
    private static final JBTreeTraverser<DasObject> DAS_TRAVERSER = JBTreeTraverser.from(o -> o.getDasChildren(null));

    private DasUtil() {
    }

    @NotNull
    public static <V> Map<String, V> newCaseAwareMap(boolean sensitive) {
        Map map2 = sensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
        if (map2 == null) {
            DasUtil.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @NotNull
    public static Set<String> newCaseAwareSet(boolean sensitive) {
        Set set = sensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
        if (set == null) {
            DasUtil.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static JBTreeTraverser<DasObject> dasTraverser() {
        JBTreeTraverser<DasObject> jBTreeTraverser = DAS_TRAVERSER;
        if (jBTreeTraverser == null) {
            DasUtil.$$$reportNull$$$0(2);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static ObjectKind getKind(@Nullable DasObject o) {
        ObjectKind objectKind = o == null ? ObjectKind.NONE : o.getKind();
        if (objectKind == null) {
            DasUtil.$$$reportNull$$$0(3);
        }
        return objectKind;
    }

    public static boolean isNoName(@Nullable String name2) {
        return Strings.areSameInstance((String)name2, (String)NO_NAME);
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byKind(@Nullable ObjectKind kind) {
        Condition condition = kind == null || kind == ObjectKind.NONE ? Conditions.alwaysTrue() : object -> DasUtil.getKind(object) == kind;
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(4);
        }
        return condition;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable String name2) {
        return DasUtil.byName(name2, NO_CASING_PROVIDER);
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable String name2, @NotNull CasingProvider casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(5);
        }
        Condition condition = name2 == null ? Conditions.alwaysFalse() : object -> DasUtil.nameEqual(object, name2, casing);
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @NotNull
    public static <C> Condition<C> byClass(@NotNull Class<?> clazz) {
        if (clazz == null) {
            DasUtil.$$$reportNull$$$0(7);
        }
        Condition condition = Conditions.instanceOf(clazz);
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @NotNull
    public static DasModel emptyModel() {
        EmptyModel emptyModel = EmptyModel.INSTANCE;
        if (emptyModel == null) {
            DasUtil.$$$reportNull$$$0(9);
        }
        return emptyModel;
    }

    public static boolean nameEqual(@Nullable DasObject obj2, @Nullable String name2, @NotNull CasingProvider casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(10);
        }
        return DasUtil.nameEqual(obj2, name2, casing.getCasing(obj2 == null ? ObjectKind.NONE : obj2.getKind(), obj2));
    }

    public static boolean nameEqual(@Nullable DasObject obj2, @Nullable String name2, @NotNull Casing casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(11);
        }
        return obj2 != null && DasUtil.equal(obj2.getName(), name2, casing);
    }

    public static boolean isCaseSensitive(@NotNull Casing casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(12);
        }
        return casing.plain == Case.EXACT;
    }

    public static boolean equal(@Nullable String name1, @Nullable String name2, @NotNull Casing casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(13);
        }
        return Comparing.equal((String)name1, (String)name2, (boolean)DasUtil.isCaseSensitive(casing));
    }

    @NotNull
    public static <T> MultiRef<T> emptyMultiRef() {
        EmptyMultiRef emptyMultiRef = EmptyMultiRef.INSTANCE;
        if (emptyMultiRef == null) {
            DasUtil.$$$reportNull$$$0(14);
        }
        return emptyMultiRef;
    }

    @NotNull
    public static <S, T> MultiRef<? extends T> transform(@NotNull MultiRef<S> ref2, @NotNull Function<? super S, ? extends T> fun) {
        if (ref2 == null) {
            DasUtil.$$$reportNull$$$0(15);
        }
        if (fun == null) {
            DasUtil.$$$reportNull$$$0(16);
        }
        return new MappedMultiRef<S, T>(ref2, fun);
    }

    @Nullable
    public static DasObject getParentOfKind(@Nullable DasObject object, @Nullable ObjectKind kind, boolean strict) {
        DasObject o;
        if (kind == null) {
            return null;
        }
        DasObject dasObject = o = strict && object != null ? object.getDasParent() : object;
        while (o != null) {
            if (o.getKind() == kind) {
                return o;
            }
            o = o.getDasParent();
        }
        return null;
    }

    @Nullable
    public static <T> T getParentOfClass(@Nullable DasObject object, @Nullable Class<? extends T> clazz, boolean strict) {
        DasObject o;
        if (clazz == null) {
            return null;
        }
        DasObject dasObject = o = strict && object != null ? object.getDasParent() : object;
        while (o != null) {
            if (clazz.isInstance(o)) {
                return (T)o;
            }
            o = o.getDasParent();
        }
        return null;
    }

    @Nullable
    public static DasNamespace getNamespace(@Nullable DasObject object) {
        return DasUtil.getParentOfClass(object, DasNamespace.class, true);
    }

    @NotNull
    public static JBIterable<DasObject> dasParents(@Nullable DasObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DasUtil.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.generate((Object)object, TO_PARENT);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @Nullable
    public static <C extends DasObject> C findChild(@Nullable DasObject parent, Class<C> clazz, ObjectKind kind, String name2) {
        return (C)(parent == null ? null : (DasObject)parent.getDasChildren(kind).filter(DasUtil.byName(name2)).filter(clazz).first());
    }

    @Nullable
    public static DasObject getCatalogObject(@Nullable DasObject object) {
        return DasUtil.getParentOfKind(object, ObjectKind.DATABASE, false);
    }

    @Nullable
    public static DasObject getSchemaObject(@Nullable DasObject object) {
        return DasUtil.getParentOfKind(object, ObjectKind.SCHEMA, false);
    }

    @NotNull
    public static String getName(@Nullable DasObject object) {
        String string = object == null ? NO_NAME : object.getName();
        if (string == null) {
            DasUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String getCatalog(@Nullable DasObject object) {
        return DasUtil.getName(DasUtil.getCatalogObject(object));
    }

    @NotNull
    public static String getSchema(@Nullable DasObject object) {
        return DasUtil.getName(DasUtil.getSchemaObject(object));
    }

    public static <T extends DasObject> MultiRef<T> asRef(Iterable<? extends T> objects) {
        return DasUtil.asRef(objects, TO_NAME, Functions.identity());
    }

    public static <S, T extends DasObject> MultiRef<T> asRef(final Iterable<? extends S> objects, final Function<? super S, String> namer, final Function<? super S, ? extends T> resolver) {
        final JBIterable fi = JBIterable.from(objects);
        return new MultiRef<T>(){

            @Override
            public MultiRef.It<T> iterate() {
                final Iterator it = objects.iterator();
                return new MultiRef.It<T>(){
                    S cur;

                    @Override
                    @Nullable
                    public T resolve() {
                        return (DasObject)resolver.fun(this.cur);
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public String next() {
                        this.cur = it.next();
                        return (String)namer.fun(this.cur);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Iterable<String> names() {
                return fi.transform(namer);
            }

            @Override
            public Iterable<? extends T> resolveObjects() {
                return fi.filterMap(resolver);
            }

            @Override
            public int size() {
                return fi.size();
            }
        };
    }

    @Nullable
    public static DasObject resolveFinalTarget(@Nullable DasSynonym synonym2) {
        int k = 9;
        DasObject o = synonym2;
        while (o instanceof DasSynonym && k-- > 0) {
            DasObject target2 = o.resolveTarget();
            if (target2 == null) {
                return o;
            }
            o = target2;
        }
        return o;
    }

    public static boolean isPrimary(@Nullable DasColumn column2) {
        return DasUtil.hasAttribute(column2, DasColumn.Attribute.PRIMARY_KEY);
    }

    public static boolean isForeign(@Nullable DasColumn column2) {
        return DasUtil.hasAttribute(column2, DasColumn.Attribute.FOREIGN_KEY);
    }

    public static boolean isAuto(@Nullable DasColumn column2) {
        return DasUtil.isAutoGenerated(column2) || DasUtil.isComputed(column2);
    }

    public static boolean isAutoGenerated(@Nullable DasColumn column2) {
        return DasUtil.hasAttribute(column2, DasColumn.Attribute.AUTO_GENERATED);
    }

    public static boolean isComputed(@Nullable DasColumn column2) {
        return DasUtil.hasAttribute(column2, DasColumn.Attribute.COMPUTED);
    }

    public static boolean isIndexColumn(@Nullable DasColumn column2) {
        return DasUtil.hasAttribute(column2, DasColumn.Attribute.INDEX);
    }

    private static boolean hasAttribute(@Nullable DasColumn column2, @NotNull DasColumn.Attribute attribute) {
        if (attribute == null) {
            DasUtil.$$$reportNull$$$0(20);
        }
        DasTable table = column2 == null ? null : column2.getTable();
        return table != null && table.getColumnAttrs(column2).contains((Object)attribute);
    }

    public static boolean isAncestor(@Nullable DasObject ancestor, @Nullable DasObject element, boolean strict) {
        if (ancestor == null || element == null) {
            return false;
        }
        if (ancestor == element) {
            return !strict;
        }
        for (DasObject object : DasUtil.dasParents(element)) {
            if (object != ancestor) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static JBIterable<? extends DasTable> getTables(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(21);
        }
        return DasUtil.getTables((DasDataSource)dataSource);
    }

    @NotNull
    public static JBIterable<? extends DasNamespace> getSchemas(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(22);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)dataSource.getModel().traverser().expandAndFilter(DasUtil.byClass(DasNamespace.class))).filter(DasUtil.byKind(ObjectKind.SCHEMA))).filter(DasNamespace.class);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    public static JBIterable<? extends DasTable> getTables(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(24);
        }
        return DasUtil.getSchemaElements(dataSource, DasTable.class);
    }

    public static <T> JBIterable<? extends T> getSchemaElements(@NotNull DasDataSource dataSource, Class<T> clazz) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(25);
        }
        return ((JBTreeTraverser)dataSource.getModel().traverser().expandAndSkip(DasUtil.byClass(DasNamespace.class))).filter(clazz);
    }

    public static JBIterable<? extends DasColumn> getColumns(@Nullable DasObject table) {
        return table == null ? JBIterable.empty() : table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
    }

    public static JBIterable<? extends DasForeignKey> getForeignKeys(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(26);
        }
        return table.getDasChildren(ObjectKind.FOREIGN_KEY).filter(DasForeignKey.class);
    }

    public static JBIterable<? extends DasIndex> getIndices(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(27);
        }
        return DasUtil.getIndices((DasObject)table);
    }

    public static JBIterable<? extends DasIndex> getIndices(@NotNull DasObject table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(28);
        }
        return table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class);
    }

    public static JBIterable<? extends DasTableKey> getTableKeys(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(29);
        }
        return DasUtil.getTableKeys((DasObject)table);
    }

    public static JBIterable<? extends DasTableKey> getTableKeys(@NotNull DasObject table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(30);
        }
        return table.getDasChildren(ObjectKind.KEY).filter(DasTableKey.class);
    }

    @Nullable
    public static DasTableKey getPrimaryKey(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(31);
        }
        return DasUtil.getPrimaryKey((DasObject)table);
    }

    public static DasTableKey getPrimaryKey(@NotNull DasObject table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(32);
        }
        for (DasTableKey key2 : DasUtil.getTableKeys(table)) {
            if (!key2.isPrimary()) continue;
            return key2;
        }
        return null;
    }

    public static boolean containsName(@NotNull String name2, @NotNull MultiRef<?> ref2) {
        if (name2 == null) {
            DasUtil.$$$reportNull$$$0(33);
        }
        if (ref2 == null) {
            DasUtil.$$$reportNull$$$0(34);
        }
        return ContainerUtil.find(ref2.names(), (Object)name2) != null;
    }

    @NotNull
    public static JBIterable<? extends DasArgument> getParameters(@NotNull DasRoutine routine2) {
        if (routine2 == null) {
            DasUtil.$$$reportNull$$$0(35);
        }
        JBIterable jBIterable = JBIterable.from(routine2.getArguments()).filter(o -> !o.getArgumentDirection().isReturnOrResult());
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 7, 10, 11, 12, 13, 15, 16, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DasUtil";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newCaseAwareMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newCaseAwareSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dasTraverser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "byKind";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DasUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "byClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMultiRef";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "dasParents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "byClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nameEqual";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaElements";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeys";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTableKeys";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryKey";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "containsName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 7, 10, 11, 12, 13, 15, 16, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 -> new IllegalArgumentException(string);
        };
    }

    private static final class EmptyModel
    extends JBTreeTraverser<DasObject>
    implements DasModel {
        private static final EmptyModel INSTANCE = new EmptyModel("empty");
        final String debugName;

        private EmptyModel(String debugName) {
            super(Functions.constant((Object)JBIterable.empty()));
            this.debugName = debugName;
        }

        @Override
        @NotNull
        public MetaModel getMetaModel() {
            MetaModel metaModel = MetaModel.EMPTY;
            if (metaModel == null) {
                EmptyModel.$$$reportNull$$$0(0);
            }
            return metaModel;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasObject> getModelRoots() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyModel.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public DasNamespace getCurrentRootNamespace() {
            return null;
        }

        @Override
        @NotNull
        public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
            if (kind == null) {
                EmptyModel.$$$reportNull$$$0(2);
            }
            Casing casing = CASING_MIXED;
            if (casing == null) {
                EmptyModel.$$$reportNull$$$0(3);
            }
            return casing;
        }

        @Override
        @NotNull
        public JBTreeTraverser<DasObject> traverser() {
            EmptyModel emptyModel = this;
            if (emptyModel == null) {
                EmptyModel.$$$reportNull$$$0(4);
            }
            return emptyModel;
        }

        @NotNull
        protected JBTreeTraverser<DasObject> newInstance(@NotNull FilteredTraverserBase.Meta<DasObject> meta) {
            if (meta == null) {
                EmptyModel.$$$reportNull$$$0(5);
            }
            EmptyModel emptyModel = this;
            if (emptyModel == null) {
                EmptyModel.$$$reportNull$$$0(6);
            }
            return emptyModel;
        }

        @Override
        public boolean contains(@Nullable DasObject o) {
            return false;
        }

        public String toString() {
            return this.debugName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DasUtil$EmptyModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModelRoots";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DasUtil$EmptyModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCasing";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "traverser";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCasing";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "newInstance";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class EmptyMultiRef
    implements MultiRef,
    MultiRef.It {
        static final EmptyMultiRef INSTANCE = new EmptyMultiRef();

        private EmptyMultiRef() {
        }

        public MultiRef.It iterate() {
            return this;
        }

        @Override
        public Iterable<String> names() {
            return Collections.emptyList();
        }

        public Iterable resolveObjects() {
            return JBIterable.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Nullable
        public Object resolve() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class MappedMultiRef<S, T>
    implements MultiRef<T> {
        final MultiRef<? extends S> original;
        final Function<? super S, T> fun;

        private MappedMultiRef(MultiRef<? extends S> original, Function<? super S, T> fun) {
            this.original = original;
            this.fun = fun;
        }

        @Override
        public MultiRef.It<T> iterate() {
            final MultiRef.It<? extends S> it = this.original.iterate();
            return new MultiRef.It<T>(){

                @Override
                @Nullable
                public T resolve() {
                    return fun.fun(it.resolve());
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    return (String)it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public Iterable<String> names() {
            return this.original.names();
        }

        @Override
        public Iterable<T> resolveObjects() {
            return JBIterable.from(this.original.resolveObjects()).filterMap(this.fun);
        }

        @Override
        public int size() {
            return this.original.size();
        }
    }
}

