/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DbModelRegistry;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.DvTreeIcons;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvFamilyDivision;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvRootDsGroup;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvUnnestFamily;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 02\u00020\u0001:\u000501234B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020\u0014J\u0014\u0010#\u001a\u00060\"R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020%H\u0002J \u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u00060\"R\u00020\u00000!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/view/DatabaseNodeWrappingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "modelRegistry", "Lcom/intellij/database/DbModelRegistry;", "getModelRegistry", "()Lcom/intellij/database/DbModelRegistry;", "modelRegistry$delegate", "Lkotlin/Lazy;", "treeStructure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "getTreeStructure", "()Lcom/intellij/database/view/structure/DvTreeStructure;", "treeStructure$delegate", "wrap", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "wrapElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "wrapRoot", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "unwrap", "o", "w", "wrappersCache", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/view/DatabaseNodeWrappingService$NodeWrapper;", "obtainCachedWrapper", "selectNode", "", "requestFocus", "", "deselectNodes", "navigateToData", "host", "childrenKind", "Lcom/intellij/database/model/ObjectKind;", "navigateToFakeData", "division", "Lcom/intellij/database/view/structure/DvFamilyDivision;", "Companion", "NodeWrapper", "FamilyWrapper", "DsGroupWrapper", "ExtraNodeWrapper", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseNodeWrappingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseNodeWrappingService.kt\ncom/intellij/database/view/DatabaseNodeWrappingService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,263:1\n31#2,2:264\n31#2,2:266\n*S KotlinDebug\n*F\n+ 1 DatabaseNodeWrappingService.kt\ncom/intellij/database/view/DatabaseNodeWrappingService\n*L\n36#1:264,2\n37#1:266,2\n*E\n"})
public final class DatabaseNodeWrappingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy modelRegistry$delegate;
    @NotNull
    private final Lazy treeStructure$delegate;
    @NotNull
    private final WeakHashMap<BasicNode, NodeWrapper> wrappersCache;
    @NotNull
    private static final Logger logger;

    public DatabaseNodeWrappingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modelRegistry$delegate = LazyKt.lazy(() -> DatabaseNodeWrappingService.modelRegistry_delegate$lambda$0(this));
        this.treeStructure$delegate = LazyKt.lazy(() -> DatabaseNodeWrappingService.treeStructure_delegate$lambda$1(this));
        this.wrappersCache = new WeakHashMap(1024);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DbModelRegistry getModelRegistry() {
        Lazy lazy = this.modelRegistry$delegate;
        return (DbModelRegistry)lazy.getValue();
    }

    private final DvTreeStructure getTreeStructure() {
        Lazy lazy = this.treeStructure$delegate;
        return (DvTreeStructure)lazy.getValue();
    }

    @Nullable
    public final PsiElement wrap(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? (node instanceof BasicRoot ? this.wrapRoot((BasicRoot)node) : this.wrapElement((BasicElement)node)) : (basicNode instanceof HostFamily ? (PsiElement)this.obtainCachedWrapper(node) : (basicNode instanceof DvDsGroup ? (PsiElement)this.obtainCachedWrapper(node) : (basicNode instanceof DataSourceNode ? (PsiElement)this.getModelRegistry().findDbDataSource((DataSourceNode)node) : (basicNode instanceof DvExtraNode ? (PsiElement)this.obtainCachedWrapper(node) : null))));
    }

    private final PsiElement wrapElement(BasicElement element) {
        DbElement w = this.getModelRegistry().findDbElement(element);
        return w;
    }

    private final PsiElement wrapRoot(BasicRoot root) {
        return this.getModelRegistry().findDbDataSource(root);
    }

    @Nullable
    public final BasicNode unwrap(@Nullable Object o) {
        BasicNode basicNode;
        Object object = o;
        if (object == null) {
            basicNode = null;
        } else if (object instanceof BasicNode) {
            basicNode = (BasicNode)o;
        } else if (object instanceof BasicModel) {
            DbModelRegistry dbModelRegistry = this.getModelRegistry();
            Object object2 = o;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModel");
            DbDataSource dbDataSource = dbModelRegistry.findDbDataSource((BasicModel)object2);
            basicNode = dbDataSource != null ? DataSourceNode.Companion.node(dbDataSource) : null;
        } else if (object instanceof PsiElement) {
            Object object3 = o;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
            basicNode = this.unwrap((PsiElement)object3);
        } else {
            basicNode = null;
        }
        return basicNode;
    }

    @Nullable
    public final BasicNode unwrap(@NotNull PsiElement w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        PsiElement psiElement = w;
        return psiElement instanceof DbElement ? DatabaseNodeWrappingService.Companion.unwrap((DbElement)w) : (psiElement instanceof NodeWrapper ? ((NodeWrapper)w).getNode() : null);
    }

    private final NodeWrapper obtainCachedWrapper(BasicNode node) {
        NodeWrapper nodeWrapper;
        NodeWrapper w = this.wrappersCache.get(node);
        if (w != null) {
            return w;
        }
        BasicNode basicNode = node;
        if (basicNode instanceof HostFamily) {
            nodeWrapper = new FamilyWrapper((HostFamily)node);
        } else if (basicNode instanceof DvDsGroup) {
            nodeWrapper = new DsGroupWrapper((DvDsGroup)node);
        } else if (basicNode instanceof DvExtraNode) {
            nodeWrapper = new ExtraNodeWrapper((DvExtraNode)node);
        } else {
            throw new IllegalArgumentException("Unknown how to wrap an instance of " + node.getClass().getSimpleName());
        }
        NodeWrapper newW = nodeWrapper;
        ((Map)this.wrappersCache).put(node, newW);
        return newW;
    }

    private final void selectNode(BasicNode node, boolean requestFocus) {
        DatabaseView.select(this.project, CollectionsKt.listOf((Object)node), requestFocus);
    }

    private final void deselectNodes() {
        DatabaseView.select(this.project, CollectionsKt.emptyList(), false);
    }

    private final void navigateToData(BasicElement host, ObjectKind childrenKind, boolean requestFocus) {
        PsiElement hostWrap = this.wrap(host);
        if (hostWrap instanceof DbElement) {
            DbNavigationUtils.navigateToData((DbElement)hostWrap, childrenKind, requestFocus);
        }
    }

    private final void navigateToFakeData(DvFamilyDivision division, boolean requestFocus) {
        BasicElement host = division.host;
        PsiElement hostWrap = this.wrap(host);
        if (hostWrap instanceof DbElement) {
            DvFamilyId fakeFamilyId = division.getFamilyId();
            ObjectKind requestingKind = fakeFamilyId.getFakeKind();
            DbNavigationUtils.navigateToData((DbElement)hostWrap, requestingKind, requestFocus);
        }
    }

    private static final DbModelRegistry modelRegistry_delegate$lambda$0(DatabaseNodeWrappingService this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DbModelRegistry)object;
    }

    private static final DvTreeStructureService treeStructure_delegate$lambda$1(DatabaseNodeWrappingService this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvTreeStructureService)object;
    }

    @JvmStatic
    private static final BasicNode unwrap(DbElement $this$unwrap) {
        return DatabaseNodeWrappingService.Companion.unwrap($this$unwrap);
    }

    static {
        Logger logger2 = Logger.getInstance(DatabaseNodeWrappingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\tH\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/DatabaseNodeWrappingService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "unwrap", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/psi/DbElement;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final BasicNode unwrap(DbElement $this$unwrap) {
            if ($this$unwrap instanceof DbDataSource) {
                return DataSourceNode.Companion.node((DbDataSource)$this$unwrap);
            }
            Object d = $this$unwrap.getDelegate();
            while (d != null) {
                Object object = d;
                if (object instanceof BasicNode) {
                    return (BasicNode)d;
                }
                if (object instanceof DbElement) {
                    d = ((DbElement)d).getDelegate();
                    continue;
                }
                d = null;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/view/DatabaseNodeWrappingService$DsGroupWrapper;", "Lcom/intellij/database/view/DatabaseNodeWrappingService$NodeWrapper;", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "group", "Lcom/intellij/database/view/structure/DvDsGroup;", "<init>", "(Lcom/intellij/database/view/DatabaseNodeWrappingService;Lcom/intellij/database/view/structure/DvDsGroup;)V", "getGroup", "()Lcom/intellij/database/view/structure/DvDsGroup;", "isRoot", "", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNode", "()Lcom/intellij/database/model/basic/BasicNode;", "getParent", "Lcom/intellij/psi/PsiElement;", "getName", "", "getIcon", "Ljavax/swing/Icon;", "open", "canNavigate", "navigate", "", "requestFocus", "isValid", "intellij.database.impl"})
    public final class DsGroupWrapper
    extends NodeWrapper {
        @NotNull
        private final DvDsGroup group;
        private final boolean isRoot;

        public DsGroupWrapper(DvDsGroup group) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            this.group = group;
            this.isRoot = this.group instanceof DvRootDsGroup;
        }

        @NotNull
        public final DvDsGroup getGroup() {
            return this.group;
        }

        @Override
        @NotNull
        public BasicNode getNode() {
            return this.group;
        }

        @Override
        @Nullable
        public PsiElement getParent() {
            if (this.isRoot) {
                return null;
            }
            return super.getParent();
        }

        @NotNull
        public String getName() {
            String string = this.group.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return string;
        }

        @NotNull
        public Icon getIcon(boolean open) {
            Icon icon = AllIcons.Nodes.Folder;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Folder");
            return icon;
        }

        @Override
        public boolean canNavigate() {
            return this.isValid() && !this.isRoot;
        }

        @Override
        public void navigate(boolean requestFocus) {
            if (this.isRoot) {
                DatabaseNodeWrappingService.this.deselectNodes();
            } else {
                super.navigate(requestFocus);
            }
        }

        @Override
        public boolean isValid() {
            return !this.getProject().isDisposed();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/view/DatabaseNodeWrappingService$ExtraNodeWrapper;", "Lcom/intellij/database/view/DatabaseNodeWrappingService$NodeWrapper;", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "node", "Lcom/intellij/database/view/structure/DvExtraNode;", "<init>", "(Lcom/intellij/database/view/DatabaseNodeWrappingService;Lcom/intellij/database/view/structure/DvExtraNode;)V", "getNode", "()Lcom/intellij/database/view/structure/DvExtraNode;", "getName", "", "getIcon", "Ljavax/swing/Icon;", "open", "", "canNavigate", "navigate", "", "requestFocus", "intellij.database.impl"})
    public final class ExtraNodeWrapper
    extends NodeWrapper {
        @NotNull
        private final DvExtraNode node;

        public ExtraNodeWrapper(DvExtraNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
        }

        @Override
        @NotNull
        public DvExtraNode getNode() {
            return this.node;
        }

        @NotNull
        public String getName() {
            String string = this.getNode().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return string;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DvTreeIcons.TREE_NODE_ITEMS.get((Object)this.getNode().getIconItem());
        }

        @Override
        public boolean canNavigate() {
            return WhenMappings.$EnumSwitchMapping$0[this.getNode().getTreeNodeRank().ordinal()] == 1;
        }

        @Override
        public void navigate(boolean requestFocus) {
            if (WhenMappings.$EnumSwitchMapping$0[this.getNode().getTreeNodeRank().ordinal()] == 1) {
                DvExtraNode dvExtraNode = this.getNode();
                if (dvExtraNode instanceof HostFamily) {
                    BasicElement basicElement = ((HostFamily)((Object)this.getNode())).getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
                    ObjectKind objectKind = ((HostFamily)((Object)this.getNode())).getChildrenKind();
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getChildrenKind(...)");
                    DatabaseNodeWrappingService.this.navigateToData(basicElement, objectKind, requestFocus);
                } else if (dvExtraNode instanceof DvUnnestFamily) {
                    DatabaseNodeWrappingService.this.navigateToData(((DvUnnestFamily)this.getNode()).host, ((DvUnnestFamily)this.getNode()).getChildrenKind(), requestFocus);
                } else if (dvExtraNode instanceof DvFamilyDivision) {
                    DatabaseNodeWrappingService.this.navigateToFakeData((DvFamilyDivision)this.getNode(), requestFocus);
                } else {
                    logger.warn("Unknown how to perform 'navigate to data' for node " + this.getNode() + " (class " + this.getNode().getClass().getSimpleName() + ")");
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DvTreeNodeRank.values().length];
                try {
                    nArray[DvTreeNodeRank.TL_FAMILY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/view/DatabaseNodeWrappingService$FamilyWrapper;", "Lcom/intellij/database/view/DatabaseNodeWrappingService$NodeWrapper;", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "family", "Lcom/intellij/database/model/families/HostFamily;", "<init>", "(Lcom/intellij/database/view/DatabaseNodeWrappingService;Lcom/intellij/database/model/families/HostFamily;)V", "getFamily", "()Lcom/intellij/database/model/families/HostFamily;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNode", "()Lcom/intellij/database/model/basic/BasicNode;", "getName", "", "getIcon", "Ljavax/swing/Icon;", "open", "", "toString", "navigate", "", "requestFocus", "intellij.database.impl"})
    public final class FamilyWrapper
    extends NodeWrapper {
        @NotNull
        private final HostFamily<?> family;

        public FamilyWrapper(HostFamily<?> family) {
            Intrinsics.checkNotNullParameter(family, (String)"family");
            this.family = family;
        }

        @NotNull
        public final HostFamily<?> getFamily() {
            return this.family;
        }

        @Override
        @NotNull
        public BasicNode getNode() {
            return this.family;
        }

        @NotNull
        public String getName() {
            return DvFun.getFamilyPresentableName(this.family);
        }

        @NotNull
        public Icon getIcon(boolean open) {
            Icon icon = DatabaseIcons.ObjectGroup;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ObjectGroup");
            return icon;
        }

        @Override
        @NotNull
        public String toString() {
            return DvFun.getFamilyPresentableName(this.family);
        }

        @Override
        public void navigate(boolean requestFocus) {
            DbModelRegistry dbModelRegistry = DatabaseNodeWrappingService.this.getModelRegistry();
            BasicElement basicElement = this.family.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
            DbElement host = dbModelRegistry.findDbElement(basicElement);
            if (host == null) {
                super.navigate(requestFocus);
            } else {
                DbNavigationUtils.navigateToData(host, this.family.getChildrenKind(), requestFocus);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/view/DatabaseNodeWrappingService$NodeWrapper;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/navigation/NavigationItem;", "<init>", "(Lcom/intellij/database/view/DatabaseNodeWrappingService;)V", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNode", "()Lcom/intellij/database/model/basic/BasicNode;", "getProject", "Lcom/intellij/openapi/project/Project;", "getManager", "Lcom/intellij/psi/PsiManager;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "getParent", "Lcom/intellij/psi/PsiElement;", "iterateChildren", "Lcom/intellij/util/containers/JBIterable;", "isValid", "getContainingFile", "", "toString", "", "intellij.database.impl"})
    public abstract class NodeWrapper
    extends FakePsiElement
    implements NavigationItem {
        @NotNull
        public abstract BasicNode getNode();

        @NotNull
        public Project getProject() {
            return DatabaseNodeWrappingService.this.getProject();
        }

        @NotNull
        public PsiManager getManager() {
            PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            return psiManager;
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            DatabaseNodeWrappingService.this.selectNode(this.getNode(), requestFocus);
        }

        @Nullable
        public PsiElement getParent() {
            BasicNode parentNode = DatabaseNodeWrappingService.this.getTreeStructure().parentOf(this.getNode());
            if (parentNode == null) {
                return null;
            }
            PsiElement parentWrapper = DatabaseNodeWrappingService.this.wrap(parentNode);
            return parentWrapper;
        }

        @NotNull
        public final JBIterable<PsiElement> iterateChildren() {
            JBIterable jBIterable = DatabaseNodeWrappingService.this.getTreeStructure().childrenOf(this.getNode()).filterMap(arg_0 -> NodeWrapper.iterateChildren$lambda$0((Function1)new Function1<BasicNode, PsiElement>((Object)DatabaseNodeWrappingService.this){

                public final PsiElement invoke(BasicNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DatabaseNodeWrappingService)this.receiver).wrap(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return jBIterable;
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public Void getContainingFile() {
            return null;
        }

        @NotNull
        public String toString() {
            return DatabaseNodeWrappingService.this.getTreeStructure().presentableNameOf(this.getNode());
        }

        private static final PsiElement iterateChildren$lambda$0(Function1 $tmp0, Object p0) {
            return (PsiElement)$tmp0.invoke(p0);
        }
    }
}

