/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseCopyPasteProvider;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseViewTreeComponent;
import com.intellij.database.view.DatabaseViewTreeComponentKt;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000234B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/view/DatabaseViewTreeComponent;", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "context", "Lcom/intellij/database/view/DatabaseTreeContext;", "myViewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "<init>", "(Lcom/intellij/database/view/DatabaseTreeContext;Lcom/intellij/database/view/structure/DvViewOptions;)V", "myTreeStructure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "getMyTreeStructure", "()Lcom/intellij/database/view/structure/DvTreeStructure;", "myTreeStructure$delegate", "Lkotlin/Lazy;", "myWrappingService", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "getMyWrappingService", "()Lcom/intellij/database/view/DatabaseNodeWrappingService;", "myWrappingService$delegate", "myCopyPasteProvider", "Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "viewport", "Lcom/intellij/ui/components/GradientViewport;", "getViewport", "()Lcom/intellij/ui/components/GradientViewport;", "myCellRenderer", "Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "setCopyPasteProvider", "", "copyPasteProvider", "getToggleClickCount", "", "getFileColorFor", "Ljava/awt/Color;", "object", "", "getFileColorForPath", "path", "Ljavax/swing/tree/TreePath;", "isFileColorsEnabled", "", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "onSelectionChange", "event", "Ljavax/swing/event/TreeSelectionEvent;", "getCellPresentation", "Lcom/intellij/navigation/ItemPresentation;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "CellRenderer", "MyGradientViewport", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseViewTreeComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseViewTreeComponent.kt\ncom/intellij/database/view/DatabaseViewTreeComponent\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,332:1\n31#2,2:333\n31#2,2:335\n*S KotlinDebug\n*F\n+ 1 DatabaseViewTreeComponent.kt\ncom/intellij/database/view/DatabaseViewTreeComponent\n*L\n57#1:333,2\n58#1:335,2\n*E\n"})
public final class DatabaseViewTreeComponent
extends DnDAwareTree {
    @NotNull
    private final DatabaseTreeContext context;
    @NotNull
    private final DvViewOptions myViewOptions;
    @NotNull
    private final Lazy myTreeStructure$delegate;
    @NotNull
    private final Lazy myWrappingService$delegate;
    @Nullable
    private DatabaseCopyPasteProvider myCopyPasteProvider;
    @NotNull
    private final GradientViewport viewport;
    @NotNull
    private final CellRenderer myCellRenderer;

    public DatabaseViewTreeComponent(@NotNull DatabaseTreeContext context, @NotNull DvViewOptions myViewOptions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)myViewOptions, (String)"myViewOptions");
        this.context = context;
        this.myViewOptions = myViewOptions;
        this.myTreeStructure$delegate = LazyKt.lazy(() -> DatabaseViewTreeComponent.myTreeStructure_delegate$lambda$0(this));
        this.myWrappingService$delegate = LazyKt.lazy(() -> DatabaseViewTreeComponent.myWrappingService_delegate$lambda$1(this));
        ClientProperty.put((JComponent)((JComponent)((Object)this)), (Key)JBViewport.ATTACH_STATUS_TEXT, (Object)true);
        this.viewport = new MyGradientViewport();
        this.putClientProperty(DefaultTreeUI.AUTO_EXPAND_ALLOWED, false);
        this.putClientProperty(BookmarksManager.ALLOWED, true);
        this.myCellRenderer = new CellRenderer();
        this.setCellRenderer(this.myCellRenderer);
        this.addMouseMotionListener(this.myCellRenderer);
        this.addMouseListener(this.myCellRenderer);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((JComponent)((Object)this)));
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        this.getSelectionModel().addTreeSelectionListener(arg_0 -> DatabaseViewTreeComponent._init_$lambda$2(this, arg_0));
    }

    private final DvTreeStructure getMyTreeStructure() {
        Lazy lazy = this.myTreeStructure$delegate;
        return (DvTreeStructure)lazy.getValue();
    }

    private final DatabaseNodeWrappingService getMyWrappingService() {
        Lazy lazy = this.myWrappingService$delegate;
        return (DatabaseNodeWrappingService)lazy.getValue();
    }

    @NotNull
    public final GradientViewport getViewport() {
        return this.viewport;
    }

    public final void setCopyPasteProvider(@NotNull DatabaseCopyPasteProvider copyPasteProvider) {
        Intrinsics.checkNotNullParameter((Object)copyPasteProvider, (String)"copyPasteProvider");
        this.myCopyPasteProvider = copyPasteProvider;
    }

    public int getToggleClickCount() {
        TreePath path;
        TreePath treePath = path = this.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        return object instanceof DasSchemaChild ? -1 : super.getToggleClickCount();
    }

    @Nullable
    public Color getFileColorFor(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        DasObject o;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = DatabaseColorManager.getLocalColorManager(this.context.getProject()).getState();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getState(...)");
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)object;
        if (!state.useColors || !state.inDatabaseView) {
            return null;
        }
        DbDataSource dataSource = DatabaseViewTreeComponentKt.access$findDbDataSourceInPath(path);
        DasObject dasObject = o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
        DbElement e = dasObject == null ? (DbElement)dataSource : DbImplUtilCore.findElement(dataSource, dasObject);
        return DatabaseColorManager.getColor(e);
    }

    public boolean isFileColorsEnabled() {
        if (this.context.getProject().isDisposed()) {
            return false;
        }
        Object object = DatabaseColorManager.getLocalColorManager(this.context.getProject()).getState();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getState(...)");
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)object;
        boolean enabled = state.useColors && state.inDatabaseView;
        boolean opaque = this.isOpaque();
        if (enabled && opaque) {
            this.setOpaque(false);
        } else if (!enabled && !opaque) {
            this.setOpaque(true);
        }
        return enabled;
    }

    protected void processKeyEvent(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getKeyCode() == 27 && this.context.isSomethingCut()) {
            DatabaseCopyPasteProvider databaseCopyPasteProvider = this.myCopyPasteProvider;
            Intrinsics.checkNotNull((Object)databaseCopyPasteProvider);
            databaseCopyPasteProvider.undoCut();
            e.consume();
            return;
        }
        super.processKeyEvent(e);
    }

    private final void onSelectionChange(TreeSelectionEvent event) {
        String string;
        int count = this.getSelectionModel().getSelectionCount();
        if (count > 1) {
            Object[] objectArray = new Object[]{count};
            string = DatabaseBundle.message("database.view.statusBar.selection.count", objectArray);
        } else {
            string = null;
        }
        String description = string;
        ActionMenu.Companion.showDescriptionInStatusBar(true, (Component)((Object)this), description);
    }

    @Nullable
    public final ItemPresentation getCellPresentation(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.myCellRenderer.getPresentationInner(node, false);
    }

    private static final DvTreeStructureService myTreeStructure_delegate$lambda$0(DatabaseViewTreeComponent this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.context.getProject();
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvTreeStructureService)object;
    }

    private static final DatabaseNodeWrappingService myWrappingService_delegate$lambda$1(DatabaseViewTreeComponent this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.context.getProject();
        boolean $i$f$service = false;
        Class<DatabaseNodeWrappingService> serviceClass$iv = DatabaseNodeWrappingService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DatabaseNodeWrappingService)object;
    }

    private static final void _init_$lambda$2(DatabaseViewTreeComponent this$0, TreeSelectionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.onSelectionChange(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0090\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0013\u001a\u00020\u000eH\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J@\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010/\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u00060"}, d2={"Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "Ljava/awt/event/MouseAdapter;", "Ljavax/swing/tree/TreeCellRenderer;", "<init>", "(Lcom/intellij/database/view/DatabaseViewTreeComponent;)V", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getPresentation", "()Lcom/intellij/ide/projectView/PresentationData;", "setPresentation", "(Lcom/intellij/ide/projectView/PresentationData;)V", "pathUnderMouse", "Ljavax/swing/tree/TreePath;", "nodeRenderer", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "getNodeRenderer", "()Lcom/intellij/ide/util/treeView/NodeRenderer;", "setNodeRenderer", "(Lcom/intellij/ide/util/treeView/NodeRenderer;)V", "createRenderer", "getCopyPresentationInner", "Lcom/intellij/navigation/ItemPresentation;", "o", "", "getPresentationInner", "node", "Lcom/intellij/database/model/basic/BasicNode;", "active", "", "isNodeCut", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "selected", "expanded", "leaf", "row", "", "hasFocus", "checkMouseOnTheLink", "e", "Ljava/awt/event/MouseEvent;", "mouseClicked", "", "mouseMoved", "mouseExited", "intellij.database.impl"})
    public class CellRenderer
    extends MouseAdapter
    implements TreeCellRenderer {
        @NotNull
        private PresentationData presentation = new PresentationData();
        @Nullable
        private TreePath pathUnderMouse;
        @NotNull
        private NodeRenderer nodeRenderer = this.createRenderer();

        @NotNull
        public final PresentationData getPresentation() {
            return this.presentation;
        }

        public final void setPresentation(@NotNull PresentationData presentationData) {
            Intrinsics.checkNotNullParameter((Object)presentationData, (String)"<set-?>");
            this.presentation = presentationData;
        }

        @NotNull
        public final NodeRenderer getNodeRenderer() {
            return this.nodeRenderer;
        }

        public final void setNodeRenderer(@NotNull NodeRenderer nodeRenderer) {
            Intrinsics.checkNotNullParameter((Object)nodeRenderer, (String)"<set-?>");
            this.nodeRenderer = nodeRenderer;
        }

        @NotNull
        protected NodeRenderer createRenderer() {
            return new NodeRenderer(this){
                final /* synthetic */ CellRenderer this$0;
                {
                    this.this$0 = $receiver;
                }

                protected ItemPresentation getPresentation(Object node) {
                    return node instanceof BasicNode ? (ItemPresentation)ReadAction.compute(() -> createRenderer.1.getPresentation$lambda$0(this.this$0, node)) : null;
                }

                private static final ItemPresentation getPresentation$lambda$0(CellRenderer this$0, Object $node) {
                    return this$0.getPresentationInner((BasicNode)$node, true);
                }
            };
        }

        @Nullable
        public final ItemPresentation getCopyPresentationInner(@Nullable Object o) {
            BasicNode node;
            Object object = o;
            BasicNode basicNode = node = object instanceof BasicNode ? (BasicNode)o : (object instanceof PsiElement ? DatabaseViewTreeComponent.this.getMyWrappingService().unwrap((PsiElement)o) : null);
            return basicNode != null ? this.getPresentationInner(basicNode, false) : null;
        }

        @Nullable
        public final ItemPresentation getPresentationInner(@NotNull BasicNode node, boolean active) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DbNodeDescriptor.updatePresentation(this.presentation, node, DatabaseViewTreeComponent.this.context.getProject(), DatabaseViewTreeComponent.this.myViewOptions, DatabaseViewTreeComponent.this.getMyTreeStructure(), this.pathUnderMouse, active, active);
            if (this.isNodeCut(node)) {
                this.presentation.setForcedTextForeground((Color)JBColor.LIGHT_GRAY);
            }
            return (ItemPresentation)this.presentation;
        }

        private final boolean isNodeCut(Object node) {
            DatabaseCopyPasteProvider provider = DatabaseViewTreeComponent.this.myCopyPasteProvider;
            return provider != null && provider.isNodeCut(node);
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Component component = this.nodeRenderer.getTreeCellRendererComponent(tree2, value, selected, expanded, leaf, row, hasFocus);
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.intellij.ui.SimpleColoredComponent");
            SimpleColoredComponent component2 = (SimpleColoredComponent)component;
            component2.setOpaque(false);
            component2.setIconOpaque(false);
            component2.setTransparentIconBackground(true);
            component2.setIconTextGap(JBUIScale.scale((int)5));
            return (Component)component2;
        }

        private final boolean checkMouseOnTheLink(MouseEvent e) {
            SimpleColoredComponent.ColoredIterator it;
            Object o;
            TreePath path;
            this.pathUnderMouse = null;
            TreePath treePath = path = DatabaseViewTreeComponent.this.getPathForLocation(e.getX(), e.getY());
            Object object = o = treePath != null ? treePath.getLastPathComponent() : null;
            if (!(o instanceof DataSourceNode || o instanceof BasicNamespaceOwner || o instanceof DvTreeLayoutLayer.EmptyScopeLeaf)) {
                return false;
            }
            LocalDataSource dataSource = DatabaseViewTreeComponentKt.access$findLocalDataSourceInPath(path);
            if (dataSource == null) {
                return false;
            }
            Rectangle bounds = DatabaseViewTreeComponent.this.getPathBounds(path);
            if (bounds == null) {
                return false;
            }
            int row = DatabaseViewTreeComponent.this.getRowForPath(path);
            Component component = this.getTreeCellRendererComponent((JTree)((Object)DatabaseViewTreeComponent.this), o, false, false, false, row, false);
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.intellij.ui.SimpleColoredComponent");
            SimpleColoredComponent component2 = (SimpleColoredComponent)component;
            int index = component2.findFragmentAt(e.getX() - bounds.x);
            SimpleColoredComponent.ColoredIterator coloredIterator = it = index < 0 ? null : component2.iterator(index);
            if (it != null && it.hasNext()) {
                it.next();
                if (it.getTextAttributes().isClickable()) {
                    this.pathUnderMouse = path;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Object o;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!UIUtil.isActionClick((MouseEvent)e, (int)500)) {
                return;
            }
            if (!this.checkMouseOnTheLink(e)) {
                return;
            }
            LocalDataSource dataSource = DatabaseViewTreeComponentKt.access$findLocalDataSourceInPath(this.pathUnderMouse);
            TreePath treePath = this.pathUnderMouse;
            Intrinsics.checkNotNull((Object)treePath);
            Object object = o = treePath.getLastPathComponent();
            BasicElement selection = object instanceof BasicElement ? (BasicElement)o : (object instanceof DvTreeLayoutLayer.EmptyScopeLeaf ? ((DvTreeLayoutLayer.EmptyScopeLeaf)o).host : null);
            Project project = DatabaseViewTreeComponent.this.context.getProject();
            LocalDataSource localDataSource = dataSource;
            Intrinsics.checkNotNull((Object)localDataSource);
            JBPopup jBPopup = DataSourceUiUtil.buildHiddenNamespacesPopup(project, localDataSource, selection);
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"buildHiddenNamespacesPopup(...)");
            JBPopup popup2 = jBPopup;
            Rectangle rectangle = DatabaseViewTreeComponent.this.getPathBounds(this.pathUnderMouse);
            Intrinsics.checkNotNull((Object)rectangle);
            Rectangle bounds = rectangle;
            popup2.show(new RelativePoint((Component)((Object)DatabaseViewTreeComponent.this), new Point(e.getX(), bounds.y + bounds.height)));
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Rectangle rectangle;
            Rectangle r1;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreePath p0 = this.pathUnderMouse;
            this.checkMouseOnTheLink(e);
            TreePath p1 = this.pathUnderMouse;
            if (p0 == null && p1 == null) {
                return;
            }
            Rectangle r0 = p0 == null ? null : DatabaseViewTreeComponent.this.getPathBounds(p0);
            Rectangle rectangle2 = r1 = p1 == null ? null : DatabaseViewTreeComponent.this.getPathBounds(p1);
            if (r0 == null && r1 == null) {
                return;
            }
            DatabaseViewTreeComponent.this.setCursor(Cursor.getPredefinedCursor(p1 != null ? 12 : 0));
            if (r0 == null) {
                rectangle = r1;
            } else {
                Rectangle rectangle3 = r1;
                rectangle = rectangle3 == null ? r0 : r0.union(rectangle3);
            }
            Rectangle clip = rectangle;
            DatabaseViewTreeComponent.this.repaint(clip);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.pathUnderMouse == null) {
                return;
            }
            DatabaseViewTreeComponent.this.setCursor(Cursor.getPredefinedCursor(0));
            Rectangle clip = DatabaseViewTreeComponent.this.getPathBounds(this.pathUnderMouse);
            if (clip != null) {
                DatabaseViewTreeComponent.this.repaint(clip);
            }
            this.pathUnderMouse = null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u001e\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/view/DatabaseViewTreeComponent$MyGradientViewport;", "Lcom/intellij/ui/components/GradientViewport;", "<init>", "(Lcom/intellij/database/view/DatabaseViewTreeComponent;)V", "myHeaderRenderer", "Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "Lcom/intellij/database/view/DatabaseViewTreeComponent;", "getMyHeaderRenderer", "()Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "setMyHeaderRenderer", "(Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;)V", "getHeaderPath", "Ljavax/swing/tree/TreePath;", "getHeader", "Ljava/awt/Component;", "findDataSourceOrGroupAt", "x", "", "y", "intellij.database.impl"})
    private final class MyGradientViewport
    extends GradientViewport {
        @NotNull
        private CellRenderer myHeaderRenderer;

        public MyGradientViewport() {
            super((Component)((Object)DatabaseViewTreeComponent.this), (Insets)JBUI.insetsTop((int)5), true);
            this.myHeaderRenderer = new CellRenderer(DatabaseViewTreeComponent.this, this){
                final /* synthetic */ MyGradientViewport this$0;
                {
                    this.this$0 = $receiver2;
                }

                protected NodeRenderer createRenderer() {
                    return new NodeRenderer(this, this.this$0){
                        final /* synthetic */ myHeaderRenderer.1 this$0;
                        final /* synthetic */ MyGradientViewport this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            ClientProperty.put((JComponent)((JComponent)((Object)this)), (Key)AnimatedIcon.REFRESH_DELEGATE, () -> myHeaderRenderer.createRenderer.1._init_$lambda$0(this));
                        }

                        protected ItemPresentation getPresentation(Object node) {
                            return (ItemPresentation)ReadAction.compute(() -> myHeaderRenderer.createRenderer.1.getPresentation$lambda$1(this.this$0, node));
                        }

                        public boolean isShowing() {
                            return this.this$1.isShowing() && MyGradientViewport.access$getHeaderPath(this.this$1) != null;
                        }

                        private static final void _init_$lambda$0(myHeaderRenderer.createRenderer.1 this$0) {
                            this$0.repaint(this$0.getBounds());
                        }

                        private static final ItemPresentation getPresentation$lambda$1(myHeaderRenderer.1 this$0, Object $node) {
                            return this$0.getCopyPresentationInner($node);
                        }
                    };
                }
            };
        }

        @NotNull
        public final CellRenderer getMyHeaderRenderer() {
            return this.myHeaderRenderer;
        }

        public final void setMyHeaderRenderer(@NotNull CellRenderer cellRenderer) {
            Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"<set-?>");
            this.myHeaderRenderer = cellRenderer;
        }

        private final TreePath getHeaderPath() {
            int x = DatabaseViewTreeComponent.this.getX();
            int y = DatabaseViewTreeComponent.this.getY();
            if (y == 0) {
                return null;
            }
            NodeRenderer headerComponent = this.myHeaderRenderer.getNodeRenderer();
            int height = headerComponent.getPreferredSize().height;
            TreePath path = this.findDataSourceOrGroupAt(-x, height + 3 - y);
            if (path == null) {
                return null;
            }
            TreePath pathAlt = this.findDataSourceOrGroupAt(-x, -y);
            return pathAlt != null && pathAlt.getLastPathComponent() != path.getLastPathComponent() ? null : path;
        }

        @Nullable
        protected Component getHeader() {
            TreePath path = this.getHeaderPath();
            if (path == null) {
                return null;
            }
            NodeRenderer headerComponent = this.myHeaderRenderer.getNodeRenderer();
            JTree jTree = (JTree)((Object)DatabaseViewTreeComponent.this);
            Object object = path.getLastPathComponent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLastPathComponent(...)");
            this.myHeaderRenderer.getTreeCellRendererComponent(jTree, object, false, false, true, 0, false);
            Color color = DatabaseViewTreeComponent.this.getFileColorForPath(path);
            headerComponent.setBackground(color);
            headerComponent.setOpaque(color != null);
            headerComponent.setTransparentIconBackground(color == null);
            return (Component)headerComponent;
        }

        private final TreePath findDataSourceOrGroupAt(int x, int y) {
            TreePath path;
            TreePath treePath = path = DatabaseViewTreeComponent.this.getClosestPathForLocation(x, y);
            TreePath treePath2 = path = treePath != null ? treePath.getParentPath() : null;
            while (path != null) {
                Object o = path.getLastPathComponent();
                TreePath parentPath = path.getParentPath();
                if (o instanceof DataSourceNode || o instanceof DvDsGroup || o instanceof DasDataSource) {
                    return parentPath == null ? null : path;
                }
                path = parentPath;
            }
            return null;
        }

        public static final /* synthetic */ TreePath access$getHeaderPath(MyGradientViewport $this) {
            return $this.getHeaderPath();
        }
    }
}

