/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.common.AtomicIncrementalValueCache;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.StringKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 A2\u00020\u0001:\u0002ABB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0018\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0&2\u0006\u0010\"\u001a\u00020!H\u0016J\u0018\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0&2\u0006\u0010(\u001a\u00020\u0015H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010(\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eH\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0*2\u0006\u0010(\u001a\u00020+H\u0002J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020!H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u0010\"\u001a\u00020!H\u0016J\u0015\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0010\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0010\u00a2\u0006\u0002\b5J\u001d\u00106\u001a\u00020\u00192\u0006\u00101\u001a\u0002022\u0006\u00107\u001a\u000208H\u0010\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b;J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010\"\u001a\u00020!H\u0016J\u0010\u0010?\u001a\u00020>2\u0006\u0010\"\u001a\u00020!H\u0016J\b\u0010@\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006C"}, d2={"Lcom/intellij/database/view/structure/DvTreeDsFoldersLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "level", "", "getLevel", "()B", "dataSources", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lcom/intellij/database/view/DataSourceNode;", "groupsCache", "Lcom/intellij/database/util/common/AtomicIncrementalValueCache;", "Lcom/intellij/database/view/structure/DvTreeDsFoldersLayer$Groups;", "groupingOption", "", "grouping", "getGrouping", "()Z", "rootGroup", "Lcom/intellij/database/view/structure/DvDsGroup;", "getRootGroup", "()Lcom/intellij/database/view/structure/DvDsGroup;", "setup", "", "base", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "retrieveAllDataSources", "recomputeGroups", "oldGroups", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "groupOfDataSource", "dsn", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "childrenOfGroup", "group", "listNestedGroups", "", "Lcom/intellij/database/view/structure/DvSimpleDsGroup;", "groups", "listNestedDataSources", "isAlwaysLeaf", "presentableNameOf", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "listAllDataSourceNodes", "countAllChildrenOf", "", "countRealChildrenOf", "clearAll", "Companion", "Groups", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeDsFoldersLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/view/structure/DvTreeDsFoldersLayer\n+ 2 DvTreeDsFoldersLayer.kt\ncom/intellij/database/view/structure/DvTreeDsFoldersLayer$Companion\n*L\n1#1,278:1\n206#2:279\n*S KotlinDebug\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/view/structure/DvTreeDsFoldersLayer\n*L\n63#1:279\n*E\n"})
public final class DvTreeDsFoldersLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentSkipListMap<String, DataSourceNode> dataSources = new ConcurrentSkipListMap();
    @NotNull
    private final AtomicIncrementalValueCache<Groups> groupsCache = new AtomicIncrementalValueCache<Groups>(noGroups, (Function1)new Function1<Groups, Groups>((Object)this){

        public final Groups invoke(Groups p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return DvTreeDsFoldersLayer.access$recomputeGroups((DvTreeDsFoldersLayer)this.receiver, p0);
        }
    });
    private volatile boolean groupingOption;
    @Deprecated
    public static final char KS = '\u0001';
    @NotNull
    private static final Groups noGroups = new Groups();

    @Override
    public byte getLevel() {
        return 2;
    }

    private final boolean getGrouping() {
        return this.groupingOption;
    }

    private final DvDsGroup getRootGroup() {
        BasicNode basicNode = this.getRoot();
        Intrinsics.checkNotNull((Object)basicNode, (String)"null cannot be cast to non-null type com.intellij.database.view.structure.DvDsGroup");
        return (DvDsGroup)basicNode;
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.groupsCache.reset();
        this.groupingOption = this.getVo().getGroupDataSources();
        if (this.groupingOption) {
            this.retrieveAllDataSources();
        }
    }

    private final void retrieveAllDataSources() {
        for (DataSourceNode dsn : this.listAllDataSourceNodes()) {
            Map map2 = this.dataSources;
            Object object = Companion;
            Intrinsics.checkNotNull((Object)dsn);
            DataSourceNode $this$key$iv = dsn;
            boolean $i$f$getKey = false;
            String string = $this$key$iv.getGroupName();
            if (string == null) {
                string = "";
            }
            object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001\u0002\u0001", "\u0001", "\u0001"}, (String)string, $this$key$iv.getDisplayName(), $this$key$iv.rawDataSource.getUniqueId());
            map2.put(object, dsn);
        }
        this.groupsCache.invalidate();
    }

    private final Groups recomputeGroups(Groups oldGroups) {
        Collection<DataSourceNode> collection = this.dataSources.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List paths = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), DvTreeDsFoldersLayer::recomputeGroups$lambda$0));
        Groups newGroups = !((Collection)paths).isEmpty() ? new Groups(paths, this.getRootGroup(), (Map<String, DvSimpleDsGroup>)oldGroups.all) : noGroups;
        return newGroups;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.getGrouping()) {
            BasicNode basicNode2 = node;
            if (basicNode2 instanceof DataSourceNode) {
                DvDsGroup dvDsGroup = this.groupOfDataSource((DataSourceNode)node);
                basicNode = dvDsGroup != null ? (BasicNode)dvDsGroup : this.getRoot();
            } else {
                basicNode = basicNode2 instanceof DvSimpleDsGroup ? (BasicNode)((DvSimpleDsGroup)node).getParent$intellij_database_core_impl() : this.getBase().parentOf(node);
            }
        } else {
            basicNode = this.getBase().parentOf(node);
        }
        return basicNode;
    }

    private final DvDsGroup groupOfDataSource(DataSourceNode dsn) {
        String path = dsn.getGroupName();
        CharSequence charSequence = path;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return this.groupsCache.getContent().get(path);
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getGrouping() && node instanceof DvDsGroup ? this.childrenOfGroup((DvDsGroup)node) : this.getBase().childrenOf(node);
    }

    private final JBIterable<? extends BasicNode> childrenOfGroup(DvDsGroup group) {
        Groups groups = this.groupsCache.getContent();
        Iterable<DvSimpleDsGroup> theGroups = null;
        Iterable<DataSourceNode> theDataSources = null;
        DvDsGroup dvDsGroup = group;
        if (Intrinsics.areEqual((Object)dvDsGroup, (Object)this.getRoot())) {
            theGroups = (Iterable<DvSimpleDsGroup>)groups.top;
            theDataSources = this.dataSources.subMap((Object)"\u0001", (Object)"\u0001\uffff").values();
        } else if (dvDsGroup instanceof DvSimpleDsGroup) {
            theGroups = this.listNestedGroups((DvSimpleDsGroup)group, groups);
            theDataSources = this.listNestedDataSources((DvSimpleDsGroup)group);
        } else {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(theGroups).append(theDataSources);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"append(...)");
        return jBIterable;
    }

    private final Iterable<DvSimpleDsGroup> listNestedGroups(DvSimpleDsGroup group, Groups groups) {
        String path = group.getPath();
        String from = path + "/";
        String till = path + "/\uffff";
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)groups.all.subMap(from, till).values()).filter(arg_0 -> DvTreeDsFoldersLayer.listNestedGroups$lambda$2(arg_0 -> DvTreeDsFoldersLayer.listNestedGroups$lambda$1(group, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return (Iterable)jBIterable;
    }

    private final Iterable<DataSourceNode> listNestedDataSources(DvSimpleDsGroup group) {
        String path = group.getPath();
        CallSite from = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)path);
        CallSite till = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001\uffff"}, (String)path);
        return this.dataSources.subMap(from, till).values();
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? false : this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvSimpleDsGroup ? ((DvSimpleDsGroup)node).getDisplayName() : this.getBase().presentableNameOf(node);
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.retrieveAllDataSources();
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        MapFun.removeIf(this.dataSources, arg_0 -> DvTreeDsFoldersLayer.onDataSourcePathChanged$lambda$3(dataSource, arg_0));
        this.retrieveAllDataSources();
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        MapFun.removeIf(this.dataSources, arg_0 -> DvTreeDsFoldersLayer.onDataSourceRemoved$lambda$4(dataSource, arg_0));
        this.groupsCache.invalidate();
    }

    @Override
    public void onViewOptionsChanged$intellij_database_core_impl() {
        boolean newGroupingOption = this.getVo().getGroupDataSources();
        if (newGroupingOption == this.groupingOption) {
            return;
        }
        this.groupingOption = newGroupingOption;
        if (this.groupingOption) {
            this.retrieveAllDataSources();
        } else {
            this.groupsCache.reset();
        }
    }

    private final JBIterable<DataSourceNode> listAllDataSourceNodes() {
        JBIterable jBIterable = this.getBase().childrenOf(this.getRoot()).filter(DataSourceNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? this.childrenOfGroup((DvDsGroup)node).size() : this.getBase().countAllChildrenOf(node);
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? this.childrenOfGroup((DvDsGroup)node).size() : this.getBase().countRealChildrenOf(node);
    }

    @Override
    public void clearAll() {
        this.groupsCache.invalidate();
    }

    private static final String recomputeGroups$lambda$0(DataSourceNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getGroupName();
        return StringKt.nullize((String)(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null), (boolean)true);
    }

    private static final boolean listNestedGroups$lambda$1(DvSimpleDsGroup $group, DvSimpleDsGroup it) {
        return it.getParent$intellij_database_core_impl() == $group;
    }

    private static final boolean listNestedGroups$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onDataSourcePathChanged$lambda$3(RawDataSource $dataSource, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return ((DataSourceNode)e.getValue()).rawDataSource == $dataSource;
    }

    private static final boolean onDataSourceRemoved$lambda$4(RawDataSource $dataSource, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return ((DataSourceNode)e.getValue()).rawDataSource == $dataSource;
    }

    public static final /* synthetic */ Groups access$recomputeGroups(DvTreeDsFoldersLayer $this, Groups oldGroups) {
        return $this.recomputeGroups(oldGroups);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/structure/DvTreeDsFoldersLayer$Companion;", "", "<init>", "()V", "KS", "", "key", "", "Lcom/intellij/database/view/DataSourceNode;", "getKey", "(Lcom/intellij/database/view/DataSourceNode;)Ljava/lang/String;", "noGroups", "Lcom/intellij/database/view/structure/DvTreeDsFoldersLayer$Groups;", "getNoGroups", "()Lcom/intellij/database/view/structure/DvTreeDsFoldersLayer$Groups;", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getKey(@NotNull DataSourceNode $this$key) {
            Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
            boolean $i$f$getKey = false;
            String string = $this$key.getGroupName();
            if (string == null) {
                string = "";
            }
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001\u0002\u0001", "\u0001", "\u0001"}, (String)string, $this$key.getDisplayName(), $this$key.rawDataSource.getUniqueId());
        }

        @NotNull
        public final Groups getNoGroups() {
            return noGroups;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B3\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fJ\u0013\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/view/structure/DvTreeDsFoldersLayer$Groups;", "", "paths", "", "", "root", "Lcom/intellij/database/view/structure/DvDsGroup;", "existentGroups", "", "Lcom/intellij/database/view/structure/DvSimpleDsGroup;", "<init>", "(Ljava/util/Collection;Lcom/intellij/database/view/structure/DvDsGroup;Ljava/util/Map;)V", "()V", "top", "", "all", "Ljava/util/NavigableMap;", "filled", "", "get", "path", "toString", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeDsFoldersLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/view/structure/DvTreeDsFoldersLayer$Groups\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1010#2,2:279\n*S KotlinDebug\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/view/structure/DvTreeDsFoldersLayer$Groups\n*L\n259#1:279,2\n*E\n"})
    private static final class Groups {
        @JvmField
        @NotNull
        public final List<DvSimpleDsGroup> top;
        @JvmField
        @NotNull
        public final NavigableMap<String, DvSimpleDsGroup> all;
        @JvmField
        public final boolean filled;

        public Groups(@NotNull Collection<String> paths, @NotNull DvDsGroup root, @NotNull Map<String, DvSimpleDsGroup> existentGroups) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(existentGroups, (String)"existentGroups");
            ArrayList<DvSimpleDsGroup> top = new ArrayList<DvSimpleDsGroup>();
            TreeMap<String, DvSimpleDsGroup> all2 = new TreeMap<String, DvSimpleDsGroup>();
            for (String path : paths) {
                Groups._init_$obtainGroup(all2, existentGroups, root, top, path);
            }
            List $this$sortBy$iv = top;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DvSimpleDsGroup it = (DvSimpleDsGroup)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (DvSimpleDsGroup)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
            }
            this.all = all2;
            this.top = top;
            this.filled = !((Map)all2).isEmpty();
        }

        public Groups() {
            this.all = Collections.emptyNavigableMap();
            this.top = Collections.emptyList();
            this.filled = false;
        }

        @Nullable
        public final DvSimpleDsGroup get(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return (DvSimpleDsGroup)this.all.get(path);
        }

        @NotNull
        public String toString() {
            return "Groups(" + this.top.size() + " top, " + this.all.size() + " all)";
        }

        private static final void _init_$handleExistentGroup(DvDsGroup $root, ArrayList<DvSimpleDsGroup> top, TreeMap<String, DvSimpleDsGroup> all2, DvSimpleDsGroup group) {
            DvDsGroup p2 = group.getParent$intellij_database_core_impl();
            if (p2 instanceof DvSimpleDsGroup) {
                Groups._init_$handleExistentGroup($root, top, all2, (DvSimpleDsGroup)p2);
            } else if (Intrinsics.areEqual((Object)p2, (Object)$root) && !top.contains(group)) {
                ((Collection)top).add(group);
            }
            ((Map)all2).put(group.getPath(), group);
        }

        private static final DvSimpleDsGroup _init_$obtainGroup(TreeMap<String, DvSimpleDsGroup> all2, Map<String, DvSimpleDsGroup> $existentGroups, DvDsGroup $root, ArrayList<DvSimpleDsGroup> top, String path) {
            DvSimpleDsGroup g = all2.get(path);
            if (g == null && (g = $existentGroups.get(path)) != null) {
                Groups._init_$handleExistentGroup($root, top, all2, g);
            }
            if (g == null) {
                int k = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (k > 0) {
                    String string = path.substring(k + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String name2 = string;
                    String string2 = path.substring(0, k);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String parentPath = string2;
                    DvSimpleDsGroup parent = Groups._init_$obtainGroup(all2, $existentGroups, $root, top, parentPath);
                    g = new DvSimpleDsGroup(parent, name2);
                } else {
                    g = new DvSimpleDsGroup($root, path);
                    ((Collection)top).add(g);
                }
                ((Map)all2).put(path, g);
            }
            return g;
        }
    }
}

