/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseDataSourceAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveConfigurable;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlAnnotator;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.intentions.SqlQualificationIntentionBase;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGrantStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlRevokeStatement;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.NotImplementedError;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlResolveInspection
extends SqlInspectionBase {
    public boolean suppressForPossibleStringLiterals;
    public boolean suppressForLabelBackReferences;
    private static final int MAX_COL_NAME_LENGTH = 30;
    @Language(value="jvm-field-name")
    public static final String OPTION_SUPPRESS_FOR_STRING_LITERALS = "suppressForPossibleStringLiterals";
    @Language(value="jvm-field-name")
    public static final String OPTION_SUPPRESS_FOR_LABEL_BACK_REFS = "suppressForLabelBackReferences";

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlFile file, final @NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        Boolean frankenstein;
        if (file == null) {
            SqlResolveInspection.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlResolveInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlResolveInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(3);
        }
        if ((frankenstein = (Boolean)file.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION)) != null && frankenstein.booleanValue()) {
            return null;
        }
        final SyntaxTraverser traverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().filter(Conditions.instanceOf(SqlReferenceExpression.class));
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){
            final Map<PsiFile, List<DbDataSource>> dataSources;
            private boolean myRefreshFixInitialized;
            private RefreshSchemaFix myRefreshSchemaFix;
            {
                super(arg0, arg1, arg2);
                this.dataSources = FactoryMap.create(o -> SqlImplUtil.getDataSources((PsiElement)o));
                this.myRefreshFixInitialized = false;
                this.myRefreshSchemaFix = null;
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression re) {
                if (re == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement element : (SyntaxTraverser)traverser.withRoot((Object)re)) {
                    SqlReferenceExpression o = (SqlReferenceExpression)element;
                    if (SqlImplUtil.isRefWithDblink((PsiElement)o)) continue;
                    if (this.shouldNotCheckElement((SqlElement)o)) {
                        return;
                    }
                    SqlReferenceElementType refType = o.getReferenceElementType();
                    ObjectKind type = refType.getTargetKind();
                    if (refType == SqlCompositeElementTypes.SQL_OPTIONAL_REFERENCE || !this.myDialect.shallResolve(o, type)) {
                        return;
                    }
                    if (o instanceof SqlPositionalReference && o.resolve() == null) {
                        Iterator elementToReport = (PsiElement)ObjectUtils.notNull((Object)((SqlPositionalReference)o).getPositionElement(), (Object)o);
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)elementToReport, SqlBundle.message((String)"inspection.message.invalid.column.index", (Object[])new Object[0]), true, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, LocalQuickFix.EMPTY_ARRAY));
                        return;
                    }
                    for (SqlReferenceExpression subRef : SqlImplUtil.sqlChildren((PsiElement)o).filter(SqlReferenceExpression.class)) {
                        if (!dialect.isMultiIdReference(subRef)) continue;
                        this.visitSqlReferenceExpression(subRef);
                    }
                    SqlExpression qualifier = o.getQualifierExpression();
                    SqlIdentifier idElement = o.getIdentifier();
                    if (idElement == null) {
                        idElement = SqlImplUtil.getAsterisk((PsiElement)o);
                    }
                    boolean afterIfExists = this.afterIfExistsClause(o);
                    if (qualifier instanceof SqlReferenceExpression) {
                        if (((SqlReferenceExpression)qualifier).resolve() == null) continue;
                        this.checkIdentifier((PsiElement)idElement, afterIfExists);
                        break;
                    }
                    this.checkIdentifier((PsiElement)idElement, afterIfExists);
                }
            }

            private void checkIdentifier(@Nullable PsiElement identifier, boolean afterIfExists) {
                if (identifier == null || afterIfExists) {
                    return;
                }
                this.checkResolve(identifier);
            }

            private boolean afterIfExistsClause(@NotNull SqlReferenceExpression o) {
                PsiElement parent;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ((parent = o.getParent()) instanceof SqlDropStatement || parent instanceof SqlAlterStatement || parent instanceof SqlAlterInstruction) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)o.getNode(), (IElementType)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (IElementType[])new IElementType[0]);
            }

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.getParent() instanceof SqlRenameToClause) {
                    return;
                }
                this.checkResolve((PsiElement)o);
            }

            public void visitSqlParameter(SqlParameter o) {
            }

            private boolean checkResolve(@Nullable PsiElement o) {
                String name2;
                SqlFunctionCallExpression foo;
                boolean isFunction;
                SqlExpression expr;
                SqlReferenceExpression ref2;
                ResolveResult[] results2;
                PsiElement grandPa;
                if (o == null || o.getTextLength() == 0) {
                    return false;
                }
                IElementType firstChildType = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
                if (firstChildType == SqlTokens.SQL_EXTERNAL_PARAM || firstChildType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || firstChildType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE) {
                    return true;
                }
                if (o.getFirstChild() instanceof SqlParameter) {
                    return true;
                }
                if (o.getLastChild() instanceof SqlParameter) {
                    return true;
                }
                PsiElement parent = o.getParent();
                PsiElement psiElement = grandPa = parent == null ? null : parent.getParent();
                if (this.isPossibleStringLiteral(o) && SqlResolveInspection.this.suppressForPossibleStringLiterals) {
                    return true;
                }
                if (SqlResolveInspection.this.suppressForLabelBackReferences && parent instanceof SqlReferenceExpression && ((SqlReferenceExpression)parent).getReferenceElementType() == SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE) {
                    return true;
                }
                if (parent instanceof SqlReferenceExpression && grandPa instanceof SqlDefinition && grandPa instanceof SqlAlterStatement) {
                    return this.checkAlterResolve(o, (SqlDefinition)grandPa);
                }
                PsiElement target2 = SqlAnnotator.getTargetByIdElement(o, true);
                if (SqlFileImpl.isUnresolved(target2)) {
                    target2 = null;
                }
                boolean softHighlighting = false;
                if (target2 instanceof SqlReferenceExpression && (results2 = (ref2 = (SqlReferenceExpression)target2).multiResolve(false)).length == 1 && SqlImplUtil.isMarkedUnresolved(results2[0])) {
                    target2 = null;
                    softHighlighting = true;
                }
                boolean isStar = "*".equals(o.getText());
                if (target2 == parent && isStar && (!(parent instanceof SqlExpression) || DasTypeSystemBase.UNKNOWN == (expr = (SqlExpression)parent).getDasType())) {
                    SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)o, SqlStatement.class);
                    if (st instanceof SqlGrantStatement || st instanceof SqlRevokeStatement) {
                        return true;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor(o, SqlBundle.message((String)"inspection.message.unable.to.resolve.in.this.context", (Object[])new Object[0]), true, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, new LocalQuickFix[0]));
                    return false;
                }
                if (target2 instanceof DasSynonym && onTheFly) {
                    DasNamespace namespace = ((DasSynonym)target2).getTargetNamespace();
                    if (namespace == null) {
                        return true;
                    }
                    JBIterable dsToIntrospect = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)file)).filter(ds -> {
                        LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource(ds);
                        return lds != null && !DataSourceSchemaMapping.isIntrospected(lds.getIntrospectionScope(), namespace);
                    });
                    if (dsToIntrospect.isEmpty()) {
                        return true;
                    }
                    ObjectPath namespacePath = ObjectPaths.of(namespace);
                    IntrospectSchemaFix fix = new IntrospectSchemaFix(dsToIntrospect.map(ds -> Pair.create((Object)ds, (Object)namespacePath)).toList(), namespace.getKind());
                    this.addDescriptor(manager.createProblemDescriptor(o, SqlBundle.message((String)"unable.to.resolve.synonym.target", (Object[])new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.WEAK_WARNING, onTheFly));
                }
                if (target2 != null) {
                    return true;
                }
                if (isStar && !SqlImplUtil.isAsteriskRef(parent)) {
                    return true;
                }
                ObjectKind expectedType = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                boolean bl = isFunction = expectedType == ObjectKind.ROUTINE;
                if (isFunction && parent.getParent().getParent() instanceof JdbcProcedureCall) {
                    return true;
                }
                SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
                if (expectedType == ObjectKind.ARGUMENT && (foo = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)api.parents((Object)parent).skip(3).first(), SqlFunctionCallExpression.class)) != null) {
                    if (foo.getParent() instanceof JdbcProcedureCall) {
                        return true;
                    }
                    name2 = foo.getNameElement();
                    if (name2 == null || name2.resolve() == null) {
                        return true;
                    }
                }
                String kindName = DbPresentationCore.getPresentableName(expectedType, SqlImplUtil.getSqlDialectSafe(o).getDbms());
                String string = name2 = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
                if (o instanceof SqlIdentifier && o.getFirstChild() instanceof OuterLanguageElement) {
                    return true;
                }
                String message = isFunction ? SqlBundle.message((String)"unknown.function", (Object[])new Object[]{name2}) : (expectedType != SqlDbElementType.ANY ? SqlBundle.message((String)"unable.to.resolve.symbol.0.1", (Object[])new Object[]{kindName, name2}) : SqlBundle.message((String)"unable.to.resolve.symbol.0", (Object[])new Object[]{name2}));
                List<LocalQuickFix> fixes = this.createQuickFixesFor(o, parent, expectedType);
                ProblemHighlightType highlightType = softHighlighting ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                this.addDescriptor(this.myManager.createProblemDescriptor(o, message, true, highlightType, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                return false;
            }

            private boolean checkAlterResolve(PsiElement o, SqlDefinition def) {
                boolean resolved;
                Object[] elements = SqlImplUtil.getRelatedElements(def);
                boolean bl = resolved = elements.length != 0;
                if (resolved) {
                    PsiElement res2 = (PsiElement)JBIterable.of((Object[])elements).filter(x -> !(x instanceof SqlAlterStatement)).first();
                    boolean bl2 = resolved = res2 != null;
                }
                if (!resolved) {
                    String name2 = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
                    String message = SqlBundle.message((String)"unable.to.resolve.symbol.0.1", (Object[])new Object[]{def.getKind(), name2});
                    List<LocalQuickFix> fixes = this.createQuickFixesFor(o, o.getParent(), def.getKind());
                    this.addDescriptor(this.myManager.createProblemDescriptor(o, message, true, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                }
                return resolved;
            }

            private boolean isPossibleStringLiteral(@NotNull PsiElement o) {
                SqlReferenceExpression ref2;
                PsiElement psiElement;
                Dbms dbms;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                return ((dbms = dialect.getDbms()).isMysql() || dbms.isSqlite()) && o instanceof SqlIdentifier && ((SqlIdentifier)o).isQuotedIdentifier() && (psiElement = o.getParent()) instanceof SqlReferenceExpression && (ref2 = (SqlReferenceExpression)psiElement).getQualifierExpression() == null;
            }

            private boolean isInsertIntoArg(@NotNull PsiElement o) {
                SqlInsertDmlInstruction insert;
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((insert = (SqlInsertDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)o, SqlInsertDmlInstruction.class, (boolean)true, (Class[])new Class[]{SqlStatement.class})) == null) {
                    return false;
                }
                SqlTableColumnsList list = insert.getColumnsList();
                if (list == null) {
                    return false;
                }
                SqlReferenceExpression reference = list.getTableReference();
                return reference != null && PsiTreeUtil.isAncestor((PsiElement)reference, (PsiElement)o, (boolean)true);
            }

            private boolean addFixesByExpectedType(@NotNull PsiElement o, @Nullable PsiElement parent, @NotNull ObjectKind expectedType, @NotNull List<LocalQuickFix> result2) {
                block16: {
                    block19: {
                        SqlReferenceExpression parentRef;
                        block17: {
                            PsiElement resolveResult;
                            block20: {
                                DbTable dbTable;
                                SqlAsExpression asExpr;
                                SqlExpression sqlExpression;
                                PsiElement resolve2;
                                block18: {
                                    DbTable dbTable2;
                                    SqlExpression qualifierExpression;
                                    LeafPsiElement beginKeyword;
                                    SqlLanguageDialectEx dialect2;
                                    Dbms dbms;
                                    if (o == null) {
                                        1.$$$reportNull$$$0(5);
                                    }
                                    if (expectedType == null) {
                                        1.$$$reportNull$$$0(6);
                                    }
                                    if (result2 == null) {
                                        1.$$$reportNull$$$0(7);
                                    }
                                    PsiFile containingFile = o.getContainingFile();
                                    boolean isInjected = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).isInjectedFragment(containingFile);
                                    if (expectedType == ObjectKind.TABLE) {
                                        Dbms dbms2;
                                        if (!isInjected) {
                                            result2.add((LocalQuickFix)new AddSqlTableFix(o, false));
                                        }
                                        result2.add((LocalQuickFix)new AddDbTableFix(o));
                                        if (!isInjected && this.isInsertIntoArg(o) && AddSqlTableFix.supportsNonVarTemporaryTables(dbms2 = SqlImplUtil.getSqlDialectSafe(o).getDbms())) {
                                            result2.add((LocalQuickFix)new AddSqlTableFix(o, true));
                                        }
                                        return true;
                                    }
                                    if (expectedType == ObjectKind.VARIABLE) {
                                        if (!isInjected && this.isInsertIntoArg(o)) {
                                            if (SqlImplUtil.getSqlDialectSafe(o).getDbms().isMicrosoft()) {
                                                result2.add((LocalQuickFix)new AddSqlTableFix(o, true));
                                            }
                                            return true;
                                        }
                                        String text = DeclareUserVariableFix.wrapVariableText(o);
                                        if (text != null) {
                                            result2.add((LocalQuickFix)new DeclareUserVariableFix(o, text));
                                        }
                                        return true;
                                    }
                                    if (expectedType != ObjectKind.COLUMN) break block16;
                                    if (!(parent instanceof SqlReferenceExpression)) {
                                        return true;
                                    }
                                    parentRef = (SqlReferenceExpression)parent;
                                    SqlBlockStatement blockStatement = (SqlBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, SqlBlockStatement.class);
                                    if (blockStatement != null && DeclarePlVariableFix.supportsPlSql(dbms = (dialect2 = SqlImplUtil.getSqlDialectSafe((PsiElement)blockStatement)).getDbms()) && (beginKeyword = (LeafPsiElement)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == SqlCommonKeywords.SQL_BEGIN).first()) != null) {
                                        result2.add((LocalQuickFix)new DeclarePlVariableFix(o));
                                    }
                                    if (!((qualifierExpression = parentRef.getQualifierExpression()) instanceof SqlReferenceExpression)) break block17;
                                    SqlReferenceExpression qualifierRef = (SqlReferenceExpression)qualifierExpression;
                                    resolve2 = qualifierRef.getReference().resolve();
                                    if (!(resolve2 instanceof DbTable) || (dbTable2 = (DbTable)resolve2).getKind() != ObjectKind.TABLE) break block18;
                                    result2.add((LocalQuickFix)new AddDbColumnFix(o, dbTable2));
                                    break block19;
                                }
                                if (!(resolve2 instanceof SqlAsExpression) || !((sqlExpression = (asExpr = (SqlAsExpression)resolve2).getExpression()) instanceof SqlReferenceExpression)) break block19;
                                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
                                resolveResult = sqlReferenceExpression.getReference().resolve();
                                if (!(resolveResult instanceof DbTable) || (dbTable = (DbTable)resolveResult).getKind() != ObjectKind.TABLE) break block20;
                                result2.add((LocalQuickFix)new AddDbColumnFix(o, dbTable));
                                break block19;
                            }
                            if (!(resolveResult instanceof SqlCreateTableStatement)) break block19;
                            result2.add((LocalQuickFix)new AddSqlColumnFix(o, (SqlCreateTableStatement)resolveResult));
                            break block19;
                        }
                        SqlReferenceImpl reference = (SqlReferenceImpl)ObjectUtils.tryCast((Object)parentRef.getReference(), SqlReferenceImpl.class);
                        if (reference != null) {
                            MyResolveContextProcessor processor2 = new MyResolveContextProcessor(reference.getReferenceName(), this.myDialect, this.dataSources.get(parent.getContainingFile()), parent);
                            if (reference.initExpectedTargetTypes(processor2)) {
                                reference.processResolveVariants(processor2);
                            }
                            for (DbTable dbTable : processor2.dbTables) {
                                if (dbTable.getKind() != ObjectKind.TABLE) continue;
                                result2.add((LocalQuickFix)new AddDbColumnFix(o, dbTable));
                            }
                            for (SqlCreateTableStatement sqlCreateTableStatement : processor2.sqlTables) {
                                result2.add((LocalQuickFix)new AddSqlColumnFix(o, sqlCreateTableStatement));
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            private void addRefreshFix(@NotNull List<LocalQuickFix> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!this.myRefreshFixInitialized) {
                    ObjectPath path;
                    PsiFile topLevelFile;
                    VirtualFile vfile;
                    this.myRefreshFixInitialized = true;
                    Project project = file.getProject();
                    JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, vfile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile());
                    ObjectPath objectPath = path = console == null ? null : console.getCurrentNamespace();
                    if (path == null) {
                        return;
                    }
                    DbDataSource dbDataSource = DbPsiFacade.getInstance(project).findDataSource(console.getDataSource().getUniqueId());
                    LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dbDataSource);
                    if (localDataSource == null) {
                        return;
                    }
                    DasObject namespace = (DasObject)QNameUtil.findByPath(console.getDataSource().getModel(), path).first();
                    if (namespace == null) {
                        return;
                    }
                    this.myRefreshSchemaFix = new RefreshSchemaFix(localDataSource, namespace);
                }
                if (this.myRefreshSchemaFix != null) {
                    result2.add((LocalQuickFix)this.myRefreshSchemaFix);
                }
            }

            private void addIntrospectFixesForQualifier(@Nullable PsiElement element, @NotNull List<LocalQuickFix> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (!(element instanceof SqlReferenceExpression)) {
                    return;
                }
                SqlExpression qualifierExpression = ((SqlReferenceExpression)element).getQualifierExpression();
                if (!(qualifierExpression instanceof SqlReferenceExpression)) {
                    return;
                }
                SqlIdentifier qualifierIdentifier = ((SqlReferenceExpression)qualifierExpression).getIdentifier();
                if (qualifierIdentifier == null) {
                    return;
                }
                PsiElement qualifier = ((SqlReferenceExpression)qualifierExpression).resolve();
                if (!(qualifier instanceof DasObject)) {
                    return;
                }
                ObjectKind kind = ((DasObject)qualifier).getKind();
                if (kind == ObjectKind.SCHEMA || kind == ObjectKind.DATABASE) {
                    this.addIntrospectFixes((PsiElement)qualifierIdentifier, (PsiElement)qualifierExpression, result2);
                }
            }

            @NotNull
            private List<LocalQuickFix> createQuickFixesFor(@NotNull PsiElement o, @Nullable PsiElement parent, @NotNull ObjectKind expectedType) {
                boolean addGenericFixes;
                if (o == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (expectedType == null) {
                    1.$$$reportNull$$$0(11);
                }
                ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
                VirtualFile file2 = SqlImplUtil.getTopLevelFile(o.getContainingFile());
                if (file2 != null && !DbVFSUtils.isAssociatedWithDataSourceAndSchema(file2) && JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file2)) {
                    result2.add((LocalQuickFix)new ChooseSchemaFix());
                }
                this.addRefreshFix(result2);
                if (!this.addFixesByExpectedType(o, parent, expectedType, result2)) {
                    this.addIntrospectFixes(o, parent, result2);
                }
                this.addIntrospectFixesForQualifier(parent, result2);
                this.addQualifyFixes(o, result2);
                boolean bl = addGenericFixes = expectedType != ObjectKind.COLUMN && file2 != null && !(file2.getFileSystem() instanceof NonPhysicalFileSystem) && !DbVFSUtils.isAssociatedWithDataSource(file2);
                if (addGenericFixes) {
                    result2.add((LocalQuickFix)new GoToResolutionScopesFix());
                    if (onTheFly && JdbcConsoleProvider.getValidConsole(o.getProject(), file2) == null) {
                        result2.add((LocalQuickFix)new AttachDataSourceFix());
                    }
                }
                if (this.isPossibleStringLiteral(o)) {
                    String optionName = SqlBundle.message((String)"sql.resolve.inspection.checkbox.suppress.for.quoted", (Object[])new Object[0]);
                    LocalQuickFix fix = LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)SqlResolveInspection.this, SqlResolveInspection.OPTION_SUPPRESS_FOR_STRING_LITERALS, SqlBundle.message((String)"intention.name.enable.option", (Object[])new Object[]{optionName}), true));
                    result2.add(fix);
                }
                ArrayList<LocalQuickFix> arrayList = result2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(12);
                }
                return arrayList;
            }

            private boolean isTopLevel(@NotNull ObjectKind kind) {
                if (kind == null) {
                    1.$$$reportNull$$$0(13);
                }
                BasicMetaModel<?> metaModel = ModelFacade.forDbms(this.myDialect.getDbms()).getMetaModel();
                for (ObjectKind parentKind : metaModel.getParentKinds(kind)) {
                    if (parentKind != ObjectKind.SCHEMA && parentKind != ObjectKind.DATABASE) continue;
                    return true;
                }
                return false;
            }

            private void addQualifyFixes(@NotNull PsiElement o, @NotNull List<LocalQuickFix> result2) {
                if (o == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (!(o instanceof SqlIdentifier)) {
                    return;
                }
                PsiElement parent = o.getParent();
                if (!(parent instanceof SqlReferenceExpression)) {
                    return;
                }
                SqlReferenceExpression refExpression = (SqlReferenceExpression)parent;
                if (refExpression.getQualifierExpression() != null) {
                    return;
                }
                SqlReference ref2 = refExpression.getReference();
                if (!(ref2 instanceof SqlReferenceImpl)) {
                    return;
                }
                SqlReferenceImpl refImpl = (SqlReferenceImpl)ref2;
                if (!this.isTopLevel(refImpl.getReferenceElementType().getTargetKind())) {
                    return;
                }
                SmartList qualifiers = new SmartList();
                SqlScopeProcessor processor2 = refImpl.createResolveProcessor((PairConsumer<? super DasSymbol, ? super ResolveState>)((PairConsumer)(arg_0, arg_1) -> 1.lambda$addQualifyFixes$5((List)qualifiers, arg_0, arg_1)));
                ResolveState resolveState = ResolveState.initial();
                PsiFile psiFile = o.getContainingFile();
                if (psiFile instanceof SqlFile) {
                    ((SqlFile)psiFile).processDeclarations(processor2, resolveState, null, o);
                }
                PsiFile topContainingFile = refImpl.getTopLevelSqlFile();
                SqlImportState importChecker = refImpl.getImportChecker();
                SqlImplUtil.traverseDataSources(processor2.getDataSources(), importChecker, dataSource -> refImpl.processUnqualifiedResolveInDataSource(processor2, resolveState, topContainingFile, (DbDataSource)dataSource, ds -> {
                    Condition<DasObject> condition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, ds.getDelegate(), false) : Conditions.alwaysTrue();
                    condition = SqlFileImpl.getFullExpandConditon(condition, dataSource, processor2, (PsiElement)refExpression);
                    return SqlFileImpl.processNameIndex(processor2, resolveState, ds.getNameIndex(), condition, ds.mapper(), true);
                }));
                if (!qualifiers.isEmpty()) {
                    result2.add((LocalQuickFix)new QualifyReferenceFix((SqlIdentifier)o, (List<DasObject>)qualifiers));
                }
            }

            @Nullable
            private static IntrospectSchemaFix calcIntrospectFix(@NotNull PsiElement o, @Nullable PsiElement parent, @NotNull SqlLanguageDialectEx dialect2) {
                String name2;
                List candidates2;
                SqlReferenceImpl ref2;
                if (o == null) {
                    1.$$$reportNull$$$0(16);
                }
                if (dialect2 == null) {
                    1.$$$reportNull$$$0(17);
                }
                List<DbDataSource> dataSources = SqlImplUtil.getDataSources((PsiElement)parent.getContainingFile());
                SqlReferenceImpl sqlReferenceImpl = ref2 = parent instanceof SqlReferenceExpression ? (SqlReferenceImpl)ObjectUtils.tryCast((Object)parent.getReference(), SqlReferenceImpl.class) : null;
                if (ref2 == null) {
                    return null;
                }
                MyResolveContextProcessor processor2 = new MyResolveContextProcessor(ref2.getReferenceName(), dialect2, dataSources, parent);
                ref2.initExpectedTargetTypes(processor2);
                boolean schemaExpected = processor2.isExpected(ObjectKind.SCHEMA);
                boolean dbExpected = processor2.isExpected(ObjectKind.DATABASE);
                if (!schemaExpected && !dbExpected) {
                    return null;
                }
                SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent).getQualifierExpression(), SqlReferenceExpression.class);
                Object[] resolved = qualifier == null ? ResolveResult.EMPTY_ARRAY : qualifier.multiResolve(false);
                JBIterable namespaces2 = JBIterable.empty();
                if (resolved.length == 0) {
                    SqlFile file2 = (SqlFile)ObjectUtils.tryCast((Object)o.getContainingFile(), SqlFile.class);
                    if (file2 != null) {
                        SqlImportState checker = SqlDialectImplUtilCore.getImportCheckerAt(file2, o);
                        for (DbDataSource source : processor2.getDataSources()) {
                            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getDelegate().getModel(), BasicModel.class);
                            if (model == null) continue;
                            namespaces2 = namespaces2.append((Iterable)((JBTreeTraverser)model.traverser().expand(SqlFileImpl.importedCondition(checker, source))).filter(BasicMateNamespace.class).transform(n -> Pair.create((Object)source, (Object)n)));
                        }
                    }
                } else {
                    namespaces2 = JBIterable.of((Object[])resolved).map(ResolveResult::getElement).filter(DbElement.class).flatten(e -> {
                        BasicElement object = (BasicElement)ObjectUtils.tryCast((Object)e.getDelegate(), BasicElement.class);
                        DbDataSource source = e.getDataSource();
                        return object == null ? JBIterable.empty() : object.getChildren().filter(BasicMateNamespace.class).map(n -> Pair.create((Object)source, (Object)n));
                    });
                }
                if ((candidates2 = namespaces2.filter(arg_0 -> 1.lambda$calcIntrospectFix$11(name2 = ref2.getReferenceName(), dialect2, schemaExpected, dbExpected, arg_0)).map(p2 -> Pair.create((Object)((DbDataSource)p2.first), (Object)ObjectPaths.of((DasObject)p2.second))).toList()).isEmpty()) {
                    return null;
                }
                ObjectKind kind = dbExpected && schemaExpected ? ObjectKind.NONE : (dbExpected ? ObjectKind.DATABASE : ObjectKind.SCHEMA);
                return new IntrospectSchemaFix(candidates2, kind);
            }

            private void addIntrospectFixes(@NotNull PsiElement o, @Nullable PsiElement parent, @NotNull List<LocalQuickFix> result2) {
                if (o == null) {
                    1.$$$reportNull$$$0(18);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(19);
                }
                SqlLanguageDialectEx dialect2 = this.myDialect;
                IntrospectSchemaFix fix = (IntrospectSchemaFix)((Object)CachedValuesManager.getCachedValue((PsiElement)o, () -> new CachedValueProvider.Result((Object)1.calcIntrospectFix(o, parent, dialect2), new Object[]{file, DbPsiFacade.getInstance(file.getProject())})));
                ContainerUtil.addIfNotNull(result2, (Object)((Object)fix));
            }

            private static /* synthetic */ boolean lambda$calcIntrospectFix$11(String name2, SqlLanguageDialectEx dialect2, boolean schemaExpected, boolean dbExpected, Pair n) {
                return !DataSourceSchemaMapping.isIntrospected(DbImplUtilCore.getIntrospectionScope((DasDataSource)n.first), (DasObject)n.second) && DasUtil.nameEqual((DasObject)n.second, name2, dialect2) && (((BasicMateNamespace)n.second).getKind() == ObjectKind.SCHEMA && schemaExpected || ((BasicMateNamespace)n.second).getKind() == ObjectKind.DATABASE && dbExpected);
            }

            private static /* synthetic */ void lambda$addQualifyFixes$5(List qualifiers, DasSymbol symbol, ResolveState state) {
                DasObject qualifier;
                DasObject candidate2 = symbol.getDasObject();
                DasObject dasObject = qualifier = candidate2 != null ? candidate2.getDasParent() : null;
                if (qualifier != null) {
                    qualifiers.add(qualifier);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 12 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "re";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 10: 
                    case 14: 
                    case 16: 
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 6: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedType";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 15: 
                    case 19: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dialect";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createQuickFixesFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "afterIfExistsClause";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlIdentifier";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isPossibleStringLiteral";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isInsertIntoArg";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "addFixesByExpectedType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "addRefreshFix";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "addIntrospectFixesForQualifier";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "createQuickFixesFor";
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "isTopLevel";
                        break;
                    }
                    case 14: 
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "addQualifyFixes";
                        break;
                    }
                    case 16: 
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "calcIntrospectFix";
                        break;
                    }
                    case 18: 
                    case 19: {
                        objectArray = objectArray;
                        objectArray[2] = "addIntrospectFixes";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 12 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static void setVariable(TemplateImpl copy, String valueString, int index, String varName, boolean stop) {
        Variable variable = (Variable)copy.getVariables().get(index);
        assert (varName.equals(variable.getName()));
        variable.setDefaultValueString("\"" + valueString + "\"");
        variable.setAlwaysStopAt(stop);
    }

    @NotNull
    private static String getTypeText(DasType type, Dbms dbms) {
        String typeName;
        String string = typeName = type == null ? "int" : type.getDescription();
        if ((dbms.isOracle() || dbms.isMysql()) && "varchar".equalsIgnoreCase(typeName)) {
            String string2 = typeName + "(255)";
            if (string2 == null) {
                SqlResolveInspection.$$$reportNull$$$0(4);
            }
            return string2;
        }
        String string3 = typeName;
        if (string3 == null) {
            SqlResolveInspection.$$$reportNull$$$0(5);
        }
        return string3;
    }

    private static List<DasType> mergeTypes(Collection<Collection<DasType>> types) {
        ArrayList<DasType> result2 = new ArrayList<DasType>();
        for (Collection<DasType> typeList : types) {
            if (result2.isEmpty()) {
                result2.addAll(typeList);
                continue;
            }
            int i2 = 0;
            for (DasType type : typeList) {
                if (i2 < result2.size()) {
                    result2.set(i2, SqlResolveInspection.merge((DasType)result2.get(i2), type));
                }
                ++i2;
            }
        }
        return result2;
    }

    private static DasType merge(DasType type, DasType type1) {
        if (type == null) {
            return type1;
        }
        if (type1 == null) {
            return type;
        }
        return type == type1 ? type : (SqlFunctionsUtil.isAssignable(type, type1) ? type1 : type);
    }

    private static void collectColumnTypes(SqlStatement statement2, Collection<Collection<DasType>> types, List<Boolean> nullableFlags) {
        SqlImplUtil.sqlTraverser((PsiElement)statement2).filter(SqlValuesExpression.class).forEach(e -> e.getExpressions().filter(SqlParenthesizedExpression.class).forEach(pe -> {
            types.add(ContainerUtil.map((Collection)pe.getExpressionList(), el -> el.getDasType()));
            List nullableState = ContainerUtil.map((Collection)pe.getExpressionList(), ex -> ex instanceof SqlLiteralExpression && "null".equals(ex.getText()));
            if (nullableFlags.isEmpty()) {
                nullableFlags.addAll(nullableState);
            } else {
                for (int i2 = 0; i2 < nullableFlags.size(); ++i2) {
                    if (i2 >= nullableState.size()) continue;
                    nullableFlags.set(i2, (Boolean)nullableFlags.get(i2) != false || (Boolean)nullableState.get(i2) != false);
                }
            }
        }));
        SqlQueryExpression queryExpression = SqlResolveInspection.getQueryExpression(statement2);
        if (queryExpression == null) {
            return;
        }
        DasType type = queryExpression.getDasType();
        if (type instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)type;
            if (!(type instanceof SqlTableTypeBase.Empty)) {
                int columnCount = tableType2.getColumnCount();
                ArrayList<DasType> allTypes = new ArrayList<DasType>(columnCount);
                for (int i2 = 0; i2 < columnCount; ++i2) {
                    try {
                        DasType columnType = tableType2.getColumnDasType(i2);
                        allTypes.add(columnType);
                        continue;
                    }
                    catch (Exception e2) {
                        allTypes.add(null);
                    }
                }
                types.add(allTypes);
            }
        }
    }

    @Nullable
    private static SqlQueryExpression getQueryExpression(SqlStatement statement2) {
        if (!(statement2 instanceof SqlInsertStatement)) {
            return null;
        }
        SqlInsertDmlInstruction insert = (SqlInsertDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)statement2, SqlInsertDmlInstruction.class);
        if (insert == null) {
            return null;
        }
        return insert.getQueryExpression();
    }

    private static void collectColumnNames(@NotNull PsiElement element, @NotNull SqlStatement statement2, @NotNull Collection<String> columnsNames) {
        if (element == null) {
            SqlResolveInspection.$$$reportNull$$$0(6);
        }
        if (statement2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(7);
        }
        if (columnsNames == null) {
            SqlResolveInspection.$$$reportNull$$$0(8);
        }
        SqlQueryExpression queryExpression = SqlResolveInspection.getQueryExpression(statement2);
        String defaultName = "col";
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element);
        Project project = element.getProject();
        if (queryExpression != null) {
            DasType type = queryExpression.getDasType();
            if (type instanceof SqlTableType && !(type instanceof SqlTableTypeBase.Empty)) {
                for (int i2 = 0; i2 < ((SqlTableType)type).getColumnCount(); ++i2) {
                    columnsNames.add(SqlResolveInspection.guessColumnName(columnsNames, defaultName, dialect, project, (SqlTableType)type, i2));
                }
            }
            return;
        }
        SqlLanguageDialectEx sqlLanguage = SqlImplUtil.getSqlDialectSafe((PsiElement)statement2);
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(sqlLanguage, SqlImplUtil.getDataSources((PsiElement)statement2));
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlAsExpression.class);
        JBIterable iterable = SqlImplUtil.sqlTraverser((PsiElement)statement2).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression e : iterable) {
            ObjectKind type = e.getReferenceElementType().getTargetKind();
            SqlIdentifier identifier = e.getIdentifier();
            if (type != ObjectKind.COLUMN || identifier == null || e.resolve() != null && !SqlImplUtil.isMarkedUnresolved(e)) continue;
            SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)e.getQualifierExpression(), SqlReferenceExpression.class);
            PsiElement parent = element.getParent();
            if (asExpression != null && qualifier != null && !asExpression.equals(qualifier.resolve()) && (!(parent instanceof DasNamed) || !new NameChecker(qualifier, sqlLanguage, casingProvider).checkName((DasNamed)parent, false))) continue;
            columnsNames.add(identifier.getText());
        }
    }

    @Nullable
    private static String computeNameFromReference(@Nullable SqlReferenceExpression expression) {
        if (expression == null) {
            return null;
        }
        SqlExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            StringBuilder fullName = new StringBuilder(expression.getName());
            expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)qualifierExpression, SqlReferenceExpression.class);
            while (expression != null) {
                fullName.insert(0, expression.getName() + "_");
                expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression.getQualifierExpression(), SqlReferenceExpression.class);
            }
            return fullName.toString();
        }
        return null;
    }

    private static String getNameFromElement(@Nullable PsiElement element, boolean allowUnqualifiedRefs) {
        if (element == null) {
            return null;
        }
        if (element instanceof SqlReferenceExpression) {
            String nameFromReference = SqlResolveInspection.computeNameFromReference((SqlReferenceExpression)element);
            return nameFromReference == null && allowUnqualifiedRefs ? ((SqlReferenceExpression)element).getName() : nameFromReference;
        }
        if (element instanceof SqlFunctionCallExpression) {
            SqlReferenceExpression nameElement = ((SqlFunctionCallExpression)element).getNameElement();
            if (nameElement == null) {
                return null;
            }
            String func_Name = nameElement.getName();
            StringBuilder nameBuilder = new StringBuilder(func_Name);
            SqlExpressionList list = ((SqlFunctionCallExpression)element).getParameterList();
            if (list != null) {
                for (SqlExpression expression : list.getExpressionList()) {
                    String innerName = SqlResolveInspection.getNameFromElement((PsiElement)expression, true);
                    if (innerName == null) continue;
                    nameBuilder.insert(0, innerName + "_");
                }
            }
            return nameBuilder.toString();
        }
        SqlFunctionCallExpression functionCallExpression = (SqlFunctionCallExpression)SqlImplUtil.sqlTraverser(element).filter(SqlFunctionCallExpression.class).first();
        if (functionCallExpression != null) {
            return SqlResolveInspection.getNameFromElement((PsiElement)functionCallExpression, true);
        }
        return SqlResolveInspection.getNameFromElement((PsiElement)SqlImplUtil.sqlTraverser(element).filter(SqlReferenceExpression.class).first(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String guessColumnName(@NotNull Collection<String> columnsNames, String defaultName, SqlLanguageDialectEx dialect, Project project, SqlTableType type, int i2) {
        block10: {
            String columnName;
            block11: {
                String string;
                if (columnsNames == null) {
                    SqlResolveInspection.$$$reportNull$$$0(9);
                }
                try {
                    columnName = type.getColumnName(i2);
                    if (columnName == null) break block10;
                    if (!columnsNames.contains(columnName) && StringUtil.indexOfAny((String)columnName, (String)"(\r\n") < 0) break block11;
                    try {
                        PsiElement element = type.getColumnElement(i2);
                        String nameFromElement = SqlResolveInspection.getNameFromElement(element, false);
                        if (nameFromElement == null) break block11;
                        string = SqlResolveInspection.disambiguateAndQuote(columnsNames, nameFromElement, dialect, project);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break block11;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                    break block10;
                }
                if (string == null) {
                    SqlResolveInspection.$$$reportNull$$$0(10);
                }
                return string;
            }
            columnName = StringUtil.replace((String)columnName, (String)"\r", (String)" ");
            if ((columnName = StringUtil.replace((String)columnName, (String)"\n", (String)" ")).length() <= 30) {
                String string = SqlResolveInspection.disambiguateAndQuote(columnsNames, columnName, dialect, project);
                if (string == null) {
                    SqlResolveInspection.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = SqlResolveInspection.disambiguateAndQuote(columnsNames, defaultName, dialect, project);
        if (string == null) {
            SqlResolveInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static String disambiguateAndQuote(@NotNull Collection<String> columnsNames, String columnName, SqlLanguageDialectEx dialect, Project project) {
        if (columnsNames == null) {
            SqlResolveInspection.$$$reportNull$$$0(13);
        }
        Object finalName = columnName;
        int localIdx = 0;
        while (columnsNames.contains(finalName)) {
            finalName = columnName + ++localIdx;
        }
        return dialect.quoteIdentifier(project, (String)finalName, ObjectKind.COLUMN);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)OPTION_SUPPRESS_FOR_STRING_LITERALS, (String)SqlBundle.message((String)"sql.resolve.inspection.checkbox.suppress.for.quoted", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)OPTION_SUPPRESS_FOR_LABEL_BACK_REFS, (String)SqlBundle.message((String)"sql.resolve.inspection.checkbox.suppress.for.back.ref", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SqlResolveInspection.$$$reportNull$$$0(14);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "guessColumnName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessColumnName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "disambiguateAndQuote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 12, 14 -> new IllegalStateException(string);
        };
    }

    private static class MyResolveContextProcessor
    extends SqlScopeProcessorBase {
        final Set<DbTable> dbTables;
        final Set<SqlCreateTableStatement> sqlTables;

        MyResolveContextProcessor(@NotNull String referenceName, @NotNull SqlLanguageDialectEx dialect, @NotNull List<DbDataSource> dataSources, @Nullable PsiElement place) {
            if (referenceName == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(1);
            }
            if (dataSources == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(2);
            }
            super(referenceName, dialect, dataSources, place);
            this.dbTables = new HashSet<DbTable>();
            this.sqlTables = new HashSet<SqlCreateTableStatement>();
        }

        public boolean isResultEmpty() {
            return this.dbTables.isEmpty() && this.sqlTables.isEmpty();
        }

        public void setResolveContext(@Nullable PsiElement context) {
            if (context == null) {
                return;
            }
            if (context instanceof SqlDmlInstruction) {
                SqlExpression targetExpression = ((SqlDmlInstruction)context).getTargetExpression();
                this.processReference(targetExpression == null ? null : targetExpression.getReference());
            }
            PsiElement contextParent = context.getParent();
            PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (o instanceof SqlReferenceExpression) {
                        this.processReference(o.getReference());
                        return;
                    }
                    super.visitElement(o);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor$1", "visitElement"));
                }
            };
            if (contextParent instanceof SqlQueryExpression) {
                SqlTableExpression tableExpression = ((SqlQueryExpression)contextParent).getTableExpression();
                if (tableExpression != null) {
                    tableExpression.accept((PsiElementVisitor)visitor2);
                }
            } else if (contextParent instanceof SqlTableColumnsList) {
                SqlReferenceExpression tableReference = ((SqlTableColumnsList)contextParent).getTableReference();
                this.processReference((PsiReference)(tableReference == null ? null : tableReference.getReference()));
            } else if (contextParent instanceof SqlTableExpression) {
                contextParent.accept((PsiElementVisitor)visitor2);
            } else if (contextParent instanceof SqlAlterStatement) {
                SqlReferenceExpression reference = ((SqlAlterStatement)contextParent).getAlterTargetReference();
                this.processReference((PsiReference)(reference == null ? null : reference.getReference()));
            } else if (context instanceof PsiObject) {
                this.processObject(context);
            }
        }

        private void processReference(@Nullable PsiReference ref2) {
            this.processObject(ref2 != null ? ref2.resolve() : null);
        }

        private void processObject(PsiElement resolve2) {
            if (resolve2 instanceof DbTable) {
                this.dbTables.add((DbTable)resolve2);
            } else if (resolve2 instanceof SqlCreateTableStatement) {
                this.sqlTables.add((SqlCreateTableStatement)resolve2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referenceName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSources";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddDbColumnFix
    extends SqlEditorAwareFix<PsiElement> {
        final ObjectPath myTable;
        final String myColumnName;

        AddDbColumnFix(@NotNull PsiElement o, @NotNull DbTable table) {
            if (o == null) {
                AddDbColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddDbColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myColumnName = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
            this.myTable = ObjectPaths.of(table);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.add.column", (Object[])new Object[]{this.myColumnName, this.myTable.getName()});
            if (string == null) {
                AddDbColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element, @Nullable Editor editor2) {
            DbDataSourceImpl dataSource;
            if (project == null) {
                AddDbColumnFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddDbColumnFix.$$$reportNull$$$0(4);
            }
            if ((dataSource = (DbDataSourceImpl)DbImplUtilCore.getForcedDataSource(element.getContainingFile())) == null) {
                return;
            }
            DbElement table = DbSqlUtilCore.findElement(dataSource, this.myTable);
            if (table == null || table.getKind() != ObjectKind.TABLE) {
                return;
            }
            DdlActions.AddColumnAction.perform((DbTable)table, null, element.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class AddDbTableFix
    extends SqlEditorAwareFix<PsiElement> {
        AddDbTableFix(@Nullable PsiElement o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.add.table", (Object[])new Object[0]);
            if (string == null) {
                AddDbTableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element, @Nullable Editor editor2) {
            SqlStatement statement2;
            List strings;
            if (project == null) {
                AddDbTableFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddDbTableFix.$$$reportNull$$$0(2);
            }
            List list = strings = (statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) == null ? ContainerUtil.emptyList() : new ArrayList();
            if (statement2 != null) {
                SqlResolveInspection.collectColumnNames(element, statement2, strings);
            }
            PsiFile file = element.getContainingFile();
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            Consumer consumer = newSession -> {
                JdbcConsoleProvider.attachConsole(project, newSession, virtualFile);
                DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(project);
                DbDataSource dataSource = dbPsiFacade.findDataSource(((DatabaseConnectionPoint)newSession.getTarget()).getDataSource().getUniqueId());
                if (dataSource == null) {
                    return;
                }
                AddDbTableFix.showDialog(dataSource, element, strings);
            };
            @Nls String title = SessionsUtil.getSessionTitle(virtualFile);
            List<PersistenceConsoleProvider.Runner> runners = DatabaseRunners.getAttachDataSourceRunners(file, title, (Consumer<? super DatabaseSession>)consumer);
            RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(runners, editor2, null);
        }

        private static void showDialog(@NotNull DbDataSource source, @NotNull PsiElement element, @NotNull Collection<String> strings) {
            if (source == null) {
                AddDbTableFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddDbTableFix.$$$reportNull$$$0(4);
            }
            if (strings == null) {
                AddDbTableFix.$$$reportNull$$$0(5);
            }
            DdlActions.AddTableAction.showAddTableDialogAndRun(null, DbRefactoringHelper.createContext(source, element, false), element.getText(), strings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showDialog";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DeclareUserVariableFix
    extends SqlEditorAwareFix<PsiElement> {
        private final String myText;

        protected DeclareUserVariableFix(@Nullable PsiElement element, @NotNull String text) {
            if (text == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myText = text;
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.declare.variable", (Object[])new Object[0]);
            if (string == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element, @Nullable Editor editor2) {
            SqlStatement statement2;
            if (project == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(3);
            }
            if ((statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) == null) {
                return;
            }
            SqlStatement statementFromText = SqlPsiElementFactory.createStatementFromText(this.myText, SqlImplUtil.getSqlDialectSafe(element), project, element);
            assert (statementFromText != null);
            statement2.getParent().addBefore((PsiElement)statementFromText, (PsiElement)statement2);
        }

        @NotNull
        static String getTypeString(@NotNull PsiElement element) {
            IElementType sign;
            SqlExpression expression;
            SqlElement value;
            SqlSetAssignment assignment;
            if (element == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(4);
            }
            if ((assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)element, SqlSetAssignment.class)) != null && (value = assignment.getRValue()) != null && (expression = SqlPsiElementFactory.createExpressionFromText(value.getText(), SqlImplUtil.getSqlDialectSafe(element), element)) != null) {
                String string = expression.getDasType().getDescription();
                if (string == null) {
                    DeclareUserVariableFix.$$$reportNull$$$0(5);
                }
                return string;
            }
            SqlBinaryExpression binary = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlBinaryExpression.class, (boolean)true, (Class[])new Class[]{SqlStatement.class});
            if (binary != null && DeclareUserVariableFix.isSuitableBinary(sign = binary.getOpSign())) {
                SqlExpression left = binary.getLOperand();
                SqlExpression right = binary.getROperand();
                if (right != null) {
                    SqlExpression other;
                    SqlExpression owner = PsiTreeUtil.isAncestor((PsiElement)left, (PsiElement)element, (boolean)true) ? left : right;
                    SqlExpression sqlExpression = other = owner == left ? right : left;
                    if (owner.getText().equals(element.getText())) {
                        String string = other.getDasType().getDescription();
                        if (string == null) {
                            DeclareUserVariableFix.$$$reportNull$$$0(6);
                        }
                        return string;
                    }
                }
            }
            return "int";
        }

        private static boolean isSuitableBinary(IElementType sign) {
            return sign == SqlCommonTokens.SQL_OP_EQ || sign == SqlCommonTokens.SQL_OP_EQEQ || sign == SqlCommonTokens.SQL_OP_NEQ;
        }

        @Nullable
        static String wrapVariableText(PsiElement o) {
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(o);
            Dbms dbms = dialect.getDbms();
            String name2 = o.getText();
            String type = DeclareUserVariableFix.getTypeString(o);
            if (dbms.isMicrosoft() || dbms.isDb2() || dbms.isSybase()) {
                return "declare " + name2 + " " + type + ";";
            }
            if ("OracleSqlPlus".equals(dialect.getID())) {
                return "define " + name2 + ";";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$DeclareUserVariableFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$DeclareUserVariableFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class DeclarePlVariableFix
    extends SqlEditorAwareFix<PsiElement> {
        protected DeclarePlVariableFix(@Nullable PsiElement element) {
            super(element);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.declare.pl.variable", (Object[])new Object[0]);
            if (string == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element, @Nullable Editor editor2) {
            if (project == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(2);
            }
            SqlBlockStatement blockStatement = (SqlBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlBlockStatement.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element);
            SqlStatement statement2 = SqlPsiElementFactory.createStatementFromText(DeclarePlVariableFix.createTemplate(dialect.getDbms(), element.getText(), DeclareUserVariableFix.getTypeString(element)), dialect, project, element);
            SqlVariableDefinition newDefinition = (SqlVariableDefinition)SqlImplUtil.sqlTraverser((PsiElement)statement2).filter(SqlVariableDefinition.class).first();
            assert (newDefinition != null);
            SqlVariableDefinition variableDefinition = (SqlVariableDefinition)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(SqlVariableDefinition.class).first();
            if (variableDefinition != null) {
                variableDefinition.getParent().addBefore((PsiElement)newDefinition, (PsiElement)variableDefinition);
                DeclarePlVariableFix.addSemiAndNewlineBefore(project, dialect, (PsiElement)variableDefinition);
                return;
            }
            LeafPsiElement beginKeyword = DeclarePlVariableFix.findChildToken(blockStatement, SqlCommonKeywords.SQL_BEGIN);
            assert (beginKeyword != null);
            LeafPsiElement existingDeclare = DeclarePlVariableFix.findChildToken(blockStatement, SqlCommonKeywords.SQL_DECLARE);
            if (existingDeclare == null) {
                LeafPsiElement declareKeyword = (LeafPsiElement)SqlImplUtil.sqlTraverser((PsiElement)statement2).filter(LeafPsiElement.class).filter(e -> e.getElementType() == SqlCommonKeywords.SQL_DECLARE).first();
                assert (declareKeyword != null);
                beginKeyword.getParent().addBefore((PsiElement)declareKeyword, (PsiElement)beginKeyword);
            }
            beginKeyword.getParent().addBefore((PsiElement)newDefinition, (PsiElement)beginKeyword);
            DeclarePlVariableFix.addSemiAndNewlineBefore(project, dialect, (PsiElement)beginKeyword);
        }

        private static void addSemiAndNewlineBefore(@NotNull Project project, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement element) {
            if (project == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(3);
            }
            if (dialect == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(5);
            }
            element.getParent().addBefore(SqlPsiElementFactory.createLeafFromText(project, dialect, ";"), element);
            element.getParent().addBefore(SqlPsiElementFactory.createLeafFromText(project, dialect, "\n"), element);
        }

        private static LeafPsiElement findChildToken(SqlBlockStatement blockStatement, SqlTokenType tokenType) {
            return (LeafPsiElement)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == tokenType).first();
        }

        static boolean supportsPlSql(@NotNull Dbms dbms) {
            if (dbms == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(6);
            }
            return dbms.isPostgres() || dbms.isOracle();
        }

        private static String createTemplate(Dbms dbms, String name2, String type) {
            String common = "DECLARE\n  " + name2 + " " + type + ";\nBEGIN\nEND";
            if (dbms.isPostgres()) {
                return "DO $$\n" + common + " $$;";
            }
            if (dbms.isOracle()) {
                return common + "/";
            }
            if (dbms.isDb2()) {
                return common;
            }
            throw new NotImplementedError("Not implemented for DBMS: " + dbms.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$DeclarePlVariableFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$DeclarePlVariableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSemiAndNewlineBefore";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsPlSql";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AddSqlTableFix
    extends SqlEditorAwareFix<PsiElement> {
        private final boolean myTemporary;

        AddSqlTableFix(PsiElement o, boolean temporary) {
            super(o);
            this.myTemporary = temporary;
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)(this.myTemporary ? "quickfix.name.create.table.declaration" : "quickfix.name.create.table.definition"), (Object[])new Object[0]);
            if (string == null) {
                AddSqlTableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element, @Nullable Editor editor2) {
            if (project == null) {
                AddSqlTableFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddSqlTableFix.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                return;
            }
            SqlStatement placeForInsertBefore = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlStatement.class);
            SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            if (statement2 == null || placeForInsertBefore == null) {
                return;
            }
            LinkedHashSet<String> columnsNames = new LinkedHashSet<String>();
            ArrayList<Collection<DasType>> columnsTypes = new ArrayList<Collection<DasType>>();
            ArrayList<Boolean> nullableFlags = new ArrayList<Boolean>();
            SqlResolveInspection.collectColumnNames(element, statement2, columnsNames);
            SqlResolveInspection.collectColumnTypes(statement2, columnsTypes, nullableFlags);
            List<DasType> typesMerged = SqlResolveInspection.mergeTypes(columnsTypes);
            int offset = placeForInsertBefore.getTextRange().getStartOffset();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = this.getTemplate(templateManager, element, columnsNames, typesMerged, nullableFlags);
            if (template == null) {
                return;
            }
            editor2.getCaretModel().moveToOffset(offset);
            templateManager.startTemplate(editor2, template);
        }

        @Nullable
        private Template getTemplate(@NotNull TemplateManager templateManager, @NotNull PsiElement element, @NotNull Collection<String> columnsNames, @NotNull List<DasType> typesMerged, @NotNull List<Boolean> nullableFlags) {
            if (templateManager == null) {
                AddSqlTableFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddSqlTableFix.$$$reportNull$$$0(4);
            }
            if (columnsNames == null) {
                AddSqlTableFix.$$$reportNull$$$0(5);
            }
            if (typesMerged == null) {
                AddSqlTableFix.$$$reportNull$$$0(6);
            }
            if (nullableFlags == null) {
                AddSqlTableFix.$$$reportNull$$$0(7);
            }
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element);
            if (columnsNames.isEmpty() && !this.myTemporary) {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate("tab", "SQL");
                if (template == null) {
                    return null;
                }
                TemplateImpl copy = template.copy();
                String s = copy.getString();
                if (!s.endsWith("\n")) {
                    copy.setString(s + "\n");
                }
                SqlResolveInspection.setVariable(copy, element.getText(), 0, "table", false);
                return copy;
            }
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            template.addTextSegment((String)(this.myTemporary ? AddSqlTableFix.createTemporaryTableStart(element.getText(), dialect.getDbms()) : "create table " + element.getText()) + " (\n");
            int size = columnsNames.size();
            int i2 = 0;
            for (String name2 : columnsNames) {
                template.addTextSegment(name2);
                template.addTextSegment(" ");
                template.addVariable("type" + i2, (Expression)new ConstantNode(i2 < typesMerged.size() ? SqlResolveInspection.getTypeText(typesMerged.get(i2), dialect.getDbms()) : "int"), true);
                if (!dialect.getDbms().isClickHouse()) {
                    template.addTextSegment(" ");
                    template.addVariable("not_null" + i2, (Expression)new ConstantNode(i2 < nullableFlags.size() && nullableFlags.get(i2) != false ? "null" : "not null"), true);
                }
                if (i2 != size - 1) {
                    template.addTextSegment(",");
                }
                template.addTextSegment("\n");
                ++i2;
            }
            template.addTextSegment(");\n");
            return template;
        }

        @NotNull
        private static String createTemporaryTableStart(String name2, @NotNull Dbms dbms) {
            if (dbms == null) {
                AddSqlTableFix.$$$reportNull$$$0(8);
            }
            if (dbms.isMicrosoft()) {
                String string = "declare " + name2 + " table";
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (dbms.isClickHouse()) {
                String string = "create temporary table " + name2;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (dbms.isDb2() || dbms.isDerby()) {
                String string = "declare global temporary table " + name2;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (dbms.isHsqldb() || dbms.isMysql()) {
                String string = "declare local temporary table " + name2;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (dbms.isOracle()) {
                String string = "create global temporary table " + name2;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(13);
                }
                return string;
            }
            throw new NotImplementedError("DBMS " + dbms.getDisplayName() + " not supported here");
        }

        static boolean supportsNonVarTemporaryTables(@NotNull Dbms dbms) {
            if (dbms == null) {
                AddSqlTableFix.$$$reportNull$$$0(14);
            }
            return dbms.isClickHouse() || dbms.isDb2() || dbms.isDerby() || dbms.isHsqldb() || dbms.isMysql() || dbms.isOracle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 14 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typesMerged";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullableFlags";
                    break;
                }
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemporaryTableStart";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplate";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemporaryTableStart";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsNonVarTemporaryTables";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 14 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AddSqlColumnFix
    extends SqlEditorAwareFix<PsiElement> {
        @FileModifier.SafeFieldForPreview
        final SmartPsiElementPointer<SqlCreateTableStatement> myTable;
        final String myTableName;
        final String myColumnName;

        AddSqlColumnFix(@NotNull PsiElement o, @NotNull SqlCreateTableStatement table) {
            if (o == null) {
                AddSqlColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddSqlColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myTable = SmartPointerManager.getInstance((Project)o.getProject()).createSmartPsiElementPointer((PsiElement)table);
            this.myTableName = table.getName();
            this.myColumnName = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.add.column", (Object[])new Object[]{this.myColumnName, this.myTableName});
            if (string == null) {
                AddSqlColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void applyFix(final @NotNull Project project, @NotNull PsiElement element, final @Nullable Editor editor2) {
            if (project == null) {
                AddSqlColumnFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddSqlColumnFix.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                return;
            }
            SqlCreateTableStatement table = (SqlCreateTableStatement)this.myTable.getElement();
            if (table == null) {
                return;
            }
            PsiColumn last = (PsiColumn)table.getDasChildren(ObjectKind.COLUMN).filter(PsiColumn.class).last();
            int offset = -1;
            boolean insertComma = true;
            if (last == null) {
                ASTNode lParen;
                ASTNode elements = table.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST);
                ASTNode aSTNode = lParen = elements == null ? null : elements.findChildByType((IElementType)SqlCommonTokens.SQL_LEFT_PAREN);
                if (lParen != null) {
                    offset = lParen.getTextRange().getEndOffset();
                    insertComma = false;
                }
            } else {
                offset = last.getTextRange().getEndOffset();
            }
            if (offset == -1) {
                return;
            }
            TemplateManager instance = TemplateManager.getInstance((Project)project);
            TemplateImpl template = TemplateSettings.getInstance().getTemplate("col", "SQL");
            if (template == null) {
                return;
            }
            TemplateImpl copy = template.copy();
            SqlResolveInspection.setVariable(copy, element.getText(), 0, "col", false);
            SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            ArrayList<Collection<DasType>> columnsTypes = new ArrayList<Collection<DasType>>();
            ArrayList<Boolean> nullableFlags = new ArrayList<Boolean>();
            SqlResolveInspection.collectColumnTypes(statement2, columnsTypes, nullableFlags);
            List<DasType> typesMerged = SqlResolveInspection.mergeTypes(columnsTypes);
            if (typesMerged.size() > table.getDasChildren(ObjectKind.COLUMN).filter(PsiColumn.class).size()) {
                DasType lastType = (DasType)ContainerUtil.getLastItem(typesMerged);
                if (lastType != null) {
                    SqlResolveInspection.setVariable(copy, SqlResolveInspection.getTypeText(lastType, SqlImplUtil.getSqlDialectSafe(element).getDbms()), 1, "type", true);
                }
                if (ContainerUtil.getLastItem(nullableFlags) == Boolean.TRUE) {
                    SqlResolveInspection.setVariable(copy, "NULL", 2, "null", true);
                }
            }
            editor2.getCaretModel().moveToOffset(offset);
            String newLine = (insertComma ? "," : "") + "\n";
            editor2.getDocument().insertString(offset, (CharSequence)newLine);
            editor2.getCaretModel().moveToOffset(offset + newLine.length());
            instance.startTemplate(editor2, (Template)copy, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    PsiFile file = myTable.getContainingFile();
                    Segment range = myTable.getRange();
                    if (file == null || range == null) {
                        return;
                    }
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
                    WriteAction.run(() -> CodeStyleManager.getInstance((Project)project).reformatText(file, range.getStartOffset(), range.getEndOffset()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix$1", "templateFinished"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class IntrospectSchemaFix
    extends IntentionAndQuickFixAction
    implements DumbAware {
        final List<Pair<DbDataSource, ObjectPath>> myCandidates;
        final String myKindName;

        public IntrospectSchemaFix(@NotNull List<Pair<DbDataSource, ObjectPath>> candidates2, @NotNull ObjectKind kind) {
            if (candidates2 == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates2;
            Pair first2 = (Pair)ContainerUtil.getFirstItem(candidates2);
            this.myKindName = StringUtil.capitalize((String)DbPresentationCore.getPresentableName(kind, first2 == null ? Dbms.UNKNOWN : ((DbDataSource)first2.first).getDbms()));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"intention.name.introspect.schema.fix", (Object[])new Object[]{StringUtil.toLowerCase((String)this.myKindName)});
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            if (project == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(4);
            }
            if (this.myCandidates.size() <= 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                IntrospectSchemaFix.setVisible(this.myCandidates);
            } else {
                final Set ds = JBIterable.from(this.myCandidates).transform(p2 -> (DbDataSource)p2.first).toSet();
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<Pair<DbDataSource, ObjectPath>>(SqlBundle.message((String)"popup.title.add.to.view", (Object[])new Object[0]), this.myCandidates){

                    public Icon getIconFor(Pair<DbDataSource, ObjectPath> value) {
                        return DbPresentationCore.getIcon(((DbDataSource)value.first).getDbms(), ((ObjectPath)value.second).kind);
                    }

                    @NotNull
                    public String getTextFor(Pair<DbDataSource, ObjectPath> value) {
                        ObjectPath parent = ((ObjectPath)value.second).parent;
                        @Nls StringBuilder text = new StringBuilder();
                        if (ds.size() > 1) {
                            text.append(((DbDataSource)value.first).getName()).append("\u2006.\u2006");
                        }
                        if (parent != null) {
                            text.append(parent.getName()).append("\u2006.\u2006");
                        }
                        text.append(((ObjectPath)value.second).getName());
                        String string = text.toString();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(List<Pair<DbDataSource, ObjectPath>> selectedValues, boolean finalChoice) {
                        IntrospectSchemaFix.setVisible(selectedValues);
                        return FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(project);
            }
        }

        private static void setVisible(List<Pair<DbDataSource, ObjectPath>> selectedValues) {
            MultiMap byDs = MultiMap.create();
            selectedValues.forEach(e -> byDs.putValue((Object)((DbDataSource)e.first), (Object)((ObjectPath)e.second)));
            for (Map.Entry entry : byDs.entrySet()) {
                TreePattern newScope;
                LoaderContext context;
                ObjectPath item = (ObjectPath)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue()));
                if (item == null) continue;
                DbDataSource dataSource = (DbDataSource)entry.getKey();
                LocalDataSource localDs = (LocalDataSource)dataSource.getDelegate();
                TreePattern oldScope = localDs.getIntrospectionScope();
                Project project = dataSource.getProject();
                if (!DataSourceUtil.setPathsVisible(project, localDs, (Iterable)entry.getValue(), true) || (context = DataSourceUiUtil.prepareScopeIntrospectionLoaderContext(project, localDs, oldScope, newScope = localDs.getIntrospectionScope())) == null) continue;
                DataSourceUtil.performManualSyncTask(context);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class QualifyReferenceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements DumbAware {
        private final List<DasObject> myQualifiers;
        private final boolean myIsPreview;

        public QualifyReferenceFix(@NotNull SqlIdentifier identifier, @NotNull List<DasObject> qualifiers, boolean isPreview) {
            if (identifier == null) {
                QualifyReferenceFix.$$$reportNull$$$0(0);
            }
            if (qualifiers == null) {
                QualifyReferenceFix.$$$reportNull$$$0(1);
            }
            super((PsiElement)identifier);
            this.myQualifiers = qualifiers;
            this.myIsPreview = isPreview;
        }

        public QualifyReferenceFix(@NotNull SqlIdentifier identifier, @NotNull List<DasObject> qualifiers) {
            if (identifier == null) {
                QualifyReferenceFix.$$$reportNull$$$0(2);
            }
            if (qualifiers == null) {
                QualifyReferenceFix.$$$reportNull$$$0(3);
            }
            this(identifier, qualifiers, false);
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                QualifyReferenceFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = SqlBundle.message((String)"intention.name.qualify.fix", (Object[])new Object[0]);
            if (string == null) {
                QualifyReferenceFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return this.myIsPreview;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
            if (target2 == null) {
                QualifyReferenceFix.$$$reportNull$$$0(6);
            }
            PsiElement identifier = this.getStartElement();
            if (!((identifier = PsiTreeUtil.findSameElementInCopy((PsiElement)identifier, (PsiFile)target2)) instanceof SqlIdentifier)) {
                return null;
            }
            return new QualifyReferenceFix((SqlIdentifier)identifier, this.myQualifiers, true);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                QualifyReferenceFix.$$$reportNull$$$0(7);
            }
            if (file == null) {
                QualifyReferenceFix.$$$reportNull$$$0(8);
            }
            if (startElement == null) {
                QualifyReferenceFix.$$$reportNull$$$0(9);
            }
            if (endElement == null) {
                QualifyReferenceFix.$$$reportNull$$$0(10);
            }
            if (editor2 == null) {
                return;
            }
            SqlIdentifier identifier = (SqlIdentifier)startElement;
            RangeMarker marker = editor2.getDocument().createRangeMarker(identifier.getTextRange());
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)identifier);
            NamingService namingService = NamingServices.getNamingService(dialect.getDbms());
            SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(file);
            List variants = JBIterable.from(this.myQualifiers).filterMap(o -> SqlQualificationIntentionBase.getName(o)).transform(Collections::singletonList).toList();
            if (this.myIsPreview) {
                SqlIntentionUtil.qualifyReference(marker, (Iterable)variants.get(0), namingService, settings);
            } else {
                SqlIntentionUtil.chooseQualifier(editor2, (Segment)marker, variants, namingService, settings, dialect, (Consumer<? super Iterable<ObjectName>>)((Consumer)v -> WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), (String)this.getText(), () -> SqlIntentionUtil.qualifyReference(marker, v, namingService, settings), (PsiFile[])new PsiFile[]{file})));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiers";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$QualifyReferenceFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$QualifyReferenceFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class RefreshSchemaFix
    extends IntentionAndQuickFixAction
    implements HighPriorityAction,
    DumbAware {
        private final LocalDataSource myDataSource;
        private final DasObject myNamespace;
        private final String myKindName;

        public RefreshSchemaFix(@NotNull LocalDataSource dataSource, @NotNull DasObject namespace) {
            if (dataSource == null) {
                RefreshSchemaFix.$$$reportNull$$$0(0);
            }
            if (namespace == null) {
                RefreshSchemaFix.$$$reportNull$$$0(1);
            }
            this.myDataSource = dataSource;
            this.myNamespace = namespace;
            this.myKindName = StringUtil.capitalize((String)DbPresentationCore.getPresentableName(namespace.getKind(), dataSource.getDbms()));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                RefreshSchemaFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"intention.name.refresh.schema.fix", (Object[])new Object[]{StringUtil.toLowerCase((String)this.myKindName)});
            if (string == null) {
                RefreshSchemaFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            Object ns;
            if (project == null) {
                RefreshSchemaFix.$$$reportNull$$$0(4);
            }
            if ((ns = DbImplUtilCore.unwrap(this.myNamespace)) == null) {
                return;
            }
            if (ns instanceof BasicNamespace) {
                BasicNamespace namespace = (BasicNamespace)ns;
                IntrospectionTask task = IntrospectionTasks.prepareOneElementRefreshTask(this.myDataSource.getUniqueId(), namespace);
                if (task != null) {
                    LoaderContext context = LoaderContext.selectTask(project, this.myDataSource, task);
                    DataSourceUtil.performManualSyncTask(context);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$RefreshSchemaFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$RefreshSchemaFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ChooseSchemaFix
    extends IntentionAndQuickFixAction
    implements HighPriorityAction,
    DumbAware {
        private ChooseSchemaFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"intention.name.choose.schema", (Object[])new Object[0]);
            if (string == null) {
                ChooseSchemaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                ChooseSchemaFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void doChooseSchema(@NotNull Editor editor2) {
            if (editor2 == null) {
                ChooseSchemaFix.$$$reportNull$$$0(2);
            }
            DatabaseRunners.chooseSchemaAndRun(editor2, null);
        }

        private static void attachConsoleAndChooseSchema(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull Editor editor2) {
            if (file == null) {
                ChooseSchemaFix.$$$reportNull$$$0(3);
            }
            if (virtualFile == null) {
                ChooseSchemaFix.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                ChooseSchemaFix.$$$reportNull$$$0(5);
            }
            Consumer consumer = newSession -> {
                JdbcConsoleProvider.attachConsole(file.getProject(), newSession, virtualFile);
                ChooseSchemaFix.doChooseSchema(editor2);
            };
            @Nls String title = SessionsUtil.getSessionTitle(virtualFile);
            List<PersistenceConsoleProvider.Runner> runners = DatabaseRunners.getAttachDataSourceRunners(file, title, (Consumer<? super DatabaseSession>)consumer);
            RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(runners, editor2, null);
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            if (project == null) {
                ChooseSchemaFix.$$$reportNull$$$0(6);
            }
            if (editor2 == null) {
                return;
            }
            if (!EditorUtil.isRealFileEditor((Editor)(editor2 = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor2)))) {
                return;
            }
            VirtualFile virtualFile = SqlImplUtil.getTopLevelFile(file);
            if (virtualFile == null) {
                return;
            }
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, virtualFile);
            if (console != null) {
                ChooseSchemaFix.doChooseSchema(editor2);
            } else {
                ChooseSchemaFix.attachConsoleAndChooseSchema(file, virtualFile, editor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$ChooseSchemaFix";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$ChooseSchemaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doChooseSchema";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "attachConsoleAndChooseSchema";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AttachDataSourceFix
    extends IntentionAndQuickFixAction
    implements DumbAware {
        private AttachDataSourceFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"intention.name.attach.data.source", (Object[])new Object[0]);
            if (string == null) {
                AttachDataSourceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                AttachDataSourceFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            if (project == null) {
                AttachDataSourceFix.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                return;
            }
            if (!EditorUtil.isRealFileEditor((Editor)(editor2 = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor2)))) {
                return;
            }
            ChooseDataSourceAction action = new ChooseDataSourceAction();
            action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)editor2.getContentComponent())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AttachDataSourceFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AttachDataSourceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class GoToResolutionScopesFix
    extends IntentionAndQuickFixAction
    implements DumbAware {
        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"intention.name.go.to.sql.resolution.scopes", (Object[])new Object[0]);
            if (string == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor2) {
            if (project == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(2);
            }
            SqlResolveConfigurable.openResolveScopesConfigurable(project, SqlImplUtil.getTopLevelFile(file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

