/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.sql.inspections.dataflow.types.SqlDfPrimitiveType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/sql/inspections/dataflow/types/SqlDfIntegralType;", "Lcom/intellij/codeInspection/dataFlow/types/DfIntegralType;", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfPrimitiveType;", "eval", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "other", "op", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "doEval", "doFromRelation", "relationType", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "doIsSuperType", "", "doJoin", "doTryJoinExactly", "doMeet", "meetRange", "range", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet;", "widen", "doTryNegate", "intellij.database.sql.core.impl"})
public interface SqlDfIntegralType
extends DfIntegralType,
SqlDfPrimitiveType {
    @NotNull
    default public DfType eval(@NotNull DfType other, @NotNull LongRangeBinOp op) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return SqlDfTypesKt.setNullability(this.doEval(other, op), this.getNullability().eval(SqlDfTypesKt.nullability(other)));
    }

    @NotNull
    public DfType doEval(@NotNull DfType var1, @NotNull LongRangeBinOp var2);

    @Override
    @NotNull
    default public DfType doFromRelation(@NotNull RelationType relationType) {
        Intrinsics.checkNotNullParameter((Object)relationType, (String)"relationType");
        LongRangeSet longRangeSet = this.getRange().fromRelation(relationType);
        Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"fromRelation(...)");
        LongRangeType longRangeType = this.getLongRangeType();
        Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
        return SqlDfTypesKt.rangeClamped(longRangeSet, longRangeType);
    }

    @Override
    default public boolean doIsSuperType(@NotNull DfType other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM) ? true : (!(other instanceof DfIntegralType) || ((DfIntegralType)other).getLongRangeType() != this.getLongRangeType() ? false : this.getRange().contains(((DfIntegralType)other).getRange()) && this.getWideRange().contains(((DfIntegralType)other).getWideRange()));
    }

    @Override
    @NotNull
    default public DfType doJoin(@NotNull DfType other) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM)) {
            dfType = this;
        } else if (!(other instanceof DfIntegralType) || ((DfIntegralType)other).getLongRangeType() != this.getLongRangeType()) {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
        } else {
            LongRangeSet longRangeSet = ((DfIntegralType)other).getRange().join(this.getRange());
            Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"join(...)");
            LongRangeSet longRangeSet2 = ((DfIntegralType)other).getWideRange().join(this.getWideRange());
            LongRangeType longRangeType = this.getLongRangeType();
            Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
            dfType = SqlDfTypesKt.range(longRangeSet, longRangeSet2, longRangeType);
        }
        return dfType;
    }

    @Override
    @Nullable
    default public DfType doTryJoinExactly(@NotNull DfType other) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM)) {
            dfType = this;
        } else if (Intrinsics.areEqual((Object)other, (Object)DfType.TOP)) {
            dfType = other;
        } else if (!(other instanceof DfIntegralType) || ((DfIntegralType)other).getLongRangeType() != this.getLongRangeType()) {
            dfType = null;
        } else {
            LongRangeSet range = ((DfIntegralType)other).getRange().tryJoinExactly(this.getRange());
            LongRangeSet wideRange = ((DfIntegralType)other).getWideRange().tryJoinExactly(this.getWideRange());
            if (range == null || wideRange == null) {
                dfType = null;
            } else {
                LongRangeType longRangeType = this.getLongRangeType();
                Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
                dfType = SqlDfTypesKt.range(range, wideRange, longRangeType);
            }
        }
        return dfType;
    }

    @Override
    @NotNull
    default public DfType doMeet(@NotNull DfType other) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other, (Object)DfType.TOP)) {
            dfType = this;
        } else if (!(other instanceof DfIntegralType) || ((DfIntegralType)other).getLongRangeType() != this.getLongRangeType()) {
            DfType dfType2 = DfType.BOTTOM;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
        } else {
            LongRangeSet longRangeSet = ((DfIntegralType)other).getRange().meet(this.getRange());
            Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"meet(...)");
            LongRangeSet longRangeSet2 = ((DfIntegralType)other).getWideRange().meet(this.getWideRange());
            LongRangeType longRangeType = this.getLongRangeType();
            Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
            dfType = SqlDfTypesKt.range(longRangeSet, longRangeSet2, longRangeType);
        }
        return dfType;
    }

    @NotNull
    default public DfType meetRange(@NotNull LongRangeSet range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        LongRangeSet longRangeSet = range.meet(this.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"meet(...)");
        LongRangeSet longRangeSet2 = range.meet(this.getWideRange());
        LongRangeType longRangeType = this.getLongRangeType();
        Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
        return SqlDfTypesKt.range(longRangeSet, longRangeSet2, longRangeType);
    }

    @NotNull
    default public DfType widen() {
        DfType dfType;
        if (Intrinsics.areEqual((Object)this.getWideRange(), (Object)this.getRange())) {
            dfType = this;
        } else {
            LongRangeSet longRangeSet = this.getWideRange();
            Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"getWideRange(...)");
            LongRangeType longRangeType = this.getLongRangeType();
            Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
            dfType = SqlDfTypesKt.range(longRangeSet, null, longRangeType);
        }
        return dfType;
    }

    @Override
    @Nullable
    default public DfType doTryNegate() {
        DfType dfType;
        LongRangeSet longRangeSet = this.getLongRangeType().fullRange().subtract(this.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"subtract(...)");
        LongRangeSet res2 = longRangeSet;
        if (res2.intersects(this.getRange())) {
            dfType = null;
        } else {
            LongRangeType longRangeType = this.getLongRangeType();
            Intrinsics.checkNotNullExpressionValue((Object)longRangeType, (String)"getLongRangeType(...)");
            dfType = SqlDfTypesKt.range(res2, null, longRangeType);
        }
        return dfType;
    }
}

