/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.scratch.RootType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlLanguageSubstitutor
extends LanguageSubstitutor {
    SqlLanguageSubstitutor() {
        SqlDialects.ensureSqlDialectsLoaded();
    }

    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        return SqlLanguageSubstitutor.getSqlLanguage(file, project);
    }

    @NotNull
    public static SqlLanguageDialect getSqlLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.chooseNotNull((Object)SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(file, project, false), (Object)SqlDialectMappings.getDefaultSqlDialect());
        if (sqlLanguageDialect == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlLanguageDialect(@Nullable VirtualFile file, @Nullable Project project) {
        Language language;
        Language language2 = language = project == null ? null : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        if (language instanceof SqlLanguageDialect) {
            SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)language;
            if (sqlLanguageDialect == null) {
                SqlLanguageSubstitutor.$$$reportNull$$$0(5);
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(project, file);
        if (sqlLanguageDialect == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(6);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect getConfiguredSqlLanguageDialect(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(7);
        }
        return SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(file, project, true);
    }

    @Nullable
    public static SqlLanguageDialect getConfiguredSqlLanguageDialect(@Nullable VirtualFile file, @NotNull Project project, boolean direct) {
        SqlLanguageDialect language;
        VirtualFile originalFile;
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(8);
        }
        while (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
            file = originalFile;
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            language = (SqlLanguageDialect)SqlDialectMappings.SQL_DIALECT_KEY.getPersistentValue(file);
            return language != null ? language : SqlLanguageSubstitutor.getSqlLanguageFromDataSource(file);
        }
        language = SqlLanguageSubstitutor.getSqlLanguageFromFile(file, project, direct);
        VirtualFile hostFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : null;
        return language != null ? language : SqlLanguageSubstitutor.getSqlLanguageFromMapping(project, hostFile, direct);
    }

    @Nullable
    private static SqlLanguageDialect getSqlLanguageFromFile(@Nullable VirtualFile file, @NotNull Project project, boolean direct) {
        SqlLanguageDialect fromRoot;
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(9);
        }
        if (file instanceof LightVirtualFile) {
            return (SqlLanguageDialect)ObjectUtils.tryCast((Object)((LightVirtualFile)file).getLanguage(), SqlLanguageDialect.class);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return DbSqlUtilCore.getSqlDialect(((DatabaseElementVirtualFileImpl)file).findDataSource(project));
        }
        RootType type = RootType.forFile((VirtualFile)file);
        SqlLanguageDialect sqlLanguageDialect = fromRoot = type == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)type.substituteLanguage(project, file), SqlLanguageDialect.class);
        if (fromRoot != null) {
            return fromRoot;
        }
        JdbcConsoleCore console = JdbcConsoleProviderCore.getValidConsole(project, file);
        return console == null ? SqlLanguageSubstitutor.getSqlLanguageFromMapping(project, file, direct) : DbSqlUtilCore.getSqlDialect(console.getDataSource());
    }

    @Nullable
    private static SqlLanguageDialect getSqlLanguageFromDataSource(@NotNull VirtualFile file) {
        LocalDataSource source;
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(10);
        }
        return (source = DbSrcUtilsCore.findDataSource(file)) == null ? null : DbSqlUtilCore.getSqlDialect(source);
    }

    @Nullable
    private static SqlLanguageDialect getSqlLanguageFromMapping(@NotNull Project project, @Nullable VirtualFile file, boolean direct) {
        SqlDialectMappings mappings;
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(11);
        }
        return (mappings = SqlDialectMappings.getInstance(project)) == null ? null : (direct ? (SqlLanguageDialect)mappings.getDirectlyConfiguredMapping(file) : (SqlLanguageDialect)mappings.getConfiguredMapping(file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlLanguageSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlLanguageSubstitutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguageDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredSqlLanguageDialect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageFromFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageFromDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageFromMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

