/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class RepositoryBase
implements Serializable,
Cloneable,
InputLocationTracker {
    private String id;
    private String name;
    private String url;
    private String layout = "default";
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation idLocation;
    private InputLocation nameLocation;
    private InputLocation urlLocation;
    private InputLocation layoutLocation;

    public RepositoryBase clone() {
        try {
            RepositoryBase copy = (RepositoryBase)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryBase)) {
            return false;
        }
        RepositoryBase that = (RepositoryBase)other;
        boolean result2 = true;
        result2 = result2 && (this.getId() == null ? that.getId() == null : this.getId().equals(that.getId()));
        return result2;
    }

    public String getId() {
        return this.id;
    }

    public String getLayout() {
        return this.layout;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    return this.location;
                }
                case "id": {
                    return this.idLocation;
                }
                case "name": {
                    return this.nameLocation;
                }
                case "url": {
                    return this.urlLocation;
                }
                case "layout": {
                    return this.layoutLocation;
                }
            }
            return this.getOtherLocation(key2);
        }
        return this.getOtherLocation(key2);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    this.location = location;
                    return;
                }
                case "id": {
                    this.idLocation = location;
                    return;
                }
                case "name": {
                    this.nameLocation = location;
                    return;
                }
                case "url": {
                    this.urlLocation = location;
                    return;
                }
                case "layout": {
                    this.layoutLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key2, location);
            return;
        }
        this.setOtherLocation(key2, location);
    }

    public void setOtherLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    private InputLocation getOtherLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + (this.id != null ? this.id.hashCode() : 0);
        return result2;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("id = '");
        buf.append(this.getId());
        buf.append("'");
        return buf.toString();
    }
}

