/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import org.codehaus.plexus.util.MatchPattern;

public class MatchPatterns {
    private final MatchPattern[] patterns;

    private MatchPatterns(MatchPattern[] patterns2) {
        this.patterns = patterns2;
    }

    public boolean matches(String name2, boolean isCaseSensitive) {
        String[] tokenized = MatchPattern.tokenizePathToString(name2, File.separator);
        return this.matches(name2, tokenized, isCaseSensitive);
    }

    public boolean matches(String name2, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i2 = 0; i2 < tokenizedName.length; ++i2) {
            tokenizedNameChar[i2] = tokenizedName[i2].toCharArray();
        }
        return this.matches(name2, tokenizedNameChar, isCaseSensitive);
    }

    public boolean matches(String name2, char[][] tokenizedNameChar, boolean isCaseSensitive) {
        for (MatchPattern pattern : this.patterns) {
            if (!pattern.matchPath(name2, tokenizedNameChar, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPatternStart(String name2, boolean isCaseSensitive) {
        for (MatchPattern includesPattern : this.patterns) {
            if (!includesPattern.matchPatternStart(name2, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static MatchPatterns from(String ... sources) {
        int length = sources.length;
        MatchPattern[] result2 = new MatchPattern[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result2[i2] = MatchPattern.fromString(sources[i2]);
        }
        return new MatchPatterns(result2);
    }

    public static MatchPatterns from(Iterable<String> strings) {
        return new MatchPatterns(MatchPatterns.getMatchPatterns(strings));
    }

    private static MatchPattern[] getMatchPatterns(Iterable<String> items) {
        ArrayList<MatchPattern> result2 = new ArrayList<MatchPattern>();
        for (String string : items) {
            result2.add(MatchPattern.fromString(string));
        }
        return result2.toArray(new MatchPattern[0]);
    }
}

